/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.rpc;

import io.moderne.jsonrpc.JsonRpc;
import io.moderne.jsonrpc.formatter.JsonMessageFormatter;
import io.moderne.jsonrpc.formatter.MessageFormatter;
import io.moderne.jsonrpc.handler.HeaderDelimitedMessageHandler;
import io.moderne.jsonrpc.handler.MessageHandler;
import io.moderne.jsonrpc.handler.TraceMessageHandler;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.Environment;
import org.openrewrite.javascript.rpc.InstallRecipesByFile;
import org.openrewrite.javascript.rpc.InstallRecipesByPackage;
import org.openrewrite.javascript.rpc.InstallRecipesResponse;
import org.openrewrite.rpc.RewriteRpc;

public class JavaScriptRewriteRpc
extends RewriteRpc {
    private final JavaScriptRewriteRpcProcess process;

    private JavaScriptRewriteRpc(JavaScriptRewriteRpcProcess process, Environment marketplace) {
        super(process.getRpcClient(), marketplace);
        this.process = process;
    }

    public static JavaScriptRewriteRpc start(Environment marketplace, String ... command) {
        JavaScriptRewriteRpcProcess process = new JavaScriptRewriteRpcProcess(command);
        process.start();
        return new JavaScriptRewriteRpc(process, marketplace);
    }

    public void shutdown() {
        super.shutdown();
        this.process.interrupt();
        try {
            this.process.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int installRecipes(File recipes) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByFile(recipes), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public int installRecipes(String packageName) {
        return this.installRecipes(packageName, null);
    }

    public int installRecipes(String packageName, @Nullable String version) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByPackage(new InstallRecipesByPackage.Package(packageName, version)), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    private static class JavaScriptRewriteRpcProcess
    extends Thread {
        private final String[] command;
        private @Nullable Process process;
        private JsonRpc rpcClient;

        public JavaScriptRewriteRpcProcess(String ... command) {
            this.command = command;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                ProcessBuilder pb = new ProcessBuilder(this.command);
                this.process = pb.start();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public synchronized void start() {
            super.start();
            while (this.process == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            HeaderDelimitedMessageHandler handler = new HeaderDelimitedMessageHandler((MessageFormatter)new JsonMessageFormatter(), this.process.getInputStream(), this.process.getOutputStream());
            handler = new TraceMessageHandler("client", (MessageHandler)handler);
            this.rpcClient = new JsonRpc((MessageHandler)handler);
        }

        @Generated
        public JsonRpc getRpcClient() {
            return this.rpcClient;
        }
    }
}

