/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.javascript.JavaScriptIsoVisitor;
import org.openrewrite.marker.Markers;

public final class UseCaseFallThrough
extends Recipe {
    public String getDisplayName() {
        return "Replaces comma and logical OR operator with fall-through cases in switch statements";
    }

    public String getDescription() {
        return "The comma `,` operator evaluates each of its operands (from left to right) and returns the value of the last operand.The logical OR `||` operator only evaluates the first argument.This recipe replaces the comma and logical OR operator with fall-through cases in switch statements.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3616");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaScriptIsoVisitor<ExecutionContext>(){

            @Override
            public J.Switch visitSwitch(J.Switch switch_, ExecutionContext executionContext) {
                J.Switch s = super.visitSwitch(switch_, executionContext);
                if (switch_.getSelector().getType() == JavaType.Primitive.Boolean) {
                    return switch_;
                }
                s = s.withCases(s.getCases().withStatements(ListUtils.flatMap((List)s.getCases().getStatements(), it -> {
                    if (it instanceof J.Case && this.changeCondition(((J.Case)it).getExpressions())) {
                        J.Case c = (J.Case)it;
                        List<Statement> converted = this.convertToFallThrough(c);
                        return ListUtils.map(converted, (i, st) -> {
                            if (st instanceof J.Case && i == converted.size() - 1) {
                                return ((J.Case)st).getPadding().withStatements(c.getPadding().getStatements());
                            }
                            return st;
                        });
                    }
                    return it;
                })));
                return s;
            }

            private List<Statement> convertToFallThrough(J.Case c) {
                ArrayList<Statement> cases = new ArrayList<Statement>();
                new CaseFallThrough(c.getPrefix()).visit((Tree)c, cases);
                return cases;
            }

            private boolean changeCondition(List<Expression> expressions) {
                for (Expression expression : expressions) {
                    if (expression instanceof J.Binary && this.isTarget((J.Binary)expression)) continue;
                    return false;
                }
                return true;
            }

            private boolean isTarget(J.Binary binary) {
                if (!(binary.getLeft() instanceof J.Binary)) {
                    return binary.getOperator() == J.Binary.Type.Or;
                }
                return this.isTarget((J.Binary)binary.getLeft()) && binary.getOperator() == J.Binary.Type.Or;
            }

            class CaseFallThrough
            extends JavaScriptIsoVisitor<List<Statement>> {
                final Space prefix;

                public CaseFallThrough(Space prefix) {
                    this.prefix = prefix;
                }

                @Override
                public J.Binary visitBinary(J.Binary binary, List<Statement> statements) {
                    if (binary.getLeft() instanceof J.Binary) {
                        super.visitBinary(binary, statements);
                        statements.add(this.convertToCase(binary.getRight()));
                    } else {
                        statements.add(this.convertToCase(binary.getLeft()));
                        statements.add(this.convertToCase(binary.getRight()));
                    }
                    return binary;
                }

                private Statement convertToCase(Expression expression) {
                    return new J.Case(Tree.randomId(), this.prefix, Markers.EMPTY, J.Case.Type.Statement, null, JContainer.build(Collections.singletonList(JRightPadded.build((Object)((Expression)expression.withPrefix(Space.build((String)" ", (List)expression.getPrefix().getComments())))))), JContainer.empty(), null);
                }
            }
        };
    }

    public String toString() {
        return "UseCaseFallThrough()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseCaseFallThrough)) {
            return false;
        }
        UseCaseFallThrough other = (UseCaseFallThrough)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof UseCaseFallThrough;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

