/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.TypeScriptSignatureBuilder;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCNodeList;
import org.openrewrite.javascript.internal.tsc.TSCSymbol;
import org.openrewrite.javascript.internal.tsc.TSCType;
import org.openrewrite.javascript.internal.tsc.generated.TSCObjectFlag;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;
import org.openrewrite.javascript.internal.tsc.generated.TSCTypeFlag;
import org.openrewrite.javascript.tree.TsType;

@Incubating(since="0.0")
public class TypeScriptTypeMapping
implements JavaTypeMapping<TSCNode> {
    private final TypeScriptSignatureBuilder signatureBuilder = new TypeScriptSignatureBuilder();
    private final JavaTypeCache typeCache;

    public TypeScriptTypeMapping(JavaTypeCache typeCache) {
        this.typeCache = typeCache;
    }

    public JavaType type(@Nullable TSCNode node) {
        if (node == null) {
            return null;
        }
        String signature = this.signatureBuilder.signature(node);
        JavaType existing = (JavaType)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        switch (node.syntaxKind()) {
            case SourceFile: {
                return this.mapSourceFileFqn(signature);
            }
            case ClassDeclaration: 
            case EnumDeclaration: 
            case InterfaceDeclaration: {
                return this.classType(node, signature);
            }
            case ArrayType: {
                return this.array(node, signature);
            }
            case EnumMember: {
                return this.mapEnumMember(node);
            }
            case Identifier: {
                return this.mapIdentifier(node);
            }
            case Parameter: {
                return this.mapParameter(node);
            }
            case QualifiedName: {
                return this.mapQualifiedName(node);
            }
            case ThisKeyword: {
                return this.mapThis(node);
            }
            case TypeOperator: {
                return this.mapTypeOperator(node);
            }
            case TypeParameter: {
                return this.generic(node, signature);
            }
            case ExpressionWithTypeArguments: 
            case TypeReference: 
            case TypeQuery: {
                return this.mapReference(node, signature);
            }
            case UnionType: {
                return TsType.Union;
            }
            case PropertyDeclaration: 
            case VariableDeclaration: {
                return this.variableType(node, signature);
            }
        }
        TSCType type = node.getTypeChecker().getTypeAtLocation(node);
        return this.mapType(type);
    }

    private JavaType array(TSCNode node, String signature) {
        JavaType.Array arr = new JavaType.Array(null, null);
        this.typeCache.put(signature, (Object)arr);
        TSCNode elementType = node.getNodeProperty("elementType");
        arr.unsafeSet(this.type(elementType));
        return arr;
    }

    @Nullable
    private JavaType.FullyQualified classType(@Nullable TSCNode node) {
        return this.classType(node, this.signatureBuilder.signature(node));
    }

    @Nullable
    private JavaType.FullyQualified classType(@Nullable TSCNode node, String signature) {
        if (node == null || node.syntaxKind() != TSCSyntaxKind.SourceFile && node.getTypeForNode() == null) {
            return null;
        }
        String fqn = this.signatureBuilder.classSignature(node);
        JavaType fq = (JavaType)this.typeCache.get(fqn);
        JavaType.Class clazz = (JavaType.Class)(fq instanceof JavaType.Parameterized ? ((JavaType.Parameterized)fq).getType() : fq);
        if (clazz == null) {
            JavaType.FullyQualified.Kind kind;
            TSCSyntaxKind syntaxKind = node.syntaxKind();
            switch (syntaxKind) {
                case EnumDeclaration: {
                    kind = JavaType.FullyQualified.Kind.Enum;
                    break;
                }
                case InterfaceDeclaration: {
                    kind = JavaType.FullyQualified.Kind.Interface;
                    break;
                }
                default: {
                    kind = JavaType.FullyQualified.Kind.Class;
                }
            }
            TSCNodeList modifiers = node.getOptionalNodeListProperty("modifiers");
            clazz = new JavaType.Class(null, this.mapModifiers(modifiers), TypeScriptSignatureBuilder.mapFqn(node), kind, null, null, null, null, null, null, null);
            this.typeCache.put(fqn, (Object)clazz);
            JavaType.FullyQualified owner = null;
            TSCNode parent = this.getOwner(node);
            if (parent.syntaxKind() == TSCSyntaxKind.ClassDeclaration) {
                owner = this.classType(parent);
            }
            JavaType.FullyQualified supertype = null;
            List interfaces = null;
            TSCNodeList heritageClauses = node.getOptionalNodeListProperty("heritageClauses");
            if (heritageClauses != null) {
                for (TSCNode heritageClause : heritageClauses) {
                    if (heritageClause.getText().contains("extends")) {
                        TSCNodeList superTypes = heritageClause.getNodeListProperty("types");
                        if (superTypes.size() > 1) {
                            this.implementMe(node.syntaxKind());
                            continue;
                        }
                        supertype = (JavaType.FullyQualified)this.type((TSCNode)superTypes.get(0));
                        continue;
                    }
                    this.implementMe(node.syntaxKind());
                }
            }
            ArrayList propertyNodes = null;
            ArrayList methodNodes = null;
            ArrayList enumNodes = null;
            if (node.hasProperty("members")) {
                for (Object member : node.getNodeListProperty("members")) {
                    if (((TSCNode)member).syntaxKind() == TSCSyntaxKind.CallSignature || ((TSCNode)member).syntaxKind() == TSCSyntaxKind.Constructor || ((TSCNode)member).syntaxKind() == TSCSyntaxKind.ConstructSignature || ((TSCNode)member).syntaxKind() == TSCSyntaxKind.FunctionDeclaration || ((TSCNode)member).syntaxKind() == TSCSyntaxKind.MethodDeclaration || ((TSCNode)member).syntaxKind() == TSCSyntaxKind.MethodSignature) {
                        if (methodNodes == null) {
                            methodNodes = new ArrayList(1);
                        }
                        methodNodes.add(member);
                        continue;
                    }
                    if (((TSCNode)member).syntaxKind() == TSCSyntaxKind.EnumMember || ((TSCNode)member).syntaxKind() == TSCSyntaxKind.PropertyDeclaration || ((TSCNode)member).syntaxKind() == TSCSyntaxKind.PropertySignature) {
                        if (propertyNodes == null) {
                            propertyNodes = new ArrayList(1);
                        }
                        propertyNodes.add(member);
                        continue;
                    }
                    if (((TSCNode)member).syntaxKind() == TSCSyntaxKind.EnumMember) {
                        if (enumNodes == null) {
                            enumNodes = new ArrayList(1);
                        }
                        enumNodes.add(member);
                        continue;
                    }
                    throw new IllegalStateException("Unable to find value declaration for symbol " + member);
                }
            }
            ArrayList<JavaType.Variable> members = null;
            if (enumNodes != null) {
                members = new ArrayList(enumNodes.size() + (propertyNodes == null ? 0 : propertyNodes.size()));
                for (TSCNode tSCNode : enumNodes) {
                    members.add(this.variableType(tSCNode, (JavaType.FullyQualified)clazz));
                }
            }
            if (propertyNodes != null) {
                members = new ArrayList<JavaType.Variable>(propertyNodes.size());
                for (TSCNode tSCNode : propertyNodes) {
                    members.add(this.variableType(tSCNode, (JavaType.FullyQualified)clazz));
                }
            }
            ArrayList<JavaType.Method> methods = null;
            if (methodNodes != null) {
                methods = new ArrayList<JavaType.Method>(methodNodes.size());
                for (TSCNode tSCNode : methodNodes) {
                    methods.add(this.methodDeclarationType(tSCNode, (JavaType.FullyQualified)clazz));
                }
            }
            clazz.unsafeSet(null, supertype, owner, this.mapAnnotations(modifiers), interfaces, members, methods);
        }
        if (node.hasProperty("typeParameters")) {
            JavaType jt = (JavaType)this.typeCache.get(signature);
            if (jt == null) {
                JavaType.Parameterized pt = new JavaType.Parameterized(null, null, null);
                this.typeCache.put(signature, (Object)pt);
                TSCNodeList paramNodes = node.getNodeListProperty("typeParameters");
                ArrayList<JavaType> typeParams = new ArrayList<JavaType>(paramNodes.size());
                for (TSCNode paramNode : paramNodes) {
                    typeParams.add(this.type(paramNode));
                }
                pt.unsafeSet((JavaType.FullyQualified)clazz, typeParams);
            } else if (!(jt instanceof JavaType.Parameterized)) {
                throw new UnsupportedOperationException("this should not have happened.");
            }
        }
        return clazz;
    }

    public JavaType.GenericTypeVariable generic(TSCNode node, String signature) {
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, node.getNodeProperty("name").getText(), JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, (Object)gtv);
        ArrayList<JavaType> bounds = null;
        JavaType.GenericTypeVariable.Variance variance = JavaType.GenericTypeVariable.Variance.INVARIANT;
        if (node.hasProperty("constraint")) {
            TSCNode constraint = node.getNodeProperty("constraint");
            if (constraint.syntaxKind() == TSCSyntaxKind.IntersectionType) {
                TSCNodeList types = constraint.getNodeListProperty("types");
                bounds = new ArrayList(types.size());
                for (TSCNode type : types) {
                    bounds.add(this.type(type));
                }
            } else {
                bounds = new ArrayList<JavaType>(1);
                bounds.add(this.type(constraint));
            }
            if (node.getText().contains("extends")) {
                variance = JavaType.GenericTypeVariable.Variance.COVARIANT;
            } else if (node.getText().contains("super")) {
                variance = JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
            }
        }
        gtv.unsafeSet(gtv.getName(), variance, bounds);
        return gtv;
    }

    @Nullable
    public JavaType.Method methodDeclarationType(TSCNode node) {
        return this.methodDeclarationType(node, null);
    }

    @Nullable
    public JavaType.Method methodDeclarationType(TSCNode node, @Nullable JavaType.FullyQualified declaringType) {
        String signature = this.signatureBuilder.methodSignature(node);
        JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        List paramNames = null;
        List defaultValues = null;
        boolean isConstructor = node.syntaxKind() == TSCSyntaxKind.Constructor;
        TSCNodeList modifiers = node.getOptionalNodeListProperty("modifiers");
        JavaType.Method method = new JavaType.Method(null, this.mapModifiers(modifiers), null, isConstructor ? "<constructor>" : (node.hasProperty("name") ? node.getNodeProperty("name").getText() : "{anonymous}"), null, paramNames, null, null, null, defaultValues);
        this.typeCache.put(signature, (Object)method);
        List exceptionTypes = null;
        JavaType.FullyQualified resolvedDeclaringType = declaringType;
        if (declaringType == null) {
            resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(this.getOwner(node)));
        }
        if (resolvedDeclaringType == null) {
            return null;
        }
        TSCNode returnTypeNode = node.getOptionalNodeProperty("type");
        JavaType returnType = returnTypeNode == null ? null : this.type(returnTypeNode);
        ArrayList<JavaType> parameterTypes = null;
        TSCNodeList paramNodes = node.getOptionalNodeListProperty("parameters");
        if (paramNodes != null && !paramNodes.isEmpty()) {
            parameterTypes = new ArrayList<JavaType>(paramNodes.size());
            for (TSCNode paramNode : paramNodes) {
                TSCNode typeNode = paramNode.getOptionalNodeProperty("type");
                if (typeNode == null) {
                    parameterTypes.add(this.type(paramNode));
                    continue;
                }
                parameterTypes.add(this.type(typeNode));
            }
        }
        method.unsafeSet(resolvedDeclaringType, (JavaType)(isConstructor ? resolvedDeclaringType : returnType), parameterTypes, exceptionTypes, this.mapAnnotations(modifiers));
        return method;
    }

    @Nullable
    public JavaType.Method methodInvocationType(TSCNode node) {
        String signature = this.signatureBuilder.methodSignature(node);
        JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        boolean isConstructor = node.syntaxKind() == TSCSyntaxKind.Constructor || node.syntaxKind() == TSCSyntaxKind.ConstructSignature || node.syntaxKind() == TSCSyntaxKind.NewExpression;
        TSCNode name = node.getOptionalNodeProperty("name");
        TSCNodeList modifiers = node.getOptionalNodeListProperty("modifiers");
        List paramNames = null;
        JavaType.Method method = new JavaType.Method(null, this.mapModifiers(modifiers), null, isConstructor ? "<constructor>" : (name == null ? "{anonymous}" : name.getText()), null, paramNames, null, null, null, null);
        this.typeCache.put(signature, (Object)method);
        TSCNodeList arguments = node.getOptionalNodeListProperty("arguments");
        ArrayList<JavaType> parameterTypes = null;
        if (arguments != null) {
            parameterTypes = new ArrayList<JavaType>(arguments.size());
            for (TSCNode argument : arguments) {
                parameterTypes.add(this.type(argument));
            }
        }
        List exceptionTypes = null;
        JavaType.FullyQualified resolvedDeclaringType = null;
        if (node.syntaxKind() == TSCSyntaxKind.NewExpression) {
            resolvedDeclaringType = (JavaType.FullyQualified)this.type(node.getNodeProperty("expression"));
        } else {
            TSCSymbol symbol = node.getTypeChecker().getTypeAtLocation(node).getOptionalSymbolProperty("symbol");
            if (symbol != null) {
                JavaType j = this.type(symbol.getValueDeclaration());
                if (j instanceof JavaType.FullyQualified) {
                    resolvedDeclaringType = (JavaType.FullyQualified)this.type(symbol.getValueDeclaration());
                } else {
                    this.implementMe(node.syntaxKind());
                }
            } else {
                resolvedDeclaringType = TsType.MissingSymbol;
            }
        }
        TSCNode returnNode = node.getOptionalNodeProperty("type");
        JavaType returnType = returnNode == null ? null : this.type(returnNode);
        method.unsafeSet(resolvedDeclaringType, (JavaType)(isConstructor ? resolvedDeclaringType : returnType), parameterTypes, exceptionTypes, this.mapAnnotations(modifiers));
        return method;
    }

    public JavaType.Primitive primitive(TSCNode node) {
        switch (node.syntaxKind()) {
            case BigIntKeyword: 
            case BigIntLiteral: {
                this.implementMe(node.syntaxKind());
            }
            case BooleanKeyword: 
            case FalseKeyword: 
            case TrueKeyword: {
                return JavaType.Primitive.Boolean;
            }
            case StringKeyword: {
                return JavaType.Primitive.String;
            }
            case NullKeyword: {
                return JavaType.Primitive.Null;
            }
            case NumberKeyword: 
            case NumericLiteral: {
                return JavaType.Primitive.Long;
            }
            case UnknownKeyword: {
                return JavaType.Primitive.None;
            }
            case VoidKeyword: {
                return JavaType.Primitive.Void;
            }
        }
        this.implementMe(node.syntaxKind());
        return JavaType.Primitive.None;
    }

    @Nullable
    public JavaType.Variable variableType(TSCNode node) {
        return this.variableType(node, null, this.signatureBuilder.variableSignature(node));
    }

    @Nullable
    public JavaType.Variable variableType(TSCNode node, String signature) {
        return this.variableType(node, null, signature);
    }

    @Nullable
    public JavaType.Variable variableType(TSCNode node, @Nullable JavaType.FullyQualified declaringType) {
        return this.variableType(node, declaringType, this.signatureBuilder.variableSignature(node));
    }

    @Nullable
    public JavaType.Variable variableType(TSCNode node, @Nullable JavaType.FullyQualified declaringType, String signature) {
        TSCNode typeNode;
        JavaType.Variable existing = (JavaType.Variable)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        TSCNodeList modifiers = node.getOptionalNodeListProperty("modifiers");
        JavaType.Variable variable = new JavaType.Variable(null, this.mapModifiers(modifiers), node.getNodeProperty("name").getText(), null, null, null);
        this.typeCache.put(signature, (Object)variable);
        List annotations = Collections.emptyList();
        JavaType.FullyQualified resolvedOwner = declaringType;
        if (resolvedOwner == null) {
            resolvedOwner = this.classType(this.getOwner(node));
        }
        JavaType type = (typeNode = node.getOptionalNodeProperty("type")) != null ? this.type(typeNode) : this.resolveNode(node);
        if (resolvedOwner == null || type instanceof JavaType.Unknown) {
            return null;
        }
        variable.unsafeSet((JavaType)resolvedOwner, type, annotations);
        return variable;
    }

    @Nullable
    private List<JavaType.FullyQualified> mapAnnotations(@Nullable List<TSCNode> modifiers) {
        if (modifiers == null || modifiers.isEmpty()) {
            return null;
        }
        List annotationNodes = modifiers.stream().filter(n -> n.syntaxKind() == TSCSyntaxKind.Decorator).collect(Collectors.toList());
        ArrayList<JavaType.FullyQualified> annotations = new ArrayList<JavaType.FullyQualified>(annotationNodes.size());
        for (TSCNode annotation : annotationNodes) {
            annotations.add((JavaType.FullyQualified)this.type(annotation));
        }
        return annotations.isEmpty() ? null : annotations;
    }

    private JavaType mapEnumMember(TSCNode node) {
        return this.type(node.getParent());
    }

    private JavaType mapIdentifier(TSCNode node) {
        TSCSymbol symbol = node.getTypeChecker().getTypeAtLocation(node).getOptionalSymbolProperty("symbol");
        if (symbol != null) {
            List<TSCNode> declarations = symbol.getDeclarations();
            if (declarations != null && !declarations.isEmpty()) {
                if (declarations.size() == 1) {
                    return this.type(declarations.get(0));
                }
                return TsType.MergedInterface;
            }
            this.implementMe(node.syntaxKind());
        }
        return this.mapType(node.getTypeChecker().getTypeAtLocation(node));
    }

    private long mapModifiers(@Nullable List<TSCNode> modifiers) {
        if (modifiers == null) {
            return 0L;
        }
        HashSet<Flag> flags = new HashSet<Flag>();
        block21: for (TSCNode modifier : modifiers) {
            switch (modifier.getText()) {
                case "public": {
                    flags.add(Flag.Public);
                    continue block21;
                }
                case "private": {
                    flags.add(Flag.Private);
                    continue block21;
                }
                case "protected": {
                    flags.add(Flag.Protected);
                    continue block21;
                }
                case "static": {
                    flags.add(Flag.Static);
                    continue block21;
                }
                case "readonly": {
                    flags.add(Flag.Final);
                    continue block21;
                }
                case "abstract": {
                    flags.add(Flag.Abstract);
                    continue block21;
                }
                case "default": {
                    flags.add(Flag.Default);
                    continue block21;
                }
                case "async": 
                case "export": {
                    continue block21;
                }
            }
            if (modifier.syntaxKind() == TSCSyntaxKind.Decorator) continue;
            this.implementMe(modifier.syntaxKind());
        }
        return Flag.flagsToBitMap(flags);
    }

    private JavaType mapParameter(TSCNode node) {
        return this.resolveNode(node);
    }

    private JavaType mapQualifiedName(TSCNode node) {
        return this.resolveNode(node);
    }

    private JavaType mapReference(TSCNode node, String signature) {
        TSCNodeList typeArguments;
        JavaType classType = null;
        TSCNode name = node.getOptionalNodeProperty("typeName");
        if (name != null) {
            classType = this.type(name);
        }
        name = node.getOptionalNodeProperty("exprName");
        if (classType == null && name != null) {
            classType = this.type(name);
        }
        if (classType == null) {
            classType = this.type(node.getNodeProperty("expression"));
        }
        if (classType instanceof JavaType.Parameterized) {
            classType = ((JavaType.Parameterized)classType).getType();
        }
        if ((typeArguments = node.getOptionalNodeListProperty("typeArguments")) == null) {
            this.typeCache.put(signature, (Object)classType);
            return classType;
        }
        JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)classType);
        assert (fq != null);
        JavaType.Parameterized pt = new JavaType.Parameterized(null, null, null);
        this.typeCache.put(signature, (Object)pt);
        ArrayList<JavaType> params = new ArrayList<JavaType>(typeArguments.size());
        for (TSCNode typeArg : typeArguments) {
            params.add(this.type(typeArg));
        }
        pt.unsafeSet(TypeUtils.asFullyQualified((JavaType)classType), params);
        return pt;
    }

    private JavaType mapSourceFileFqn(String signature) {
        JavaType.ShallowClass sourceClass = JavaType.ShallowClass.build((String)signature);
        this.typeCache.put(signature, (Object)sourceClass);
        return sourceClass;
    }

    private JavaType mapThis(TSCNode node) {
        return this.resolveNode(node);
    }

    private JavaType mapTypeOperator(TSCNode node) {
        return this.type(node.getNodeProperty("type"));
    }

    private JavaType mapType(TSCType type) {
        TSCTypeFlag flag = null;
        try {
            flag = type.getExactTypeFlag();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (flag != null) {
            switch (flag) {
                case Any: {
                    return TsType.Any;
                }
                case Boolean: 
                case BooleanLiteral: {
                    return JavaType.Primitive.Boolean;
                }
                case Number: 
                case NumberLiteral: {
                    return TsType.Number;
                }
                case Null: {
                    return JavaType.Primitive.Null;
                }
                case Object: {
                    return TsType.Anonymous;
                }
                case String: 
                case StringLiteral: {
                    return JavaType.Primitive.String;
                }
                case Undefined: {
                    return TsType.Undefined;
                }
                case Union: {
                    return TsType.Union;
                }
                case Unit: {
                    return TsType.Unit;
                }
                case Unknown: {
                    return TsType.Unknown;
                }
                case Void: {
                    return JavaType.Primitive.Void;
                }
                case Enum: {
                    return TsType.Enum;
                }
                case EnumLiteral: {
                    return TsType.EnumLiteral;
                }
                case BigInt: {
                    return TsType.BigInt;
                }
                case BigIntLiteral: {
                    return TsType.BigIntLiteral;
                }
                case ESSymbol: {
                    return TsType.ESSymbol;
                }
                case UniqueESSymbol: {
                    return TsType.UniqueESSymbol;
                }
                case Never: {
                    return TsType.Never;
                }
                case TypeParameter: {
                    return TsType.TypeParameter;
                }
                case Intersection: {
                    return TsType.Intersection;
                }
                case Index: {
                    return TsType.Index;
                }
                case IndexedAccess: {
                    return TsType.IndexedAccess;
                }
                case Conditional: {
                    return TsType.Conditional;
                }
                case Substitution: {
                    return TsType.Substitution;
                }
                case NonPrimitive: {
                    return TsType.NonPrimitive;
                }
                case TemplateLiteral: {
                    return TsType.TemplateLiteral;
                }
                case StringMapping: {
                    return TsType.StringMapping;
                }
                case AnyOrUnknown: {
                    return TsType.AnyOrUnknown;
                }
                case Nullable: {
                    return TsType.Nullable;
                }
                case Literal: {
                    return TsType.Literal;
                }
                case Freshable: {
                    return TsType.Freshable;
                }
                case StringOrNumberLiteral: {
                    return TsType.StringOrNumberLiteral;
                }
                case StringOrNumberLiteralOrUnique: {
                    return TsType.StringOrNumberLiteralOrUnique;
                }
                case DefinitelyFalsy: {
                    return TsType.DefinitelyFalsy;
                }
                case PossiblyFalsy: {
                    return TsType.PossiblyFalsy;
                }
                case Intrinsic: {
                    return TsType.Intrinsic;
                }
                case Primitive: {
                    return TsType.Primitive;
                }
                case StringLike: {
                    return TsType.StringLike;
                }
                case NumberLike: {
                    return TsType.NumberLike;
                }
                case BigIntLike: {
                    return TsType.BigIntLike;
                }
                case BooleanLike: {
                    return TsType.BooleanLike;
                }
                case EnumLike: {
                    return TsType.EnumLike;
                }
                case ESSymbolLike: {
                    return TsType.ESSymbolLike;
                }
                case VoidLike: {
                    return TsType.VoidLike;
                }
                case DefinitelyNonNullable: {
                    return TsType.DefinitelyNonNullable;
                }
                case DisjointDomains: {
                    return TsType.DisjointDomains;
                }
                case UnionOrIntersection: {
                    return TsType.UnionOrIntersection;
                }
                case StructuredType: {
                    return TsType.StructuredType;
                }
                case TypeVariable: {
                    return TsType.TypeVariable;
                }
                case InstantiableNonPrimitive: {
                    return TsType.InstantiableNonPrimitive;
                }
                case InstantiablePrimitive: {
                    return TsType.InstantiablePrimitive;
                }
                case Instantiable: {
                    return TsType.Instantiable;
                }
                case StructuredOrInstantiable: {
                    return TsType.StructuredOrInstantiable;
                }
                case ObjectFlagsType: {
                    return TsType.ObjectFlagsType;
                }
                case Simplifiable: {
                    return TsType.Simplifiable;
                }
                case Singleton: {
                    return TsType.Singleton;
                }
                case Narrowable: {
                    return TsType.Narrowable;
                }
                case IncludesMask: {
                    return TsType.IncludesMask;
                }
                case NotPrimitiveUnion: {
                    return TsType.NotPrimitiveUnion;
                }
            }
            this.implementMe(type);
        } else {
            TSCObjectFlag objectFlag = TSCObjectFlag.fromMaskExact(type.getObjectFlags());
            if (objectFlag == TSCObjectFlag.PrimitiveUnion) {
                return TsType.PrimitiveUnion;
            }
            this.implementMe(type);
        }
        return null;
    }

    private TSCNode getOwner(TSCNode node) {
        TSCNode parent = node.getParent();
        if (parent == null) {
            return node;
        }
        if (parent.syntaxKind() == TSCSyntaxKind.SourceFile || parent.syntaxKind() == TSCSyntaxKind.ClassDeclaration || parent.syntaxKind() == TSCSyntaxKind.EnumDeclaration || parent.syntaxKind() == TSCSyntaxKind.InterfaceDeclaration || parent.syntaxKind() == TSCSyntaxKind.MethodDeclaration) {
            return parent;
        }
        return this.getOwner(node.getParent());
    }

    private JavaType resolveNode(TSCNode node) {
        TSCSymbol symbol = node.getTypeChecker().getTypeAtLocation(node).getOptionalSymbolProperty("symbol");
        if (symbol != null) {
            try {
                return this.type(symbol.getValueDeclaration());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mapType(node.getTypeChecker().getTypeAtLocation(node));
    }

    private void implementMe(TSCSyntaxKind syntaxKind) {
        throw new UnsupportedOperationException(syntaxKind.name() + " syntaxKind is not supported in TypeMapping.");
    }

    private void implementMe(TSCType type) {
        throw new UnsupportedOperationException(type.typeToString() + " type is not supported in TypeMapping.");
    }
}

