/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.javascript.JavaScriptIsoVisitor;
import org.openrewrite.javascript.table.ParseExceptionAnalysis;
import org.openrewrite.marker.SearchResult;

@Incubating(since="0.0")
public final class FindParseExceptionAnalysis
extends Recipe {
    private final transient ParseExceptionAnalysis report = new ParseExceptionAnalysis(this);
    @Option(displayName="Mark source files", description="Adds a `SearchResult` marker to LST elements that resulted in a parser exception.", required=false)
    @Nullable
    private final Boolean markFailures;
    @Option(displayName="`ParseExceptionAnalysis.nodeType`", description="Limits the marked results to a specific node type.", required=false)
    @Nullable
    private final String nodeType;

    public String getDisplayName() {
        return "Parser exception report";
    }

    public String getDescription() {
        return "Find ParseExceptionResults per LST element and create a data tables to prioritize fixing parsing failures. This recipe is an iteration of `FindParseFailures` that uses `ParseExceptionAnalysis` to identify parser exceptions on a per-node basis.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        HashMap<String, Map<String, Integer>> counts = new HashMap<String, Map<String, Integer>>();
        JavaScriptIsoVisitor<Integer> target = new JavaScriptIsoVisitor<Integer>();
        if (Boolean.TRUE.equals(this.markFailures)) {
            List after = ListUtils.map(before, it -> target.isAcceptable((SourceFile)it, 0) ? (SourceFile)new AnalysisVisitor((SourceFile)it, (Map<String, Map<String, Integer>>)counts, this.markFailures, this.nodeType).visit((Tree)it, ctx) : it);
            return this.analyzeResults(after, ctx, counts);
        }
        for (SourceFile sourceFile : before) {
            if (!target.isAcceptable(sourceFile, 0)) continue;
            new AnalysisVisitor(sourceFile, counts, this.markFailures, this.nodeType).visit((Tree)sourceFile, ctx);
        }
        return this.analyzeResults(before, ctx, counts);
    }

    private List<SourceFile> analyzeResults(List<SourceFile> before, ExecutionContext ctx, Map<String, Map<String, Integer>> counts) {
        for (Map.Entry<String, Map<String, Integer>> fileExtensionEntries : counts.entrySet()) {
            for (Map.Entry<String, Integer> nodeTypeCounts : fileExtensionEntries.getValue().entrySet()) {
                this.report.insertRow(ctx, new ParseExceptionAnalysis.Row(fileExtensionEntries.getKey(), nodeTypeCounts.getKey(), nodeTypeCounts.getValue()));
            }
        }
        return before;
    }

    public FindParseExceptionAnalysis(Boolean markFailures, String nodeType) {
        this.markFailures = markFailures;
        this.nodeType = nodeType;
    }

    public ParseExceptionAnalysis getReport() {
        return this.report;
    }

    public Boolean getMarkFailures() {
        return this.markFailures;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String toString() {
        return "FindParseExceptionAnalysis(report=" + (Object)((Object)this.getReport()) + ", markFailures=" + this.getMarkFailures() + ", nodeType=" + this.getNodeType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindParseExceptionAnalysis)) {
            return false;
        }
        FindParseExceptionAnalysis other = (FindParseExceptionAnalysis)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$markFailures = this.getMarkFailures();
        Boolean other$markFailures = other.getMarkFailures();
        if (this$markFailures == null ? other$markFailures != null : !((Object)this$markFailures).equals(other$markFailures)) {
            return false;
        }
        String this$nodeType = this.getNodeType();
        String other$nodeType = other.getNodeType();
        return !(this$nodeType == null ? other$nodeType != null : !this$nodeType.equals(other$nodeType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindParseExceptionAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $markFailures = this.getMarkFailures();
        result = result * 59 + ($markFailures == null ? 43 : ((Object)$markFailures).hashCode());
        String $nodeType = this.getNodeType();
        result = result * 59 + ($nodeType == null ? 43 : $nodeType.hashCode());
        return result;
    }

    private static class AnalysisVisitor
    extends TreeVisitor<Tree, ExecutionContext> {
        private final Map<String, Map<String, Integer>> counts;
        private final Set<String> ids = new HashSet<String>();
        private final boolean markFailures;
        @Nullable
        private final String markNodeType;
        private final String extension;

        public AnalysisVisitor(SourceFile source, Map<String, Map<String, Integer>> counts, @Nullable Boolean markFailures, @Nullable String markNodeType) {
            this.counts = counts;
            this.markFailures = Boolean.TRUE.equals(markFailures);
            this.markNodeType = markNodeType;
            this.extension = source.getSourcePath().toString().substring(source.getSourcePath().toString().lastIndexOf(".") + 1);
        }

        @Nullable
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            ParseExceptionResult result;
            if (tree == null) {
                return null;
            }
            Tree t = super.visit(tree, (Object)ctx);
            if (t != null && (result = (ParseExceptionResult)t.getMarkers().findFirst(ParseExceptionResult.class).orElse(null)) != null) {
                String nodeType = ParseExceptionAnalysis.getNodeType(result.getMessage());
                if (this.markFailures && (this.markNodeType == null || this.markNodeType.equals(nodeType)) && this.ids.add(result.getId().toString())) {
                    t = SearchResult.found((Tree)t);
                }
                Map nodeTypeCounts = this.counts.computeIfAbsent(this.extension, k -> new HashMap());
                nodeTypeCounts.merge(nodeType, 1, Integer::sum);
            }
            return t;
        }
    }
}

