/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openrewrite.DebugOnly;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.javascript.internal.tsc.TSCGlobals;
import org.openrewrite.javascript.internal.tsc.TSCInstanceOfChecks;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCSymbol;
import org.openrewrite.javascript.internal.tsc.TSCSyntaxListNode;
import org.openrewrite.javascript.internal.tsc.TSCType;
import org.openrewrite.javascript.internal.tsc.TSCUtils;
import org.openrewrite.javascript.internal.tsc.TSCV8Backed;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;

public class TSCNode
implements TSCV8Backed {
    private final TSCProgramContext programContext;
    public final V8ValueObject nodeV8;

    static boolean isValidBackingObject(TSCProgramContext programContext, V8ValueObject objectV8) {
        TSCInstanceOfChecks.InterfaceKind interfaceKind = programContext.identifyInterfaceKind((V8Value)objectV8);
        return interfaceKind == TSCInstanceOfChecks.InterfaceKind.Node;
    }

    static TSCNode wrap(TSCProgramContext programContext, V8ValueObject objectV8) {
        TSCSyntaxKind syntaxKind;
        if (!TSCNode.isValidBackingObject(programContext, objectV8)) {
            throw new IllegalArgumentException("object provided is not actually a TSC node");
        }
        try {
            syntaxKind = TSCSyntaxKind.fromCode(objectV8.getInteger((Object)"kind"));
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
        switch (syntaxKind) {
            case SyntaxList: {
                return new TSCSyntaxListNode(programContext, objectV8);
            }
            case SourceFile: {
                return new SourceFile(programContext, objectV8);
            }
        }
        TSCGlobals ts = programContext.getTypeScriptGlobals();
        if (ts.invokeMethodBoolean("isTypeNode", objectV8)) {
            return new TypeNode(programContext, objectV8);
        }
        return new TSCNode(programContext, objectV8);
    }

    protected TSCNode(TSCProgramContext programContext, V8ValueObject nodeV8) {
        this.programContext = programContext;
        this.nodeV8 = nodeV8;
    }

    @Override
    public TSCProgramContext getProgramContext() {
        return this.programContext;
    }

    public String toString() {
        return String.format("Node(%s@[%d,%d); \u00ab%s\u00bb)", this.syntaxKind().name(), this.getStart(), this.getEnd(), TSCUtils.preview(this.getText(), 15));
    }

    public int syntaxKindCode() {
        return this.getIntProperty("kind");
    }

    public TSCSyntaxKind syntaxKind() {
        return TSCSyntaxKind.fromCode(this.syntaxKindCode());
    }

    @Nullable
    public TSCType getTypeForNode() {
        return this.programContext.getTypeChecker().getTypeAtLocation(this);
    }

    @DebugOnly
    public TSCNode firstNodeContaining(String text) {
        return this.firstNodeContaining(text, null);
    }

    @DebugOnly
    public TSCNode firstNodeContaining(String text, @Nullable TSCSyntaxKind kind) {
        for (TSCNode child : this.getAllChildNodes()) {
            TSCNode found = child.firstNodeContaining(text, kind);
            if (found == null) continue;
            return found;
        }
        if (!this.getText().contains(text)) {
            return null;
        }
        if (kind != null && this.syntaxKind() != kind) {
            return null;
        }
        return this;
    }

    @DebugOnly
    public TSCNode firstNodeWithText(String text) {
        return Objects.requireNonNull(this.firstNodeWithTextOrNull(text));
    }

    @DebugOnly
    @Nullable
    public TSCNode firstNodeWithTextOrNull(String text) {
        for (TSCNode child : this.getAllChildNodes()) {
            TSCNode found = child.firstNodeWithTextOrNull(text);
            if (found == null) continue;
            return found;
        }
        if (text.equals(this.getText())) {
            return this;
        }
        return null;
    }

    @Nullable
    public TSCNode findNodeAtPosition(int position) {
        if (!this.containsPosition(position)) {
            throw new IllegalArgumentException(String.format("Attempt to find node at position %d, but this %s node only covers [%d, %d).", new Object[]{position, this.syntaxKind(), this.getStart(), this.getEnd()}));
        }
        if (this.getStart() == position) {
            return this;
        }
        for (TSCNode child : this.getAllChildNodes()) {
            if (!child.containsPosition(position)) continue;
            return child.findNodeAtPosition(position);
        }
        return null;
    }

    public boolean containsPosition(int position) {
        return position >= this.getStart() && position < this.getEnd();
    }

    @Nullable
    public TSCSymbol getSymbolForNode() {
        return this.programContext.getTypeChecker().getSymbolAtLocation(this);
    }

    public int getStartWithLeadingSpace() {
        return this.getIntProperty("pos");
    }

    public int getStart() {
        return this.getIntProperty("getStart()");
    }

    public int getEnd() {
        return this.getIntProperty("end");
    }

    public int getChildCount() {
        return this.getIntProperty("getChildCount");
    }

    @Nullable
    public TSCNode getParent() {
        return this.getOptionalNodeProperty("parent");
    }

    @DebugOnly
    @Nullable
    public TSCNode nearestContainingNamedDeclaration() {
        return Objects.requireNonNull(this.nearestContainingNamedDeclarationOrNull());
    }

    @DebugOnly
    @Nullable
    public TSCNode nearestContainingNamedDeclarationOrNull() {
        for (TSCNode node = this.getParent(); node != null; node = node.getParent()) {
            if (!node.hasProperty("name")) continue;
            return node;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public TSCNode getChildNode(String name) {
        return this.getOptionalNodeProperty(name);
    }

    @Deprecated
    public TSCNode getChildNodeRequired(String name) {
        return this.getNodeProperty(name);
    }

    @Deprecated
    public List<TSCNode> getChildNodes(String name) {
        return this.getNodeListProperty(name);
    }

    public SourceFile getSourceFile() {
        return Objects.requireNonNull(this.getNodeProperty("getSourceFile()").assertSourceFile());
    }

    public SourceFile assertSourceFile() {
        if (this instanceof SourceFile) {
            return (SourceFile)this;
        }
        throw new IllegalStateException("not a source file: " + (Object)((Object)this.syntaxKind()));
    }

    public String getText() {
        return this.getStringProperty("getText()");
    }

    public TypeNode assertTypeNode() {
        if (this instanceof TypeNode) {
            return (TypeNode)this;
        }
        throw new IllegalStateException("expected a TypeNode, but this is an ordinary Node");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TSCNode> getAllChildNodes() {
        try (V8Value v8Value = this.nodeV8.invoke("getChildren", new V8Value[0]);){
            if (v8Value.isNullOrUndefined()) {
                List<TSCNode> list = Collections.emptyList();
                return list;
            }
            V8ValueArray v8Array = (V8ValueArray)v8Value;
            int count = v8Array.getLength();
            ArrayList<TSCNode> result = new ArrayList<TSCNode>(count);
            for (int i = 0; i < count; ++i) {
                try (V8Value child = v8Array.get(i);){
                    result.add(this.programContext.tscNode((V8ValueObject)child));
                    continue;
                }
            }
            ArrayList<TSCNode> arrayList = result;
            return arrayList;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @DebugOnly
    public void printTree(PrintStream ps) {
        this.printTree(ps, "");
    }

    private void printTree(PrintStream ps, String indent) {
        ps.print(indent);
        ps.print((Object)this.syntaxKind());
        if (this.syntaxKind().name().contains("Literal")) {
            ps.print(" (" + this.getText() + ")");
        }
        ps.println();
        String childIndent = indent + "  ";
        for (TSCNode child : this.getAllChildNodes()) {
            child.printTree(ps, childIndent);
        }
    }

    @Override
    public V8ValueObject getBackingV8Object() {
        return this.nodeV8;
    }

    public static class SourceFile
    extends TSCNode {
        protected SourceFile(TSCProgramContext programContext, V8ValueObject nodeV8) {
            super(programContext, nodeV8);
        }

        public String getFileName() {
            return this.getStringProperty("fileName");
        }

        public String getPath() {
            return this.getStringProperty("path");
        }

        public String getResolvedPath() {
            return this.getStringProperty("resolvedPath");
        }

        public String getOriginalFileName() {
            return this.getStringProperty("originalFileName");
        }

        public String getModuleName() {
            return this.getStringProperty("moduleName");
        }

        public TSCProgramContext.CompilerBridgeSourceInfo getCompilerBridgeSourceInfo() {
            return this.getProgramContext().getBridgeSourceInfo(this);
        }
    }

    public static class TypeNode
    extends TSCNode {
        protected TypeNode(TSCProgramContext programContext, V8ValueObject nodeV8) {
            super(programContext, nodeV8);
        }

        public TSCType getTypeFromTypeNode() {
            return this.getTypeChecker().getTypeFromTypeNode(this);
        }
    }
}

