/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal;

import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JsLeftPadded;
import org.openrewrite.javascript.tree.JsRightPadded;
import org.openrewrite.javascript.tree.JsSpace;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.markers.ForLoopType;
import org.openrewrite.markers.FunctionDeclaration;
import org.openrewrite.markers.TypeReferencePrefix;
import org.openrewrite.markers.VariableModifier;

public class JavaScriptPrinter<P>
extends JavaScriptVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> JAVA_SCRIPT_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";
    private final JavaScriptJavaPrinter delegate = new JavaScriptJavaPrinter();

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof JS)) {
            return this.delegate.visit(tree, p);
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J visitCompilationUnit(JS.CompilationUnit cu, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visitRightPadded(cu.getPadding().getStatements(), JRightPadded.Location.LANGUAGE_EXTENSION, "", p);
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        this.afterSyntax(cu, p);
        return cu;
    }

    @Override
    public J visitJsBinary(JS.JsBinary binary, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)binary, JsSpace.Location.BINARY_PREFIX, p);
        this.visit((Tree)binary.getLeft(), p);
        String keyword = "";
        switch (binary.getOperator()) {
            case IdentityEquals: {
                keyword = "===";
                break;
            }
            case IdentityNotEquals: {
                keyword = "!==";
            }
        }
        this.visitSpace(binary.getPadding().getOperator().getBefore(), JsSpace.Location.BINARY_PREFIX, p);
        p.append(keyword);
        this.visit((Tree)binary.getRight(), p);
        this.afterSyntax(binary, p);
        return binary;
    }

    @Override
    public J visitJsOperator(JS.JsOperator operator, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)operator, JsSpace.Location.BINARY_PREFIX, p);
        this.visit((Tree)operator.getLeft(), p);
        String keyword = "";
        switch (operator.getOperator()) {
            case Delete: {
                keyword = "delete";
                break;
            }
            case In: {
                keyword = "in";
                break;
            }
            case TypeOf: {
                keyword = "typeof";
            }
        }
        this.visitSpace(operator.getPadding().getOperator().getBefore(), JsSpace.Location.OPERATOR_PREFIX, p);
        p.append(keyword);
        this.visit((Tree)operator.getRight(), p);
        this.afterSyntax(operator, p);
        return operator;
    }

    @Override
    public J visitTypeOperator(JS.TypeOperator typeOperator, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeOperator, JsSpace.Location.BINARY_PREFIX, p);
        String keyword = "";
        if (typeOperator.getOperator() == JS.TypeOperator.Type.ReadOnly) {
            keyword = "readonly";
        }
        p.append(keyword);
        this.visitLeftPadded(typeOperator.getPadding().getExpression(), JsLeftPadded.Location.TYPE_OPERATOR, p);
        this.afterSyntax(typeOperator, p);
        return typeOperator;
    }

    @Override
    public J visitUnion(JS.Union union, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)union, JsSpace.Location.UNION_PREFIX, p);
        this.visitRightPadded(union.getPadding().getTypes(), JsRightPadded.Location.UNION_TYPE, "|", p);
        this.afterSyntax(union, p);
        return union;
    }

    @Override
    public J visitUnknownElement(JS.UnknownElement unknownElement, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)unknownElement, JsSpace.Location.UNION_PREFIX, p);
        this.visit((Tree)unknownElement.getSource(), p);
        this.afterSyntax(unknownElement, p);
        return unknownElement;
    }

    @Override
    public J visitUnknownElementSource(JS.UnknownElement.Source source, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)source, JsSpace.Location.UNKNOWN_SOURCE_PREFIX, p);
        p.append(source.getText());
        this.afterSyntax(source, p);
        return source;
    }

    protected void beforeSyntax(J j, JsSpace.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable JsSpace.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
    }

    protected void beforeSyntax(J j, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
    }

    protected void afterSyntax(J j, PrintOutputCapture<P> p) {
        this.afterSyntax(j.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit((Tree)leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JsRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    @Override
    public Space visitSpace(Space space, JsSpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, loc, p);
    }

    public Markers visitMarkers(Markers markers, PrintOutputCapture<P> pPrintOutputCapture) {
        return this.delegate.visitMarkers(markers, pPrintOutputCapture);
    }

    private class JavaScriptJavaPrinter
    extends JavaPrinter<P> {
        private JavaScriptJavaPrinter() {
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof JS) {
                return JavaScriptPrinter.this.visit(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public J visitTypeCast(J.TypeCast typeCast, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)typeCast, Space.Location.TYPE_CAST_PREFIX, p);
            this.visit((Tree)typeCast.getExpression(), p);
            this.visitSpace(typeCast.getClazz().getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("as");
            this.visitRightPadded(typeCast.getClazz().getPadding().getTree(), JRightPadded.Location.NAMED_VARIABLE, p);
            this.afterSyntax((J)typeCast, p);
            return typeCast;
        }

        public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
            p.append("for");
            J.ForEachLoop.Control ctrl = forEachLoop.getControl();
            this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
            p.append('(');
            ForLoopType forLoopType = forEachLoop.getMarkers().findFirst(ForLoopType.class).orElse(null);
            String suffix = forLoopType == null ? ":" : forLoopType.getKeyword().getWord();
            this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, suffix, p);
            this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
            p.append(')');
            this.visitStatement((JRightPadded<Statement>)forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
            this.afterSyntax((J)forEachLoop, p);
            return forEachLoop;
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(method.getLeadingAnnotations(), p);
            if (method.getMarkers().findFirst(FunctionDeclaration.class).isPresent()) {
                p.append("function");
            }
            this.visit((Tree)method.getName(), p);
            this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
            if (method.getReturnTypeExpression() != null) {
                TypeReferencePrefix typeReferencePrefix = method.getReturnTypeExpression().getMarkers().findFirst(TypeReferencePrefix.class).orElse(null);
                if (typeReferencePrefix != null) {
                    this.visitSpace(typeReferencePrefix.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                    p.append(":");
                }
                this.visit((Tree)method.getReturnTypeExpression(), p);
            }
            this.visit((Tree)method.getBody(), p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)newArray, Space.Location.NEW_ARRAY_PREFIX, p);
            this.visit((Tree)newArray.getTypeExpression(), p);
            this.visit(newArray.getDimensions(), p);
            this.visitContainer("[", newArray.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, ",", "]", p);
            this.afterSyntax((J)newArray, p);
            return newArray;
        }

        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visit(multiVariable.getLeadingAnnotations(), p);
            for (J.Modifier m : multiVariable.getModifiers()) {
                this.visitModifier(m, p);
            }
            VariableModifier variableModifier = multiVariable.getMarkers().findFirst(VariableModifier.class).orElse(null);
            if (variableModifier != null) {
                switch (variableModifier.getKeyword()) {
                    case CONST: {
                        p.append(VariableModifier.Keyword.CONST.getWord());
                        break;
                    }
                    case LET: {
                        p.append(VariableModifier.Keyword.LET.getWord());
                        break;
                    }
                    case VAR: {
                        p.append(VariableModifier.Keyword.VAR.getWord());
                    }
                }
            }
            List variables = multiVariable.getPadding().getVariables();
            for (int i = 0; i < variables.size(); ++i) {
                JRightPadded variable = (JRightPadded)variables.get(i);
                this.beforeSyntax((J)variable.getElement(), Space.Location.VARIABLE_PREFIX, p);
                this.visit((Tree)((J.VariableDeclarations.NamedVariable)variable.getElement()).getName(), p);
                if (multiVariable.getTypeExpression() != null) {
                    multiVariable.getMarkers().findFirst(TypeReferencePrefix.class).ifPresent(typeReferencePrefix -> this.visitSpace(typeReferencePrefix.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p));
                    p.append(":");
                    this.visit((Tree)multiVariable.getTypeExpression(), p);
                }
                if (((J.VariableDeclarations.NamedVariable)variable.getElement()).getInitializer() != null) {
                    JavaScriptPrinter.this.visitLeftPadded("=", (JLeftPadded<J>)((J.VariableDeclarations.NamedVariable)variable.getElement()).getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p);
                }
                this.visitSpace(variable.getAfter(), Space.Location.NAMED_VARIABLE_SUFFIX, p);
                this.afterSyntax((J)variable.getElement(), p);
                if (i < variables.size() - 1) {
                    p.append(",");
                    continue;
                }
                if (!variable.getMarkers().findFirst(Semicolon.class).isPresent()) continue;
                p.append(";");
            }
            this.afterSyntax((J)multiVariable, p);
            return multiVariable;
        }

        public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)variable, Space.Location.VARIABLE_PREFIX, p);
            this.visit((Tree)variable.getName(), p);
            this.afterSyntax((J)variable, p);
            return variable;
        }

        protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
            if (paddedStat != null) {
                this.visit((Tree)paddedStat.getElement(), p);
                this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
                this.visitMarkers(paddedStat.getMarkers(), p);
            }
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof TrailingComma) {
                p.append(",");
                this.visitSpace(((TrailingComma)marker).getSuffix(), Space.Location.LANGUAGE_EXTENSION, p);
            } else if (marker instanceof Semicolon) {
                p.append(';');
            }
            return (M)super.visitMarker(marker, p);
        }
    }
}

