/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JsContainer;
import org.openrewrite.javascript.tree.JsLeftPadded;
import org.openrewrite.javascript.tree.JsRightPadded;
import org.openrewrite.javascript.tree.JsSpace;

public class JavaScriptVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof JS.CompilationUnit;
    }

    public String getLanguage() {
        return "javascript";
    }

    public J visitJavaSourceFile(JavaSourceFile cu, P p) {
        return cu instanceof JS.CompilationUnit ? this.visitCompilationUnit((JS.CompilationUnit)cu, p) : cu;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("JS has a different structure for its compilation unit. See JS.CompilationUnit.");
    }

    public J visitCompilationUnit(JS.CompilationUnit cu, P p) {
        JS.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.withStatements(ListUtils.map(c.getStatements(), e -> (Statement)this.visitAndCast((Tree)e, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitJsBinary(JS.JsBinary binary, P p) {
        JS.JsBinary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), JsSpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof JS.JsBinary)) {
            return temp;
        }
        b = (JS.JsBinary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), JsLeftPadded.Location.BINARY_OPERATOR, p));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), p));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public J visitJsOperator(JS.JsOperator operator, P p) {
        JS.JsOperator o = operator;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), JsSpace.Location.OPERATOR_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(o = o.withMarkers(this.visitMarkers(o.getMarkers(), p)), p);
        if (!(temp instanceof JS.JsOperator)) {
            return temp;
        }
        o = (JS.JsOperator)temp;
        o = o.withLeft((Expression)this.visitAndCast((Tree)o.getLeft(), p));
        o = o.getPadding().withOperator(this.visitLeftPadded(o.getPadding().getOperator(), JsLeftPadded.Location.OPERATOR, p));
        o = o.withRight((Expression)this.visitAndCast((Tree)o.getRight(), p));
        o = o.withType(this.visitType(o.getType(), p));
        return o;
    }

    public J visitTypeOperator(JS.TypeOperator typeOperator, P p) {
        JS.TypeOperator t = typeOperator;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_OPERATOR_PREFIX, p));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        t = t.getPadding().withExpression(this.visitLeftPadded(t.getPadding().getExpression(), JsLeftPadded.Location.TYPE_OPERATOR, p));
        return t;
    }

    public J visitUnion(JS.Union union, P p) {
        JS.Union u = union;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), JsSpace.Location.UNION_PREFIX, p));
        u = u.withMarkers(this.visitMarkers(u.getMarkers(), p));
        u = u.getPadding().withTypes(ListUtils.map(u.getPadding().getTypes(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.UNION_TYPE, p)));
        return u;
    }

    public J visitUnknownElement(JS.UnknownElement unknownElement, P p) {
        JS.UnknownElement u = unknownElement;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), JsSpace.Location.UNKNOWN_PREFIX, p));
        u = u.withMarkers(this.visitMarkers(u.getMarkers(), p));
        u = u.withSource((JS.UnknownElement.Source)this.visitAndCast((Tree)u.getSource(), p));
        return u;
    }

    public J visitUnknownElementSource(JS.UnknownElement.Source source, P p) {
        JS.UnknownElement.Source s = source;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), JsSpace.Location.UNKNOWN_SOURCE_PREFIX, p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        return s;
    }

    public Space visitSpace(Space space, JsSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JsRightPadded.Location loc, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, JsLeftPadded.Location loc, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, JsContainer.Location loc, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }
}

