/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.tree;

import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.internal.JavaScriptPrinter;
import org.openrewrite.marker.Markers;

public interface JS
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        String visitorName = v.getClass().getCanonicalName();
        if (visitorName != null && visitorName.startsWith("io.moderne.serialization.")) {
            return (R)this;
        }
        return (R)this.acceptJavaScript((JavaScriptVisitor)v.adapt(JavaScriptVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(JavaScriptVisitor.class);
    }

    @Nullable
    default public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
        return (J)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    public static final class UnknownElement
    implements JS,
    Statement,
    Expression,
    TypeTree,
    TypedTree,
    NameTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Source source;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitUnknownElement(this, p);
        }

        @Nullable
        public JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return null;
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnknownElement)) {
                return false;
            }
            UnknownElement other = (UnknownElement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public UnknownElement(UUID id, Space prefix, Markers markers, Source source) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.source = source;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Source getSource() {
            return this.source;
        }

        @org.openrewrite.internal.lang.NonNull
        public String toString() {
            return "JS.UnknownElement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", source=" + this.getSource() + ")";
        }

        @org.openrewrite.internal.lang.NonNull
        public UnknownElement withId(UUID id) {
            return this.id == id ? this : new UnknownElement(id, this.prefix, this.markers, this.source);
        }

        @org.openrewrite.internal.lang.NonNull
        public UnknownElement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnknownElement(this.id, prefix, this.markers, this.source);
        }

        @org.openrewrite.internal.lang.NonNull
        public UnknownElement withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnknownElement(this.id, this.prefix, markers, this.source);
        }

        @org.openrewrite.internal.lang.NonNull
        public UnknownElement withSource(Source source) {
            return this.source == source ? this : new UnknownElement(this.id, this.prefix, this.markers, source);
        }

        public static class Source
        implements JS {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final String text;

            @Override
            public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
                return v.visitUnknownElementSource(this, p);
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Source)) {
                    return false;
                }
                Source other = (Source)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(@Nullable Object other) {
                return other instanceof Source;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Source(UUID id, Space prefix, Markers markers, String text) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.text = text;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String getText() {
                return this.text;
            }

            @org.openrewrite.internal.lang.NonNull
            public String toString() {
                return "JS.UnknownElement.Source(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
            }

            @org.openrewrite.internal.lang.NonNull
            public Source withId(UUID id) {
                return this.id == id ? this : new Source(id, this.prefix, this.markers, this.text);
            }

            @org.openrewrite.internal.lang.NonNull
            public Source withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Source(this.id, prefix, this.markers, this.text);
            }

            @org.openrewrite.internal.lang.NonNull
            public Source withMarkers(Markers markers) {
                return this.markers == markers ? this : new Source(this.id, this.prefix, markers, this.text);
            }

            @org.openrewrite.internal.lang.NonNull
            public Source withText(String text) {
                return this.text == text ? this : new Source(this.id, this.prefix, this.markers, text);
            }
        }
    }

    public static final class StatementExpression
    implements JS,
    Expression,
    Statement {
        private final UUID id;
        private final Statement statement;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getStatement(), p);
            if (j instanceof StatementExpression) {
                return j;
            }
            if (j instanceof Statement) {
                return this.withStatement((Statement)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withStatement((Statement)this.statement.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.statement.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withStatement((Statement)this.statement.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.statement.getMarkers();
        }

        @Nullable
        public JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            throw new UnsupportedOperationException("StatementExpression cannot have a type");
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof StatementExpression;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public StatementExpression(UUID id, Statement statement) {
            this.id = id;
            this.statement = statement;
        }

        @org.openrewrite.internal.lang.NonNull
        public StatementExpression withId(UUID id) {
            return this.id == id ? this : new StatementExpression(id, this.statement);
        }

        public UUID getId() {
            return this.id;
        }

        @org.openrewrite.internal.lang.NonNull
        public StatementExpression withStatement(Statement statement) {
            return this.statement == statement ? this : new StatementExpression(this.id, statement);
        }

        public Statement getStatement() {
            return this.statement;
        }
    }

    public static final class Union
    implements JS,
    Expression,
    TypeTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<Expression>> types;
        @Nullable
        private final JavaType type;

        public List<Expression> getTypes() {
            return JRightPadded.getElements(this.types);
        }

        public Union withTypes(List<Expression> types) {
            return this.getPadding().withTypes(JRightPadded.withElements(this.types, types));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitUnion(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Union)) {
                return false;
            }
            Union other = (Union)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Union(UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        private Union(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @org.openrewrite.internal.lang.NonNull
        public String toString() {
            return "JS.Union(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", types=" + this.getTypes() + ", type=" + this.getType() + ")";
        }

        @org.openrewrite.internal.lang.NonNull
        public Union withId(UUID id) {
            return this.id == id ? this : new Union(this.padding, id, this.prefix, this.markers, this.types, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public Union withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Union(this.padding, this.id, prefix, this.markers, this.types, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public Union withMarkers(Markers markers) {
            return this.markers == markers ? this : new Union(this.padding, this.id, this.prefix, markers, this.types, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public Union withType(@Nullable JavaType type) {
            return this.type == type ? this : new Union(this.padding, this.id, this.prefix, this.markers, this.types, type);
        }

        public static class Padding {
            private final Union t;

            public List<JRightPadded<Expression>> getTypes() {
                return this.t.types;
            }

            public Union withTypes(List<JRightPadded<Expression>> types) {
                return this.t.types == types ? this.t : new Union(this.t.id, this.t.prefix, this.t.markers, types, this.t.type);
            }

            public Padding(Union t) {
                this.t = t;
            }
        }
    }

    public static final class ExpressionStatement
    implements JS,
    Expression,
    Statement {
        private final UUID id;
        private final Expression expression;

        public ExpressionStatement(Expression expression) {
            this.id = Tree.randomId();
            this.expression = expression;
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getExpression(), p);
            if (j instanceof ExpressionStatement) {
                return j;
            }
            if (j instanceof Expression) {
                return this.withExpression((Expression)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withExpression((Expression)this.expression.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withExpression((Expression)this.expression.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        @Nullable
        public JavaType getType() {
            return this.expression.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this.withExpression((Expression)this.expression.withType(type));
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ExpressionStatement;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public ExpressionStatement(UUID id, Expression expression) {
            this.id = id;
            this.expression = expression;
        }

        @org.openrewrite.internal.lang.NonNull
        public ExpressionStatement withId(UUID id) {
            return this.id == id ? this : new ExpressionStatement(id, this.expression);
        }

        public UUID getId() {
            return this.id;
        }

        @org.openrewrite.internal.lang.NonNull
        public ExpressionStatement withExpression(Expression expression) {
            return this.expression == expression ? this : new ExpressionStatement(this.id, expression);
        }

        public Expression getExpression() {
            return this.expression;
        }
    }

    public static final class TypeOperator
    implements JS,
    Expression,
    TypedTree,
    NameTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type operator;
        private final JLeftPadded<Expression> expression;
        @Nullable
        private final JavaType type;

        public Expression getExpression() {
            return (Expression)this.expression.getElement();
        }

        public TypeOperator withExpression(Expression expression) {
            return this.getPadding().withExpression((JLeftPadded<Expression>)this.expression.withElement((Object)expression));
        }

        @Nullable
        public JavaType getType() {
            return ((Expression)this.expression.getElement()).getType();
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this.getPadding().withExpression((JLeftPadded<Expression>)this.expression.withElement((Object)((Expression)((Expression)this.expression.getElement()).withType(type))));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeOperator(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeOperator)) {
                return false;
            }
            TypeOperator other = (TypeOperator)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeOperator(UUID id, Space prefix, Markers markers, Type operator, JLeftPadded<Expression> expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        private TypeOperator(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Type operator, JLeftPadded<Expression> expression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Type getOperator() {
            return this.operator;
        }

        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @org.openrewrite.internal.lang.NonNull
        public String toString() {
            return "JS.TypeOperator(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", operator=" + (Object)((Object)this.getOperator()) + ", expression=" + this.getExpression() + ", type=" + this.getType() + ")";
        }

        @org.openrewrite.internal.lang.NonNull
        public TypeOperator withId(UUID id) {
            return this.id == id ? this : new TypeOperator(this.padding, id, this.prefix, this.markers, this.operator, this.expression, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public TypeOperator withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeOperator(this.padding, this.id, prefix, this.markers, this.operator, this.expression, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public TypeOperator withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeOperator(this.padding, this.id, this.prefix, markers, this.operator, this.expression, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public TypeOperator withOperator(Type operator) {
            return this.operator == operator ? this : new TypeOperator(this.padding, this.id, this.prefix, this.markers, operator, this.expression, this.type);
        }

        public static enum Type {
            ReadOnly;

        }

        public static class Padding {
            private final TypeOperator t;

            public JLeftPadded<Expression> getExpression() {
                return this.t.expression;
            }

            public TypeOperator withExpression(JLeftPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new TypeOperator(this.t.id, this.t.prefix, this.t.markers, this.t.operator, expression, this.t.type);
            }

            public Padding(TypeOperator t) {
                this.t = t;
            }
        }
    }

    public static final class JsOperator
    implements JS,
    Expression,
    TypedTree,
    NameTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public JsOperator withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitJsOperator(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsOperator)) {
                return false;
            }
            JsOperator other = (JsOperator)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public JsOperator(UUID id, Space prefix, Markers markers, @Nullable Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        private JsOperator(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @org.openrewrite.internal.lang.NonNull
        public String toString() {
            return "JS.JsOperator(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + (Object)((Object)this.getOperator()) + ", right=" + this.getRight() + ", type=" + this.getType() + ")";
        }

        @org.openrewrite.internal.lang.NonNull
        public JsOperator withId(UUID id) {
            return this.id == id ? this : new JsOperator(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsOperator withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JsOperator(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsOperator withMarkers(Markers markers) {
            return this.markers == markers ? this : new JsOperator(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsOperator withLeft(@Nullable Expression left) {
            return this.left == left ? this : new JsOperator(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsOperator withRight(Expression right) {
            return this.right == right ? this : new JsOperator(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsOperator withType(@Nullable JavaType type) {
            return this.type == type ? this : new JsOperator(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, type);
        }

        public static enum Type {
            Delete,
            In,
            TypeOf;

        }

        public static class Padding {
            private final JsOperator t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public JsOperator withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new JsOperator(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.type);
            }

            public Padding(JsOperator t) {
                this.t = t;
            }
        }
    }

    public static final class JsBinary
    implements JS,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public JsBinary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitJsBinary(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsBinary)) {
                return false;
            }
            JsBinary other = (JsBinary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public JsBinary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        private JsBinary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @org.openrewrite.internal.lang.NonNull
        public String toString() {
            return "JS.JsBinary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + (Object)((Object)this.getOperator()) + ", right=" + this.getRight() + ", type=" + this.getType() + ")";
        }

        @org.openrewrite.internal.lang.NonNull
        public JsBinary withId(UUID id) {
            return this.id == id ? this : new JsBinary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsBinary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JsBinary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsBinary withMarkers(Markers markers) {
            return this.markers == markers ? this : new JsBinary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsBinary withLeft(Expression left) {
            return this.left == left ? this : new JsBinary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsBinary withRight(Expression right) {
            return this.right == right ? this : new JsBinary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.type);
        }

        @org.openrewrite.internal.lang.NonNull
        public JsBinary withType(@Nullable JavaType type) {
            return this.type == type ? this : new JsBinary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, type);
        }

        public static enum Type {
            IdentityEquals,
            IdentityNotEquals;

        }

        public static class Padding {
            private final JsBinary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public JsBinary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new JsBinary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.type);
            }

            public Padding(JsBinary t) {
                this.t = t;
            }
        }
    }

    public static final class CompilationUnit
    implements JS,
    JavaSourceFile,
    SourceFile {
        @Nullable
        private transient SoftReference<TypesInUse> typesInUse;
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<JRightPadded<J.Import>> imports;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public List<J.Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.imports, imports));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Transient
        @NonNull
        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        @NonNull
        public JavaSourceFile withClasses(List<J.ClassDeclaration> classes) {
            return this;
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitJavaSourceFile(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new JavaScriptPrinter();
        }

        @Transient
        @NonNull
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        @Nullable
        public J.Package getPackageDeclaration() {
            return null;
        }

        public JavaSourceFile withPackageDeclaration(J.Package pkg) {
            throw new IllegalStateException("JavaScript does not support package declarations");
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @org.openrewrite.internal.lang.NonNull
        public String toString() {
            return "JS.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", imports=" + this.getImports() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        private CompilationUnit(@Nullable SoftReference<TypesInUse> typesInUse, @Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        @org.openrewrite.internal.lang.NonNull
        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public UUID getId() {
            return this.id;
        }

        @org.openrewrite.internal.lang.NonNull
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @org.openrewrite.internal.lang.NonNull
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @org.openrewrite.internal.lang.NonNull
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        @org.openrewrite.internal.lang.NonNull
        public CompilationUnit withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @org.openrewrite.internal.lang.NonNull
        private CompilationUnit withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @org.openrewrite.internal.lang.NonNull
        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @org.openrewrite.internal.lang.NonNull
        public CompilationUnit withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.imports, this.statements, this.eof);
        }

        @Nullable
        public Checksum getChecksum() {
            return this.checksum;
        }

        @org.openrewrite.internal.lang.NonNull
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, eof);
        }

        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            public List<JRightPadded<J.Import>> getImports() {
                return this.t.imports;
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, imports, this.t.statements, this.t.eof);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.imports, statements, this.t.eof);
            }

            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }
}

