/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JsContainer;
import org.openrewrite.javascript.tree.JsLeftPadded;
import org.openrewrite.javascript.tree.JsRightPadded;
import org.openrewrite.javascript.tree.JsSpace;
import org.openrewrite.marker.Markers;

public class JavaScriptVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof JS.CompilationUnit;
    }

    public String getLanguage() {
        return "javascript";
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("JS has a different structure for its compilation unit. See JS.CompilationUnit.");
    }

    public J visitCompilationUnit(JS.CompilationUnit cu, P p) {
        JS.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.getPadding().withImports(Objects.requireNonNull(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p))));
        c = c.withStatements(Objects.requireNonNull(ListUtils.map(c.getStatements(), e -> (Statement)this.visitAndCast((Tree)e, p))));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitAlias(JS.Alias alias, P p) {
        JS.Alias a = alias;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.ALIAS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.Alias)) {
            return temp;
        }
        a = (JS.Alias)temp;
        a = a.getPadding().withPropertyName(Objects.requireNonNull(this.visitRightPadded(a.getPadding().getPropertyName(), JsRightPadded.Location.ALIAS_PROPERTY_NAME, p)));
        a = a.withAlias(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getAlias(), p)));
        return a;
    }

    public J visitArrowFunction(JS.ArrowFunction arrowFunction, P p) {
        JS.ArrowFunction a = arrowFunction;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.ARROW_FUNCTION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.ArrowFunction)) {
            return temp;
        }
        a = (JS.ArrowFunction)temp;
        a = a.withLeadingAnnotations(Objects.requireNonNull(ListUtils.map(a.getLeadingAnnotations(), ann -> (J.Annotation)this.visitAndCast((Tree)ann, p))));
        a = a.withModifiers(Objects.requireNonNull(ListUtils.map(a.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p))));
        a = a.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)a.getTypeParameters(), p));
        a = a.withParameters(a.getParameters().withPrefix(this.visitSpace(a.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p)));
        a = a.withParameters(a.getParameters().getPadding().withParams(Objects.requireNonNull(ListUtils.map((List)a.getParameters().getPadding().getParams(), param -> this.visitRightPadded((JRightPadded)param, JRightPadded.Location.LAMBDA_PARAM, p)))));
        a = a.withParameters(Objects.requireNonNull((J.Lambda.Parameters)this.visitAndCast((Tree)a.getParameters(), p)));
        a = a.withReturnTypeExpression((TypeTree)this.visitAndCast((Tree)a.getReturnTypeExpression(), p));
        a = a.getPadding().withBody(Objects.requireNonNull(this.visitLeftPadded(a.getPadding().getBody(), JsLeftPadded.Location.LAMBDA_ARROW, p)));
        a = a.withBody(Objects.requireNonNull((J)this.visitAndCast((Tree)a.getBody(), p)));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitAwait(JS.Await await, P p) {
        JS.Await a = await;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.AWAIT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.Await)) {
            return temp;
        }
        a = (JS.Await)temp;
        a = a.withExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getExpression(), p)));
        return a;
    }

    public J visitBindingElement(JS.BindingElement binding, P p) {
        JS.BindingElement b = binding;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), JsSpace.Location.BINDING_ELEMENT_PREFIX, p));
        b = b.withMarkers(this.visitMarkers(b.getMarkers(), p));
        b = b.withPropertyName((Expression)this.visitAndCast((Tree)b.getPropertyName(), p));
        if ((b = b.withName(Objects.requireNonNull((TypedTree)this.visitAndCast((Tree)b.getName(), p)))).getPadding().getInitializer() != null) {
            b = b.getPadding().withInitializer(this.visitLeftPadded(b.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_ELEMENT_INITIALIZER, p));
        }
        b = b.withVariableType((JavaType.Variable)this.visitType((JavaType)b.getVariableType(), p));
        return b;
    }

    public J visitConditionalType(JS.ConditionalType conditionalType, P p) {
        JS.ConditionalType t = conditionalType;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.CONDITIONAL_TYPE_PREFIX, p));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        if ((t = t.withCheckType(Objects.requireNonNull((Expression)this.visitAndCast((Tree)t.getCheckType(), p)))).getCheckType() instanceof NameTree) {
            t = t.withCheckType((Expression)this.visitTypeName((NameTree)t.getCheckType(), p));
        }
        t = t.getPadding().withCondition(this.visitContainer(t.getPadding().getCondition(), JsContainer.Location.CONDITIONAL_TYPE_CONDITION, p));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitDefaultType(JS.DefaultType defaultType, P p) {
        JS.DefaultType d = defaultType;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.ASSIGNMENT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof JS.DefaultType)) {
            return temp;
        }
        d = (JS.DefaultType)temp;
        d = d.withLeft(Objects.requireNonNull((Expression)this.visitAndCast((Tree)d.getLeft(), p)));
        d = d.withBeforeEquals(this.visitSpace(d.getBeforeEquals(), Space.Location.ASSIGNMENT_OPERATION_PREFIX, p));
        d = d.withRight(Objects.requireNonNull((Expression)this.visitAndCast((Tree)d.getRight(), p)));
        d = d.withType(this.visitType(d.getType(), p));
        return d;
    }

    public J visitDelete(JS.Delete delete, P p) {
        JS.Delete d = delete;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), JsSpace.Location.DELETE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof JS.Delete)) {
            return temp;
        }
        d = (JS.Delete)temp;
        d = d.withType(this.visitType(d.getType(), p));
        return d;
    }

    public J visitExport(JS.Export export, P p) {
        JS.Export e = export;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), JsSpace.Location.EXPORT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(e = e.withMarkers(this.visitMarkers(e.getMarkers(), p)), p);
        if (!(temp instanceof JS.Export)) {
            return temp;
        }
        e = (JS.Export)temp;
        if (e.getPadding().getExports() != null) {
            e = e.getPadding().withExports(this.visitContainer(e.getPadding().getExports(), JsContainer.Location.EXPORT_ELEMENT, p));
        }
        if (e.getFrom() != null) {
            e = e.withFrom(this.visitSpace(e.getFrom(), JsSpace.Location.EXPORT_FROM_PREFIX, p));
        }
        if ((e = e.withTarget((J.Literal)this.visitAndCast((Tree)e.getTarget(), p))).getPadding().getInitializer() != null) {
            e = e.getPadding().withInitializer(this.visitLeftPadded(e.getPadding().getInitializer(), JsLeftPadded.Location.EXPORT_INITIALIZER, p));
        }
        return e;
    }

    public J visitExpressionStatement(JS.ExpressionStatement statement, P p) {
        JS.ExpressionStatement es = statement;
        Statement temp = (Statement)this.visitStatement(es = (JS.ExpressionStatement)es.withMarkers(this.visitMarkers(es.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExpressionStatement)) {
            return temp;
        }
        es = (JS.ExpressionStatement)temp;
        J expression = (J)this.visit((Tree)es.getExpression(), p);
        if (expression instanceof Statement) {
            return expression;
        }
        es = es.withExpression((Expression)Objects.requireNonNull(expression));
        return es;
    }

    public J visitTrailingTokenStatement(JS.TrailingTokenStatement statement, P p) {
        JS.TrailingTokenStatement st = statement;
        st = st.withPrefix(this.visitSpace(st.getPrefix(), JsSpace.Location.TRAILING_TOKEN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(st = st.withMarkers(this.visitMarkers(st.getMarkers(), p)), p);
        if (!(temp instanceof JS.TrailingTokenStatement)) {
            return temp;
        }
        st = (JS.TrailingTokenStatement)temp;
        st = st.getPadding().withExpression(Objects.requireNonNull(this.visitRightPadded(st.getPadding().getExpression(), JsRightPadded.Location.TRAILING_TOKEN_EXPRESSION, p)));
        st = st.withType(this.visitType(st.getType(), p));
        return st;
    }

    public J visitExpressionWithTypeArguments(JS.ExpressionWithTypeArguments expressionWithTypeArguments, P p) {
        JS.ExpressionWithTypeArguments ta = expressionWithTypeArguments;
        ta = ta.withPrefix(this.visitSpace(ta.getPrefix(), JsSpace.Location.EXPR_WITH_TYPE_ARG_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ta = ta.withMarkers(this.visitMarkers(ta.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExpressionWithTypeArguments)) {
            return temp;
        }
        ta = (JS.ExpressionWithTypeArguments)temp;
        if ((ta = ta.withClazz(Objects.requireNonNull((J)this.visitAndCast((Tree)ta.getClazz(), p)))).getPadding().getTypeArguments() != null) {
            ta = ta.getPadding().withTypeArguments(this.visitContainer(ta.getPadding().getTypeArguments(), JsContainer.Location.EXPR_WITH_TYPE_ARG_PARAMETERS, p));
        }
        ta = ta.withType(this.visitType(ta.getType(), p));
        return ta;
    }

    public J visitFunctionType(JS.FunctionType functionType, P p) {
        JS.FunctionType f = functionType;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), JsSpace.Location.FUNCTION_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof JS.FunctionType)) {
            return temp;
        }
        f = (JS.FunctionType)temp;
        f = f.withModifiers(Objects.requireNonNull(ListUtils.map(f.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        f = f.getPadding().withConstructorType(Objects.requireNonNull(this.visitLeftPadded(f.getPadding().getConstructorType(), JsLeftPadded.Location.FUNCTION_TYPE_CONSTRUCTOR, p)));
        f = f.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)f.getTypeParameters(), p));
        f = f.getPadding().withParameters((JContainer<Statement>)Objects.requireNonNull(this.visitContainer(f.getPadding().getParameters(), JContainer.Location.LANGUAGE_EXTENSION, p)));
        f = f.withParameters(Objects.requireNonNull(ListUtils.map(f.getParameters(), e -> (Statement)this.visitAndCast((Tree)e, p))));
        f = f.withArrow(this.visitSpace(f.getArrow(), JsSpace.Location.FUNCTION_TYPE_ARROW_PREFIX, p));
        f = f.withReturnType(Objects.requireNonNull((Expression)this.visitAndCast((Tree)f.getReturnType(), p)));
        f = f.withType(this.visitType(f.getType(), p));
        return f;
    }

    public J visitInferType(JS.InferType inferType, P p) {
        JS.InferType t = inferType;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.INFER_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.InferType)) {
            return temp;
        }
        t = (JS.InferType)temp;
        t = t.getPadding().withTypeParameter(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getTypeParameter(), JsLeftPadded.Location.INFER_TYPE_PARAMETER, p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitJsBinary(JS.JsBinary binary, P p) {
        JS.JsBinary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), JsSpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof JS.JsBinary)) {
            return temp;
        }
        b = (JS.JsBinary)temp;
        b = b.withLeft(Objects.requireNonNull((Expression)this.visitAndCast((Tree)b.getLeft(), p)));
        b = b.getPadding().withOperator(Objects.requireNonNull(this.visitLeftPadded(b.getPadding().getOperator(), JsLeftPadded.Location.BINARY_OPERATOR, p)));
        b = b.withRight(Objects.requireNonNull((Expression)this.visitAndCast((Tree)b.getRight(), p)));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public J visitJsImport(JS.JsImport jsImport, P p) {
        JS.JsImport i = jsImport;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), JsSpace.Location.IMPORT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(i = i.withMarkers(this.visitMarkers(i.getMarkers(), p)), p);
        if (!(temp instanceof JS.JsImport)) {
            return temp;
        }
        i = (JS.JsImport)temp;
        i = i.getPadding().withImportType(Objects.requireNonNull(this.visitLeftPadded(i.getPadding().getImportType(), JsLeftPadded.Location.JS_IMPORT_IMPORT_TYPE, p)));
        if ((i = i.withName((J.Identifier)this.visitAndCast((Tree)i.getName(), p))).getPadding().getImports() != null) {
            i = i.getPadding().withImports(this.visitContainer(i.getPadding().getImports(), JsContainer.Location.IMPORT_ELEMENT, p));
        }
        if (i.getFrom() != null) {
            i = i.withFrom(this.visitSpace(i.getFrom(), JsSpace.Location.IMPORT_FROM_PREFIX, p));
        }
        if ((i = i.withTarget((J.Literal)this.visitAndCast((Tree)i.getTarget(), p))).getPadding().getInitializer() != null) {
            i = i.getPadding().withInitializer(this.visitLeftPadded(i.getPadding().getInitializer(), JsLeftPadded.Location.IMPORT_INITIALIZER, p));
        }
        return i;
    }

    public J visitJsImportSpecifier(JS.JsImportSpecifier jis, P p) {
        JS.JsImportSpecifier i = jis;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), JsSpace.Location.JS_IMPORT_SPECIFIER_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(i = i.withMarkers(this.visitMarkers(i.getMarkers(), p)), p);
        if (!(temp instanceof JS.JsImportSpecifier)) {
            return temp;
        }
        i = (JS.JsImportSpecifier)temp;
        i = i.getPadding().withImportType(Objects.requireNonNull(this.visitLeftPadded(i.getPadding().getImportType(), JsLeftPadded.Location.JS_IMPORT_SPECIFIER_IMPORT_TYPE, p)));
        i = i.withSpecifier(Objects.requireNonNull((Expression)this.visitAndCast((Tree)i.getSpecifier(), p)));
        i = i.withType(this.visitType(i.getType(), p));
        return i;
    }

    public J visitLiteralType(JS.LiteralType literalType, P p) {
        JS.LiteralType type = literalType;
        type = type.withPrefix(this.visitSpace(type.getPrefix(), JsSpace.Location.LITERAL_TYPE_PREFIX, p));
        type = type.withMarkers(this.visitMarkers(type.getMarkers(), p));
        type = type.withLiteral(Objects.requireNonNull((Expression)this.visitAndCast((Tree)type.getLiteral(), p)));
        return type;
    }

    public J visitMappedType(JS.MappedType mappedType, P p) {
        JS.MappedType t = mappedType;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.MAPPED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.MappedType)) {
            return temp;
        }
        t = (JS.MappedType)temp;
        t = t.getPadding().withPrefixToken(this.visitLeftPadded(t.getPadding().getPrefixToken(), JsLeftPadded.Location.MAPPED_TYPE_PREFIX_TOKEN, p));
        t = t.getPadding().withHasReadonly(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getHasReadonly(), JsLeftPadded.Location.MAPPED_TYPE_READONLY, p)));
        t = t.withKeysRemapping(Objects.requireNonNull((JS.MappedType.KeysRemapping)this.visitAndCast((Tree)t.getKeysRemapping(), p)));
        t = t.getPadding().withSuffixToken(this.visitLeftPadded(t.getPadding().getSuffixToken(), JsLeftPadded.Location.MAPPED_TYPE_SUFFIX_TOKEN, p));
        t = t.getPadding().withHasQuestionToken(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getHasQuestionToken(), JsLeftPadded.Location.MAPPED_TYPE_QUESTION_TOKEN, p)));
        t = t.getPadding().withValueType(Objects.requireNonNull(this.visitContainer(t.getPadding().getValueType(), JsContainer.Location.MAPPED_TYPE_VALUE_TYPE, p)));
        return t;
    }

    public J visitMappedTypeKeysRemapping(JS.MappedType.KeysRemapping mappedTypeKeys, P p) {
        JS.MappedType.KeysRemapping m = mappedTypeKeys;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), JsSpace.Location.MAPPED_TYPE_KEYS_REMAPPING_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof JS.MappedType.KeysRemapping)) {
            return temp;
        }
        m = (JS.MappedType.KeysRemapping)temp;
        if ((m = m.getPadding().withTypeParameter(Objects.requireNonNull(this.visitRightPadded(m.getPadding().getTypeParameter(), JsRightPadded.Location.MAPPED_TYPE_KEYS_REMAPPING_TYPE_PARAMETER, p)))).getNameType() != null) {
            m = m.getPadding().withNameType(Objects.requireNonNull(this.visitRightPadded(m.getPadding().getNameType(), JsRightPadded.Location.MAPPED_TYPE_KEYS_REMAPPING_NAME_TYPE, p)));
        }
        return m;
    }

    public J visitMappedTypeMappedTypeParameter(JS.MappedType.MappedTypeParameter mappedTypeParameter, P p) {
        JS.MappedType.MappedTypeParameter m = mappedTypeParameter;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), JsSpace.Location.MAPPED_TYPE_MAPPED_TYPE_PARAMETER_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof JS.MappedType.MappedTypeParameter)) {
            return temp;
        }
        m = (JS.MappedType.MappedTypeParameter)temp;
        m = m.withName(Objects.requireNonNull((Expression)this.visitAndCast((Tree)m.getName(), p)));
        m = m.getPadding().withIterateType(Objects.requireNonNull(this.visitLeftPadded(m.getPadding().getIterateType(), JsLeftPadded.Location.MAPPED_TYPE_MAPPED_TYPE_PARAMETER_ITERATE, p)));
        return m;
    }

    public J visitObjectBindingDeclarations(JS.ObjectBindingDeclarations objectBindingDeclarations, P p) {
        JS.ObjectBindingDeclarations o = objectBindingDeclarations;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), JsSpace.Location.OBJECT_BINDING_DECLARATIONS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(o = o.withMarkers(this.visitMarkers(o.getMarkers(), p)), p);
        if (!(temp instanceof JS.ObjectBindingDeclarations)) {
            return temp;
        }
        o = (JS.ObjectBindingDeclarations)temp;
        o = o.withLeadingAnnotations(Objects.requireNonNull(ListUtils.map(o.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        o = o.withModifiers(Objects.requireNonNull(ListUtils.map(o.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        o = o.withTypeExpression((o = o.withTypeExpression((TypeTree)this.visitAndCast((Tree)o.getTypeExpression(), p))).getTypeExpression() == null ? null : this.visitTypeName(o.getTypeExpression(), p));
        if ((o = o.getPadding().withBindings(Objects.requireNonNull(this.visitContainer(o.getPadding().getBindings(), JsContainer.Location.BINDING_ELEMENT, p)))).getPadding().getInitializer() != null) {
            o = o.getPadding().withInitializer(this.visitLeftPadded(o.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_ELEMENT_INITIALIZER, p));
        }
        return o;
    }

    public J visitPropertyAssignment(JS.PropertyAssignment propertyAssignment, P p) {
        JS.PropertyAssignment pa = propertyAssignment;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), JsSpace.Location.PROPERTY_ASSIGNMENT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), p)), p);
        if (!(temp instanceof JS.PropertyAssignment)) {
            return temp;
        }
        pa = (JS.PropertyAssignment)temp;
        pa = pa.getPadding().withName(Objects.requireNonNull(this.visitRightPadded(pa.getPadding().getName(), JsRightPadded.Location.PROPERTY_ASSIGNMENT_NAME, p)));
        pa = pa.withInitializer((Expression)this.visitAndCast((Tree)pa.getInitializer(), p));
        return pa;
    }

    public J visitSatisfiesExpression(JS.SatisfiesExpression satisfiesExpression, P p) {
        JS.SatisfiesExpression sa = satisfiesExpression;
        sa = sa.withPrefix(this.visitSpace(sa.getPrefix(), JsSpace.Location.SATISFIES_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(sa = sa.withMarkers(this.visitMarkers(sa.getMarkers(), p)), p);
        if (!(temp instanceof JS.SatisfiesExpression)) {
            return temp;
        }
        sa = (JS.SatisfiesExpression)temp;
        sa = sa.withExpression(Objects.requireNonNull((J)this.visitAndCast((Tree)sa.getExpression(), p)));
        sa = sa.getPadding().withSatisfiesType(Objects.requireNonNull(this.visitLeftPadded(sa.getPadding().getSatisfiesType(), JsLeftPadded.Location.SATISFIES_EXPRESSION_TYPE, p)));
        return sa;
    }

    public J visitScopedVariableDeclarations(JS.ScopedVariableDeclarations scopedVariableDeclarations, P p) {
        JS.ScopedVariableDeclarations vd = scopedVariableDeclarations;
        vd = vd.withPrefix(this.visitSpace(vd.getPrefix(), JsSpace.Location.SCOPED_VARIABLE_DECLARATIONS_PREFIX, p));
        vd = vd.withMarkers(this.visitMarkers(vd.getMarkers(), p));
        Statement temp = (Statement)this.visitStatement(vd = vd.getPadding().withScope(this.visitLeftPadded(vd.getPadding().getScope(), JsLeftPadded.Location.SCOPED_VARIABLE_DECLARATIONS_SCOPE, p)), p);
        if (!(temp instanceof JS.ScopedVariableDeclarations)) {
            return temp;
        }
        vd = (JS.ScopedVariableDeclarations)temp;
        vd = vd.getPadding().withVariables(Objects.requireNonNull(ListUtils.map(vd.getPadding().getVariables(), e -> this.visitRightPadded((JRightPadded)e, JsRightPadded.Location.SCOPED_VARIABLE_DECLARATIONS_VARIABLE, p))));
        return vd;
    }

    public J visitStatementExpression(JS.StatementExpression expression, P p) {
        JS.StatementExpression se = expression;
        Expression temp = (Expression)this.visitExpression(se, p);
        if (!(temp instanceof JS.StatementExpression)) {
            return temp;
        }
        se = (JS.StatementExpression)temp;
        J statement = (J)this.visit((Tree)se.getStatement(), p);
        if (statement instanceof Expression) {
            return statement;
        }
        se = se.withStatement((Statement)Objects.requireNonNull(statement));
        return se;
    }

    public J visitTaggedTemplateExpression(JS.TaggedTemplateExpression taggedTemplateExpression, P p) {
        JS.TaggedTemplateExpression ta = taggedTemplateExpression;
        ta = ta.withPrefix(this.visitSpace(ta.getPrefix(), JsSpace.Location.TAGGED_TEMPLATE_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ta = ta.withMarkers(this.visitMarkers(ta.getMarkers(), p)), p);
        if (!(temp instanceof JS.TaggedTemplateExpression)) {
            return temp;
        }
        ta = (JS.TaggedTemplateExpression)temp;
        if ((ta = ta.getPadding().withTag(this.visitRightPadded(ta.getPadding().getTag(), JsRightPadded.Location.TEMPLATE_EXPRESSION_TAG, p))).getPadding().getTypeArguments() != null) {
            ta = ta.getPadding().withTypeArguments(this.visitContainer(ta.getPadding().getTypeArguments(), JsContainer.Location.TEMPLATE_EXPRESSION_TYPE_ARG_PARAMETERS, p));
        }
        ta = ta.withTemplateExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)ta.getTemplateExpression(), p)));
        return ta;
    }

    public J visitTemplateExpression(JS.TemplateExpression templateExpression, P p) {
        JS.TemplateExpression te = templateExpression;
        te = te.withPrefix(this.visitSpace(te.getPrefix(), JsSpace.Location.TEMPLATE_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(te = te.withMarkers(this.visitMarkers(te.getMarkers(), p)), p);
        if (!(temp instanceof JS.TemplateExpression)) {
            return temp;
        }
        te = (JS.TemplateExpression)temp;
        te = te.withHead(Objects.requireNonNull((J.Literal)this.visitAndCast((Tree)te.getHead(), p)));
        te = te.getPadding().withTemplateSpans(Objects.requireNonNull(ListUtils.map(te.getPadding().getTemplateSpans(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.TEMPLATE_EXPRESSION_TEMPLATE_SPAN, p))));
        te = te.withType(this.visitType(te.getType(), p));
        return te;
    }

    public J visitTemplateExpressionTemplateSpan(JS.TemplateExpression.TemplateSpan span, P p) {
        JS.TemplateExpression.TemplateSpan s = span;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), JsSpace.Location.TEMPLATE_EXPRESSION_SPAN_PREFIX, p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        s = s.withExpression(Objects.requireNonNull((J)this.visitAndCast((Tree)s.getExpression(), p)));
        s = s.withTail(Objects.requireNonNull((J.Literal)this.visitAndCast((Tree)s.getTail(), p)));
        s = s.withTail(s.getTail());
        return s;
    }

    public J visitTuple(JS.Tuple tuple, P p) {
        JS.Tuple t = tuple;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TUPLE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.Tuple)) {
            return temp;
        }
        t = (JS.Tuple)temp;
        t = t.getPadding().withElements(Objects.requireNonNull(this.visitContainer(t.getPadding().getElements(), JsContainer.Location.TUPLE_ELEMENT, p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitTypeDeclaration(JS.TypeDeclaration typeDeclaration, P p) {
        JS.TypeDeclaration t = typeDeclaration;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeDeclaration)) {
            return temp;
        }
        t = (JS.TypeDeclaration)temp;
        t = t.withModifiers(Objects.requireNonNull(ListUtils.map(t.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        t = t.getPadding().withName(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getName(), JsLeftPadded.Location.TYPE_DECLARATION_NAME, p)));
        t = t.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)t.getTypeParameters(), p));
        t = t.getPadding().withInitializer(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getInitializer(), JsLeftPadded.Location.TYPE_DECLARATION_INITIALIZER, p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitTypeOperator(JS.TypeOperator typeOperator, P p) {
        JS.TypeOperator t = typeOperator;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_OPERATOR_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeOperator)) {
            return temp;
        }
        t = (JS.TypeOperator)temp;
        t = t.getPadding().withExpression(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getExpression(), JsLeftPadded.Location.TYPE_OPERATOR, p)));
        return t;
    }

    public J visitTypePredicate(JS.TypePredicate typePredicate, P p) {
        JS.TypePredicate t = typePredicate;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_PREDICATE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypePredicate)) {
            return temp;
        }
        t = (JS.TypePredicate)temp;
        t = t.getPadding().withAsserts(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getAsserts(), JsLeftPadded.Location.TYPE_PREDICATE_ASSERTS, p)));
        t = t.withParameterName(Objects.requireNonNull((J.Identifier)this.visitAndCast((Tree)t.getParameterName(), p)));
        t = t.getPadding().withExpression(this.visitLeftPadded(t.getPadding().getExpression(), JsLeftPadded.Location.TYPE_PREDICATE_EXPRESSION, p));
        return t;
    }

    public J visitUnary(JS.Unary unary, P p) {
        JS.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNARY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof JS.Unary)) {
            return temp;
        }
        u = (JS.Unary)temp;
        Expression temp2 = (Expression)this.visitExpression(u, p);
        if (!(temp2 instanceof JS.Unary)) {
            return temp2;
        }
        u = (JS.Unary)temp2;
        u = u.getPadding().withOperator((JLeftPadded<JS.Unary.Type>)Objects.requireNonNull(this.visitLeftPadded(u.getPadding().getOperator(), JLeftPadded.Location.UNARY_OPERATOR, p)));
        u = u.withExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)u.getExpression(), p)));
        u = u.withType(this.visitType(u.getType(), p));
        return u;
    }

    public J visitUnion(JS.Union union, P p) {
        JS.Union u = union;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), JsSpace.Location.UNION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof JS.Union)) {
            return temp;
        }
        u = (JS.Union)temp;
        u = u.getPadding().withTypes(Objects.requireNonNull(ListUtils.map(u.getPadding().getTypes(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.UNION_TYPE, p))));
        u = u.withType(this.visitType(u.getType(), p));
        return u;
    }

    public J visitIntersection(JS.Intersection intersection, P p) {
        JS.Intersection u = intersection;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), JsSpace.Location.INTERSECTION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof JS.Intersection)) {
            return temp;
        }
        u = (JS.Intersection)temp;
        u = u.getPadding().withTypes(Objects.requireNonNull(ListUtils.map(u.getPadding().getTypes(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.INTERSECTION_TYPE, p))));
        u = u.withType(this.visitType(u.getType(), p));
        return u;
    }

    public J visitExportDeclaration(JS.ExportDeclaration exportDeclaration, P p) {
        JS.ExportDeclaration ed = exportDeclaration;
        ed = ed.withPrefix(this.visitSpace(ed.getPrefix(), JsSpace.Location.EXPORT_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(ed = ed.withMarkers(this.visitMarkers(ed.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExportDeclaration)) {
            return temp;
        }
        ed = (JS.ExportDeclaration)temp;
        ed = ed.withModifiers(Objects.requireNonNull(ListUtils.map(ed.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        ed = ed.getPadding().withTypeOnly(Objects.requireNonNull(this.visitLeftPadded(ed.getPadding().getTypeOnly(), JsLeftPadded.Location.EXPORT_DECLARATION_TYPE_ONLY, p)));
        ed = ed.withExportClause((Expression)this.visitAndCast((Tree)ed.getExportClause(), p));
        ed = ed.getPadding().withModuleSpecifier(this.visitLeftPadded(ed.getPadding().getModuleSpecifier(), JsLeftPadded.Location.EXPORT_DECLARATION_MODULE_SPECIFIER, p));
        return ed;
    }

    public J visitExportAssignment(JS.ExportAssignment exportAssignment, P p) {
        JS.ExportAssignment es = exportAssignment;
        es = es.withPrefix(this.visitSpace(es.getPrefix(), JsSpace.Location.EXPORT_ASSIGNMENT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(es = es.withMarkers(this.visitMarkers(es.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExportAssignment)) {
            return temp;
        }
        es = (JS.ExportAssignment)temp;
        es = es.withModifiers(Objects.requireNonNull(ListUtils.map(es.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        es = es.getPadding().withExportEquals(Objects.requireNonNull(this.visitLeftPadded(es.getPadding().getExportEquals(), JsLeftPadded.Location.EXPORT_ASSIGNMENT_EXPORT_EQUALS, p)));
        es = es.withExpression((Expression)this.visitAndCast((Tree)es.getExpression(), p));
        return es;
    }

    public J visitNamedExports(JS.NamedExports namedExports, P p) {
        JS.NamedExports ne = namedExports;
        ne = ne.withPrefix(this.visitSpace(ne.getPrefix(), JsSpace.Location.NAMED_EXPORTS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ne = ne.withMarkers(this.visitMarkers(ne.getMarkers(), p)), p);
        if (!(temp instanceof JS.NamedExports)) {
            return temp;
        }
        ne = (JS.NamedExports)temp;
        ne = ne.getPadding().withElements(Objects.requireNonNull(this.visitContainer(ne.getPadding().getElements(), JsContainer.Location.NAMED_EXPORTS_ELEMENTS, p)));
        ne = ne.withType(this.visitType(ne.getType(), p));
        return ne;
    }

    public J visitExportSpecifier(JS.ExportSpecifier exportSpecifier, P p) {
        JS.ExportSpecifier es = exportSpecifier;
        es = es.withPrefix(this.visitSpace(es.getPrefix(), JsSpace.Location.EXPORT_SPECIFIER_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(es = es.withMarkers(this.visitMarkers(es.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExportSpecifier)) {
            return temp;
        }
        es = (JS.ExportSpecifier)temp;
        es = es.getPadding().withTypeOnly(Objects.requireNonNull(this.visitLeftPadded(es.getPadding().getTypeOnly(), JsLeftPadded.Location.EXPORT_SPECIFIER_TYPE_ONLY, p)));
        es = es.withSpecifier(Objects.requireNonNull((Expression)this.visitAndCast((Tree)es.getSpecifier(), p)));
        es = es.withType(this.visitType(es.getType(), p));
        return es;
    }

    public J visitIndexedAccessType(JS.IndexedAccessType indexedAccessType, P p) {
        JS.IndexedAccessType iat = indexedAccessType;
        iat = iat.withPrefix(this.visitSpace(iat.getPrefix(), JsSpace.Location.INDEXED_ACCESS_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(iat = iat.withMarkers(this.visitMarkers(iat.getMarkers(), p)), p);
        if (!(temp instanceof JS.IndexedAccessType)) {
            return temp;
        }
        iat = (JS.IndexedAccessType)temp;
        iat = iat.withObjectType(Objects.requireNonNull((TypeTree)this.visitAndCast((Tree)iat.getObjectType(), p)));
        iat = iat.withIndexType(Objects.requireNonNull((TypeTree)this.visitAndCast((Tree)iat.getIndexType(), p)));
        iat = iat.withType(this.visitType(iat.getType(), p));
        return iat;
    }

    public J visitIndexedAccessTypeIndexType(JS.IndexedAccessType.IndexType indexedAccessTypeIndexType, P p) {
        JS.IndexedAccessType.IndexType iatit = indexedAccessTypeIndexType;
        iatit = iatit.withPrefix(this.visitSpace(iatit.getPrefix(), JsSpace.Location.INDEXED_ACCESS_TYPE_INDEX_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(iatit = iatit.withMarkers(this.visitMarkers(iatit.getMarkers(), p)), p);
        if (!(temp instanceof JS.IndexedAccessType.IndexType)) {
            return temp;
        }
        iatit = (JS.IndexedAccessType.IndexType)temp;
        iatit = iatit.getPadding().withElement(Objects.requireNonNull(this.visitRightPadded(iatit.getPadding().getElement(), JsRightPadded.Location.INDEXED_ACCESS_TYPE_INDEX_TYPE_ELEMENT, p)));
        iatit = iatit.withType(this.visitType(iatit.getType(), p));
        return iatit;
    }

    public J visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        J.AnnotatedType a = annotatedType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression((Expression)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p))), p);
        if (!(temp instanceof J.AnnotatedType)) {
            return temp;
        }
        a = (J.AnnotatedType)temp;
        a = a.withAnnotations(Objects.requireNonNull(ListUtils.map((List)a.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p))));
        a = a.withTypeExpression((TypeTree)this.visitAndCast((Tree)a.getTypeExpression(), p));
        a = a.withTypeExpression(this.visitTypeName(a.getTypeExpression(), p));
        return a;
    }

    public J visitParameterizedType(J.ParameterizedType type, P p) {
        J.ParameterizedType pt = type;
        pt = pt.withPrefix(this.visitSpace(pt.getPrefix(), Space.Location.PARAMETERIZED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression((Expression)(pt = pt.withMarkers(this.visitMarkers(pt.getMarkers(), p))), p);
        if (!(temp instanceof J.ParameterizedType)) {
            return temp;
        }
        pt = (J.ParameterizedType)temp;
        if ((pt = pt.withClazz((NameTree)this.visitAndCast((Tree)pt.getClazz(), p))).getPadding().getTypeParameters() != null) {
            pt = pt.getPadding().withTypeParameters(this.visitContainer(pt.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        pt = pt.getPadding().withTypeParameters(this.visitTypeNames(pt.getPadding().getTypeParameters(), p));
        pt = pt.withType(this.visitType(pt.getType(), p));
        return pt;
    }

    public <N extends NameTree> N visitTypeName(N nameTree, P p) {
        return nameTree;
    }

    private <N extends NameTree> @Nullable JLeftPadded<N> visitTypeName(@Nullable JLeftPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement((Object)this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    private <N extends NameTree> @Nullable JRightPadded<N> visitTypeName(@Nullable JRightPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement((Object)this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    private <J2 extends J> @Nullable JContainer<J2> visitTypeNames(@Nullable JContainer<J2> nameTrees, P p) {
        if (nameTrees == null) {
            return null;
        }
        List js = ListUtils.map((List)nameTrees.getPadding().getElements(), t -> Objects.requireNonNull(t).getElement() instanceof NameTree ? this.visitTypeName((JRightPadded)t, p) : t);
        return js == nameTrees.getPadding().getElements() ? nameTrees : JContainer.build((Space)nameTrees.getBefore(), (List)Objects.requireNonNull(js), (Markers)Markers.EMPTY);
    }

    public Space visitSpace(Space space, JsSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JsRightPadded.Location loc, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> @Nullable JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, JsLeftPadded.Location loc, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> @Nullable JContainer<J2> visitContainer(@Nullable JContainer<J2> container, JsContainer.Location loc, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }

    public J visitTypeOf(JS.TypeOf typeOf, P p) {
        JS.TypeOf t = typeOf;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPEOF_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeOf)) {
            return temp;
        }
        t = (JS.TypeOf)temp;
        t = t.withExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)t.getExpression(), p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitTypeQuery(JS.TypeQuery typeQuery, P p) {
        JS.TypeQuery t = typeQuery;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_QUERY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeQuery)) {
            return temp;
        }
        t = (JS.TypeQuery)temp;
        if ((t = t.withTypeExpression(Objects.requireNonNull((TypeTree)this.visitAndCast((Tree)t.getTypeExpression(), p)))).getPadding().getTypeArguments() != null) {
            t = t.getPadding().withTypeArguments(this.visitContainer(t.getPadding().getTypeArguments(), JsContainer.Location.TYPE_QUERY_TYPE_ARGUMENTS, p));
        }
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitVoid(JS.Void aVoid, P p) {
        JS.Void v = aVoid;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), JsSpace.Location.VOID_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(v = v.withMarkers(this.visitMarkers(v.getMarkers(), p)), p);
        if (!(temp instanceof JS.Void)) {
            return temp;
        }
        v = (JS.Void)temp;
        v = v.withExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)v.getExpression(), p)));
        return v;
    }

    public J visitYield(JS.Yield yield, P p) {
        JS.Yield y = yield;
        y = y.withPrefix(this.visitSpace(y.getPrefix(), JsSpace.Location.YIELD_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(y = y.withMarkers(this.visitMarkers(y.getMarkers(), p)), p);
        if (!(temp instanceof JS.Yield)) {
            return temp;
        }
        y = (JS.Yield)temp;
        y = y.getPadding().withDelegated(Objects.requireNonNull(this.visitLeftPadded(y.getPadding().getDelegated(), JsLeftPadded.Location.JS_YIELD_DELEGATED, p)));
        y = y.withExpression((Expression)this.visitAndCast((Tree)y.getExpression(), p));
        return y;
    }

    public J visitTypeInfo(JS.TypeInfo typeInfo, P p) {
        JS.TypeInfo ti = typeInfo;
        ti = ti.withPrefix(this.visitSpace(ti.getPrefix(), JsSpace.Location.YIELD_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ti = ti.withMarkers(this.visitMarkers(ti.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeInfo)) {
            return temp;
        }
        ti = (JS.TypeInfo)temp;
        ti = ti.withTypeIdentifier(Objects.requireNonNull((TypeTree)this.visitAndCast((Tree)ti.getTypeIdentifier(), p)));
        return ti;
    }

    public J visitJSVariableDeclarations(JS.JSVariableDeclarations multiVariable, P p) {
        JS.JSVariableDeclarations m = multiVariable.withPrefix(this.visitSpace(multiVariable.getPrefix(), JsSpace.Location.JSVARIABLE_DECLARATIONS_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof JS.JSVariableDeclarations)) {
            return temp;
        }
        m = (JS.JSVariableDeclarations)temp;
        m = m.withLeadingAnnotations(Objects.requireNonNull(ListUtils.map(m.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        m = m.withModifiers(Objects.requireNonNull(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        m = m.withTypeExpression((m = m.withTypeExpression((TypeTree)this.visitAndCast((Tree)m.getTypeExpression(), p))).getTypeExpression() == null ? null : this.visitTypeName(m.getTypeExpression(), p));
        m = m.withVarargs(m.getVarargs() == null ? null : this.visitSpace(m.getVarargs(), Space.Location.VARARGS, p));
        m = m.getPadding().withVariables(Objects.requireNonNull(ListUtils.map(m.getPadding().getVariables(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.JSNAMED_VARIABLE, p))));
        return m;
    }

    public J visitJSVariableDeclarationsJSNamedVariable(JS.JSVariableDeclarations.JSNamedVariable variable, P p) {
        JS.JSVariableDeclarations.JSNamedVariable v = variable.withPrefix(this.visitSpace(variable.getPrefix(), JsSpace.Location.JSVARIABLE_PREFIX, p));
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), p));
        v = v.withName(Objects.requireNonNull((Expression)this.visitAndCast((Tree)v.getName(), p)));
        if ((v = v.withDimensionsAfterName(Objects.requireNonNull(ListUtils.map(v.getDimensionsAfterName(), dim -> Objects.requireNonNull(dim).withBefore(this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, p)).withElement((Object)this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p)))))).getPadding().getInitializer() != null) {
            v = v.getPadding().withInitializer(this.visitLeftPadded(v.getPadding().getInitializer(), JsLeftPadded.Location.JSVARIABLE_INITIALIZER, p));
        }
        v = v.withVariableType((JavaType.Variable)this.visitType((JavaType)v.getVariableType(), p));
        return v;
    }

    public J visitJSMethodDeclaration(JS.JSMethodDeclaration method, P p) {
        JS.JSMethodDeclaration m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof JS.JSMethodDeclaration)) {
            return temp;
        }
        m = (JS.JSMethodDeclaration)temp;
        m = m.withLeadingAnnotations(Objects.requireNonNull(ListUtils.map(m.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        m = m.withModifiers(Objects.requireNonNull(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        m = m.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)m.getTypeParameters(), p));
        m = m.withReturnTypeExpression((m = m.withReturnTypeExpression((TypeTree)this.visitAndCast((Tree)m.getReturnTypeExpression(), p))).getReturnTypeExpression() == null ? null : this.visitTypeName(m.getReturnTypeExpression(), p));
        m = m.withName(Objects.requireNonNull((Expression)this.visitAndCast((Tree)m.getName(), p)));
        if ((m = m.getPadding().withParameters((JContainer<Statement>)Objects.requireNonNull(this.visitContainer(m.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, p)))).getPadding().getThrowz() != null) {
            m = m.getPadding().withThrowz((JContainer<NameTree>)this.visitContainer(m.getPadding().getThrowz(), JContainer.Location.THROWS, p));
        }
        if ((m = m.withBody((J.Block)this.visitAndCast((Tree)m.getBody(), p))).getPadding().getDefaultValue() != null) {
            m = m.getPadding().withDefaultValue((JLeftPadded<Expression>)this.visitLeftPadded(m.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, p));
        }
        m = m.withMethodType((JavaType.Method)this.visitType((JavaType)m.getMethodType(), p));
        return m;
    }

    public J visitNamespaceDeclaration(JS.NamespaceDeclaration namespaceDeclaration, P p) {
        JS.NamespaceDeclaration ns = namespaceDeclaration;
        ns = ns.withPrefix(this.visitSpace(ns.getPrefix(), JsSpace.Location.NAMESPACE_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(ns = ns.withMarkers(this.visitMarkers(ns.getMarkers(), p)), p);
        if (!(temp instanceof JS.NamespaceDeclaration)) {
            return temp;
        }
        ns = (JS.NamespaceDeclaration)temp;
        ns = ns.withModifiers(Objects.requireNonNull(ListUtils.map(ns.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p))));
        ns = ns.getPadding().withKeywordType(Objects.requireNonNull(this.visitLeftPadded(ns.getPadding().getKeywordType(), JsLeftPadded.Location.NAMESPACE_DECLARATION_KEYWORD_TYPE, p)));
        ns = ns.getPadding().withName(Objects.requireNonNull(this.visitRightPadded(ns.getPadding().getName(), JsRightPadded.Location.NAMESPACE_DECLARATION_NAME, p)));
        ns = ns.withBody((J.Block)this.visitAndCast((Tree)ns.getBody(), p));
        return ns;
    }

    public J visitFunctionDeclaration(JS.FunctionDeclaration functionDeclaration, P p) {
        JS.FunctionDeclaration f = functionDeclaration;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), JsSpace.Location.FUNCTION_DECLARATION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof JS.FunctionDeclaration)) {
            return temp;
        }
        f = (JS.FunctionDeclaration)temp;
        f = f.withModifiers(Objects.requireNonNull(ListUtils.map(f.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        f = f.getPadding().withAsteriskToken(Objects.requireNonNull(this.visitLeftPadded(f.getPadding().getAsteriskToken(), JsLeftPadded.Location.FUNCTION_DECLARATION_ASTERISK_TOKEN, p)));
        f = f.getPadding().withName(Objects.requireNonNull(this.visitLeftPadded(f.getPadding().getName(), JsLeftPadded.Location.FUNCTION_DECLARATION_NAME, p)));
        f = f.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)f.getTypeParameters(), p));
        f = f.getPadding().withParameters((JContainer<Statement>)Objects.requireNonNull(this.visitContainer(f.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, p)));
        f = f.withReturnTypeExpression((TypeTree)this.visitAndCast((Tree)f.getReturnTypeExpression(), p));
        f = f.withBody((J)this.visitAndCast((Tree)f.getBody(), p));
        f = f.withType(this.visitType(f.getType(), p));
        return f;
    }

    public J visitTypeLiteral(JS.TypeLiteral typeLiteral, P p) {
        JS.TypeLiteral t = typeLiteral;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeLiteral)) {
            return temp;
        }
        t = (JS.TypeLiteral)temp;
        t = t.withMembers(Objects.requireNonNull((J.Block)this.visitAndCast((Tree)t.getMembers(), p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitImportType(JS.ImportType importType, P p) {
        JS.ImportType t = importType;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.IMPORT_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.ImportType)) {
            return temp;
        }
        t = (JS.ImportType)temp;
        t = t.getPadding().withHasTypeof(Objects.requireNonNull(this.visitRightPadded(t.getPadding().getHasTypeof(), JsRightPadded.Location.IMPORT_TYPE_TYPEOF, p)));
        t = t.withImportArgument(Objects.requireNonNull((J.ParenthesizedTypeTree)this.visitAndCast((Tree)t.getImportArgument(), p)));
        if ((t = t.getPadding().withQualifier(this.visitLeftPadded(t.getPadding().getQualifier(), JsLeftPadded.Location.IMPORT_TYPE_QUALIFIER, p))).getPadding().getTypeArguments() != null) {
            t = t.getPadding().withTypeArguments(this.visitContainer(t.getPadding().getTypeArguments(), JsContainer.Location.IMPORT_TYPE_TYPE_ARGUMENTS, p));
        }
        return t;
    }

    public J visitIndexSignatureDeclaration(JS.IndexSignatureDeclaration indexSignatureDeclaration, P p) {
        JS.IndexSignatureDeclaration isd = indexSignatureDeclaration;
        isd = isd.withPrefix(this.visitSpace(isd.getPrefix(), JsSpace.Location.INDEXED_SIGNATURE_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(isd = isd.withMarkers(this.visitMarkers(isd.getMarkers(), p)), p);
        if (!(temp instanceof JS.IndexSignatureDeclaration)) {
            return temp;
        }
        isd = (JS.IndexSignatureDeclaration)temp;
        isd = isd.withModifiers(Objects.requireNonNull(ListUtils.map(isd.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        isd = isd.getPadding().withParameters(Objects.requireNonNull(this.visitContainer(isd.getPadding().getParameters(), JsContainer.Location.INDEXED_SIGNATURE_DECLARATION_PARAMETERS, p)));
        isd = isd.getPadding().withTypeExpression(Objects.requireNonNull(this.visitLeftPadded(isd.getPadding().getTypeExpression(), JsLeftPadded.Location.INDEXED_SIGNATURE_DECLARATION_TYPE_EXPRESSION, p)));
        isd = isd.withType(this.visitType(isd.getType(), p));
        return isd;
    }

    public J visitJSForOfLoop(JS.JSForOfLoop jsForOfLoop, P p) {
        JS.JSForOfLoop f = jsForOfLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), JsSpace.Location.FOR_OF_LOOP_PREFIX, p));
        Statement temp = (Statement)this.visitStatement((Statement)(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p))), p);
        if (!(temp instanceof JS.JSForOfLoop)) {
            return temp;
        }
        f = (JS.JSForOfLoop)temp;
        f = f.getPadding().withAwait(Objects.requireNonNull(this.visitLeftPadded(f.getPadding().getAwait(), JsLeftPadded.Location.FOR_OF_AWAIT, p)));
        f = f.withControl(Objects.requireNonNull((JS.JSForInOfLoopControl)this.visitAndCast((Tree)f.getControl(), p)));
        f = f.getPadding().withBody(Objects.requireNonNull(this.visitRightPadded(f.getPadding().getBody(), JsRightPadded.Location.FOR_BODY, p)));
        return f;
    }

    public J visitJSForInLoop(JS.JSForInLoop jsForInLoop, P p) {
        JS.JSForInLoop f = jsForInLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), JsSpace.Location.FOR_IN_LOOP_PREFIX, p));
        Statement temp = (Statement)this.visitStatement((Statement)(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p))), p);
        if (!(temp instanceof JS.JSForInLoop)) {
            return temp;
        }
        f = (JS.JSForInLoop)temp;
        f = f.withControl(Objects.requireNonNull((JS.JSForInOfLoopControl)this.visitAndCast((Tree)f.getControl(), p)));
        f = f.getPadding().withBody(Objects.requireNonNull(this.visitRightPadded(f.getPadding().getBody(), JsRightPadded.Location.FOR_BODY, p)));
        return f;
    }

    public J visitJSForInOfLoopControl(JS.JSForInOfLoopControl jsForInOfLoopControl, P p) {
        JS.JSForInOfLoopControl c = jsForInOfLoopControl;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), JsSpace.Location.FOR_LOOP_CONTROL_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.getPadding().withVariable(Objects.requireNonNull(this.visitRightPadded(c.getPadding().getVariable(), JsRightPadded.Location.FOR_CONTROL_VAR, p)));
        c = c.getPadding().withIterable(Objects.requireNonNull(this.visitRightPadded(c.getPadding().getIterable(), JsRightPadded.Location.FOR_CONTROL_ITER, p)));
        return c;
    }

    public J visitArrayBindingPattern(JS.ArrayBindingPattern arrayBindingPattern, P p) {
        JS.ArrayBindingPattern c = arrayBindingPattern;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), JsSpace.Location.ARRAY_BINDING_PATTERN_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(c = c.withMarkers(this.visitMarkers(c.getMarkers(), p)), p);
        if (!(temp instanceof JS.ArrayBindingPattern)) {
            return temp;
        }
        c = (JS.ArrayBindingPattern)temp;
        c = c.getPadding().withElements(Objects.requireNonNull(this.visitContainer(c.getPadding().getElements(), JsContainer.Location.ARRAY_BINDING_PATTERN_ELEMENTS, p)));
        return c;
    }

    public J visitJsAssignmentOperation(JS.JsAssignmentOperation assignOp, P p) {
        JS.JsAssignmentOperation a = assignOp;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.ASSIGNMENT_OPERATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.JsAssignmentOperation)) {
            return temp;
        }
        a = (JS.JsAssignmentOperation)temp;
        Expression temp2 = (Expression)this.visitExpression(a, p);
        if (!(temp2 instanceof JS.JsAssignmentOperation)) {
            return temp2;
        }
        a = (JS.JsAssignmentOperation)temp2;
        a = a.withVariable(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getVariable(), p)));
        a = a.getPadding().withOperator(Objects.requireNonNull(this.visitLeftPadded(a.getPadding().getOperator(), JsLeftPadded.Location.ASSIGNMENT_OPERATION_OPERATOR, p)));
        a = a.withAssignment(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getAssignment(), p)));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitTypeTreeExpression(JS.TypeTreeExpression typeTreeExpression, P p) {
        JS.TypeTreeExpression a = typeTreeExpression;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.TYPE_TREE_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeTreeExpression)) {
            return temp;
        }
        a = (JS.TypeTreeExpression)temp;
        a = a.withExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getExpression(), p)));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }
}

