/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.util.Optional;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.javascript.JavaScriptIsoVisitor;
import org.openrewrite.javascript.JavaScriptParser;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.opentest4j.AssertionFailedError;

public final class Assertions {
    private Assertions() {
    }

    public static SourceSpecs javaScript(@Language(value="typescript") @Nullable String before) {
        return Assertions.javaScript(before, (SourceSpec<JS.CompilationUnit> s) -> {});
    }

    public static SourceSpecs javaScript(@Language(value="typescript") @Nullable String before, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javaScript0(before, null, spec);
    }

    public static SourceSpecs javaScript(@Language(value="typescript") @Nullable String before, @Language(value="typescript") String after) {
        return Assertions.javaScript(before, after, s -> {});
    }

    public static SourceSpecs javaScript(@Language(value="typescript") @Nullable String before, @Language(value="typescript") String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javaScript0(before, after, spec);
    }

    private static SourceSpec<JS.CompilationUnit> javaScript0(@Language(value="typescript") @Nullable String before, @Language(value="typescript") @Nullable String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        SourceSpec js = new SourceSpec(JS.CompilationUnit.class, null, (Parser.Builder)JavaScriptParser.builder(), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext);
        if (after != null) {
            js = js.after(s -> after);
        }
        Assertions.acceptSpec(spec, (SourceSpec<JS.CompilationUnit>)js);
        return js;
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
    }

    private static void acceptSpec(Consumer<SourceSpec<JS.CompilationUnit>> spec, SourceSpec<JS.CompilationUnit> javaScript) {
        ThrowingConsumer userSuppliedAfterRecipe = javaScript.getAfterRecipe();
        javaScript.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        Assertions.isFullyParsed().andThen(spec).accept(javaScript);
    }

    public static Consumer<SourceSpec<JS.CompilationUnit>> isFullyParsed() {
        return spec -> spec.afterRecipe(cu -> {
            new JavaScriptIsoVisitor<Integer>(){

                public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                    org.assertj.core.api.Assertions.assertThat((String)space.getWhitespace()).isBlank();
                    return super.visitSpace(space, loc, (Object)integer);
                }
            }.visit((Tree)cu, 0);
            new JavaScriptVisitor<Integer>(){

                public J visitUnknownSource(J.Unknown.Source source, Integer integer) {
                    Optional result = source.getMarkers().findFirst(ParseExceptionResult.class);
                    if (result.isPresent()) {
                        throw new AssertionFailedError("Parsing error, J.Unknown detected for: " + source.getText());
                    }
                    throw new UnsupportedOperationException("A J.Unknown should always have a parse exception result.");
                }
            }.visit((Tree)cu, 0);
        });
    }
}

