/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.tree;

import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.service.ImportService;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.internal.JavaScriptPrinter;
import org.openrewrite.javascript.service.JavaScriptImportService;
import org.openrewrite.marker.Markers;

public interface JS
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptJavaScript((JavaScriptVisitor)v.adapt(JavaScriptVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(JavaScriptVisitor.class);
    }

    default public <P> @Nullable J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
        return (J)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    public static final class Union
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<Expression>> types;
        private final @Nullable JavaType type;

        public List<Expression> getTypes() {
            return JRightPadded.getElements(this.types);
        }

        public Union withTypes(List<Expression> types) {
            return this.getPadding().withTypes(JRightPadded.withElements(this.types, types));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitUnion(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Union)) {
                return false;
            }
            Union other = (Union)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Union(UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        @Generated
        private Union(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "JS.Union(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", types=" + this.getTypes() + ", type=" + this.getType() + ")";
        }

        @Generated
        public Union withId(UUID id) {
            return this.id == id ? this : new Union(this.padding, id, this.prefix, this.markers, this.types, this.type);
        }

        @Generated
        public Union withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Union(this.padding, this.id, prefix, this.markers, this.types, this.type);
        }

        @Generated
        public Union withMarkers(Markers markers) {
            return this.markers == markers ? this : new Union(this.padding, this.id, this.prefix, markers, this.types, this.type);
        }

        @Generated
        public Union withType(@Nullable JavaType type) {
            return this.type == type ? this : new Union(this.padding, this.id, this.prefix, this.markers, this.types, type);
        }

        public static class Padding {
            private final Union t;

            public List<JRightPadded<Expression>> getTypes() {
                return this.t.types;
            }

            public Union withTypes(List<JRightPadded<Expression>> types) {
                return this.t.types == types ? this.t : new Union(this.t.id, this.t.prefix, this.t.markers, types, this.t.type);
            }

            @Generated
            public Padding(Union t) {
                this.t = t;
            }
        }
    }

    public static final class Unary
    implements JS,
    Statement,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Type> operator;
        private final Expression expression;
        private final @Nullable JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public Unary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
            return JS.super.accept(v, p);
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitUnary(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Transient
        public List<J> getSideEffects() {
            return this.getOperator().isModifying() ? Collections.singletonList(this) : this.expression.getSideEffects();
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new JavaPrinter());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Unary(UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        private Unary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        public Unary withId(UUID id) {
            return this.id == id ? this : new Unary(this.padding, id, this.prefix, this.markers, this.operator, this.expression, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Unary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unary(this.padding, this.id, prefix, this.markers, this.operator, this.expression, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Unary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unary(this.padding, this.id, this.prefix, markers, this.operator, this.expression, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Unary withExpression(Expression expression) {
            return this.expression == expression ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, expression, this.type);
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public Unary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, this.expression, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static enum Type {
            Spread;


            public boolean isModifying() {
                switch (this) {
                    default: 
                }
                return false;
            }
        }

        public static class Padding {
            private final Unary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Unary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Unary(this.t.id, this.t.prefix, this.t.markers, operator, this.t.expression, this.t.type);
            }

            @Generated
            public Padding(Unary t) {
                this.t = t;
            }
        }
    }

    public static final class TypeOperator
    implements JS,
    Expression,
    TypedTree,
    NameTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type operator;
        private final JLeftPadded<Expression> expression;

        public Expression getExpression() {
            return (Expression)this.expression.getElement();
        }

        public TypeOperator withExpression(Expression expression) {
            return this.getPadding().withExpression((JLeftPadded<Expression>)this.expression.withElement((Object)expression));
        }

        public @Nullable JavaType getType() {
            return ((Expression)this.expression.getElement()).getType();
        }

        public TypeOperator withType(@Nullable JavaType type) {
            return type == this.getType() ? this : this.getPadding().withExpression((JLeftPadded<Expression>)this.expression.withElement((Object)((Expression)((Expression)this.expression.getElement()).withType(type))));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeOperator(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeOperator)) {
                return false;
            }
            TypeOperator other = (TypeOperator)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeOperator(UUID id, Space prefix, Markers markers, Type operator, JLeftPadded<Expression> expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
        }

        @Generated
        private TypeOperator(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Type operator, JLeftPadded<Expression> expression) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Type getOperator() {
            return this.operator;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "JS.TypeOperator(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", operator=" + (Object)((Object)this.getOperator()) + ", expression=" + this.getExpression() + ")";
        }

        @Generated
        public TypeOperator withId(UUID id) {
            return this.id == id ? this : new TypeOperator(this.padding, id, this.prefix, this.markers, this.operator, this.expression);
        }

        @Generated
        public TypeOperator withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeOperator(this.padding, this.id, prefix, this.markers, this.operator, this.expression);
        }

        @Generated
        public TypeOperator withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeOperator(this.padding, this.id, this.prefix, markers, this.operator, this.expression);
        }

        @Generated
        public TypeOperator withOperator(Type operator) {
            return this.operator == operator ? this : new TypeOperator(this.padding, this.id, this.prefix, this.markers, operator, this.expression);
        }

        public static enum Type {
            ReadOnly,
            KeyOf;

        }

        public static class Padding {
            private final TypeOperator t;

            public JLeftPadded<Expression> getExpression() {
                return this.t.expression;
            }

            public TypeOperator withExpression(JLeftPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new TypeOperator(this.t.id, this.t.prefix, this.t.markers, this.t.operator, expression);
            }

            @Generated
            public Padding(TypeOperator t) {
                this.t = t;
            }
        }
    }

    public static final class TypeDeclaration
    implements JS,
    Statement,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Annotation> leadingAnnotations;
        private final List<J.Modifier> modifiers;
        private final J.Identifier name;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters;
        private final JLeftPadded<Expression> initializer;
        private final @Nullable JavaType javaType;

        public Expression getInitializer() {
            return (Expression)this.initializer.getElement();
        }

        public TypeDeclaration withInitializer(Expression initializer) {
            return this.getPadding().withInitializer((JLeftPadded<Expression>)JLeftPadded.withElement(this.initializer, (Object)initializer));
        }

        public @Nullable JavaType getType() {
            return this.javaType;
        }

        public TypeDeclaration withType(@Nullable JavaType javaType) {
            return this.javaType == javaType ? this : new TypeDeclaration(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.name, this.typeParameters, this.initializer, javaType);
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeDeclaration(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeDeclaration)) {
                return false;
            }
            TypeDeclaration other = (TypeDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeDeclaration(UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, J.Identifier name, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters, JLeftPadded<Expression> initializer, @Nullable JavaType javaType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.name = name;
            this.typeParameters = typeParameters;
            this.initializer = initializer;
            this.javaType = javaType;
        }

        @Generated
        private TypeDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, J.Identifier name, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters, JLeftPadded<Expression> initializer, @Nullable JavaType javaType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.name = name;
            this.typeParameters = typeParameters;
            this.initializer = initializer;
            this.javaType = javaType;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<J.Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @Generated
        public J.Identifier getName() {
            return this.name;
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        @Generated
        public @Nullable JavaType getJavaType() {
            return this.javaType;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "JS.TypeDeclaration(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", leadingAnnotations=" + this.getLeadingAnnotations() + ", modifiers=" + this.getModifiers() + ", name=" + this.getName() + ", typeParameters=" + this.getTypeParameters() + ", initializer=" + this.getInitializer() + ", javaType=" + this.getJavaType() + ")";
        }

        @Generated
        public TypeDeclaration withId(UUID id) {
            return this.id == id ? this : new TypeDeclaration(this.padding, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.name, this.typeParameters, this.initializer, this.javaType);
        }

        @Generated
        public TypeDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeDeclaration(this.padding, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.name, this.typeParameters, this.initializer, this.javaType);
        }

        @Generated
        public TypeDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeDeclaration(this.padding, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.name, this.typeParameters, this.initializer, this.javaType);
        }

        @Generated
        public TypeDeclaration withLeadingAnnotations(List<J.Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new TypeDeclaration(this.padding, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.name, this.typeParameters, this.initializer, this.javaType);
        }

        @Generated
        public TypeDeclaration withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new TypeDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.name, this.typeParameters, this.initializer, this.javaType);
        }

        @Generated
        public TypeDeclaration withName(J.Identifier name) {
            return this.name == name ? this : new TypeDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, name, this.typeParameters, this.initializer, this.javaType);
        }

        @Generated
        public TypeDeclaration withTypeParameters(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new TypeDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.name, typeParameters, this.initializer, this.javaType);
        }

        public static class Padding {
            private final TypeDeclaration t;

            public JLeftPadded<Expression> getInitializer() {
                return this.t.initializer;
            }

            public TypeDeclaration withInitializer(JLeftPadded<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new TypeDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.name, this.t.typeParameters, initializer, this.t.javaType);
            }

            @Generated
            public Padding(TypeDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class Tuple
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<J> elements;
        private final @Nullable JavaType type;

        public List<J> getElements() {
            return this.elements.getElements();
        }

        public Tuple withElements(List<J> elements) {
            return this.getPadding().withElements((JContainer<J>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTuple(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple other = (Tuple)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Tuple(UUID id, Space prefix, Markers markers, JContainer<J> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        private Tuple(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<J> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "JS.Tuple(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", elements=" + this.getElements() + ", type=" + this.getType() + ")";
        }

        @Generated
        public Tuple withId(UUID id) {
            return this.id == id ? this : new Tuple(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Generated
        public Tuple withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Tuple(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        @Generated
        public Tuple withMarkers(Markers markers) {
            return this.markers == markers ? this : new Tuple(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Generated
        public Tuple withType(@Nullable JavaType type) {
            return this.type == type ? this : new Tuple(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final Tuple t;

            public JContainer<J> getElements() {
                return this.t.elements;
            }

            public Tuple withElements(JContainer<J> elements) {
                return this.t.elements == elements ? this.t : new Tuple(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            @Generated
            public Padding(Tuple t) {
                this.t = t;
            }
        }
    }

    public static final class TemplateExpression
    implements JS,
    Statement,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String delimiter;
        private final @Nullable JRightPadded<Expression> tag;
        private final List<J> strings;
        private final @Nullable JavaType type;

        public @Nullable Expression getTag() {
            return this.tag == null ? null : (Expression)this.tag.getElement();
        }

        public TemplateExpression withTag(@Nullable Expression tag) {
            return this.getPadding().withTag((JRightPadded<Expression>)JRightPadded.withElement(this.tag, (Object)tag));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTemplateExpression(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateExpression)) {
                return false;
            }
            TemplateExpression other = (TemplateExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TemplateExpression(UUID id, Space prefix, Markers markers, String delimiter, @Nullable JRightPadded<Expression> tag, List<J> strings, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.delimiter = delimiter;
            this.tag = tag;
            this.strings = strings;
            this.type = type;
        }

        @Generated
        private TemplateExpression(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, String delimiter, @Nullable JRightPadded<Expression> tag, List<J> strings, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.delimiter = delimiter;
            this.tag = tag;
            this.strings = strings;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getDelimiter() {
            return this.delimiter;
        }

        @Generated
        public List<J> getStrings() {
            return this.strings;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "JS.TemplateExpression(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", delimiter=" + this.getDelimiter() + ", tag=" + this.getTag() + ", strings=" + this.getStrings() + ", type=" + this.getType() + ")";
        }

        @Generated
        public TemplateExpression withId(UUID id) {
            return this.id == id ? this : new TemplateExpression(this.padding, id, this.prefix, this.markers, this.delimiter, this.tag, this.strings, this.type);
        }

        @Generated
        public TemplateExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TemplateExpression(this.padding, this.id, prefix, this.markers, this.delimiter, this.tag, this.strings, this.type);
        }

        @Generated
        public TemplateExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new TemplateExpression(this.padding, this.id, this.prefix, markers, this.delimiter, this.tag, this.strings, this.type);
        }

        @Generated
        public TemplateExpression withDelimiter(String delimiter) {
            return this.delimiter == delimiter ? this : new TemplateExpression(this.padding, this.id, this.prefix, this.markers, delimiter, this.tag, this.strings, this.type);
        }

        @Generated
        public TemplateExpression withStrings(List<J> strings) {
            return this.strings == strings ? this : new TemplateExpression(this.padding, this.id, this.prefix, this.markers, this.delimiter, this.tag, strings, this.type);
        }

        @Generated
        public TemplateExpression withType(@Nullable JavaType type) {
            return this.type == type ? this : new TemplateExpression(this.padding, this.id, this.prefix, this.markers, this.delimiter, this.tag, this.strings, type);
        }

        public static class Padding {
            private final TemplateExpression t;

            public @Nullable JRightPadded<Expression> getTag() {
                return this.t.tag;
            }

            public TemplateExpression withTag(@Nullable JRightPadded<Expression> tag) {
                return this.t.tag == tag ? this.t : new TemplateExpression(this.t.id, this.t.prefix, this.t.markers, this.t.delimiter, tag, this.t.strings, this.t.type);
            }

            @Generated
            public Padding(TemplateExpression t) {
                this.t = t;
            }
        }

        public static final class Value
        implements JS {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final J tree;
            private final Space after;
            private final boolean enclosedInBraces;

            @Override
            public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
                return v.visitTemplateExpressionValue(this, p);
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof Value;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }

            @Generated
            public Value(UUID id, Space prefix, Markers markers, J tree, Space after, boolean enclosedInBraces) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.tree = tree;
                this.after = after;
                this.enclosedInBraces = enclosedInBraces;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public J getTree() {
                return this.tree;
            }

            @Generated
            public Space getAfter() {
                return this.after;
            }

            @Generated
            public boolean isEnclosedInBraces() {
                return this.enclosedInBraces;
            }

            @Generated
            public String toString() {
                return "JS.TemplateExpression.Value(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ", after=" + this.getAfter() + ", enclosedInBraces=" + this.isEnclosedInBraces() + ")";
            }

            @Generated
            public Value withId(UUID id) {
                return this.id == id ? this : new Value(id, this.prefix, this.markers, this.tree, this.after, this.enclosedInBraces);
            }

            @Generated
            public Value withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Value(this.id, prefix, this.markers, this.tree, this.after, this.enclosedInBraces);
            }

            @Generated
            public Value withMarkers(Markers markers) {
                return this.markers == markers ? this : new Value(this.id, this.prefix, markers, this.tree, this.after, this.enclosedInBraces);
            }

            @Generated
            public Value withTree(J tree) {
                return this.tree == tree ? this : new Value(this.id, this.prefix, this.markers, tree, this.after, this.enclosedInBraces);
            }

            @Generated
            public Value withAfter(Space after) {
                return this.after == after ? this : new Value(this.id, this.prefix, this.markers, this.tree, after, this.enclosedInBraces);
            }

            @Generated
            public Value withEnclosedInBraces(boolean enclosedInBraces) {
                return this.enclosedInBraces == enclosedInBraces ? this : new Value(this.id, this.prefix, this.markers, this.tree, this.after, enclosedInBraces);
            }
        }
    }

    public static final class StatementExpression
    implements JS,
    Expression,
    Statement {
        private final UUID id;
        private final Statement statement;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getStatement(), p);
            if (j instanceof StatementExpression) {
                return j;
            }
            if (j instanceof Statement) {
                return this.withStatement((Statement)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withStatement((Statement)this.statement.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.statement.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withStatement((Statement)this.statement.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.statement.getMarkers();
        }

        public @Nullable JavaType getType() {
            return null;
        }

        public StatementExpression withType(@Nullable JavaType type) {
            return this;
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Statement getStatement() {
            return this.statement;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof StatementExpression;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public StatementExpression(UUID id, Statement statement) {
            this.id = id;
            this.statement = statement;
        }

        @Generated
        public StatementExpression withId(UUID id) {
            return this.id == id ? this : new StatementExpression(id, this.statement);
        }

        @Generated
        public StatementExpression withStatement(Statement statement) {
            return this.statement == statement ? this : new StatementExpression(this.id, statement);
        }
    }

    public static final class ObjectBindingDeclarations
    implements JS,
    Statement,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Annotation> leadingAnnotations;
        private final List<J.Modifier> modifiers;
        private final @Nullable TypeTree typeExpression;
        private final JContainer<Binding> bindings;
        private final @Nullable JLeftPadded<Expression> initializer;

        public List<Binding> getBindings() {
            return this.bindings.getElements();
        }

        public ObjectBindingDeclarations withBindings(List<Binding> bindings) {
            return this.getPadding().withBindings((JContainer<Binding>)JContainer.withElements(this.bindings, bindings));
        }

        public @Nullable Expression getInitializer() {
            return this.initializer == null ? null : (Expression)this.initializer.getElement();
        }

        public ObjectBindingDeclarations withInitializer(@Nullable Expression initializer) {
            return this.getPadding().withInitializer((JLeftPadded<Expression>)JLeftPadded.withElement(this.initializer, (Object)initializer));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitObjectBindingDeclarations(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public List<J.Annotation> getAllAnnotations() {
            ArrayList<J.Annotation> allAnnotations = new ArrayList<J.Annotation>(this.leadingAnnotations);
            for (J.Modifier modifier : this.modifiers) {
                allAnnotations.addAll(modifier.getAnnotations());
            }
            if (this.typeExpression != null && this.typeExpression instanceof J.AnnotatedType) {
                allAnnotations.addAll(((J.AnnotatedType)this.typeExpression).getAnnotations());
            }
            return allAnnotations;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.FullyQualified getTypeAsFullyQualified() {
            return this.typeExpression == null ? null : TypeUtils.asFullyQualified((JavaType)this.typeExpression.getType());
        }

        public @Nullable JavaType getType() {
            return this.typeExpression == null ? null : this.typeExpression.getType();
        }

        public ObjectBindingDeclarations withType(@Nullable JavaType type) {
            return this.typeExpression == null ? this : this.withTypeExpression((TypeTree)this.typeExpression.withType(type));
        }

        public boolean hasModifier(J.Modifier.Type modifier) {
            return J.Modifier.hasModifier(this.getModifiers(), (J.Modifier.Type)modifier);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObjectBindingDeclarations)) {
                return false;
            }
            ObjectBindingDeclarations other = (ObjectBindingDeclarations)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ObjectBindingDeclarations(UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, @Nullable TypeTree typeExpression, JContainer<Binding> bindings, @Nullable JLeftPadded<Expression> initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.bindings = bindings;
            this.initializer = initializer;
        }

        @Generated
        private ObjectBindingDeclarations(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, @Nullable TypeTree typeExpression, JContainer<Binding> bindings, @Nullable JLeftPadded<Expression> initializer) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.bindings = bindings;
            this.initializer = initializer;
        }

        @Generated
        public ObjectBindingDeclarations withId(UUID id) {
            return this.id == id ? this : new ObjectBindingDeclarations(this.padding, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public ObjectBindingDeclarations withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ObjectBindingDeclarations(this.padding, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public ObjectBindingDeclarations withMarkers(Markers markers) {
            return this.markers == markers ? this : new ObjectBindingDeclarations(this.padding, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public ObjectBindingDeclarations withLeadingAnnotations(List<J.Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new ObjectBindingDeclarations(this.padding, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public List<J.Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @Generated
        public ObjectBindingDeclarations withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ObjectBindingDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @Generated
        public ObjectBindingDeclarations withTypeExpression(@Nullable TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new ObjectBindingDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public @Nullable TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        public static class Padding {
            private final ObjectBindingDeclarations t;

            public JContainer<Binding> getBindings() {
                return this.t.bindings;
            }

            public ObjectBindingDeclarations withBindings(JContainer<Binding> bindings) {
                return this.t.bindings == bindings ? this.t : new ObjectBindingDeclarations(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeExpression, bindings, (JLeftPadded<Expression>)this.t.initializer);
            }

            public @Nullable JLeftPadded<Expression> getInitializer() {
                return this.t.initializer;
            }

            public ObjectBindingDeclarations withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new ObjectBindingDeclarations(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeExpression, (JContainer<Binding>)this.t.bindings, initializer);
            }

            @Generated
            public Padding(ObjectBindingDeclarations t) {
                this.t = t;
            }
        }

        public static final class Binding
        implements JS,
        NameTree {
            private transient @Nullable WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Identifier> propertyName;
            private final J.Identifier name;
            private final List<JLeftPadded<Space>> dimensionsAfterName;
            private final @Nullable Space afterVararg;
            private final @Nullable JLeftPadded<Expression> initializer;
            private final // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaType.Variable variableType;

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.Identifier getPropertyName() {
                return this.propertyName == null ? null : (J.Identifier)this.propertyName.getElement();
            }

            public Binding withPropertyName(// Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.Identifier propertyName) {
                return this.getPadding().withPropertyName((JRightPadded<J.Identifier>)JRightPadded.withElement(this.propertyName, (Object)propertyName));
            }

            public @Nullable Expression getInitializer() {
                return this.initializer == null ? null : (Expression)this.initializer.getElement();
            }

            public Binding withInitializer(@Nullable Expression initializer) {
                return this.getPadding().withInitializer((JLeftPadded<Expression>)JLeftPadded.withElement(this.initializer, (Object)initializer));
            }

            public JavaType getType() {
                return this.variableType != null ? this.variableType.getType() : null;
            }

            public Binding withType(@Nullable JavaType type) {
                return this.variableType != null ? this.withVariableType(this.variableType.withType(type)) : this;
            }

            public String getSimpleName() {
                return this.name.getSimpleName();
            }

            @Override
            public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
                return v.visitBinding(this, p);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Binding)) {
                    return false;
                }
                Binding other = (Binding)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Binding(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Identifier> propertyName, J.Identifier name, List<JLeftPadded<Space>> dimensionsAfterName, @Nullable Space afterVararg, @Nullable JLeftPadded<Expression> initializer, // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaType.Variable variableType) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.propertyName = propertyName;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.afterVararg = afterVararg;
                this.initializer = initializer;
                this.variableType = variableType;
            }

            @Generated
            private Binding(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Identifier> propertyName, J.Identifier name, List<JLeftPadded<Space>> dimensionsAfterName, @Nullable Space afterVararg, @Nullable JLeftPadded<Expression> initializer, // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaType.Variable variableType) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.propertyName = propertyName;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.afterVararg = afterVararg;
                this.initializer = initializer;
                this.variableType = variableType;
            }

            @Generated
            public Binding withId(UUID id) {
                return this.id == id ? this : new Binding(this.padding, id, this.prefix, this.markers, this.propertyName, this.name, this.dimensionsAfterName, this.afterVararg, this.initializer, this.variableType);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Generated
            public Binding withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Binding(this.padding, this.id, prefix, this.markers, this.propertyName, this.name, this.dimensionsAfterName, this.afterVararg, this.initializer, this.variableType);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Binding withMarkers(Markers markers) {
                return this.markers == markers ? this : new Binding(this.padding, this.id, this.prefix, markers, this.propertyName, this.name, this.dimensionsAfterName, this.afterVararg, this.initializer, this.variableType);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public Binding withName(J.Identifier name) {
                return this.name == name ? this : new Binding(this.padding, this.id, this.prefix, this.markers, this.propertyName, name, this.dimensionsAfterName, this.afterVararg, this.initializer, this.variableType);
            }

            @Generated
            public J.Identifier getName() {
                return this.name;
            }

            @Generated
            public Binding withDimensionsAfterName(List<JLeftPadded<Space>> dimensionsAfterName) {
                return this.dimensionsAfterName == dimensionsAfterName ? this : new Binding(this.padding, this.id, this.prefix, this.markers, this.propertyName, this.name, dimensionsAfterName, this.afterVararg, this.initializer, this.variableType);
            }

            @Generated
            public List<JLeftPadded<Space>> getDimensionsAfterName() {
                return this.dimensionsAfterName;
            }

            @Generated
            public Binding withAfterVararg(@Nullable Space afterVararg) {
                return this.afterVararg == afterVararg ? this : new Binding(this.padding, this.id, this.prefix, this.markers, this.propertyName, this.name, this.dimensionsAfterName, afterVararg, this.initializer, this.variableType);
            }

            @Generated
            public @Nullable Space getAfterVararg() {
                return this.afterVararg;
            }

            @Generated
            public Binding withVariableType(// Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaType.Variable variableType) {
                return this.variableType == variableType ? this : new Binding(this.padding, this.id, this.prefix, this.markers, this.propertyName, this.name, this.dimensionsAfterName, this.afterVararg, this.initializer, variableType);
            }

            @Generated
            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaType.Variable getVariableType() {
                return this.variableType;
            }

            public static class Padding {
                private final Binding t;

                public @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
                J.Identifier> getPropertyName() {
                    return this.t.propertyName;
                }

                public Binding withPropertyName(@Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
                J.Identifier> propertyName) {
                    return this.t.propertyName == propertyName ? this.t : new Binding(this.t.id, this.t.prefix, this.t.markers, propertyName, this.t.name, this.t.dimensionsAfterName, this.t.afterVararg, (JLeftPadded<Expression>)this.t.initializer, this.t.variableType);
                }

                public @Nullable JLeftPadded<Expression> getInitializer() {
                    return this.t.initializer;
                }

                public Binding withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                    return this.t.initializer == initializer ? this.t : new Binding(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<J.Identifier>)this.t.propertyName, this.t.name, this.t.dimensionsAfterName, this.t.afterVararg, initializer, this.t.variableType);
                }

                @Generated
                public Padding(Binding t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class JsOperator
    implements JS,
    Statement,
    Expression,
    TypedTree,
    NameTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        private final @Nullable JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public JsOperator withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitJsOperator(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsOperator)) {
                return false;
            }
            JsOperator other = (JsOperator)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public JsOperator(UUID id, Space prefix, Markers markers, @Nullable Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        @Generated
        private JsOperator(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable Expression getLeft() {
            return this.left;
        }

        @Generated
        public Expression getRight() {
            return this.right;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "JS.JsOperator(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + (Object)((Object)this.getOperator()) + ", right=" + this.getRight() + ", type=" + this.getType() + ")";
        }

        @Generated
        public JsOperator withId(UUID id) {
            return this.id == id ? this : new JsOperator(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @Generated
        public JsOperator withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JsOperator(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @Generated
        public JsOperator withMarkers(Markers markers) {
            return this.markers == markers ? this : new JsOperator(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.type);
        }

        @Generated
        public JsOperator withLeft(@Nullable Expression left) {
            return this.left == left ? this : new JsOperator(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.type);
        }

        @Generated
        public JsOperator withRight(Expression right) {
            return this.right == right ? this : new JsOperator(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.type);
        }

        @Generated
        public JsOperator withType(@Nullable JavaType type) {
            return this.type == type ? this : new JsOperator(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, type);
        }

        public static enum Type {
            Await,
            Delete,
            In,
            TypeOf;

        }

        public static class Padding {
            private final JsOperator t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public JsOperator withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new JsOperator(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.type);
            }

            @Generated
            public Padding(JsOperator t) {
                this.t = t;
            }
        }
    }

    public static final class JsBinary
    implements JS,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        private final @Nullable JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public JsBinary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitJsBinary(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsBinary)) {
                return false;
            }
            JsBinary other = (JsBinary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public JsBinary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        @Generated
        private JsBinary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getLeft() {
            return this.left;
        }

        @Generated
        public Expression getRight() {
            return this.right;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "JS.JsBinary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + (Object)((Object)this.getOperator()) + ", right=" + this.getRight() + ", type=" + this.getType() + ")";
        }

        @Generated
        public JsBinary withId(UUID id) {
            return this.id == id ? this : new JsBinary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @Generated
        public JsBinary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JsBinary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @Generated
        public JsBinary withMarkers(Markers markers) {
            return this.markers == markers ? this : new JsBinary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.type);
        }

        @Generated
        public JsBinary withLeft(Expression left) {
            return this.left == left ? this : new JsBinary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.type);
        }

        @Generated
        public JsBinary withRight(Expression right) {
            return this.right == right ? this : new JsBinary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.type);
        }

        @Generated
        public JsBinary withType(@Nullable JavaType type) {
            return this.type == type ? this : new JsBinary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, type);
        }

        public static enum Type {
            IdentityEquals,
            IdentityNotEquals,
            In;

        }

        public static class Padding {
            private final JsBinary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public JsBinary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new JsBinary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.type);
            }

            @Generated
            public Padding(JsBinary t) {
                this.t = t;
            }
        }
    }

    public static class JsImport
    implements JS,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Identifier> name;
        private final @Nullable JContainer<Expression> imports;
        private final @Nullable Space from;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal target;
        private final @Nullable JLeftPadded<Expression> initializer;

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Identifier getName() {
            return this.name == null ? null : (J.Identifier)this.name.getElement();
        }

        public JsImport withName(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Identifier name) {
            return this.getPadding().withName((JRightPadded<J.Identifier>)JRightPadded.withElement(this.name, (Object)name));
        }

        public @Nullable List<Expression> getImports() {
            return this.imports == null ? null : this.imports.getElements();
        }

        public JsImport withImports(List<Expression> imports) {
            return this.getPadding().withImports((JContainer<Expression>)JContainer.withElementsNullable(this.imports, imports));
        }

        public @Nullable Expression getInitializer() {
            return this.initializer == null ? null : (Expression)this.initializer.getElement();
        }

        public JsImport withInitializer(@Nullable Expression initializer) {
            return this.getPadding().withInitializer((JLeftPadded<Expression>)JLeftPadded.withElement(this.initializer, (Object)initializer));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitJsImport(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsImport)) {
                return false;
            }
            JsImport other = (JsImport)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JsImport;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public JsImport(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Identifier> name, @Nullable JContainer<Expression> imports, @Nullable Space from, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal target, @Nullable JLeftPadded<Expression> initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.imports = imports;
            this.from = from;
            this.target = target;
            this.initializer = initializer;
        }

        @Generated
        private JsImport(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Identifier> name, @Nullable JContainer<Expression> imports, @Nullable Space from, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal target, @Nullable JLeftPadded<Expression> initializer) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.imports = imports;
            this.from = from;
            this.target = target;
            this.initializer = initializer;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public JsImport withId(UUID id) {
            return this.id == id ? this : new JsImport(this.padding, id, this.prefix, this.markers, this.name, this.imports, this.from, this.target, this.initializer);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public JsImport withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JsImport(this.padding, this.id, prefix, this.markers, this.name, this.imports, this.from, this.target, this.initializer);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public JsImport withMarkers(Markers markers) {
            return this.markers == markers ? this : new JsImport(this.padding, this.id, this.prefix, markers, this.name, this.imports, this.from, this.target, this.initializer);
        }

        @Generated
        public @Nullable Space getFrom() {
            return this.from;
        }

        @Generated
        public JsImport withFrom(@Nullable Space from) {
            return this.from == from ? this : new JsImport(this.padding, this.id, this.prefix, this.markers, this.name, this.imports, from, this.target, this.initializer);
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal getTarget() {
            return this.target;
        }

        @Generated
        public JsImport withTarget(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal target) {
            return this.target == target ? this : new JsImport(this.padding, this.id, this.prefix, this.markers, this.name, this.imports, this.from, target, this.initializer);
        }

        public static class Padding {
            private final JsImport t;

            public @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Identifier> getName() {
                return this.t.name;
            }

            public JsImport withName(@Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Identifier> name) {
                return this.t.name == name ? this.t : new JsImport(this.t.id, this.t.prefix, this.t.markers, name, (JContainer<Expression>)this.t.imports, this.t.from, this.t.target, (JLeftPadded<Expression>)this.t.initializer);
            }

            public @Nullable JContainer<Expression> getImports() {
                return this.t.imports;
            }

            public JsImport withImports(@Nullable JContainer<Expression> imports) {
                return this.t.imports == imports ? this.t : new JsImport(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<J.Identifier>)this.t.name, imports, this.t.from, this.t.target, (JLeftPadded<Expression>)this.t.initializer);
            }

            public @Nullable JLeftPadded<Expression> getInitializer() {
                return this.t.initializer;
            }

            public JsImport withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new JsImport(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<J.Identifier>)this.t.name, (JContainer<Expression>)this.t.imports, this.t.from, this.t.target, initializer);
            }

            @Generated
            public Padding(JsImport t) {
                this.t = t;
            }
        }
    }

    public static class FunctionType
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Statement> parameters;
        private final Space arrow;
        private final Expression returnType;
        private final @Nullable JavaType type;

        public List<Statement> getParameters() {
            return this.parameters.getElements();
        }

        public FunctionType withParameters(List<Statement> parameters) {
            return this.getPadding().withParameters((JContainer<Statement>)JContainer.withElements(this.parameters, parameters));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitFunctionType(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionType)) {
                return false;
            }
            FunctionType other = (FunctionType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public FunctionType(UUID id, Space prefix, Markers markers, JContainer<Statement> parameters, Space arrow, Expression returnType, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.parameters = parameters;
            this.arrow = arrow;
            this.returnType = returnType;
            this.type = type;
        }

        @Generated
        private FunctionType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Statement> parameters, Space arrow, Expression returnType, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.parameters = parameters;
            this.arrow = arrow;
            this.returnType = returnType;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public FunctionType withId(UUID id) {
            return this.id == id ? this : new FunctionType(this.padding, id, this.prefix, this.markers, this.parameters, this.arrow, this.returnType, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public FunctionType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FunctionType(this.padding, this.id, prefix, this.markers, this.parameters, this.arrow, this.returnType, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public FunctionType withMarkers(Markers markers) {
            return this.markers == markers ? this : new FunctionType(this.padding, this.id, this.prefix, markers, this.parameters, this.arrow, this.returnType, this.type);
        }

        @Generated
        public Space getArrow() {
            return this.arrow;
        }

        @Generated
        public FunctionType withArrow(Space arrow) {
            return this.arrow == arrow ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, this.parameters, arrow, this.returnType, this.type);
        }

        @Generated
        public Expression getReturnType() {
            return this.returnType;
        }

        @Generated
        public FunctionType withReturnType(Expression returnType) {
            return this.returnType == returnType ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, this.parameters, this.arrow, returnType, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public FunctionType withType(@Nullable JavaType type) {
            return this.type == type ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, this.parameters, this.arrow, this.returnType, type);
        }

        public static class Padding {
            private final FunctionType t;

            public JContainer<Statement> getParameters() {
                return this.t.parameters;
            }

            public FunctionType withParameters(JContainer<Statement> parameters) {
                return this.t.parameters == parameters ? this.t : new FunctionType(this.t.id, this.t.prefix, this.t.markers, parameters, this.t.arrow, this.t.returnType, this.t.type);
            }

            @Generated
            public Padding(FunctionType t) {
                this.t = t;
            }
        }
    }

    public static final class ExpressionStatement
    implements JS,
    Expression,
    Statement {
        private final UUID id;
        private final Expression expression;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getExpression(), p);
            if (j instanceof ExpressionStatement) {
                return j;
            }
            if (j instanceof Expression) {
                return this.withExpression((Expression)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withExpression((Expression)this.expression.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withExpression((Expression)this.expression.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        public @Nullable JavaType getType() {
            return this.expression.getType();
        }

        public ExpressionStatement withType(@Nullable JavaType type) {
            return this.withExpression((Expression)this.expression.withType(type));
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ExpressionStatement;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public ExpressionStatement(UUID id, Expression expression) {
            this.id = id;
            this.expression = expression;
        }

        @Generated
        public ExpressionStatement withId(UUID id) {
            return this.id == id ? this : new ExpressionStatement(id, this.expression);
        }

        @Generated
        public ExpressionStatement withExpression(Expression expression) {
            return this.expression == expression ? this : new ExpressionStatement(this.id, expression);
        }
    }

    public static class Export
    implements JS,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable JContainer<Expression> exports;
        private final @Nullable Space from;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal target;
        private final @Nullable JLeftPadded<Expression> initializer;

        public @Nullable List<Expression> getExports() {
            return this.exports == null ? null : this.exports.getElements();
        }

        public Export withExports(List<Expression> exports) {
            return this.getPadding().withExports((JContainer<Expression>)JContainer.withElementsNullable(this.exports, exports));
        }

        public @Nullable Expression getInitializer() {
            return this.initializer == null ? null : (Expression)this.initializer.getElement();
        }

        public Export withInitializer(@Nullable Expression initializer) {
            return this.getPadding().withInitializer((JLeftPadded<Expression>)JLeftPadded.withElement(this.initializer, (Object)initializer));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitExport(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Export)) {
                return false;
            }
            Export other = (Export)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Export;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Export(UUID id, Space prefix, Markers markers, @Nullable JContainer<Expression> exports, @Nullable Space from, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal target, @Nullable JLeftPadded<Expression> initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.exports = exports;
            this.from = from;
            this.target = target;
            this.initializer = initializer;
        }

        @Generated
        private Export(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JContainer<Expression> exports, @Nullable Space from, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal target, @Nullable JLeftPadded<Expression> initializer) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.exports = exports;
            this.from = from;
            this.target = target;
            this.initializer = initializer;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Export withId(UUID id) {
            return this.id == id ? this : new Export(this.padding, id, this.prefix, this.markers, this.exports, this.from, this.target, this.initializer);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Export withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Export(this.padding, this.id, prefix, this.markers, this.exports, this.from, this.target, this.initializer);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Export withMarkers(Markers markers) {
            return this.markers == markers ? this : new Export(this.padding, this.id, this.prefix, markers, this.exports, this.from, this.target, this.initializer);
        }

        @Generated
        public @Nullable Space getFrom() {
            return this.from;
        }

        @Generated
        public Export withFrom(@Nullable Space from) {
            return this.from == from ? this : new Export(this.padding, this.id, this.prefix, this.markers, this.exports, from, this.target, this.initializer);
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal getTarget() {
            return this.target;
        }

        @Generated
        public Export withTarget(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal target) {
            return this.target == target ? this : new Export(this.padding, this.id, this.prefix, this.markers, this.exports, this.from, target, this.initializer);
        }

        public static class Padding {
            private final Export t;

            public @Nullable JContainer<Expression> getExports() {
                return this.t.exports;
            }

            public Export withExports(@Nullable JContainer<Expression> exports) {
                return this.t.exports == exports ? this.t : new Export(this.t.id, this.t.prefix, this.t.markers, exports, this.t.from, this.t.target, (JLeftPadded<Expression>)this.t.initializer);
            }

            public @Nullable JLeftPadded<Expression> getInitializer() {
                return this.t.initializer;
            }

            public Export withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new Export(this.t.id, this.t.prefix, this.t.markers, (JContainer<Expression>)this.t.exports, this.t.from, this.t.target, initializer);
            }

            @Generated
            public Padding(Export t) {
                this.t = t;
            }
        }
    }

    public static final class Delete
    implements JS,
    Expression,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitDelete(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Delete)) {
                return false;
            }
            Delete other = (Delete)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Delete(UUID id, Space prefix, Markers markers, Expression expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "JS.Delete(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ", type=" + this.getType() + ")";
        }

        @Generated
        public Delete withId(UUID id) {
            return this.id == id ? this : new Delete(id, this.prefix, this.markers, this.expression, this.type);
        }

        @Generated
        public Delete withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Delete(this.id, prefix, this.markers, this.expression, this.type);
        }

        @Generated
        public Delete withMarkers(Markers markers) {
            return this.markers == markers ? this : new Delete(this.id, this.prefix, markers, this.expression, this.type);
        }

        @Generated
        public Delete withExpression(Expression expression) {
            return this.expression == expression ? this : new Delete(this.id, this.prefix, this.markers, expression, this.type);
        }

        @Generated
        public Delete withType(@Nullable JavaType type) {
            return this.type == type ? this : new Delete(this.id, this.prefix, this.markers, this.expression, type);
        }
    }

    public static final class DefaultType
    implements JS,
    Expression,
    TypedTree,
    NameTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final Space beforeEquals;
        private final Expression right;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitDefaultType(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultType)) {
                return false;
            }
            DefaultType other = (DefaultType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public DefaultType(UUID id, Space prefix, Markers markers, Expression left, Space beforeEquals, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.beforeEquals = beforeEquals;
            this.right = right;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getLeft() {
            return this.left;
        }

        @Generated
        public Space getBeforeEquals() {
            return this.beforeEquals;
        }

        @Generated
        public Expression getRight() {
            return this.right;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "JS.DefaultType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", beforeEquals=" + this.getBeforeEquals() + ", right=" + this.getRight() + ", type=" + this.getType() + ")";
        }

        @Generated
        public DefaultType withId(UUID id) {
            return this.id == id ? this : new DefaultType(id, this.prefix, this.markers, this.left, this.beforeEquals, this.right, this.type);
        }

        @Generated
        public DefaultType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DefaultType(this.id, prefix, this.markers, this.left, this.beforeEquals, this.right, this.type);
        }

        @Generated
        public DefaultType withMarkers(Markers markers) {
            return this.markers == markers ? this : new DefaultType(this.id, this.prefix, markers, this.left, this.beforeEquals, this.right, this.type);
        }

        @Generated
        public DefaultType withLeft(Expression left) {
            return this.left == left ? this : new DefaultType(this.id, this.prefix, this.markers, left, this.beforeEquals, this.right, this.type);
        }

        @Generated
        public DefaultType withBeforeEquals(Space beforeEquals) {
            return this.beforeEquals == beforeEquals ? this : new DefaultType(this.id, this.prefix, this.markers, this.left, beforeEquals, this.right, this.type);
        }

        @Generated
        public DefaultType withRight(Expression right) {
            return this.right == right ? this : new DefaultType(this.id, this.prefix, this.markers, this.left, this.beforeEquals, right, this.type);
        }

        @Generated
        public DefaultType withType(@Nullable JavaType type) {
            return this.type == type ? this : new DefaultType(this.id, this.prefix, this.markers, this.left, this.beforeEquals, this.right, type);
        }
    }

    public static final class ArrowFunction
    implements JS,
    Statement,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Annotation> leadingAnnotations;
        private final List<J.Modifier> modifiers;
        private final J.Lambda.Parameters parameters;
        private final @Nullable TypeTree returnTypeExpression;
        private final Space arrow;
        private final J body;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitArrowFunction(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrowFunction)) {
                return false;
            }
            ArrowFunction other = (ArrowFunction)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ArrowFunction(UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, J.Lambda.Parameters parameters, @Nullable TypeTree returnTypeExpression, Space arrow, J body, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.parameters = parameters;
            this.returnTypeExpression = returnTypeExpression;
            this.arrow = arrow;
            this.body = body;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<J.Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @Generated
        public J.Lambda.Parameters getParameters() {
            return this.parameters;
        }

        @Generated
        public Space getArrow() {
            return this.arrow;
        }

        @Generated
        public J getBody() {
            return this.body;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "JS.ArrowFunction(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", leadingAnnotations=" + this.getLeadingAnnotations() + ", modifiers=" + this.getModifiers() + ", parameters=" + this.getParameters() + ", returnTypeExpression=" + this.getReturnTypeExpression() + ", arrow=" + this.getArrow() + ", body=" + this.getBody() + ", type=" + this.getType() + ")";
        }

        @Generated
        public ArrowFunction withId(UUID id) {
            return this.id == id ? this : new ArrowFunction(id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.parameters, this.returnTypeExpression, this.arrow, this.body, this.type);
        }

        @Generated
        public ArrowFunction withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrowFunction(this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.parameters, this.returnTypeExpression, this.arrow, this.body, this.type);
        }

        @Generated
        public ArrowFunction withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrowFunction(this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.parameters, this.returnTypeExpression, this.arrow, this.body, this.type);
        }

        @Generated
        public ArrowFunction withLeadingAnnotations(List<J.Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new ArrowFunction(this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.parameters, this.returnTypeExpression, this.arrow, this.body, this.type);
        }

        @Generated
        public ArrowFunction withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.parameters, this.returnTypeExpression, this.arrow, this.body, this.type);
        }

        @Generated
        public ArrowFunction withParameters(J.Lambda.Parameters parameters) {
            return this.parameters == parameters ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, parameters, this.returnTypeExpression, this.arrow, this.body, this.type);
        }

        @Generated
        public ArrowFunction withReturnTypeExpression(@Nullable TypeTree returnTypeExpression) {
            return this.returnTypeExpression == returnTypeExpression ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.parameters, returnTypeExpression, this.arrow, this.body, this.type);
        }

        @Generated
        public @Nullable TypeTree getReturnTypeExpression() {
            return this.returnTypeExpression;
        }

        @Generated
        public ArrowFunction withArrow(Space arrow) {
            return this.arrow == arrow ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.parameters, this.returnTypeExpression, arrow, this.body, this.type);
        }

        @Generated
        public ArrowFunction withBody(J body) {
            return this.body == body ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.parameters, this.returnTypeExpression, this.arrow, body, this.type);
        }

        @Generated
        public ArrowFunction withType(@Nullable JavaType type) {
            return this.type == type ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.parameters, this.returnTypeExpression, this.arrow, this.body, type);
        }
    }

    public static final class Alias
    implements JS,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J.Identifier> propertyName;
        private final J.Identifier alias;

        public J.Identifier getPropertyName() {
            return (J.Identifier)this.propertyName.getElement();
        }

        public Alias withPropertyName(J.Identifier propertyName) {
            return this.getPadding().withPropertyName((JRightPadded<J.Identifier>)this.propertyName.withElement((Object)propertyName));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitAlias(this, p);
        }

        public @Nullable JavaType getType() {
            return ((J.Identifier)this.propertyName.getElement()).getType();
        }

        public Alias withType(@Nullable JavaType type) {
            return this.withPropertyName(((J.Identifier)this.propertyName.getElement()).withType(type));
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alias)) {
                return false;
            }
            Alias other = (Alias)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Alias(UUID id, Space prefix, Markers markers, JRightPadded<J.Identifier> propertyName, J.Identifier alias) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.propertyName = propertyName;
            this.alias = alias;
        }

        @Generated
        private Alias(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<J.Identifier> propertyName, J.Identifier alias) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.propertyName = propertyName;
            this.alias = alias;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public J.Identifier getAlias() {
            return this.alias;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "JS.Alias(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", propertyName=" + this.getPropertyName() + ", alias=" + this.getAlias() + ")";
        }

        @Generated
        public Alias withId(UUID id) {
            return this.id == id ? this : new Alias(this.padding, id, this.prefix, this.markers, this.propertyName, this.alias);
        }

        @Generated
        public Alias withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Alias(this.padding, this.id, prefix, this.markers, this.propertyName, this.alias);
        }

        @Generated
        public Alias withMarkers(Markers markers) {
            return this.markers == markers ? this : new Alias(this.padding, this.id, this.prefix, markers, this.propertyName, this.alias);
        }

        @Generated
        public Alias withAlias(J.Identifier alias) {
            return this.alias == alias ? this : new Alias(this.padding, this.id, this.prefix, this.markers, this.propertyName, alias);
        }

        public static class Padding {
            private final Alias t;

            public JRightPadded<J.Identifier> getPropertyName() {
                return this.t.propertyName;
            }

            public Alias withPropertyName(JRightPadded<J.Identifier> propertyName) {
                return this.t.propertyName == propertyName ? this.t : new Alias(this.t.id, this.t.prefix, this.t.markers, propertyName, this.t.alias);
            }

            @Generated
            public Padding(Alias t) {
                this.t = t;
            }
        }
    }

    public static final class CompilationUnit
    implements JS,
    JavaSourceFile,
    SourceFile {
        private transient @Nullable SoftReference<TypesInUse> typesInUse;
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        private final @Nullable FileAttributes fileAttributes;
        private final @Nullable String charsetName;
        private final boolean charsetBomMarked;
        private final @Nullable Checksum checksum;
        private final List<JRightPadded<J.Import>> imports;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public List<J.Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.imports, imports));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Transient
        @NonNull
        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        @NonNull
        public JavaSourceFile withClasses(List<J.ClassDeclaration> classes) {
            return this;
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new JavaScriptPrinter();
        }

        @Transient
        @NonNull
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Package getPackageDeclaration() {
            return null;
        }

        public JavaSourceFile withPackageDeclaration(J.Package pkg) {
            throw new IllegalStateException("JavaScript does not support package declarations");
        }

        public <S, T extends S> T service(Class<S> service) {
            String serviceName = service.getName();
            try {
                Class<Object> serviceClass;
                if (JavaScriptImportService.class.getName().equals(serviceName)) {
                    serviceClass = service;
                } else if (ImportService.class.getName().equals(serviceName)) {
                    serviceClass = service.getClassLoader().loadClass(JavaScriptImportService.class.getName());
                } else {
                    return (T)super.service(service);
                }
                return (T)serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public String toString() {
            return "JS.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", imports=" + this.getImports() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        @Generated
        private CompilationUnit(@Nullable SoftReference<TypesInUse> typesInUse, @Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        @Generated
        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public CompilationUnit withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public @Nullable FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Generated
        private CompilationUnit withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @Generated
        public CompilationUnit withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public @Nullable Checksum getChecksum() {
            return this.checksum;
        }

        @Generated
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, eof);
        }

        @Generated
        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            public List<JRightPadded<J.Import>> getImports() {
                return this.t.imports;
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, imports, this.t.statements, this.t.eof);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.imports, statements, this.t.eof);
            }

            @Generated
            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }
}

