/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.IV8Value;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.javascript.internal.JavetUtils;

public abstract class TSCV8ValueHolder
implements AutoCloseable {
    private final List<IV8Value> v8Values = new ArrayList<IV8Value>();
    private final List<AutoCloseable> otherValues = new ArrayList<AutoCloseable>();
    private boolean isClosed = false;

    protected <T extends AutoCloseable> T lifecycleLinked(T value) {
        if (this.isClosed) {
            throw new IllegalStateException("attempt to add value when already closed");
        }
        if (value instanceof V8ValuePrimitive || value instanceof V8ValueUndefined || value instanceof V8ValueNull) {
            return value;
        }
        if (value instanceof IV8Value) {
            try {
                value = ((IV8Value)value).toClone();
            }
            catch (JavetException e) {
                throw new RuntimeException(e);
            }
            this.v8Values.add((IV8Value)value);
        } else {
            this.otherValues.add((AutoCloseable)value);
        }
        return value;
    }

    @Override
    public final void close() {
        if (this.isClosed) {
            throw new IllegalStateException("already closed");
        }
        this.isClosed = true;
        for (IV8Value valueV8 : this.v8Values) {
            JavetUtils.close(valueV8);
        }
        for (AutoCloseable value : this.otherValues) {
            try {
                value.close();
            }
            catch (Exception e) {
                System.err.println("Exception while attempting to close a " + value.getClass().getName());
                e.printStackTrace();
            }
        }
    }
}

