/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.DebugOnly;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.javascript.internal.tsc.TSCIndexInfo;
import org.openrewrite.javascript.internal.tsc.TSCInternal;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCSignature;
import org.openrewrite.javascript.internal.tsc.TSCSymbol;
import org.openrewrite.javascript.internal.tsc.TSCType;
import org.openrewrite.javascript.internal.tsc.TSCV8Backed;
import org.openrewrite.javascript.internal.tsc.generated.TSCObjectFlag;
import org.openrewrite.javascript.internal.tsc.generated.TSCTypeFlag;

public interface TSCTypeAccessors
extends TSCV8Backed {
    public TSCType _typeInstanceInternal();

    default public String typeToString() {
        return this.getTypeChecker().typeToString(this._typeInstanceInternal());
    }

    @Override
    default public TSCType.DebugInfo getDebugInfo() {
        return new TSCType.DebugInfo(this.listMatchingTypeFlags(), this.listMatchingObjectFlags(), this.getAllPropertiesForDebugging(), this.listMatchingTypeInterfaces());
    }

    default public long getTypeId() {
        return this.getLongProperty("id");
    }

    default public TSCSymbol getSymbolForType() {
        return this.getSymbolProperty("symbol");
    }

    default public int getTypeFlags() {
        return this.getIntProperty("flags");
    }

    default public boolean hasTypeFlag(TSCTypeFlag flag) {
        return flag.matches(this.getTypeFlags());
    }

    default public boolean hasExactTypeFlag(TSCTypeFlag flag) {
        return flag.code == this.getTypeFlags();
    }

    default public TSCTypeFlag getExactTypeFlag() {
        return TSCTypeFlag.fromMaskExact(this.getTypeFlags());
    }

    @DebugOnly
    default public List<TSCTypeFlag> listMatchingTypeFlags() {
        int typeFlags = this.getTypeFlags();
        ArrayList<TSCTypeFlag> result = new ArrayList<TSCTypeFlag>();
        for (TSCTypeFlag flag : TSCTypeFlag.values()) {
            if (!flag.matches(typeFlags)) continue;
            result.add(flag);
        }
        return result;
    }

    default public int getObjectFlags() {
        if (!this.hasTypeFlag(TSCTypeFlag.ObjectFlagsType)) {
            return 0;
        }
        return this.getIntProperty("objectFlags");
    }

    default public boolean hasObjectFlag(TSCObjectFlag flag) {
        return flag.matches(this.getObjectFlags());
    }

    @DebugOnly
    default public List<TSCObjectFlag> listMatchingObjectFlags() {
        int objectFlags = this.getObjectFlags();
        ArrayList<TSCObjectFlag> result = new ArrayList<TSCObjectFlag>();
        for (TSCObjectFlag flag : TSCObjectFlag.values()) {
            if (!flag.matches(objectFlags)) continue;
            result.add(flag);
        }
        return result;
    }

    default public List<TSCSymbol> getTypeProperties() {
        return this.getSymbolListProperty("getProperties()");
    }

    @Nullable
    default public TSCType getConstraint() {
        return this.getOptionalTypeProperty("getConstraint()");
    }

    @Nullable
    default public TSCType getDefault() {
        return this.getOptionalTypeProperty("getDefault()");
    }

    @Nullable
    default public InterfaceType asInterfaceType() {
        if (this.hasObjectFlag(TSCObjectFlag.Interface) || this.hasObjectFlag(TSCObjectFlag.Class)) {
            return new InterfaceType.Impl(this._typeInstanceInternal());
        }
        return null;
    }

    default public InterfaceType assertInterfaceType() {
        return Objects.requireNonNull(this.asInterfaceType());
    }

    @Nullable
    default public UnionOrIntersectionType asUnionOrIntersectionType() {
        if (this.hasTypeFlag(TSCTypeFlag.UnionOrIntersection)) {
            return new UnionOrIntersectionType.Impl(this._typeInstanceInternal());
        }
        return null;
    }

    default public UnionOrIntersectionType assertUnionOrIntersectionType() {
        return Objects.requireNonNull(this.asUnionOrIntersectionType());
    }

    @Nullable
    default public ObjectType asObjectType() {
        if (this.hasTypeFlag(TSCTypeFlag.Object)) {
            return new ObjectType.Impl(this._typeInstanceInternal());
        }
        return null;
    }

    default public ObjectType assertObjectType() {
        return Objects.requireNonNull(this.asObjectType());
    }

    @Nullable
    default public TypeReference asTypeReference() {
        if (this.hasObjectFlag(TSCObjectFlag.Reference)) {
            return new TypeReference.Impl(this._typeInstanceInternal());
        }
        return null;
    }

    default public TypeReference assertTypeReference() {
        return Objects.requireNonNull(this.asTypeReference());
    }

    @DebugOnly
    default public List<TSCTypeAccessors> listMatchingTypeInterfaces() {
        TSCTypeAccessors[] allAccessors = new TSCTypeAccessors[]{this.asInterfaceType(), this.asTypeReference(), this.asObjectType(), this.asUnionOrIntersectionType()};
        return Stream.of(allAccessors).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static interface InterfaceType
    extends TypeWrapper,
    ObjectType {
        @Nullable
        default public List<TSCType> getTypeParameters() {
            return this.wrapped().getOptionalTypeListProperty("typeParameters");
        }

        @Nullable
        default public List<TSCType> getOuterTypeParameters() {
            return this.wrapped().getOptionalTypeListProperty("outerTypeParameters");
        }

        @Nullable
        default public List<TSCType> getLocalTypeParameters() {
            return this.wrapped().getOptionalTypeListProperty("localTypeParameters");
        }

        @Nullable
        default public TSCType getThisType() {
            return this.wrapped().getOptionalTypeProperty("thisType");
        }

        @Nullable
        @TSCInternal
        default public TSCType getResolvedBaseConstructorType() {
            return this.wrapped().getOptionalTypeProperty("resolvedBaseConstructorType");
        }

        @TSCInternal
        default public List<TSCType> getResolvedBaseTypes() {
            return this.wrapped().getTypeListProperty("resolvedBaseTypes");
        }

        @TSCInternal
        default public boolean getBaseTypesResolved() {
            return this.wrapped().getBooleanProperty("baseTypesResolved");
        }

        public static class Impl
        extends TypeWrapper.Impl
        implements InterfaceType {
            public Impl(TSCType wrapped) {
                super(wrapped);
            }
        }
    }

    public static interface UnionOrIntersectionType
    extends TypeWrapper {
        default public List<TSCType> getTypes() {
            return this.wrapped().getTypeListProperty("types");
        }

        public static class Impl
        extends TypeWrapper.Impl
        implements UnionOrIntersectionType {
            public Impl(TSCType wrapped) {
                super(wrapped);
            }
        }
    }

    public static interface ObjectType
    extends TypeWrapper {
        @Nullable
        @TSCInternal
        default public List<TSCSymbol> getProperties() {
            return this.getOptionalSymbolListProperty("properties");
        }

        @Nullable
        @TSCInternal
        default public List<TSCSignature> getCallSignatures() {
            return this.getOptionalSignatureListProperty("callSignatures");
        }

        @Nullable
        @TSCInternal
        default public List<TSCSignature> getConstructSignatures() {
            return this.getOptionalSignatureListProperty("constructSignatures");
        }

        @Nullable
        @TSCInternal
        default public List<TSCIndexInfo> getIndexInfos() {
            return this.getOptionalIndexInfoListProperty("indexInfos");
        }

        @Nullable
        @TSCInternal
        default public ObjectType getObjectTypeWithoutAbstractConstructSignatures() {
            TSCType resultType = this.getOptionalTypeProperty("objectTypeWithoutAbstractConstructSignatures");
            return resultType == null ? null : resultType.asObjectType();
        }

        public static class Impl
        extends TypeWrapper.Impl
        implements ObjectType {
            public Impl(TSCType wrapped) {
                super(wrapped);
            }
        }
    }

    public static interface TypeReference
    extends TypeWrapper,
    ObjectType {
        default public TSCType getTarget() {
            return this.getTypeProperty("target");
        }

        @Nullable
        default public TSCNode.TypeNode getNode() {
            return this.getOptionalTypeNodeProperty("node");
        }

        default public List<TSCType> getTypeArguments() {
            return this.getTypeChecker().getTypeArguments(this._typeInstanceInternal());
        }

        public static class Impl
        extends TypeWrapper.Impl
        implements TypeReference {
            public Impl(TSCType wrapped) {
                super(wrapped);
            }
        }
    }

    public static interface TypeWrapper
    extends TSCV8Backed.Wrapper,
    TSCTypeAccessors {
        @Override
        default public TSCType wrapped() {
            return this._typeInstanceInternal();
        }

        public static abstract class Impl
        implements TypeWrapper {
            private final TSCType wrapped;

            public Impl(TSCType wrapped) {
                this.wrapped = wrapped;
            }

            @Override
            public TSCType _typeInstanceInternal() {
                return this.wrapped;
            }

            public String toString() {
                String interfaceName = "???";
                Class<?> enclosing = this.getClass().getEnclosingClass();
                if (enclosing != null) {
                    interfaceName = enclosing.getSimpleName();
                }
                return "Type[as " + interfaceName + "]#" + this.getTypeId() + "(" + this.typeToString() + ")";
            }
        }
    }
}

