/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeSignatureBuilder;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCNodeList;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCSymbol;
import org.openrewrite.javascript.internal.tsc.TSCType;
import org.openrewrite.javascript.internal.tsc.generated.TSCObjectFlag;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;
import org.openrewrite.javascript.internal.tsc.generated.TSCTypeFlag;
import org.openrewrite.javascript.tree.TsType;

@Incubating(since="0.0")
public class TypeScriptSignatureBuilder
implements JavaTypeSignatureBuilder {
    @Nullable
    Set<String> typeVariableNameStack;
    Map<TSCNode, String> signatures = new IdentityHashMap<TSCNode, String>();

    public String signature(@Nullable Object object) {
        if (object == null) {
            return "{undefined}";
        }
        TSCNode node = (TSCNode)object;
        String cached = this.signatures.get(node);
        if (cached != null) {
            return cached;
        }
        switch (node.syntaxKind()) {
            case SourceFile: {
                cached = TypeScriptSignatureBuilder.mapSourceFileFqn((TSCNode.SourceFile)node);
                break;
            }
            case ClassDeclaration: 
            case EnumDeclaration: 
            case InterfaceDeclaration: {
                TSCNodeList typeParameters = node.getOptionalNodeListProperty("typeParameters");
                return typeParameters != null && !typeParameters.isEmpty() ? this.parameterizedSignature(node) : this.classSignature(node);
            }
            case ArrayType: {
                cached = this.arraySignature(node);
                break;
            }
            case EnumMember: {
                return this.mapEnumMember(node);
            }
            case Identifier: {
                return this.mapIdentifier(node);
            }
            case Parameter: {
                return this.mapParameter(node);
            }
            case QualifiedName: {
                return this.mapQualifiedName(node);
            }
            case ThisKeyword: {
                return this.mapThis(node);
            }
            case TypeOperator: {
                return this.mapTypeOperator(node);
            }
            case TypeParameter: {
                cached = this.genericSignature(node);
                break;
            }
            case ExpressionWithTypeArguments: 
            case TypeReference: 
            case TypeQuery: {
                return this.mapTypeReference(node);
            }
            case UnionType: {
                return TsType.Union.getFullyQualifiedName();
            }
            case PropertyDeclaration: 
            case VariableDeclaration: {
                cached = this.variableSignature(node);
            }
        }
        if (cached != null) {
            this.signatures.put(node, cached);
            return cached;
        }
        TSCType type = node.getTypeChecker().getTypeAtLocation(node);
        return this.mapType(type);
    }

    public String arraySignature(Object object) {
        TSCNode node = (TSCNode)object;
        TSCNode elementType = node.getNodeProperty("elementType");
        return this.signature(elementType) + this.trimWhitespace(node.getText().substring(elementType.getText().length()));
    }

    public String classSignature(Object object) {
        TSCNode node = (TSCNode)object;
        if (node.syntaxKind() == TSCSyntaxKind.SourceFile) {
            return TypeScriptSignatureBuilder.mapSourceFileFqn((TSCNode.SourceFile)node);
        }
        return TypeScriptSignatureBuilder.mapFqn(node);
    }

    public String genericSignature(Object object) {
        String boundSigStr;
        String name;
        TSCNode node = (TSCNode)object;
        if (this.typeVariableNameStack == null) {
            this.typeVariableNameStack = new HashSet<String>();
        }
        if (!this.typeVariableNameStack.add(name = node.getNodeProperty("name").getText())) {
            return "Generic{" + name + "}";
        }
        StringBuilder s = new StringBuilder("Generic{").append(name);
        StringJoiner boundSigs = new StringJoiner(" & ");
        TSCNode constraint = node.getOptionalNodeProperty("constraint");
        if (constraint != null) {
            if (constraint.syntaxKind() == TSCSyntaxKind.IntersectionType) {
                for (TSCNode type : constraint.getNodeListProperty("types")) {
                    boundSigs.add(this.signature(type));
                }
            } else {
                boundSigs.add(this.signature(constraint));
            }
        }
        if (!(boundSigStr = boundSigs.toString()).isEmpty()) {
            s.append(" extends ").append(boundSigStr);
        }
        this.typeVariableNameStack.remove(name);
        s.append("}");
        return s.toString();
    }

    public String methodSignature(Object object) {
        TSCNode node = (TSCNode)object;
        String s = this.classSignature(this.getOwner(node));
        boolean isConstructor = node.syntaxKind() == TSCSyntaxKind.Constructor || node.syntaxKind() == TSCSyntaxKind.ConstructSignature || node.syntaxKind() == TSCSyntaxKind.NewExpression;
        TSCNode type = node.getOptionalNodeProperty("type");
        String returnType = type != null ? this.signature(type) : "void";
        if (isConstructor) {
            s = s + "{name=<constructor>,return=" + s;
        } else {
            TSCNode name = node.getOptionalNodeProperty("name");
            s = s + "{name=" + (name == null ? "" : name.getText()) + ",return=" + returnType;
        }
        return s + ",parameters=" + this.methodArgumentSignature(node) + "}";
    }

    public String parameterizedSignature(Object object) {
        TSCNode node = (TSCNode)object;
        StringBuilder s = new StringBuilder(this.classSignature(node));
        StringJoiner joiner = new StringJoiner(", ", "<", ">");
        for (TSCNode param : node.getNodeListProperty("typeParameters")) {
            joiner.add(this.signature(param));
        }
        s.append(joiner);
        return s.toString();
    }

    public String primitiveSignature(Object object) {
        TSCNode node = (TSCNode)object;
        switch (node.syntaxKind()) {
            case BooleanKeyword: {
                return JavaType.Primitive.Boolean.getKeyword();
            }
            case NumberKeyword: {
                return "number";
            }
            case StringKeyword: {
                return JavaType.Primitive.String.getKeyword();
            }
            case VoidKeyword: {
                return JavaType.Primitive.Void.getKeyword();
            }
        }
        throw new IllegalArgumentException("Unexpected primitive type " + object);
    }

    private String methodArgumentSignature(TSCNode node) {
        TSCNodeList parameters = node.getOptionalNodeListProperty("parameters");
        if (parameters != null) {
            StringJoiner genericArgumentTypes = new StringJoiner(",", "[", "]");
            for (TSCNode parameter : parameters) {
                genericArgumentTypes.add(this.signature(parameter));
            }
            return genericArgumentTypes.toString();
        }
        return "[]";
    }

    public String variableSignature(TSCNode node) {
        String owner = this.signature(this.getOwner(node));
        if (owner == null) {
            return null;
        }
        if (owner.contains("<")) {
            owner = owner.substring(0, owner.indexOf(60));
        }
        String name = node.getNodeProperty("name").getText();
        TSCNode type = node.getOptionalNodeProperty("type");
        String typeSig = type != null ? this.signature(type) : (node.syntaxKind() == TSCSyntaxKind.EnumMember ? owner : this.resolveNode(node));
        return owner + "{name=" + name + ",type=" + typeSig + '}';
    }

    private String resolveNode(TSCNode node) {
        TSCNode type = node.getOptionalNodeProperty("type");
        if (type != null) {
            return this.signature(type);
        }
        TSCSymbol symbol = node.getTypeChecker().getTypeAtLocation(node).getOptionalSymbolProperty("symbol");
        if (symbol != null) {
            try {
                return this.signature(symbol.getValueDeclaration());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mapType(node.getTypeChecker().getTypeAtLocation(node));
    }

    private static boolean isClassDeclaration(TSCNode node) {
        return node.syntaxKind() == TSCSyntaxKind.ClassDeclaration || node.syntaxKind() == TSCSyntaxKind.InterfaceDeclaration || node.syntaxKind() == TSCSyntaxKind.EnumDeclaration;
    }

    private String mapEnumMember(TSCNode node) {
        return this.signature(node.getParent());
    }

    public static String mapFqn(TSCNode node) {
        String fqn;
        TSCNode parent = node.getParent();
        if (parent == null) {
            return "";
        }
        TSCNode name = node.getOptionalNodeProperty("name");
        String string = fqn = name == null ? "" : node.getNodeProperty("name").getText();
        if (parent.syntaxKind() == TSCSyntaxKind.SourceFile) {
            fqn = TypeScriptSignatureBuilder.mapSourceFileFqn((TSCNode.SourceFile)parent) + "." + fqn;
        } else if (TypeScriptSignatureBuilder.isClassDeclaration(parent) && TypeScriptSignatureBuilder.isClassDeclaration(node)) {
            String prefix = TypeScriptSignatureBuilder.mapFqn(parent);
            fqn = prefix + "$" + fqn;
        } else {
            String prefix = TypeScriptSignatureBuilder.mapFqn(parent);
            fqn = prefix + "." + fqn;
        }
        return fqn;
    }

    private String mapIdentifier(TSCNode node) {
        TSCSymbol symbol = node.getTypeChecker().getTypeAtLocation(node).getOptionalSymbolProperty("symbol");
        if (symbol != null) {
            List<TSCNode> declarations = symbol.getDeclarations();
            if (declarations != null && !declarations.isEmpty()) {
                if (declarations.size() == 1) {
                    return this.signature(declarations.get(0));
                }
                return TsType.MergedInterface.getFullyQualifiedName();
            }
            this.implementMe(node.syntaxKind());
        }
        return this.mapType(node.getTypeChecker().getTypeAtLocation(node));
    }

    private String mapParameter(TSCNode node) {
        return this.resolveNode(node);
    }

    private String mapQualifiedName(TSCNode node) {
        String left = this.signature(node.getNodeProperty("left"));
        int index = left.indexOf(60);
        if (index != -1) {
            left = left.substring(0, index);
        }
        return left + "$" + node.getNodeProperty("right").getText();
    }

    private static String mapSourceFileFqn(TSCNode.SourceFile node) {
        String path = node.getCompilerBridgeSourceInfo().getSourceKind() == TSCProgramContext.CompilerBridgeSourceKind.ApplicationCode ? node.getSourceFile().getPath().replaceFirst("/app", "") : node.getSourceFile().getPath().replaceFirst("/lib", "lib");
        String clean = path.replace("/", ".");
        return clean.startsWith(".") ? clean.substring(1) : clean;
    }

    private String mapThis(TSCNode node) {
        return this.resolveNode(node);
    }

    private String mapType(TSCType type) {
        TSCTypeFlag flag = null;
        try {
            flag = type.getExactTypeFlag();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (flag != null) {
            switch (flag) {
                case Any: {
                    return TsType.Any.getFullyQualifiedName();
                }
                case Boolean: 
                case BooleanLiteral: {
                    return JavaType.Primitive.Boolean.getKeyword();
                }
                case Number: 
                case NumberLiteral: {
                    return TsType.Number.getFullyQualifiedName();
                }
                case Null: {
                    return JavaType.Primitive.Null.getKeyword();
                }
                case Object: {
                    return TsType.Anonymous.getFullyQualifiedName();
                }
                case String: 
                case StringLiteral: {
                    return JavaType.Primitive.String.getKeyword();
                }
                case Undefined: {
                    return TsType.Undefined.getFullyQualifiedName();
                }
                case Union: {
                    return TsType.Union.getFullyQualifiedName();
                }
                case Unit: {
                    return TsType.Unit.getFullyQualifiedName();
                }
                case Unknown: {
                    return TsType.Unknown.getFullyQualifiedName();
                }
                case Void: {
                    return JavaType.Primitive.Void.getKeyword();
                }
                case Enum: {
                    return TsType.Enum.getFullyQualifiedName();
                }
                case EnumLiteral: {
                    return TsType.EnumLiteral.getFullyQualifiedName();
                }
                case BigInt: {
                    return TsType.BigInt.getFullyQualifiedName();
                }
                case BigIntLiteral: {
                    return TsType.BigIntLiteral.getFullyQualifiedName();
                }
                case ESSymbol: {
                    return TsType.ESSymbol.getFullyQualifiedName();
                }
                case UniqueESSymbol: {
                    return TsType.UniqueESSymbol.getFullyQualifiedName();
                }
                case Never: {
                    return TsType.Never.getFullyQualifiedName();
                }
                case TypeParameter: {
                    return TsType.TypeParameter.getFullyQualifiedName();
                }
                case Intersection: {
                    return TsType.Intersection.getFullyQualifiedName();
                }
                case Index: {
                    return TsType.Index.getFullyQualifiedName();
                }
                case IndexedAccess: {
                    return TsType.IndexedAccess.getFullyQualifiedName();
                }
                case Conditional: {
                    return TsType.Conditional.getFullyQualifiedName();
                }
                case Substitution: {
                    return TsType.Substitution.getFullyQualifiedName();
                }
                case NonPrimitive: {
                    return TsType.NonPrimitive.getFullyQualifiedName();
                }
                case TemplateLiteral: {
                    return TsType.TemplateLiteral.getFullyQualifiedName();
                }
                case StringMapping: {
                    return TsType.StringMapping.getFullyQualifiedName();
                }
                case AnyOrUnknown: {
                    return TsType.AnyOrUnknown.getFullyQualifiedName();
                }
                case Nullable: {
                    return TsType.Nullable.getFullyQualifiedName();
                }
                case Literal: {
                    return TsType.Literal.getFullyQualifiedName();
                }
                case Freshable: {
                    return TsType.Freshable.getFullyQualifiedName();
                }
                case StringOrNumberLiteral: {
                    return TsType.StringOrNumberLiteral.getFullyQualifiedName();
                }
                case StringOrNumberLiteralOrUnique: {
                    return TsType.StringOrNumberLiteralOrUnique.getFullyQualifiedName();
                }
                case DefinitelyFalsy: {
                    return TsType.DefinitelyFalsy.getFullyQualifiedName();
                }
                case PossiblyFalsy: {
                    return TsType.PossiblyFalsy.getFullyQualifiedName();
                }
                case Intrinsic: {
                    return TsType.Intrinsic.getFullyQualifiedName();
                }
                case Primitive: {
                    return TsType.Primitive.getFullyQualifiedName();
                }
                case StringLike: {
                    return TsType.StringLike.getFullyQualifiedName();
                }
                case NumberLike: {
                    return TsType.NumberLike.getFullyQualifiedName();
                }
                case BigIntLike: {
                    return TsType.BigIntLike.getFullyQualifiedName();
                }
                case BooleanLike: {
                    return TsType.BooleanLike.getFullyQualifiedName();
                }
                case EnumLike: {
                    return TsType.EnumLike.getFullyQualifiedName();
                }
                case ESSymbolLike: {
                    return TsType.ESSymbolLike.getFullyQualifiedName();
                }
                case VoidLike: {
                    return TsType.VoidLike.getFullyQualifiedName();
                }
                case DefinitelyNonNullable: {
                    return TsType.DefinitelyNonNullable.getFullyQualifiedName();
                }
                case DisjointDomains: {
                    return TsType.DisjointDomains.getFullyQualifiedName();
                }
                case UnionOrIntersection: {
                    return TsType.UnionOrIntersection.getFullyQualifiedName();
                }
                case StructuredType: {
                    return TsType.StructuredType.getFullyQualifiedName();
                }
                case TypeVariable: {
                    return TsType.TypeVariable.getFullyQualifiedName();
                }
                case InstantiableNonPrimitive: {
                    return TsType.InstantiableNonPrimitive.getFullyQualifiedName();
                }
                case InstantiablePrimitive: {
                    return TsType.InstantiablePrimitive.getFullyQualifiedName();
                }
                case Instantiable: {
                    return TsType.Instantiable.getFullyQualifiedName();
                }
                case StructuredOrInstantiable: {
                    return TsType.StructuredOrInstantiable.getFullyQualifiedName();
                }
                case ObjectFlagsType: {
                    return TsType.ObjectFlagsType.getFullyQualifiedName();
                }
                case Simplifiable: {
                    return TsType.Simplifiable.getFullyQualifiedName();
                }
                case Singleton: {
                    return TsType.Singleton.getFullyQualifiedName();
                }
                case Narrowable: {
                    return TsType.Narrowable.getFullyQualifiedName();
                }
                case IncludesMask: {
                    return TsType.IncludesMask.getFullyQualifiedName();
                }
                case NotPrimitiveUnion: {
                    return TsType.NotPrimitiveUnion.getFullyQualifiedName();
                }
            }
            this.implementMe(type);
        } else {
            TSCObjectFlag objectFlag = TSCObjectFlag.fromMaskExact(type.getObjectFlags());
            if (objectFlag == TSCObjectFlag.PrimitiveUnion) {
                return TsType.PrimitiveUnion.getFullyQualifiedName();
            }
            this.implementMe(type);
        }
        throw new UnsupportedOperationException("Cannot map type " + type);
    }

    private String mapTypeOperator(TSCNode node) {
        return this.signature(node.getNodeProperty("type"));
    }

    private String mapTypeReference(TSCNode node) {
        TSCNodeList typeArguments;
        String className = null;
        TSCNode name = node.getOptionalNodeProperty("typeName");
        if (name != null) {
            className = this.signature(name);
        }
        name = node.getOptionalNodeProperty("exprName");
        if (className == null && name != null) {
            className = this.signature(name);
        }
        if (className == null) {
            className = this.signature(node.getNodeProperty("expression"));
        }
        if (className.contains("<") && !className.startsWith("Generic{")) {
            className = className.substring(0, className.indexOf(60));
        }
        if ((typeArguments = node.getOptionalNodeListProperty("typeArguments")) != null) {
            StringJoiner typeArgSigs = new StringJoiner(", ", "<", ">");
            for (TSCNode typeArg : typeArguments) {
                typeArgSigs.add(this.signature(typeArg));
            }
            className = className + typeArgSigs;
        }
        return className;
    }

    private TSCNode getOwner(TSCNode node) {
        TSCNode parent = node.getParent();
        if (parent == null) {
            return node;
        }
        if (parent.syntaxKind() == TSCSyntaxKind.SourceFile || parent.syntaxKind() == TSCSyntaxKind.ClassDeclaration || parent.syntaxKind() == TSCSyntaxKind.EnumDeclaration || parent.syntaxKind() == TSCSyntaxKind.InterfaceDeclaration || parent.syntaxKind() == TSCSyntaxKind.MethodDeclaration) {
            return parent;
        }
        return this.getOwner(node.getParent());
    }

    private String trimWhitespace(String s) {
        return s.replaceAll("\\s+", "");
    }

    private void implementMe(TSCSyntaxKind syntaxKind) {
        throw new UnsupportedOperationException(syntaxKind.name() + " syntaxKind is not supported in TypeScriptSignatureBuilder.");
    }

    private void implementMe(TSCType type) {
        throw new UnsupportedOperationException(type.typeToString() + " type is not supported in TypeScriptSignatureBuilder.");
    }
}

