/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCSourceFileContext;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;

public class TsTreePrinter {
    private static final String TAB = "    ";
    private static final String ELEMENT_PREFIX = "\\---";
    private static final char BRANCH_CONTINUE_CHAR = '|';
    private static final char BRANCH_END_CHAR = '\\';
    private static final int CONTENT_MAX_LENGTH = 200;
    private static final String CONTINUE_PREFIX = "----";
    private static final String UNVISITED_PREFIX = "#";
    private static final boolean printTypes = true;
    private final List<StringBuilder> outputLines = new ArrayList<StringBuilder>();

    protected TsTreePrinter() {
    }

    public static String print(Parser.Input input) {
        return TsTreePrinter.printIndexedSourceCode(input.getSource((ExecutionContext)new InMemoryExecutionContext()).readFully());
    }

    public static String print(Tree tree) {
        return "------------\nJ Tree\n" + TsTreePrinter.printJTree(tree);
    }

    public static String print(TSCNode node, TSCSourceFileContext context, boolean printSpace) {
        return TsTreePrinter.printTSTree(node, context, printSpace);
    }

    public static String printTSTree(TSCNode node, TSCSourceFileContext context, boolean printSpace) {
        TsTreePrinter treePrinter = new TsTreePrinter();
        StringBuilder sb = new StringBuilder();
        sb.append("------------").append("\n");
        sb.append("TS tree").append("\n");
        if (printSpace) {
            treePrinter.printBeforeFirstNode(node, 0, context);
        }
        treePrinter.printTSCNode(node, 1, context, printSpace);
        sb.append(String.join((CharSequence)"\n", treePrinter.outputLines));
        context.resetScanner(0);
        return sb.toString();
    }

    private void printBeforeFirstNode(TSCNode node, int depth, TSCSourceFileContext context) {
        if (node.getStart() == 0) {
            return;
        }
        StringBuilder line = new StringBuilder();
        context.resetScanner(0);
        int stop = node.getStart();
        while (true) {
            TSCSyntaxKind kind = context.nextScannerSyntaxType();
            String text = context.scannerTokenText();
            int start = context.scannerTokenStart();
            int end = context.scannerTokenEnd();
            if (end > stop || kind == TSCSyntaxKind.EndOfFileToken) break;
            StringBuilder subLine = new StringBuilder();
            subLine.append(TsTreePrinter.leftPadding(depth + 1)).append("[").append(start).append(",").append(end).append(")").append(" | ").append("* ").append((Object)kind).append(" | Text : \"").append(TsTreePrinter.truncate(text).replace("\n", "\\n").replace("\r", "\\r")).append("\"");
            this.connectToLatestSibling(depth + 1);
            this.outputLines.add(subLine);
        }
    }

    private void printTSCNode(TSCNode node, int depth, TSCSourceFileContext context, boolean printSpace) {
        StringBuilder line = new StringBuilder();
        line.append(TsTreePrinter.leftPadding(depth)).append(TsTreePrinter.toString(node));
        this.connectToLatestSibling(depth);
        this.outputLines.add(line);
        List<TSCNode> tscNodes = node.getAllChildNodes();
        block0: for (int i = 0; i < tscNodes.size(); ++i) {
            TSCNode childNode = tscNodes.get(i);
            TSCNode nextChildNode = i < tscNodes.size() - 1 ? tscNodes.get(i + 1) : null;
            boolean hasGap = nextChildNode != null && nextChildNode.getStart() > childNode.getEnd();
            this.printTSCNode(childNode, depth + 1, context, printSpace);
            if (!printSpace || !hasGap) continue;
            context.resetScanner(childNode.getEnd());
            int stop = nextChildNode.getStart();
            while (true) {
                TSCSyntaxKind kind = context.nextScannerSyntaxType();
                String text = context.scannerTokenText();
                int start = context.scannerTokenStart();
                int end = context.scannerTokenEnd();
                if (end > stop || kind == TSCSyntaxKind.EndOfFileToken) continue block0;
                StringBuilder subLine = new StringBuilder();
                subLine.append(TsTreePrinter.leftPadding(depth + 1)).append("[").append(start).append(",").append(end).append(")").append(" | ").append("* ").append((Object)kind).append(" | Text : \"").append(TsTreePrinter.truncate(text).replace("\n", "\\n").replace("\r", "\\r")).append("\"");
                this.connectToLatestSibling(depth + 1);
                this.outputLines.add(subLine);
            }
        }
    }

    private static String toString(TSCNode node) {
        return "[" + node.getStart() + "," + node.getEnd() + ") | " + node.syntaxKind().name() + " | Text : \"" + TsTreePrinter.truncate(node.getText()).replace("\n", "\\n").replace("\r", "\\r") + "\"";
    }

    private static String printType(Tree tree) {
        J.Identifier id;
        J.VariableDeclarations.NamedVariable v;
        J.MethodInvocation m;
        JavaType type;
        StringBuilder sb = new StringBuilder();
        if (tree instanceof TypedTree && (type = ((TypedTree)tree).getType()) != null && !(type instanceof JavaType.Unknown)) {
            sb.append(type);
        }
        if (tree instanceof J.MethodInvocation && (m = (J.MethodInvocation)tree).getMethodType() != null) {
            sb.append(" MethodType = ").append(m.getMethodType());
        }
        if (tree instanceof J.MethodDeclaration && (m = (J.MethodDeclaration)tree).getMethodType() != null) {
            sb.append(" MethodType = ").append(m.getMethodType());
        }
        if (tree instanceof J.VariableDeclarations.NamedVariable && (v = (J.VariableDeclarations.NamedVariable)tree).getVariableType() != null) {
            sb.append(" VariableType = ").append(v.getVariableType());
        }
        if (tree instanceof J.Identifier && (id = (J.Identifier)tree).getFieldType() != null) {
            sb.append(" FieldType = ").append(id.getFieldType());
        }
        return sb.toString();
    }

    private static String printTreeElement(Tree tree) {
        if (tree instanceof J.CompilationUnit || tree instanceof J.ClassDeclaration || tree instanceof J.Block || tree instanceof J.Empty || tree instanceof J.Try || tree instanceof J.Try.Catch || tree instanceof J.ForLoop || tree instanceof J.WhileLoop || tree instanceof J.DoWhileLoop || tree instanceof J.Lambda || tree instanceof J.Lambda.Parameters || tree instanceof J.If || tree instanceof J.If.Else || tree instanceof J.EnumValueSet || tree instanceof J.TypeParameter || tree instanceof J.Package || tree instanceof J.ForEachLoop) {
            return "";
        }
        if (tree instanceof J.Literal) {
            String s = ((J.Literal)tree).getValueSource();
            return s != null ? s : "";
        }
        String[] lines = tree.toString().split("\n");
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            output.append(lines[i].trim());
            if (i >= lines.length - 1) continue;
            output.append(" ");
        }
        return output.toString();
    }

    private static String printSpace(Space space) {
        String sb = " whitespace=\"" + space.getWhitespace() + "\" comments=\"" + space.getComments().stream().map(c -> c.printComment(new Cursor(null, (Object)"root"))).collect(Collectors.joining(",")) + "\"";
        return sb.replace("\n", "\\s\n");
    }

    public static String printJTree(Tree tree) {
        TreeVisitingPrinter visitor = new TreeVisitingPrinter(true, true);
        visitor.visit(tree, (ExecutionContext)new InMemoryExecutionContext());
        return visitor.print();
    }

    public static String printIndexedSourceCode(String sourceCode) {
        int count = 0;
        String[] lines = sourceCode.split("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("------------").append("\n");
        sb.append("Source code with index:").append("\n\n");
        ArrayDeque<Integer> digits = new ArrayDeque<Integer>();
        for (String line : lines) {
            StringBuilder spacesSb = new StringBuilder();
            for (int i = 0; i < line.length(); ++i) {
                if (count % 10 == 0) {
                    String numStr = Integer.toString(count);
                    for (int j = 0; j < numStr.length(); ++j) {
                        char c = numStr.charAt(j);
                        int digit = Character.getNumericValue(c);
                        digits.add(digit);
                    }
                }
                if (!digits.isEmpty()) {
                    spacesSb.append(digits.poll());
                } else {
                    spacesSb.append(" ");
                }
                ++count;
            }
            sb.append(line).append("\n").append((CharSequence)spacesSb).append("\n");
            ++count;
        }
        return sb.toString();
    }

    private static String leftPadding(int depth) {
        StringBuilder sb = new StringBuilder();
        int tabCount = depth - 1;
        if (tabCount > 0) {
            sb.append(String.join((CharSequence)"", Collections.nCopies(tabCount, TAB)));
        }
        if (depth > 0) {
            sb.append(ELEMENT_PREFIX);
        }
        return sb.toString();
    }

    private void connectToLatestSibling(int depth) {
        StringBuilder line;
        if (depth <= 1) {
            return;
        }
        int pos = (depth - 1) * TAB.length();
        for (int i = this.outputLines.size() - 1; i > 0 && pos < (line = this.outputLines.get(i)).length(); --i) {
            if (line.charAt(pos) != ' ') {
                if (line.charAt(pos) != '\\') break;
                line.setCharAt(pos, '|');
                break;
            }
            line.setCharAt(pos, '|');
        }
    }

    private static void connectToLatestSibling(int depth, List<StringBuilder> lines) {
        StringBuilder line;
        if (depth <= 1) {
            return;
        }
        int pos = (depth - 1) * TAB.length();
        for (int i = lines.size() - 1; i > 0 && pos < (line = lines.get(i)).length(); --i) {
            if (line.charAt(pos) != ' ') {
                if (line.charAt(pos) != '\\') break;
                line.setCharAt(pos, '|');
                break;
            }
            line.setCharAt(pos, '|');
        }
    }

    private static String truncate(String content) {
        if (content.length() > 200) {
            return content.substring(0, 197) + "...";
        }
        return content;
    }

    static class TreeVisitingPrinter
    extends TreeVisitor<Tree, ExecutionContext> {
        private List<Object> lastCursorStack = new ArrayList<Object>();
        private final List<StringBuilder> outputLines = new ArrayList<StringBuilder>();
        private final boolean skipUnvisitedElement;
        private final boolean printContent;

        public TreeVisitingPrinter(boolean skipUnvisitedElement, boolean printContent) {
            this.skipUnvisitedElement = skipUnvisitedElement;
            this.printContent = printContent;
        }

        public String print() {
            return String.join((CharSequence)"\n", this.outputLines);
        }

        @Nullable
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            String content;
            String typeName;
            if (tree == null) {
                return super.visit((Tree)null, (Object)ctx);
            }
            Cursor cursor = this.getCursor();
            List cursorStack = StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor.getPath(), 0), false).collect(Collectors.toList());
            Collections.reverse(cursorStack);
            int depth = cursorStack.size();
            int diffPos = -1;
            for (int i = 0; i < cursorStack.size(); ++i) {
                if (i < this.lastCursorStack.size() && cursorStack.get(i) == this.lastCursorStack.get(i)) continue;
                diffPos = i;
                break;
            }
            StringBuilder line = new StringBuilder();
            if (diffPos >= 0) {
                for (int i = diffPos; i < cursorStack.size(); ++i) {
                    Object element = cursorStack.get(i);
                    if (this.skipUnvisitedElement) {
                        if (i == diffPos) {
                            line.append(TsTreePrinter.leftPadding(i));
                            TsTreePrinter.connectToLatestSibling(i, this.outputLines);
                            continue;
                        }
                        line.append(TsTreePrinter.CONTINUE_PREFIX);
                        continue;
                    }
                    TsTreePrinter.connectToLatestSibling(i, this.outputLines);
                    StringBuilder newLine = new StringBuilder().append(TsTreePrinter.leftPadding(i)).append(TsTreePrinter.UNVISITED_PREFIX).append(element instanceof String ? element : element.getClass().getSimpleName());
                    if (element instanceof JRightPadded) {
                        JRightPadded rp = (JRightPadded)element;
                        newLine.append(" | ");
                        newLine.append(" after = ").append(TsTreePrinter.printSpace(rp.getAfter()));
                    }
                    if (element instanceof JLeftPadded) {
                        JLeftPadded lp = (JLeftPadded)element;
                        newLine.append(" | ");
                        newLine.append(" before = ").append(TsTreePrinter.printSpace(lp.getBefore()));
                    }
                    this.outputLines.add(newLine);
                }
            }
            String string = typeName = tree instanceof J ? tree.getClass().getCanonicalName().substring(tree.getClass().getPackage().getName().length() + 1) : tree.getClass().getCanonicalName();
            if (this.skipUnvisitedElement) {
                boolean leftPadded;
                boolean bl = leftPadded = diffPos >= 0;
                if (leftPadded) {
                    line.append(TsTreePrinter.CONTINUE_PREFIX);
                } else {
                    TsTreePrinter.connectToLatestSibling(depth, this.outputLines);
                    line.append(TsTreePrinter.leftPadding(depth));
                }
                line.append(typeName);
            } else {
                TsTreePrinter.connectToLatestSibling(depth, this.outputLines);
                line.append(TsTreePrinter.leftPadding(depth)).append(typeName);
            }
            String type = TsTreePrinter.printType(tree);
            if (!type.isEmpty()) {
                line.append(" | TYPE = ").append(type);
            }
            if (this.printContent && !(content = TsTreePrinter.truncate(TsTreePrinter.printTreeElement(tree))).isEmpty()) {
                line.append(" | \"").append(content).append("\"");
            }
            this.outputLines.add(line);
            cursorStack.add(tree);
            this.lastCursorStack = cursorStack;
            return super.visit(tree, (Object)ctx);
        }
    }

    public static class TreePrinterContext {
        List<StringBuilder> lines;
        int depth;

        @Generated
        public TreePrinterContext(List<StringBuilder> lines, int depth) {
            this.lines = lines;
            this.depth = depth;
        }

        @Generated
        public List<StringBuilder> getLines() {
            return this.lines;
        }

        @Generated
        public int getDepth() {
            return this.depth;
        }

        @Generated
        public void setLines(List<StringBuilder> lines) {
            this.lines = lines;
        }

        @Generated
        public void setDepth(int depth) {
            this.depth = depth;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TreePrinterContext)) {
                return false;
            }
            TreePrinterContext other = (TreePrinterContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDepth() != other.getDepth()) {
                return false;
            }
            List<StringBuilder> this$lines = this.getLines();
            List<StringBuilder> other$lines = other.getLines();
            return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TreePrinterContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDepth();
            List<StringBuilder> $lines = this.getLines();
            result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TsTreePrinter.TreePrinterContext(lines=" + this.getLines() + ", depth=" + this.getDepth() + ")";
        }
    }
}

