/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.jspecify.annotations.Nullable;
import org.openrewrite.java.TypeNameMatcher;
import org.openrewrite.java.tree.TypeUtils;

class PatternTypeNameMatcher
implements TypeNameMatcher {
    private final String pattern;
    private final PatternType patternType;

    private PatternTypeNameMatcher(String pattern, @Nullable PatternType explicitType) {
        this.pattern = pattern;
        this.patternType = explicitType != null ? explicitType : ("*".equals(pattern) || "*..*".equals(pattern) ? PatternType.FullWildcard : (!pattern.contains("*") && !pattern.contains("..") ? PatternType.Exact : PatternType.Wildcard));
    }

    static PatternTypeNameMatcher fromPattern(String pattern) {
        return new PatternTypeNameMatcher(pattern, null);
    }

    static PatternTypeNameMatcher fullWildcard(String pattern) {
        return new PatternTypeNameMatcher(pattern, PatternType.FullWildcard);
    }

    static PatternTypeNameMatcher packagePrefix(String pattern) {
        return new PatternTypeNameMatcher(pattern, PatternType.PackagePrefix);
    }

    static PatternTypeNameMatcher wildcard(String pattern) {
        return new PatternTypeNameMatcher(pattern, PatternType.Wildcard);
    }

    boolean isFullWildcard() {
        return this.patternType == PatternType.FullWildcard;
    }

    @Override
    public boolean matches(String text) {
        switch (this.patternType.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return TypeUtils.fullyQualifiedNamesAreEqual(this.pattern, text);
            }
            case 2: {
                int prefixLen = this.pattern.length();
                return text.length() > prefixLen && text.startsWith(this.pattern) && text.charAt(prefixLen) == '.';
            }
        }
        return this.matchesPattern(this.pattern, text, 0, 0);
    }

    @Override
    public boolean matchesSimpleName(String simpleName) {
        int lastDot = this.pattern.lastIndexOf(46);
        if (lastDot > 0 && lastDot < this.pattern.length() - 1) {
            int lastPartStart = lastDot + 1;
            int lastPartLength = this.pattern.length() - lastPartStart;
            if (lastPartLength == 1 && this.pattern.charAt(lastPartStart) == '*') {
                return true;
            }
            boolean hasWildcard = false;
            for (int i = lastPartStart; i < this.pattern.length(); ++i) {
                if (this.pattern.charAt(i) != '*') continue;
                hasWildcard = true;
                break;
            }
            if (!hasWildcard) {
                return simpleName.length() == lastPartLength && this.pattern.regionMatches(lastPartStart, simpleName, 0, lastPartLength);
            }
            return simpleName.matches(this.pattern.substring(lastPartStart).replace("*", ".*"));
        }
        return false;
    }

    private boolean matchesPattern(String pattern, String text, int pIdx, int tIdx) {
        int pLength = pattern.length();
        int tLength = text.length();
        while (pIdx < pLength) {
            char p = pattern.charAt(pIdx);
            if (tIdx >= tLength) {
                while (pIdx < pLength) {
                    if (p == '*') {
                        ++pIdx;
                        continue;
                    }
                    if (p == '.' && pIdx + 1 < pLength && pattern.charAt(pIdx + 1) == '.') {
                        pIdx += 2;
                        continue;
                    }
                    return false;
                }
                return true;
            }
            if (p == '*') {
                if (++pIdx >= pLength) {
                    while (tIdx < tLength) {
                        if (text.charAt(tIdx) == '.') {
                            return false;
                        }
                        ++tIdx;
                    }
                    return true;
                }
                if (this.matchesPattern(pattern, text, pIdx, tIdx)) {
                    return true;
                }
                while (tIdx < tLength) {
                    if (text.charAt(tIdx) == '.') {
                        return false;
                    }
                    if (!this.matchesPattern(pattern, text, pIdx, ++tIdx)) continue;
                    return true;
                }
                return false;
            }
            if (p == '.' && pIdx + 1 < pLength && pattern.charAt(pIdx + 1) == '.') {
                if ((pIdx += 2) >= pLength) {
                    return true;
                }
                if (pattern.charAt(pIdx) == '*') {
                    return true;
                }
                while (tIdx <= tLength) {
                    if (this.matchesPattern(pattern, text, pIdx, tIdx)) {
                        return true;
                    }
                    ++tIdx;
                }
                return false;
            }
            if (p == '.') {
                if (text.charAt(tIdx) != '.' && text.charAt(tIdx) != '$') {
                    return false;
                }
                ++pIdx;
                ++tIdx;
                continue;
            }
            if (p != text.charAt(tIdx)) {
                return false;
            }
            ++pIdx;
            ++tIdx;
        }
        return tIdx >= tLength;
    }

    public String toString() {
        return this.pattern;
    }

    private static enum PatternType {
        FullWildcard,
        Exact,
        PackagePrefix,
        Wildcard;

    }
}

