/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.rpc;

import org.openrewrite.java.JavaTypeSignatureBuilder;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.internal.DefaultJavaTypeSignatureBuilder;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.rpc.Reference;
import org.openrewrite.rpc.RpcSendQueue;

public class JavaTypeSender
extends JavaTypeVisitor<RpcSendQueue> {
    private final JavaTypeSignatureBuilder sig = new DefaultJavaTypeSignatureBuilder();

    @Override
    public JavaType visitAnnotation(JavaType.Annotation annotation, RpcSendQueue q) {
        q.getAndSend((Object)annotation, a -> Reference.asRef((Object)a.getType()), t -> this.visit((JavaType)Reference.getValueNonNull((Object)t), q));
        return annotation;
    }

    @Override
    public JavaType visitMultiCatch(JavaType.MultiCatch multiCatch, RpcSendQueue q) {
        q.getAndSendListAsRef((Object)multiCatch, JavaType.MultiCatch::getThrowableTypes, this.sig::signature, t -> this.visit((JavaType)t, q));
        return multiCatch;
    }

    @Override
    public JavaType visitIntersection(JavaType.Intersection intersection, RpcSendQueue q) {
        q.getAndSendListAsRef((Object)intersection, JavaType.Intersection::getBounds, this.sig::signature, t -> this.visit((JavaType)t, q));
        return intersection;
    }

    @Override
    public JavaType visitClass(JavaType.Class aClass, RpcSendQueue q) {
        q.getAndSend((Object)aClass, JavaType.Class::getFlagsBitMap);
        q.getAndSend((Object)aClass, JavaType.Class::getKind);
        q.getAndSend((Object)aClass, JavaType.Class::getFullyQualifiedName);
        q.getAndSendListAsRef((Object)aClass, JavaType.Class::getTypeParameters, this.sig::signature, t -> this.visit((JavaType)t, q));
        q.getAndSend((Object)aClass, c -> Reference.asRef((Object)c.getSupertype()), t -> this.visit((JavaType)Reference.getValueNonNull((Object)t), q));
        q.getAndSend((Object)aClass, c -> Reference.asRef((Object)c.getOwningClass()), t -> this.visit((JavaType)Reference.getValueNonNull((Object)t), q));
        q.getAndSendListAsRef((Object)aClass, JavaType.Class::getAnnotations, this.sig::signature, t -> this.visit((JavaType)t, q));
        q.getAndSendListAsRef((Object)aClass, JavaType.Class::getInterfaces, this.sig::signature, t -> this.visit((JavaType)t, q));
        q.getAndSendListAsRef((Object)aClass, JavaType.Class::getMembers, this.sig::signature, t -> this.visit((JavaType)t, q));
        q.getAndSendListAsRef((Object)aClass, JavaType.Class::getMethods, this.sig::signature, t -> this.visit((JavaType)t, q));
        return aClass;
    }

    @Override
    public JavaType visitParameterized(JavaType.Parameterized parameterized, RpcSendQueue q) {
        q.getAndSend((Object)parameterized, p -> Reference.asRef((Object)p.getType()), t -> this.visit((JavaType)Reference.getValueNonNull((Object)t), q));
        q.getAndSendListAsRef((Object)parameterized, JavaType.Parameterized::getTypeParameters, this.sig::signature, t -> this.visit((JavaType)t, q));
        return parameterized;
    }

    @Override
    public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable generic, RpcSendQueue q) {
        q.getAndSend((Object)generic, JavaType.GenericTypeVariable::getName);
        q.getAndSend((Object)generic, JavaType.GenericTypeVariable::getVariance);
        q.getAndSendListAsRef((Object)generic, JavaType.GenericTypeVariable::getBounds, this.sig::signature, t -> this.visit((JavaType)t, q));
        return generic;
    }

    @Override
    public JavaType visitArray(JavaType.Array array, RpcSendQueue q) {
        q.getAndSend((Object)array, a -> Reference.asRef((Object)a.getElemType()), t -> this.visit((JavaType)Reference.getValueNonNull((Object)t), q));
        q.getAndSendListAsRef((Object)array, JavaType.Array::getAnnotations, this.sig::signature, t -> this.visit((JavaType)t, q));
        return array;
    }

    @Override
    public JavaType visitPrimitive(JavaType.Primitive primitive, RpcSendQueue q) {
        q.getAndSend((Object)primitive, JavaType.Primitive::getKeyword);
        return primitive;
    }

    @Override
    public JavaType visitMethod(JavaType.Method method, RpcSendQueue q) {
        q.getAndSend((Object)method, m -> Reference.asRef((Object)m.getDeclaringType()), t -> this.visit((JavaType)Reference.getValueNonNull((Object)t), q));
        q.getAndSend((Object)method, JavaType.Method::getName);
        q.getAndSend((Object)method, JavaType.Method::getFlagsBitMap);
        q.getAndSend((Object)method, m -> Reference.asRef((Object)m.getReturnType()), t -> this.visit((JavaType)Reference.getValueNonNull((Object)t), q));
        q.getAndSendList((Object)method, JavaType.Method::getParameterNames, String::toString, null);
        q.getAndSendListAsRef((Object)method, JavaType.Method::getParameterTypes, this.sig::signature, t -> this.visit((JavaType)t, q));
        q.getAndSendListAsRef((Object)method, JavaType.Method::getThrownExceptions, this.sig::signature, t -> this.visit((JavaType)t, q));
        q.getAndSendListAsRef((Object)method, JavaType.Method::getAnnotations, this.sig::signature, t -> this.visit((JavaType)t, q));
        q.getAndSendList((Object)method, JavaType.Method::getDefaultValue, String::toString, null);
        q.getAndSendList((Object)method, JavaType.Method::getDeclaredFormalTypeNames, String::toString, null);
        return method;
    }

    @Override
    public JavaType visitVariable(JavaType.Variable variable, RpcSendQueue q) {
        q.getAndSend((Object)variable, JavaType.Variable::getName);
        q.getAndSend((Object)variable, v -> Reference.asRef((Object)v.getOwner()), t -> this.visit((JavaType)Reference.getValueNonNull((Object)t), q));
        q.getAndSend((Object)variable, v -> Reference.asRef((Object)v.getType()), t -> this.visit((JavaType)Reference.getValueNonNull((Object)t), q));
        q.getAndSendListAsRef((Object)variable, JavaType.Variable::getAnnotations, this.sig::signature, t -> this.visit((JavaType)t, q));
        return variable;
    }
}

