/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.openrewrite.style.StyleHelper;

public class SpacesVisitor<P>
extends JavaIsoVisitor<P> {
    protected final SpacesStyle spacesStyle;
    protected final @Nullable EmptyForInitializerPadStyle emptyForInitializerPadStyle;
    protected final @Nullable EmptyForIteratorPadStyle emptyForIteratorPadStyle;
    protected final @Nullable Tree stopAfter;
    protected final boolean removeCustomLineBreaks;

    public SpacesVisitor(SourceFile sourceFile, boolean removeCustomLineBreaks, @Nullable Tree stopAfter) {
        this(sourceFile.getMarkers().findAll(NamedStyles.class), removeCustomLineBreaks, stopAfter);
    }

    public SpacesVisitor(List<NamedStyles> styles, boolean removeCustomLineBreaks, @Nullable Tree stopAfter) {
        this(SpacesVisitor.getStyle(SpacesStyle.class, styles, IntelliJ::spaces), SpacesVisitor.getStyle(EmptyForInitializerPadStyle.class, styles), SpacesVisitor.getStyle(EmptyForIteratorPadStyle.class, styles), stopAfter, removeCustomLineBreaks);
    }

    public SpacesVisitor(SpacesStyle spacesStyle, @Nullable Tree stopAfter) {
        this(spacesStyle, null, null, stopAfter, false);
    }

    public SpacesVisitor(SpacesStyle spacesStyle, boolean removeCustomLineBreaks, @Nullable Tree stopAfter) {
        this(spacesStyle, null, null, stopAfter, removeCustomLineBreaks);
    }

    @Deprecated
    public SpacesVisitor(SpacesStyle spacesStyle, @Nullable EmptyForInitializerPadStyle emptyForInitializerPadStyle, @Nullable EmptyForIteratorPadStyle emptyForIteratorPadStyle, @Nullable Tree stopAfter) {
        this(spacesStyle, emptyForInitializerPadStyle, emptyForIteratorPadStyle, stopAfter, false);
    }

    public SpacesVisitor(SpacesStyle spacesStyle, @Nullable EmptyForInitializerPadStyle emptyForInitializerPadStyle, @Nullable EmptyForIteratorPadStyle emptyForIteratorPadStyle, @Nullable Tree stopAfter, boolean removeCustomLineBreaks) {
        this.spacesStyle = spacesStyle;
        this.emptyForInitializerPadStyle = emptyForInitializerPadStyle;
        this.emptyForIteratorPadStyle = emptyForIteratorPadStyle;
        this.stopAfter = stopAfter;
        this.removeCustomLineBreaks = removeCustomLineBreaks;
    }

    @Override
    public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, P p) {
        Object t;
        if (right == null || !(right.getElement() instanceof J)) {
            return super.visitRightPadded(right, loc, p);
        }
        Cursor cursor = this.getCursor();
        Cursor parentTreeCursor = cursor.getParentTreeCursor();
        String before = null;
        String after = null;
        JContainer.Location containerLocation = (JContainer.Location)((Object)cursor.getMessage("location"));
        int index = -1;
        int size = -1;
        boolean emptyContainer = false;
        switch (loc) {
            case LANGUAGE_EXTENSION: 
            case CASE_LABEL: {
                break;
            }
            case MEMBER_REFERENCE_CONTAINING: {
                after = this.evaluate(() -> this.spacesStyle.getAroundOperators().getMethodReferenceDoubleColon(), false) ? " " : "";
                break;
            }
            case PARENTHESES: {
                J parent = (J)parentTreeCursor.getValue();
                if (parent instanceof J.If) {
                    before = this.evaluate(() -> this.spacesStyle.getWithin().getIfParentheses(), false) ? " " : "";
                } else if (parent instanceof J.WhileLoop || parent instanceof J.DoWhileLoop) {
                    before = this.evaluate(() -> this.spacesStyle.getWithin().getWhileParentheses(), false) ? " " : "";
                } else if (parent instanceof J.Switch || parent instanceof J.SwitchExpression) {
                    before = this.evaluate(() -> this.spacesStyle.getWithin().getSwitchParentheses(), false) ? " " : "";
                } else if (parent instanceof J.Try.Catch) {
                    before = this.evaluate(() -> this.spacesStyle.getWithin().getCatchParentheses(), false) ? " " : "";
                } else if (parent instanceof J.Synchronized) {
                    before = this.evaluate(() -> this.spacesStyle.getWithin().getSynchronizedParentheses(), false) ? " " : "";
                } else if (parent instanceof J.TypeCast) {
                    before = this.evaluate(() -> this.spacesStyle.getWithin().getTypeCastParentheses(), false) ? " " : "";
                } else if (parent instanceof J.ArrayAccess) {
                    before = this.evaluate(() -> this.spacesStyle.getWithin().getBrackets(), false) ? " " : "";
                } else if (parent instanceof J.NewArray) {
                    before = this.evaluate(() -> this.spacesStyle.getWithin().getBrackets(), false) ? " " : "";
                } else {
                    if (!(this.getCursor().getValue() instanceof J.Parentheses) || !(((J.Parentheses)this.getCursor().getValue()).getTree() instanceof J.Binary)) break;
                    before = this.evaluate(() -> this.spacesStyle.getWithin().getGroupingParentheses(), false) ? " " : "";
                }
                after = before;
                break;
            }
            case FOR_INIT: {
                J.ForLoop.Control controlInit = (J.ForLoop.Control)this.getCursor().getValue();
                if (controlInit.getInit().stream().allMatch(i -> i instanceof J.Empty)) {
                    before = this.emptyForInitializerPadStyle != null ? (this.evaluate(() -> this.emptyForInitializerPadStyle.getSpace(), false) ? " " : "") : (this.evaluate(() -> this.spacesStyle.getWithin().getForParentheses(), this.evaluate(() -> this.spacesStyle.getOther().getBeforeForSemicolon(), false)) ? " " : "");
                    after = "";
                    break;
                }
                before = this.evaluate(() -> this.spacesStyle.getOther().getAfterComma(), true) ? " " : "";
                after = this.evaluate(() -> this.spacesStyle.getOther().getBeforeComma(), false) ? " " : "";
                index = controlInit.getInit().indexOf(right.getElement());
                if (index == 0) {
                    String string = before = this.evaluate(() -> this.spacesStyle.getWithin().getForParentheses(), true) ? " " : "";
                }
                if (index != controlInit.getInit().size() - 1) break;
                after = this.evaluate(() -> this.spacesStyle.getOther().getBeforeForSemicolon(), false) ? " " : "";
                break;
            }
            case FOR_CONDITION: {
                before = this.evaluate(() -> this.spacesStyle.getOther().getAfterForSemicolon(), true) ? " " : "";
                after = this.evaluate(() -> this.spacesStyle.getOther().getBeforeForSemicolon(), true) ? " " : "";
                break;
            }
            case FOR_UPDATE: {
                J.ForLoop.Control controlUpdate = (J.ForLoop.Control)this.getCursor().getValue();
                if (controlUpdate.getUpdate().stream().allMatch(i -> i instanceof J.Empty)) {
                    before = this.emptyForIteratorPadStyle != null ? (this.evaluate(() -> this.emptyForIteratorPadStyle.getSpace(), false) ? " " : "") : (this.evaluate(() -> this.spacesStyle.getOther().getAfterForSemicolon(), this.evaluate(() -> this.spacesStyle.getWithin().getForParentheses(), true)) ? " " : "");
                    after = "";
                    break;
                }
                before = this.evaluate(() -> this.spacesStyle.getOther().getAfterComma(), true) ? " " : "";
                after = this.evaluate(() -> this.spacesStyle.getOther().getBeforeComma(), false) ? " " : "";
                index = controlUpdate.getUpdate().indexOf(right.getElement());
                if (index == 0) {
                    String string = before = this.evaluate(() -> this.spacesStyle.getOther().getAfterForSemicolon(), true) ? " " : "";
                }
                if (index != controlUpdate.getUpdate().size() - 1) break;
                after = this.evaluate(() -> this.spacesStyle.getWithin().getForParentheses(), false) ? " " : "";
                break;
            }
            case FOREACH_ITERABLE: {
                before = " ";
                after = this.evaluate(() -> this.spacesStyle.getWithin().getForParentheses(), false) ? " " : "";
                break;
            }
            case FOREACH_VARIABLE: {
                before = this.evaluate(() -> this.spacesStyle.getWithin().getForParentheses(), false) ? " " : "";
                after = this.evaluate(() -> this.spacesStyle.getOther().getBeforeColonInForEach(), true) ? " " : "";
                break;
            }
            case ARRAY_INDEX: {
                before = this.evaluate(() -> this.spacesStyle.getWithin().getBrackets(), true) ? " " : "";
                after = this.evaluate(() -> this.spacesStyle.getWithin().getBrackets(), true) ? " " : "";
                break;
            }
            case CATCH_ALTERNATIVE: {
                J.MultiCatch multiCatch = (J.MultiCatch)cursor.getValue();
                after = before = this.evaluate(() -> this.spacesStyle.getAroundOperators().getBitwise(), true) ? " " : "";
                index = multiCatch.getAlternatives().indexOf(right.getElement());
                if (index == 0) {
                    before = "";
                }
                if (index != multiCatch.getAlternatives().size() - 1) break;
                after = "";
                break;
            }
            case ENUM_VALUE: {
                Cursor classCursor = parentTreeCursor.getParentTreeCursor();
                final AtomicInteger atomicSize = new AtomicInteger(-1);
                final AtomicInteger atomicIndex = new AtomicInteger(-1);
                new JavaIsoVisitor<J.EnumValue>(){

                    @Override
                    public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enums, J.EnumValue ctx) {
                        if (enums.getEnums().contains(ctx)) {
                            atomicSize.set(enums.getEnums().size());
                            atomicIndex.set(enums.getEnums().indexOf(ctx));
                        }
                        return enums;
                    }
                }.visit((J)classCursor.getValue(), (J.EnumValue)right.getElement());
                if (classCursor.getMessage("singleLineEnum") == Boolean.TRUE) {
                    if (atomicIndex.get() == 0) {
                        before = this.evaluate(() -> this.spacesStyle.getOther().getInsideOneLineEnumBraces(), false) ? " " : "";
                    } else if (atomicIndex.get() > 0) {
                        String string = before = this.evaluate(() -> this.spacesStyle.getOther().getAfterComma(), true) ? " " : "";
                    }
                    if (atomicIndex.get() == atomicSize.get() - 1) {
                        after = this.evaluate(() -> this.spacesStyle.getOther().getInsideOneLineEnumBraces(), false) ? " " : "";
                        break;
                    }
                    if (atomicIndex.get() < 0) break;
                    after = this.evaluate(() -> this.spacesStyle.getOther().getBeforeComma(), false) ? " " : "";
                    break;
                }
                if (atomicIndex.get() > 0 && !this.hasLineBreakInSpace(((J)right.getElement()).getPrefix())) {
                    before = " ";
                }
                after = "";
                break;
            }
            case LAMBDA_PARAM: {
                J parent = (J)cursor.getValue();
                index = ((J.Lambda.Parameters)parent).getParameters().indexOf(right.getElement());
                size = ((J.Lambda.Parameters)parent).getParameters().size();
                containerLocation = JContainer.Location.METHOD_DECLARATION_PARAMETERS;
                break;
            }
            case TYPE_PARAMETER: {
                if (cursor.getValue() instanceof J.TypeParameters) {
                    J.TypeParameters params = (J.TypeParameters)cursor.getValue();
                    index = params.getTypeParameters().indexOf(right.getElement());
                    size = params.getTypeParameters().size();
                    containerLocation = JContainer.Location.TYPE_PARAMETERS;
                    break;
                }
            }
            case METHOD_DECLARATION_PARAMETER: 
            case RECORD_STATE_VECTOR: 
            case METHOD_INVOCATION_ARGUMENT: 
            case NEW_CLASS_ARGUMENTS: 
            case ANNOTATION_ARGUMENT: 
            case TYPE_BOUND: 
            case NEW_ARRAY_INITIALIZER: 
            case TRY_RESOURCE: {
                JContainer container = (JContainer)cursor.getValue();
                index = container.getElements().indexOf(right.getElement());
                size = container.getElements().size();
                emptyContainer = container.getElements().stream().allMatch(element -> element instanceof J.Empty);
                break;
            }
            case METHOD_SELECT: {
                after = "";
                break;
            }
            case INSTANCEOF: {
                after = " ";
                break;
            }
            default: {
                after = this.hasLineBreakInSpace(right.getAfter()) ? right.getAfter().getWhitespace() : "";
            }
        }
        if (index >= 0 && containerLocation != null) {
            if (emptyContainer) {
                before = this.getMinimizedWhitespaceWithin(containerLocation, ContainerPosition.EMPTY);
                after = "";
            } else {
                ContainerPosition beforePosition = ContainerPosition.AFTER_SEPARATOR;
                ContainerPosition afterPosition = ContainerPosition.BEFORE_SEPARATOR;
                if (index == 0) {
                    beforePosition = ContainerPosition.OPEN;
                }
                if (index == size - 1) {
                    afterPosition = ContainerPosition.CLOSE;
                }
                before = this.getMinimizedWhitespaceWithin(containerLocation, beforePosition);
                after = this.getMinimizedWhitespaceWithin(containerLocation, afterPosition);
            }
        }
        if (after != null) {
            right = index != size - 1 && right.getElement() instanceof J.Try.Resource ? right.withElement(new JavaIsoVisitor<String>(){

                @Override
                public <B> @Nullable JRightPadded<B> visitRightPadded(@Nullable JRightPadded<B> right, JRightPadded.Location loc, String p) {
                    return right == null ? null : right.withAfter(SpacesVisitor.this.minimizedLastComment(right.getAfter(), p));
                }
            }.visit((Tree)right.getElement(), after)) : right.withAfter(this.minimizedLastComment(right.getAfter(), after));
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        if (before != null) {
            this.getCursor().putMessage("before", (Object)before);
        }
        if ((t = right.getElement()) instanceof J) {
            t = this.visitAndCast((J)right.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space afterSpace = right.getAfter();
        if (after == null) {
            afterSpace = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        }
        Markers markers = this.visitMarkers(right.getMarkers(), p);
        return afterSpace == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JRightPadded<T>(t, afterSpace, markers);
    }

    @Override
    public <T> @Nullable JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, JLeftPadded.Location loc, P p) {
        Object t;
        if (left == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), left));
        String before = null;
        String beforeElem = null;
        switch (loc) {
            case LANGUAGE_EXTENSION: {
                break;
            }
            case TERNARY_TRUE: {
                before = this.evaluate(() -> this.spacesStyle.getTernaryOperator().getBeforeQuestionMark(), true) ? " " : "";
                beforeElem = this.evaluate(() -> this.spacesStyle.getTernaryOperator().getAfterQuestionMark(), true) ? " " : "";
                break;
            }
            case TERNARY_FALSE: {
                before = this.evaluate(() -> this.spacesStyle.getTernaryOperator().getBeforeColon(), true) ? " " : "";
                String string = beforeElem = this.evaluate(() -> this.spacesStyle.getTernaryOperator().getAfterColon(), true) ? " " : "";
            }
        }
        if (before != null) {
            this.getCursor().putMessage("before", before);
        }
        Space beforeSpace = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), p);
        if (beforeElem != null) {
            this.getCursor().putMessage("before", (Object)beforeElem);
        }
        if ((t = left.getElement()) instanceof J) {
            t = this.visitAndCast((J)left.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (left.getElement() == t && beforeSpace == left.getBefore()) {
            return left;
        }
        return t == null ? null : new JLeftPadded<T>(beforeSpace, t, left.getMarkers());
    }

    @Override
    public Space visitSpace(@Nullable Space space, Space.Location loc, P ctx) {
        if (space == null) {
            return super.visitSpace(null, loc, ctx);
        }
        if (this.getCursor().getValue() instanceof JContainer) {
            Arrays.stream(JContainer.Location.values()).filter(l -> l.getBeforeLocation() == loc).findFirst().ifPresent(l -> this.getCursor().computeMessageIfAbsent("location", __ -> l));
        }
        String whitespace = null;
        String before = (String)this.getCursor().pollNearestMessage("before");
        if (before != null) {
            return super.visitSpace(this.minimizedSkipComments(space, before), loc, ctx);
        }
        BiFunction<Space, String, Space> minimized = this::minimizedLastComment;
        switch (loc) {
            case LANGUAGE_EXTENSION: {
                break;
            }
            case BLOCK_PREFIX: {
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor();
                if (!(parentTreeCursor.getValue() instanceof J)) break;
                J parent = (J)parentTreeCursor.getValue();
                if (parent instanceof J.ClassDeclaration) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getClassLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.MethodDeclaration) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getMethodLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.If) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getIfLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.If.Else) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getElseLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.ForEachLoop || parent instanceof J.ForLoop) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getForLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.WhileLoop) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getWhileLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.DoWhileLoop) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getDoLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.Switch || parent instanceof J.SwitchExpression) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getSwitchLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.Try.Catch) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getCatchLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.Synchronized) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getSynchronizedLeftBrace(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.Try) {
                    if (((J.Try)parent).getFinally() != null && ((J.Try)parent).getFinally().getId() == ((J.Block)this.getCursor().getValue()).getId()) {
                        whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getFinallyLeftBrace(), true) ? " " : "";
                        break;
                    }
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getTryLeftBrace(), true) ? " " : "";
                    break;
                }
                if (!(parent instanceof J.Lambda)) break;
                whitespace = this.evaluate(() -> this.spacesStyle.getAroundOperators().getLambdaArrow(), true) ? " " : "";
                break;
            }
            case LAMBDA_ARROW_PREFIX: {
                whitespace = this.evaluate(() -> this.spacesStyle.getAroundOperators().getLambdaArrow(), true) ? " " : "";
                break;
            }
            case METHOD_DECLARATION_PARAMETERS: {
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getMethodDeclaration(), false) ? " " : "";
                break;
            }
            case PRIMITIVE_PREFIX: {
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor();
                if (parentTreeCursor.getValue() instanceof J) {
                    J parent = (J)parentTreeCursor.getValue();
                    if (parent instanceof J.MethodDeclaration) {
                        J.MethodDeclaration m = (J.MethodDeclaration)parent;
                        TypeTree type = m.getReturnTypeExpression();
                        if (m.getModifiers().isEmpty() && type == this.getCursor().getValue()) {
                            whitespace = space.getWhitespace();
                        }
                    } else if (parent instanceof J.VariableDeclarations) {
                        J.VariableDeclarations v2 = (J.VariableDeclarations)parent;
                        TypeTree type = v2.getTypeExpression();
                        if (v2.getModifiers().isEmpty() && type == this.getCursor().getValue()) {
                            whitespace = space.getWhitespace();
                        }
                    }
                }
                if (whitespace != null || space.getWhitespace().isEmpty()) break;
                whitespace = " ";
                break;
            }
            case IDENTIFIER_PREFIX: {
                if (this.getCursor().getParentTreeCursor().getValue() instanceof J.MethodInvocation) {
                    J.MethodInvocation mi = (J.MethodInvocation)this.getCursor().getParentTreeCursor().getValue();
                    whitespace = mi.getName() == this.getCursor().getValue() && mi.getTypeParameters() != null ? (this.evaluate(() -> this.spacesStyle.getTypeArguments().getAfterClosingAngleBracket(), false) ? " " : "") : "";
                } else if (!space.getWhitespace().isEmpty()) {
                    whitespace = " ";
                }
                minimized = this::minimizedSkipComments;
                break;
            }
            case MODIFIER_PREFIX: {
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor();
                if (!(parentTreeCursor.getValue() instanceof J)) break;
                J parent = (J)parentTreeCursor.getValue();
                List<J.Modifier> modifiers = null;
                if (parent instanceof J.MethodDeclaration) {
                    modifiers = ((J.MethodDeclaration)parent).getModifiers();
                } else if (parent instanceof J.ClassDeclaration) {
                    modifiers = ((J.ClassDeclaration)parent).getModifiers();
                } else if (parent instanceof J.VariableDeclarations) {
                    modifiers = ((J.VariableDeclarations)parent).getModifiers();
                }
                if (modifiers != null && modifiers.indexOf((J.Modifier)this.getCursor().getValue()) > 0) {
                    whitespace = " ";
                }
                if (modifiers == null || modifiers.indexOf((J.Modifier)this.getCursor().getValue()) != 0 || StringUtils.hasLineBreak((String)space.getWhitespace()) || space.getWhitespace().isEmpty()) break;
                whitespace = " ";
                break;
            }
            case MEMBER_REFERENCE_NAME: {
                whitespace = this.evaluate(() -> this.spacesStyle.getAroundOperators().getMethodReferenceDoubleColon(), false) ? " " : "";
                break;
            }
            case CATCH_PREFIX: {
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeKeywords().getCatchKeyword(), true) ? " " : "";
                break;
            }
            case WHILE_CONDITION: {
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeKeywords().getWhileKeyword(), true) ? " " : "";
                break;
            }
            case IF_PREFIX: {
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor();
                if (!(parentTreeCursor.getValue() instanceof J.If.Else) || !space.getComments().isEmpty()) break;
                space = space.withWhitespace(" ");
                break;
            }
            case ELSE_PREFIX: {
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor();
                J parent = (J)parentTreeCursor.getValue();
                if (!(parent instanceof J.If) || !(((J.If)parent).getThenPart() instanceof J.Block) || !space.getComments().isEmpty()) break;
                space = space.withWhitespace(this.evaluate(() -> this.spacesStyle.getBeforeKeywords().getElseKeyword(), true) ? " " : "");
                break;
            }
            case TRY_FINALLY: {
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeKeywords().getFinallyKeyword(), true) ? " " : "";
                break;
            }
            case RECORD_STATE_VECTOR_SUFFIX: 
            case METHOD_DECLARATION_PARAMETER_SUFFIX: 
            case METHOD_INVOCATION_ARGUMENT_SUFFIX: 
            case TYPE_PARAMETER_SUFFIX: {
                whitespace = this.evaluate(() -> this.spacesStyle.getOther().getBeforeComma(), false) ? " " : "";
                break;
            }
            case ANNOTATION_ARGUMENTS: {
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getAnnotationParameters(), true) ? " " : "";
                break;
            }
            case TRY_RESOURCES: {
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getTryParentheses(), true) ? " " : "";
                break;
            }
            case FOR_CONTROL_PREFIX: 
            case FOR_EACH_CONTROL_PREFIX: {
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getForParentheses(), true) ? " " : "";
                break;
            }
            case CONTROL_PARENTHESES_PREFIX: {
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor();
                if (!(parentTreeCursor.getValue() instanceof J)) break;
                J parent = (J)parentTreeCursor.getValue();
                if (parent instanceof J.If) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getIfParentheses(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.WhileLoop) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getWhileParentheses(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.Switch) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getSwitchParentheses(), true) ? " " : "";
                    break;
                }
                if (parent instanceof J.Try.Catch) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getCatchParentheses(), true) ? " " : "";
                    break;
                }
                if (!(parent instanceof J.Synchronized)) break;
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getSynchronizedParentheses(), true) ? " " : "";
                break;
            }
            case TYPE_PARAMETERS: 
            case TYPE_PARAMETERS_PREFIX: {
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor();
                if (parentTreeCursor.getValue() instanceof J.MethodDeclaration) {
                    whitespace = ((J.MethodDeclaration)parentTreeCursor.getValue()).getModifiers().isEmpty() ? "" : " ";
                    break;
                }
                if (parentTreeCursor.getValue() instanceof J.ClassDeclaration) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getTypeParameters().getBeforeOpeningAngleBracket(), false) ? " " : "";
                    break;
                }
                whitespace = this.evaluate(() -> this.spacesStyle.getTypeArguments().getBeforeOpeningAngleBracket(), false) ? " " : "";
                break;
            }
            case NEW_CLASS_ARGUMENTS: 
            case METHOD_INVOCATION_ARGUMENTS: {
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeParentheses().getMethodCall(), false) ? " " : "";
                break;
            }
            case NEW_ARRAY_INITIALIZER: {
                whitespace = this.evaluate(() -> this.spacesStyle.getBeforeLeftBrace().getArrayInitializerLeftBrace(), false) ? " " : "";
                break;
            }
            case UNARY_OPERATOR: 
            case METHOD_SELECT_SUFFIX: 
            case VARARGS: 
            case TYPE_BOUND_SUFFIX: {
                whitespace = "";
                break;
            }
            case VARIABLE_PREFIX: 
            case LAMBDA_PARAMETERS_PREFIX: 
            case LAMBDA_PREFIX: {
                if (space.getWhitespace().isEmpty()) break;
                whitespace = " ";
                break;
            }
            case TYPE_BOUNDS: {
                whitespace = " ";
                break;
            }
            case BLOCK_END: {
                Cursor parentTreeCursor;
                J.Block block = (J.Block)this.getCursor().getValue();
                if (this.getCursor().dropParentWhile(v -> !(v instanceof J.ClassDeclaration) && !"root".equals(v)).getMessage("singleLineEnum") == Boolean.TRUE) {
                    if (block.getStatements().isEmpty()) {
                        whitespace = this.evaluate(() -> this.spacesStyle.getOther().getInsideOneLineEnumBraces(), false) ? " " : "";
                        break;
                    }
                    whitespace = "";
                    break;
                }
                if (block.getStatements().isEmpty() && block.getEnd().getComments().isEmpty() && ((parentTreeCursor = this.getCursor().getParentTreeCursor()).getValue() instanceof J.ClassDeclaration || parentTreeCursor.getValue() instanceof J.MethodDeclaration)) {
                    String string = whitespace = this.evaluate(() -> this.spacesStyle.getWithin().getCodeBraces(), false) ? " " : "";
                }
                if (!block.getStatements().isEmpty()) break;
                if (StringUtils.countOccurrences((String)block.getEnd().getWhitespace(), (String)"\n") > 3) {
                    space = space.withWhitespace("\n\n\n" + block.getEnd().getWhitespace().substring(block.getEnd().getWhitespace().lastIndexOf("\n") + 1));
                }
                space = space.withComments(ListUtils.map(space.getComments(), comment -> {
                    if (StringUtils.countOccurrences((String)comment.getSuffix(), (String)"\n") > 3) {
                        comment = comment.withSuffix("\n\n\n" + comment.getSuffix().substring(comment.getSuffix().lastIndexOf("\n") + 1));
                    }
                    return comment;
                }));
                break;
            }
            case BINARY_OPERATOR: {
                J.Binary binary = (J.Binary)this.getCursor().getParentTreeCursor().getValue();
                whitespace = this.getWhitespaceAroundOperator(binary.getOperator());
                break;
            }
            case ASSIGNMENT_OPERATION_OPERATOR: 
            case ASSIGNMENT: 
            case VARIABLE_INITIALIZER: {
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor().getParentTreeCursor();
                if (parentTreeCursor.getValue() instanceof J.Annotation) {
                    whitespace = this.evaluate(() -> this.spacesStyle.getOther().getAroundEqualInAnnotationValuePair(), true) ? " " : "";
                    break;
                }
                whitespace = this.evaluate(() -> this.spacesStyle.getAroundOperators().getAssignment(), true) ? " " : "";
                break;
            }
            case ANNOTATION_PREFIX: {
                boolean firstAnnotation = true;
                Cursor parentTreeCursor = this.getCursor().getParentTreeCursor();
                if (parentTreeCursor.getValue() instanceof J.ClassDeclaration) {
                    firstAnnotation = ((J.ClassDeclaration)parentTreeCursor.getValue()).getLeadingAnnotations().indexOf(this.getCursor().getValue()) <= 0;
                } else if (parentTreeCursor.getValue() instanceof J.MethodDeclaration) {
                    firstAnnotation = ((J.MethodDeclaration)parentTreeCursor.getValue()).getLeadingAnnotations().indexOf(this.getCursor().getValue()) <= 0;
                } else if (parentTreeCursor.getValue() instanceof J.VariableDeclarations) {
                    boolean bl = firstAnnotation = ((J.VariableDeclarations)parentTreeCursor.getValue()).getLeadingAnnotations().indexOf(this.getCursor().getValue()) <= 0;
                }
                if (!firstAnnotation && space.getWhitespace().isEmpty() && (space.getComments().isEmpty() || space.getComments().get(space.getComments().size() - 1).getSuffix().isEmpty())) {
                    whitespace = " ";
                }
            }
            default: {
                if (StringUtils.hasLineBreak((String)space.getWhitespace()) || space.getWhitespace().isEmpty()) break;
                whitespace = " ";
            }
        }
        if (whitespace != null) {
            return super.visitSpace(minimized.apply(space, whitespace), loc, ctx);
        }
        return super.visitSpace(space, loc, ctx);
    }

    @Override
    public J.TypeCast visitTypeCast(J.TypeCast typeCast, P p) {
        String afterTypeCast = this.evaluate(() -> this.spacesStyle.getOther().getAfterTypeCast(), true) ? " " : "";
        return super.visitTypeCast(typeCast.withExpression(this.minimized(typeCast.getExpression(), afterTypeCast)), (Object)p);
    }

    @Override
    public J.Lambda visitLambda(J.Lambda lambda, P p) {
        String afterArrow = this.evaluate(() -> this.spacesStyle.getAroundOperators().getLambdaArrow(), true) ? " " : "";
        return super.visitLambda(lambda.withBody(this.minimized(lambda.getBody(), afterArrow)), (Object)p);
    }

    @Override
    public J.Unary visitUnary(J.Unary unary, P p) {
        switch (unary.getOperator()) {
            case PreIncrement: 
            case PreDecrement: 
            case Positive: 
            case Negative: 
            case Complement: 
            case Not: {
                unary = unary.withExpression(this.minimized(unary.getExpression(), this.evaluate(() -> this.spacesStyle.getAroundOperators().getUnary(), false) ? " " : ""));
            }
        }
        return super.visitUnary(unary, (Object)p);
    }

    @Override
    public J.Binary visitBinary(J.Binary binary, P p) {
        return super.visitBinary(binary.withRight(this.minimized(binary.getRight(), this.getWhitespaceAroundOperator(binary.getOperator()))), (Object)p);
    }

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        if (variable.getInitializer() != null) {
            String afterOperator = this.evaluate(() -> this.spacesStyle.getAroundOperators().getAssignment(), true) ? " " : "";
            variable = variable.withInitializer(this.minimized(variable.getInitializer(), afterOperator));
        }
        return super.visitVariable(variable, (Object)p);
    }

    @Override
    public J.Assignment visitAssignment(J.Assignment assignment, P p) {
        String afterOperator = this.getCursor().getParentTreeCursor().getValue() instanceof J.Annotation ? (this.evaluate(() -> this.spacesStyle.getOther().getAroundEqualInAnnotationValuePair(), true) ? " " : "") : (this.evaluate(() -> this.spacesStyle.getAroundOperators().getAssignment(), true) ? " " : "");
        return super.visitAssignment(assignment.withAssignment(this.minimized(assignment.getAssignment(), afterOperator)), (Object)p);
    }

    @Override
    public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, P p) {
        String afterOperator = this.evaluate(() -> this.spacesStyle.getAroundOperators().getAssignment(), true) ? " " : "";
        return super.visitAssignmentOperation(assignOp.withAssignment(this.minimized(assignOp.getAssignment(), afterOperator)), (Object)p);
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Enum) {
            boolean singleLineEnum;
            boolean bl = singleLineEnum = !this.hasLineBreakInSpace(classDecl.getBody().getPrefix()) && !this.hasLineBreakInSpace(classDecl.getBody().getEnd());
            if (classDecl.getBody().getStatements().size() == 1 && classDecl.getBody().getStatements().get(0) instanceof J.EnumValueSet) {
                J.EnumValueSet enumValueSet = (J.EnumValueSet)classDecl.getBody().getStatements().get(0);
                if (this.hasLineBreakInSpace(enumValueSet.getPrefix()) || enumValueSet.getEnums().stream().map(J.EnumValue::getPrefix).anyMatch(this::hasLineBreakInSpace)) {
                    singleLineEnum = false;
                }
            } else if (!classDecl.getBody().getStatements().isEmpty()) {
                singleLineEnum = false;
            }
            this.getCursor().putMessage("singleLineEnum", (Object)singleLineEnum);
        }
        return super.visitClassDeclaration(classDecl, (Object)p);
    }

    public @Nullable J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    public @Nullable J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    private <T extends Expression> T minimized(T j, String whitespace) {
        return (T)((Expression)j.withPrefix(this.minimizedSkipComments(j.getPrefix(), whitespace)));
    }

    private J minimized(J j, String whitespace) {
        return j.withPrefix(this.minimizedSkipComments(j.getPrefix(), whitespace));
    }

    private Space minimizedSkipComments(Space space, String whitespace) {
        if (space.getComments().isEmpty()) {
            if (!this.removeCustomLineBreaks && StringUtils.hasLineBreak((String)space.getWhitespace())) {
                return space;
            }
            if (StringUtils.hasLineBreak((String)whitespace)) {
                return space.withWhitespace(whitespace.substring(whitespace.lastIndexOf(10)));
            }
            return space.withWhitespace(whitespace);
        }
        return space;
    }

    private Space minimizedLastComment(Space space, String whitespace) {
        return this.minimizedSkipComments(space, whitespace).withComments(ListUtils.mapLast(space.getComments(), comment -> {
            if (!StringUtils.hasLineBreak((String)comment.getSuffix())) {
                return comment.withSuffix(whitespace);
            }
            if (this.removeCustomLineBreaks) {
                Object parent;
                if (comment.isMultiline() && !((parent = this.getCursor().getParentTreeCursor().getValue()) instanceof J.Block) && !(parent instanceof J.Case)) {
                    return comment.withSuffix(whitespace);
                }
                return comment.withSuffix(comment.getSuffix().substring(comment.getSuffix().lastIndexOf(10)));
            }
            return comment;
        }));
    }

    private @Nullable String getMinimizedWhitespaceWithin(JContainer.Location loc, ContainerPosition containerPosition) {
        if (loc != JContainer.Location.TYPE_BOUNDS && loc != JContainer.Location.TRY_RESOURCES && loc != JContainer.Location.TYPE_PARAMETERS && containerPosition == ContainerPosition.AFTER_SEPARATOR) {
            return this.evaluate(() -> this.spacesStyle.getOther().getAfterComma(), true) ? " " : "";
        }
        if (loc != JContainer.Location.TYPE_BOUNDS && loc != JContainer.Location.TRY_RESOURCES && loc != JContainer.Location.TYPE_PARAMETERS && containerPosition == ContainerPosition.BEFORE_SEPARATOR) {
            return this.evaluate(() -> this.spacesStyle.getOther().getBeforeComma(), true) ? " " : "";
        }
        switch (loc) {
            case RECORD_STATE_VECTOR: {
                if (containerPosition == ContainerPosition.EMPTY) {
                    return "";
                }
                return this.evaluate(() -> this.spacesStyle.getWithin().getRecordHeader(), false) ? " " : "";
            }
            case METHOD_DECLARATION_PARAMETERS: {
                if (containerPosition == ContainerPosition.EMPTY) {
                    return this.evaluate(() -> this.spacesStyle.getWithin().getEmptyMethodDeclarationParentheses(), false) ? " " : "";
                }
                return this.evaluate(() -> this.spacesStyle.getWithin().getMethodDeclarationParentheses(), false) ? " " : "";
            }
            case METHOD_INVOCATION_ARGUMENTS: 
            case NEW_CLASS_ARGUMENTS: {
                if (containerPosition == ContainerPosition.EMPTY) {
                    return this.evaluate(() -> this.spacesStyle.getWithin().getEmptyMethodCallParentheses(), false) ? " " : "";
                }
                return this.evaluate(() -> this.spacesStyle.getWithin().getMethodCallParentheses(), false) ? " " : "";
            }
            case ANNOTATION_ARGUMENTS: {
                return this.evaluate(() -> this.spacesStyle.getWithin().getAnnotationParentheses(), false) ? " " : "";
            }
            case TRY_RESOURCES: {
                if (containerPosition == ContainerPosition.AFTER_SEPARATOR) {
                    return this.evaluate(() -> this.spacesStyle.getOther().getAfterForSemicolon(), true) ? " " : "";
                }
                if (containerPosition == ContainerPosition.BEFORE_SEPARATOR) {
                    JContainer resources = (JContainer)this.getCursor().getValue();
                    if (!resources.getElements().isEmpty() && ((J.Try.Resource)resources.getElements().get(0)).isTerminatedWithSemicolon()) {
                        return this.evaluate(() -> this.spacesStyle.getOther().getBeforeForSemicolon(), false) ? " " : "";
                    }
                    return "";
                }
                return this.evaluate(() -> this.spacesStyle.getWithin().getTryParentheses(), false) ? " " : "";
            }
            case NEW_ARRAY_INITIALIZER: {
                if (containerPosition == ContainerPosition.EMPTY) {
                    return this.evaluate(() -> this.spacesStyle.getWithin().getEmptyArrayInitializerBraces(), false) ? " " : "";
                }
                return this.evaluate(() -> this.spacesStyle.getWithin().getArrayInitializerBraces(), false) ? " " : "";
            }
            case TYPE_PARAMETERS: {
                if (containerPosition == ContainerPosition.AFTER_SEPARATOR) {
                    Object value = this.getCursor().getParentTreeCursor().getValue();
                    if (value instanceof J.MethodDeclaration || value instanceof J.ClassDeclaration) {
                        return this.evaluate(() -> this.spacesStyle.getOther().getAfterComma(), true) ? " " : "";
                    }
                    return this.evaluate(() -> this.spacesStyle.getTypeArguments().getAfterComma(), true) ? " " : "";
                }
                if (containerPosition == ContainerPosition.BEFORE_SEPARATOR || containerPosition == ContainerPosition.EMPTY) {
                    return "";
                }
                return this.evaluate(() -> this.spacesStyle.getWithin().getAngleBrackets(), false) ? " " : "";
            }
            case TYPE_BOUNDS: {
                if (containerPosition == ContainerPosition.AFTER_SEPARATOR || containerPosition == ContainerPosition.BEFORE_SEPARATOR) {
                    return this.evaluate(() -> this.spacesStyle.getTypeParameters().getAroundTypeBounds(), true) ? " " : "";
                }
                if (containerPosition == ContainerPosition.OPEN) {
                    return " ";
                }
                return "";
            }
        }
        return null;
    }

    private String getWhitespaceAroundOperator(J.Binary.Type operator) {
        switch (operator) {
            case Addition: 
            case Subtraction: {
                return this.evaluate(() -> this.spacesStyle.getAroundOperators().getAdditive(), true) ? " " : "";
            }
            case Multiplication: 
            case Division: 
            case Modulo: {
                return this.evaluate(() -> this.spacesStyle.getAroundOperators().getMultiplicative(), true) ? " " : "";
            }
            case LessThan: 
            case GreaterThan: 
            case LessThanOrEqual: 
            case GreaterThanOrEqual: {
                return this.evaluate(() -> this.spacesStyle.getAroundOperators().getRelational(), true) ? " " : "";
            }
            case Equal: 
            case NotEqual: {
                return this.evaluate(() -> this.spacesStyle.getAroundOperators().getEquality(), true) ? " " : "";
            }
            case BitAnd: 
            case BitOr: 
            case BitXor: {
                return this.evaluate(() -> this.spacesStyle.getAroundOperators().getBitwise(), true) ? " " : "";
            }
            case LeftShift: 
            case RightShift: 
            case UnsignedRightShift: {
                return this.evaluate(() -> this.spacesStyle.getAroundOperators().getShift(), true) ? " " : "";
            }
        }
        return this.evaluate(() -> this.spacesStyle.getAroundOperators().getLogical(), true) ? " " : "";
    }

    private boolean evaluate(Supplier<Boolean> supplier, boolean defaultValue) {
        try {
            return supplier.get();
        }
        catch (NoSuchMethodError e) {
            return defaultValue;
        }
    }

    private boolean hasLineBreakInSpace(Space space) {
        if (StringUtils.hasLineBreak((String)space.getWhitespace())) {
            return true;
        }
        for (Comment comment : space.getComments()) {
            if (!StringUtils.hasLineBreak((String)comment.getSuffix())) continue;
            return true;
        }
        return false;
    }

    private static <S extends Style> @Nullable S getStyle(Class<S> styleClass, List<NamedStyles> styles) {
        Style style = NamedStyles.merge(styleClass, styles);
        if (style != null) {
            return (S)style.applyDefaults();
        }
        return null;
    }

    private static <S extends Style> S getStyle(Class<S> styleClass, List<NamedStyles> styles, Supplier<S> defaultStyle) {
        Style style = NamedStyles.merge(styleClass, styles);
        if (style != null) {
            return (S)((Style)StyleHelper.merge((Object)((Style)defaultStyle.get()), (Object)style));
        }
        return (S)((Style)defaultStyle.get());
    }

    private static enum ContainerPosition {
        OPEN,
        CLOSE,
        BEFORE_SEPARATOR,
        AFTER_SEPARATOR,
        EMPTY;

    }
}

