/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.whitespace;

import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class NoWhitespaceBeforeCaseDefaultColonCheck
extends AbstractCheck {
    public static final String MSG_KEY = "ws.preceded";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{82};
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (NoWhitespaceBeforeCaseDefaultColonCheck.isInSwitch(ast) && NoWhitespaceBeforeCaseDefaultColonCheck.isWhiteSpaceBeforeColon(ast)) {
            this.log(ast, MSG_KEY, ast.getText());
        }
    }

    private static boolean isInSwitch(DetailAST colonAst) {
        return TokenUtil.isOfType(colonAst.getParent(), 93, 94);
    }

    private static boolean isWhiteSpaceBeforeColon(DetailAST colonAst) {
        DetailAST parent = colonAst.getParent();
        boolean result = NoWhitespaceBeforeCaseDefaultColonCheck.isOnDifferentLineWithPreviousToken(colonAst) ? true : (parent.getType() == 93 ? NoWhitespaceBeforeCaseDefaultColonCheck.isWhitespaceBeforeColonOfCase(colonAst) : NoWhitespaceBeforeCaseDefaultColonCheck.isWhitespaceBeforeColonOfDefault(colonAst));
        return result;
    }

    private static boolean isWhitespaceBeforeColonOfCase(DetailAST colonAst) {
        DetailAST previousSibling = colonAst.getPreviousSibling();
        int offset = 0;
        if (previousSibling.getType() == 145) {
            offset = 1;
        }
        return colonAst.getColumnNo() != NoWhitespaceBeforeCaseDefaultColonCheck.getLastColumnNumberOf(previousSibling) + offset;
    }

    private static boolean isWhitespaceBeforeColonOfDefault(DetailAST colonAst) {
        boolean result;
        DetailAST previousSibling = colonAst.getPreviousSibling();
        if (previousSibling == null) {
            DetailAST literalDefault = colonAst.getParent();
            result = colonAst.getColumnNo() != literalDefault.getColumnNo() + literalDefault.getText().length();
        } else {
            result = colonAst.getColumnNo() != NoWhitespaceBeforeCaseDefaultColonCheck.getLastColumnNumberOf(previousSibling) + 1;
        }
        return result;
    }

    private static boolean isOnDifferentLineWithPreviousToken(DetailAST colonAst) {
        DetailAST parent = colonAst.getParent();
        DetailAST previousSibling = parent.getType() == 93 ? colonAst.getPreviousSibling() : colonAst.getParent();
        return !TokenUtil.areOnSameLine(previousSibling, colonAst);
    }

    private static int getLastColumnNumberOf(DetailAST ast) {
        DetailAST lastChild = ast;
        while (lastChild.hasChildren()) {
            lastChild = lastChild.getLastChild();
        }
        return lastChild.getColumnNo() + lastChild.getText().length();
    }
}

