/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import java.util.BitSet;

public class IndentLevel {
    private final BitSet levels = new BitSet();

    public IndentLevel(int indent) {
        this.levels.set(indent);
    }

    public IndentLevel(IndentLevel base, int ... offsets) {
        BitSet src = base.levels;
        int i = src.nextSetBit(0);
        while (i >= 0) {
            for (int offset : offsets) {
                this.levels.set(i + offset);
            }
            i = src.nextSetBit(i + 1);
        }
    }

    private IndentLevel() {
    }

    public final boolean isMultiLevel() {
        return this.levels.cardinality() > 1;
    }

    public boolean isAcceptable(int indent) {
        return this.levels.get(indent);
    }

    public boolean isGreaterThan(int indent) {
        return this.levels.nextSetBit(0) > indent;
    }

    public static IndentLevel addAcceptable(IndentLevel base, int ... additions) {
        IndentLevel result = new IndentLevel();
        result.levels.or(base.levels);
        for (int addition : additions) {
            result.levels.set(addition);
        }
        return result;
    }

    public static IndentLevel addAcceptable(IndentLevel base, IndentLevel addition) {
        IndentLevel result = new IndentLevel();
        result.levels.or(base.levels);
        result.levels.or(addition.levels);
        return result;
    }

    public int getFirstIndentLevel() {
        return this.levels.nextSetBit(0);
    }

    public int getLastIndentLevel() {
        return this.levels.length() - 1;
    }

    public String toString() {
        String result;
        if (this.levels.cardinality() == 1) {
            result = String.valueOf(this.levels.nextSetBit(0));
        } else {
            StringBuilder sb = new StringBuilder(50);
            int i = this.levels.nextSetBit(0);
            while (i >= 0) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(i);
                i = this.levels.nextSetBit(i + 1);
            }
            result = sb.toString();
        }
        return result;
    }
}

