/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public final class AddOrUpdateAnnotationAttribute
extends Recipe {
    @Option(displayName="Annotation type", description="The fully qualified name of the annotation.", example="org.junit.Test")
    private final String annotationType;
    @Option(displayName="Attribute name", description="The name of attribute to change. If omitted defaults to 'value'.", required=false, example="timeout")
    private final @Nullable String attributeName;
    @Option(displayName="Attribute value", description="The value to set the attribute to. If the attribute is an array, provide values separated by comma to add multiple attributes at once. Set to `null` to remove the attribute.", required=false, example="500")
    private final @Nullable String attributeValue;
    @Option(displayName="Old Attribute value", description="The current value of the attribute, this can be used to filter where the change is applied. Set to `null` for wildcard behavior.", required=false, example="400")
    private final @Nullable String oldAttributeValue;
    @Option(displayName="Add only", description="When set to `true` will not change existing annotation attribute values.", required=false)
    private final @Nullable Boolean addOnly;
    @Option(displayName="Append array", description="If the attribute is an array, setting this option to `true` will append the value(s). In conjunction with `addOnly`, it is possible to control duplicates: `addOnly=true`, always append. `addOnly=false`, only append if the value is not already present.", required=false)
    private final @Nullable Boolean appendArray;

    public String getDisplayName() {
        return "Add or update annotation attribute";
    }

    public String getDescription() {
        return "Some annotations accept arguments. This recipe sets an existing argument to the specified value, or adds the argument if it is not already set.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType(this.annotationType, false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation a, ExecutionContext ctx) {
                J original = super.visitAnnotation(a, ctx);
                if (!TypeUtils.isOfClassType(a.getType(), AddOrUpdateAnnotationAttribute.this.annotationType)) {
                    return original;
                }
                String newAttributeValue = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, AddOrUpdateAnnotationAttribute.this.attributeValue, a);
                List<Expression> currentArgs = a.getArguments();
                if (currentArgs == null || currentArgs.isEmpty() || currentArgs.get(0) instanceof J.Empty) {
                    if (newAttributeValue == null || AddOrUpdateAnnotationAttribute.this.oldAttributeValue != null) {
                        return a;
                    }
                    if (AddOrUpdateAnnotationAttribute.this.attributeName == null || "value".equals(AddOrUpdateAnnotationAttribute.this.attributeName)) {
                        return (J.Annotation)JavaTemplate.apply("#{}", this.getCursor(), a.getCoordinates().replaceArguments(), newAttributeValue);
                    }
                    String newAttributeValueResult = AddOrUpdateAnnotationAttribute.this.isArray(a) ? AddOrUpdateAnnotationAttribute.this.getAttributeValuesAsString() : newAttributeValue;
                    return (J.Annotation)JavaTemplate.apply("#{} = #{}", this.getCursor(), a.getCoordinates().replaceArguments(), AddOrUpdateAnnotationAttribute.this.attributeName, newAttributeValueResult);
                }
                AtomicBoolean foundOrSetAttributeWithDesiredValue = new AtomicBoolean(false);
                J.Annotation finalA = a;
                List newArgs = ListUtils.map(currentArgs, it -> {
                    if (it instanceof J.Assignment) {
                        J.Assignment as = (J.Assignment)it;
                        J.Identifier var = (J.Identifier)as.getVariable();
                        if (AddOrUpdateAnnotationAttribute.this.attributeName == null && !"value".equals(var.getSimpleName())) {
                            return it;
                        }
                        if (AddOrUpdateAnnotationAttribute.this.attributeName != null && !AddOrUpdateAnnotationAttribute.this.attributeName.equals(var.getSimpleName())) {
                            return it;
                        }
                        foundOrSetAttributeWithDesiredValue.set(true);
                        if (newAttributeValue == null) {
                            return null;
                        }
                        if (as.getAssignment() instanceof J.NewArray) {
                            String newAttributeListValue;
                            List<Expression> initializerList = Objects.requireNonNull(((J.NewArray)as.getAssignment()).getInitializer());
                            List attributeList = AddOrUpdateAnnotationAttribute.this.getAttributeValues();
                            if (as.getMarkers().findFirst(AlreadyAppended.class).filter(ap -> ap.getValues().equals(newAttributeValue)).isPresent()) {
                                return as;
                            }
                            if (Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.appendArray)) {
                                boolean changed = false;
                                for (String attrListValues : attributeList) {
                                    String newAttributeListValue2 = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, attrListValues, finalA);
                                    if (Boolean.FALSE.equals(AddOrUpdateAnnotationAttribute.this.addOnly) && AddOrUpdateAnnotationAttribute.attributeValIsAlreadyPresent(initializerList, newAttributeListValue2) || AddOrUpdateAnnotationAttribute.this.oldAttributeValue != null && !AddOrUpdateAnnotationAttribute.this.oldAttributeValue.equals(attrListValues)) continue;
                                    changed = true;
                                    Expression e = Objects.requireNonNull(((J.Annotation)JavaTemplate.apply(newAttributeListValue2, this.getCursor(), finalA.getCoordinates().replaceArguments(), new Object[0])).getArguments()).get(0);
                                    initializerList.add(e);
                                }
                                return changed ? as.withAssignment(((J.NewArray)as.getAssignment()).withInitializer(initializerList)).withMarkers(as.getMarkers().add((Marker)new AlreadyAppended(Tree.randomId(), newAttributeValue))) : as;
                            }
                            int m = 0;
                            for (int i = 0; i < Objects.requireNonNull(initializerList).size(); ++i) {
                                if (i >= attributeList.size()) {
                                    initializerList.remove(i);
                                    --i;
                                    continue;
                                }
                                newAttributeListValue = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, (String)attributeList.get(i), finalA);
                                if (initializerList.size() == i + 1) {
                                    m = i + 1;
                                }
                                if (initializerList.get(i) instanceof J.Literal && newAttributeListValue.equals(((J.Literal)initializerList.get(i)).getValueSource()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly) || AddOrUpdateAnnotationAttribute.this.oldAttributeValue != null && !AddOrUpdateAnnotationAttribute.this.oldAttributeValue.equals(attributeList.get(i))) continue;
                                J.Literal newLiteral = new J.Literal(Tree.randomId(), initializerList.get(i).getPrefix(), Markers.EMPTY, newAttributeListValue, newAttributeListValue, null, JavaType.Primitive.String);
                                initializerList.set(i, newLiteral);
                            }
                            if (initializerList.size() < attributeList.size() || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                if (Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                    m = 0;
                                }
                                for (int j = m; j < attributeList.size(); ++j) {
                                    newAttributeListValue = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, (String)attributeList.get(j), finalA);
                                    initializerList.add(j, new J.Literal(Tree.randomId(), initializerList.get(j - 1).getPrefix(), Markers.EMPTY, newAttributeListValue, newAttributeListValue, null, JavaType.Primitive.String));
                                }
                            }
                            return as.withAssignment(((J.NewArray)as.getAssignment()).withInitializer(initializerList));
                        }
                        Expression exp = as.getAssignment();
                        if (exp instanceof J.Literal) {
                            J.Literal value = (J.Literal)exp;
                            if (newAttributeValue.equals(value.getValueSource()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                return it;
                            }
                            if (!AddOrUpdateAnnotationAttribute.valueMatches(value, AddOrUpdateAnnotationAttribute.this.oldAttributeValue)) {
                                return it;
                            }
                            if (AddOrUpdateAnnotationAttribute.this.isArray(finalA)) {
                                return as.withAssignment(((J.Annotation)JavaTemplate.apply("#{}", this.getCursor(), finalA.getCoordinates().replaceArguments(), AddOrUpdateAnnotationAttribute.this.getAttributeValuesAsString())).getArguments().get(0));
                            }
                            return as.withAssignment(value.withValue(newAttributeValue).withValueSource(newAttributeValue));
                        }
                        if (exp instanceof J.FieldAccess) {
                            if (Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly) || AddOrUpdateAnnotationAttribute.this.oldAttributeValue != null) {
                                return it;
                            }
                            return ((J.Annotation)JavaTemplate.apply("#{} = #{}", this.getCursor(), as.getCoordinates().replace(), var.getSimpleName(), newAttributeValue)).getArguments().get(finalA.getArguments().indexOf(as));
                        }
                    } else if (it instanceof J.Literal) {
                        if (AddOrUpdateAnnotationAttribute.this.attributeName == null || "value".equals(AddOrUpdateAnnotationAttribute.this.attributeName)) {
                            foundOrSetAttributeWithDesiredValue.set(true);
                            if (newAttributeValue == null) {
                                return null;
                            }
                            J.Literal literal = (J.Literal)it;
                            if (newAttributeValue.equals(literal.getValueSource()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                return it;
                            }
                            if (!AddOrUpdateAnnotationAttribute.valueMatches(literal, AddOrUpdateAnnotationAttribute.this.oldAttributeValue)) {
                                return it;
                            }
                            if (AddOrUpdateAnnotationAttribute.this.isArray(finalA)) {
                                return ((J.Annotation)JavaTemplate.apply("#{}", this.getCursor(), finalA.getCoordinates().replaceArguments(), AddOrUpdateAnnotationAttribute.this.getAttributeValuesAsString())).getArguments().get(0);
                            }
                            return literal.withValue(newAttributeValue).withValueSource(newAttributeValue);
                        }
                        if (AddOrUpdateAnnotationAttribute.this.oldAttributeValue == null) {
                            return this.createAnnotationAssignment(finalA, "value", it);
                        }
                    } else {
                        if (it instanceof J.FieldAccess) {
                            if (AddOrUpdateAnnotationAttribute.this.attributeName == null || "value".equals(AddOrUpdateAnnotationAttribute.this.attributeName)) {
                                foundOrSetAttributeWithDesiredValue.set(true);
                                if (!AddOrUpdateAnnotationAttribute.valueMatches(it, AddOrUpdateAnnotationAttribute.this.oldAttributeValue)) {
                                    return it;
                                }
                                if (newAttributeValue == null) {
                                    return null;
                                }
                                J.FieldAccess value = (J.FieldAccess)it;
                                if (newAttributeValue.equals(value.toString()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                    return it;
                                }
                                return ((J.Annotation)JavaTemplate.apply(newAttributeValue, this.getCursor(), finalA.getCoordinates().replaceArguments(), new Object[0])).getArguments().get(0);
                            }
                            return this.createAnnotationAssignment(finalA, "value", it);
                        }
                        if (it instanceof J.NewArray) {
                            String newAttributeListValue;
                            if (it.getMarkers().findFirst(AlreadyAppended.class).filter(ap -> ap.getValues().equals(newAttributeValue)).isPresent()) {
                                return it;
                            }
                            if (newAttributeValue == null) {
                                return null;
                            }
                            if (AddOrUpdateAnnotationAttribute.this.attributeName != null && !AddOrUpdateAnnotationAttribute.this.attributeValue.equals("value")) {
                                return AddOrUpdateAnnotationAttribute.isAnnotationWithOnlyValueMethod(finalA) ? it : this.createAnnotationAssignment(finalA, "value", it);
                            }
                            J.NewArray arrayValue = (J.NewArray)it;
                            List initializerList = Objects.requireNonNull(arrayValue.getInitializer());
                            List attributeList = AddOrUpdateAnnotationAttribute.this.getAttributeValues();
                            if (Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.appendArray)) {
                                boolean changed = false;
                                for (String attrListValues : attributeList) {
                                    String newAttributeListValue3 = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, attrListValues, finalA);
                                    if (Boolean.FALSE.equals(AddOrUpdateAnnotationAttribute.this.addOnly) && AddOrUpdateAnnotationAttribute.attributeValIsAlreadyPresent(initializerList, newAttributeListValue3)) continue;
                                    changed = true;
                                    Expression e = Objects.requireNonNull(((J.Annotation)JavaTemplate.apply(newAttributeListValue3, this.getCursor(), finalA.getCoordinates().replaceArguments(), new Object[0])).getArguments()).get(0);
                                    initializerList.add(e);
                                }
                                if (AddOrUpdateAnnotationAttribute.this.oldAttributeValue != null) {
                                    initializerList = ListUtils.map(initializerList, val -> AddOrUpdateAnnotationAttribute.valueMatches(val, AddOrUpdateAnnotationAttribute.this.oldAttributeValue) ? null : val);
                                }
                                return changed ? arrayValue.withInitializer(initializerList).withMarkers(it.getMarkers().add((Marker)new AlreadyAppended(Tree.randomId(), newAttributeValue))) : it;
                            }
                            int m = 0;
                            for (int i = 0; i < Objects.requireNonNull(initializerList).size(); ++i) {
                                if (i >= attributeList.size()) {
                                    initializerList.remove(i);
                                    --i;
                                    continue;
                                }
                                newAttributeListValue = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, (String)attributeList.get(i), finalA);
                                if (initializerList.size() == i + 1) {
                                    m = i + 1;
                                }
                                if (initializerList.get(i) instanceof J.Literal && newAttributeListValue.equals(((J.Literal)initializerList.get(i)).getValueSource()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly) || AddOrUpdateAnnotationAttribute.this.oldAttributeValue != null && !AddOrUpdateAnnotationAttribute.this.oldAttributeValue.equals(newAttributeListValue)) continue;
                                J.Literal newLiteral = new J.Literal(Tree.randomId(), ((Expression)initializerList.get(i)).getPrefix(), Markers.EMPTY, newAttributeListValue, newAttributeListValue, null, JavaType.Primitive.String);
                                initializerList.set(i, newLiteral);
                            }
                            if (initializerList.size() < attributeList.size() || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                if (Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                    m = 0;
                                }
                                for (int j = m; j < attributeList.size(); ++j) {
                                    newAttributeListValue = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, (String)attributeList.get(j), finalA);
                                    Expression e = Objects.requireNonNull(((J.Annotation)JavaTemplate.apply(newAttributeListValue, this.getCursor(), finalA.getCoordinates().replaceArguments(), new Object[0])).getArguments()).get(0);
                                    initializerList.add(j, e);
                                }
                            }
                            return arrayValue.withInitializer(initializerList);
                        }
                    }
                    return it;
                });
                if (newArgs != currentArgs) {
                    a = a.withArguments(newArgs);
                }
                if (!(foundOrSetAttributeWithDesiredValue.get() || AddOrUpdateAnnotationAttribute.attributeValIsAlreadyPresent(newArgs, newAttributeValue) || AddOrUpdateAnnotationAttribute.this.oldAttributeValue != null || AddOrUpdateAnnotationAttribute.isAnnotationWithOnlyValueMethod(a))) {
                    String effectiveName = AddOrUpdateAnnotationAttribute.this.attributeName == null ? "value" : AddOrUpdateAnnotationAttribute.this.attributeName;
                    J.Assignment as = this.createAnnotationAssignment(a, effectiveName, newAttributeValue);
                    a = a.withArguments(ListUtils.concat((Object)as, a.getArguments()));
                }
                a = this.maybeAutoFormat(original, a, ctx);
                return a;
            }

            private J.Assignment createAnnotationAssignment(J.Annotation annotation, String name, @Nullable Object parameter) {
                return (J.Assignment)((J.Annotation)JavaTemplate.apply(name + " = " + (parameter instanceof J ? "#{any()}" : "#{}"), this.getCursor(), annotation.getCoordinates().replaceArguments(), parameter)).getArguments().get(0);
            }
        });
    }

    private List<String> getAttributeValues() {
        String[] stringArray;
        if (this.attributeValue == null) {
            return Collections.emptyList();
        }
        String attributeValueCleanedUp = this.attributeValue.replaceAll("\\s+", "").replaceAll("[\\s+{}\"]", "");
        if (attributeValueCleanedUp.contains(",")) {
            stringArray = attributeValueCleanedUp.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = attributeValueCleanedUp;
        }
        return Arrays.asList(stringArray);
    }

    private String getAttributeValuesAsString() {
        return this.getAttributeValues().stream().map(String::valueOf).collect(Collectors.joining("\", \"", "{\"", "\"}"));
    }

    private boolean isArray(J.Annotation annotation) {
        String effectiveName = this.attributeName == null ? "value" : this.attributeName;
        List<JavaType.Method> methods = ((JavaType.FullyQualified)Objects.requireNonNull(annotation.getAnnotationType().getType())).getMethods();
        for (JavaType.Method method : methods) {
            if (!effectiveName.equals(method.getName()) || !method.getReturnType().toString().equals("java.lang.String[]")) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationWithOnlyValueMethod(J.Annotation annotation) {
        return ((JavaType.FullyQualified)Objects.requireNonNull(annotation.getAnnotationType().getType())).getMethods().size() == 1 && ((JavaType.FullyQualified)Objects.requireNonNull(annotation.getAnnotationType().getType())).getMethods().get(0).getName().equals("value");
    }

    private static boolean valueMatches(@Nullable Expression expression, @Nullable String oldAttributeValue) {
        if (expression == null) {
            return oldAttributeValue == null;
        }
        if (oldAttributeValue == null) {
            return true;
        }
        if (expression instanceof J.Literal) {
            return oldAttributeValue.equals(((J.Literal)expression).getValue());
        }
        if (expression instanceof J.FieldAccess) {
            J.FieldAccess fa = (J.FieldAccess)expression;
            String currentValue = ((J.Identifier)fa.getTarget()).getSimpleName() + "." + fa.getSimpleName();
            return oldAttributeValue.equals(currentValue);
        }
        if (expression instanceof J.Identifier) {
            if (oldAttributeValue.endsWith(".class")) {
                String className = TypeUtils.toString(Objects.requireNonNull(expression.getType())) + ".class";
                return className.endsWith(oldAttributeValue);
            }
            return oldAttributeValue.equals(((J.Identifier)expression).getSimpleName());
        }
        throw new IllegalArgumentException("Unexpected expression type: " + expression.getClass());
    }

    @Contract(value="_, null, _ -> null; _, !null, _ -> !null")
    private static @Nullable String maybeQuoteStringArgument(@Nullable String attributeName, @Nullable String attributeValue, J.Annotation annotation) {
        if (attributeValue != null && AddOrUpdateAnnotationAttribute.attributeIsString(attributeName, annotation)) {
            return "\"" + attributeValue + "\"";
        }
        return attributeValue;
    }

    private static boolean attributeIsString(@Nullable String attributeName, J.Annotation annotation) {
        String actualAttributeName = attributeName == null ? "value" : attributeName;
        JavaType.Class annotationType = (JavaType.Class)annotation.getType();
        if (annotationType != null) {
            for (JavaType.Method m : annotationType.getMethods()) {
                if (!m.getName().equals(actualAttributeName)) continue;
                return TypeUtils.isOfClassType(m.getReturnType(), "java.lang.String");
            }
        }
        return false;
    }

    private static boolean attributeValIsAlreadyPresent(@Nullable List<Expression> expression, @Nullable String attributeValue) {
        if (expression == null) {
            return attributeValue == null;
        }
        for (Expression e : expression) {
            J.Literal literal;
            if (e instanceof J.Literal && (literal = (J.Literal)e).getValueSource() != null && literal.getValueSource().equals(attributeValue)) {
                return true;
            }
            if (!(e instanceof J.NewArray)) continue;
            return AddOrUpdateAnnotationAttribute.attributeValIsAlreadyPresent(((J.NewArray)e).getInitializer(), attributeValue);
        }
        return false;
    }

    @Generated
    public AddOrUpdateAnnotationAttribute(String annotationType, @Nullable String attributeName, @Nullable String attributeValue, @Nullable String oldAttributeValue, @Nullable Boolean addOnly, @Nullable Boolean appendArray) {
        this.annotationType = annotationType;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.oldAttributeValue = oldAttributeValue;
        this.addOnly = addOnly;
        this.appendArray = appendArray;
    }

    @Generated
    public String getAnnotationType() {
        return this.annotationType;
    }

    @Generated
    public @Nullable String getAttributeName() {
        return this.attributeName;
    }

    @Generated
    public @Nullable String getAttributeValue() {
        return this.attributeValue;
    }

    @Generated
    public @Nullable String getOldAttributeValue() {
        return this.oldAttributeValue;
    }

    @Generated
    public @Nullable Boolean getAddOnly() {
        return this.addOnly;
    }

    @Generated
    public @Nullable Boolean getAppendArray() {
        return this.appendArray;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddOrUpdateAnnotationAttribute(annotationType=" + this.getAnnotationType() + ", attributeName=" + this.getAttributeName() + ", attributeValue=" + this.getAttributeValue() + ", oldAttributeValue=" + this.getOldAttributeValue() + ", addOnly=" + this.getAddOnly() + ", appendArray=" + this.getAppendArray() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOrUpdateAnnotationAttribute)) {
            return false;
        }
        AddOrUpdateAnnotationAttribute other = (AddOrUpdateAnnotationAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addOnly = this.getAddOnly();
        Boolean other$addOnly = other.getAddOnly();
        if (this$addOnly == null ? other$addOnly != null : !((Object)this$addOnly).equals(other$addOnly)) {
            return false;
        }
        Boolean this$appendArray = this.getAppendArray();
        Boolean other$appendArray = other.getAppendArray();
        if (this$appendArray == null ? other$appendArray != null : !((Object)this$appendArray).equals(other$appendArray)) {
            return false;
        }
        String this$annotationType = this.getAnnotationType();
        String other$annotationType = other.getAnnotationType();
        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$attributeValue = this.getAttributeValue();
        String other$attributeValue = other.getAttributeValue();
        if (this$attributeValue == null ? other$attributeValue != null : !this$attributeValue.equals(other$attributeValue)) {
            return false;
        }
        String this$oldAttributeValue = this.getOldAttributeValue();
        String other$oldAttributeValue = other.getOldAttributeValue();
        return !(this$oldAttributeValue == null ? other$oldAttributeValue != null : !this$oldAttributeValue.equals(other$oldAttributeValue));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddOrUpdateAnnotationAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addOnly = this.getAddOnly();
        result = result * 59 + ($addOnly == null ? 43 : ((Object)$addOnly).hashCode());
        Boolean $appendArray = this.getAppendArray();
        result = result * 59 + ($appendArray == null ? 43 : ((Object)$appendArray).hashCode());
        String $annotationType = this.getAnnotationType();
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $attributeValue = this.getAttributeValue();
        result = result * 59 + ($attributeValue == null ? 43 : $attributeValue.hashCode());
        String $oldAttributeValue = this.getOldAttributeValue();
        result = result * 59 + ($oldAttributeValue == null ? 43 : $oldAttributeValue.hashCode());
        return result;
    }

    private static final class AlreadyAppended
    implements Marker {
        private final UUID id;
        private final String values;

        @Generated
        public AlreadyAppended(UUID id, String values) {
            this.id = id;
            this.values = values;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getValues() {
            return this.values;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlreadyAppended)) {
                return false;
            }
            AlreadyAppended other = (AlreadyAppended)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$values = this.getValues();
            String other$values = other.getValues();
            return !(this$values == null ? other$values != null : !this$values.equals(other$values));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : $values.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddOrUpdateAnnotationAttribute.AlreadyAppended(id=" + this.getId() + ", values=" + this.getValues() + ")";
        }

        @NonNull
        @Generated
        public AlreadyAppended withId(UUID id) {
            return this.id == id ? this : new AlreadyAppended(id, this.values);
        }

        @NonNull
        @Generated
        public AlreadyAppended withValues(String values) {
            return this.values == values ? this : new AlreadyAppended(this.id, values);
        }
    }
}

