/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.rpc;

import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.rpc.Reference;
import org.openrewrite.rpc.RpcSendQueue;

public class JavaSender
extends JavaVisitor<RpcSendQueue> {
    public J preVisit(J j, RpcSendQueue q) {
        q.getAndSend((Object)j, Tree::getId);
        q.getAndSend((Object)j, J::getPrefix, space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        q.sendMarkers((Object)j, Tree::getMarkers);
        return j;
    }

    @Override
    public J visitAnnotation(J.Annotation annotation, RpcSendQueue q) {
        q.getAndSend((Object)annotation, J.Annotation::getAnnotationType, type -> this.visit((Tree)type, q));
        q.getAndSend((Object)annotation, a -> a.getPadding().getArguments(), args -> this.visitContainer((JContainer)args, q));
        return annotation;
    }

    @Override
    public J visitAnnotatedType(J.AnnotatedType annotatedType, RpcSendQueue q) {
        q.getAndSendList((Object)annotatedType, J.AnnotatedType::getAnnotations, Tree::getId, a -> this.visit((Tree)a, q));
        q.getAndSend((Object)annotatedType, J.AnnotatedType::getTypeExpression, t -> this.visit((Tree)t, q));
        return annotatedType;
    }

    @Override
    public J visitArrayAccess(J.ArrayAccess arrayAccess, RpcSendQueue q) {
        q.getAndSend((Object)arrayAccess, J.ArrayAccess::getIndexed, indexed -> this.visit((Tree)indexed, q));
        q.getAndSend((Object)arrayAccess, J.ArrayAccess::getDimension, dim -> this.visit((Tree)dim, q));
        return arrayAccess;
    }

    @Override
    public J visitArrayDimension(J.ArrayDimension arrayDimension, RpcSendQueue q) {
        q.getAndSend((Object)arrayDimension, a -> a.getPadding().getIndex(), idx -> this.visitRightPadded((JRightPadded)idx, q));
        return arrayDimension;
    }

    @Override
    public J visitArrayType(J.ArrayType arrayType, RpcSendQueue q) {
        q.getAndSend((Object)arrayType, J.ArrayType::getElementType, type -> this.visit((Tree)type, q));
        q.getAndSendList((Object)arrayType, J.ArrayType::getAnnotations, Tree::getId, a -> this.visit((Tree)a, q));
        q.getAndSend((Object)arrayType, J.ArrayType::getDimension, d -> this.visitLeftPadded((JLeftPadded)d, q));
        q.getAndSend((Object)arrayType, J.ArrayType::getType, type -> this.visitType((JavaType)type, q));
        return arrayType;
    }

    @Override
    public J visitAssert(J.Assert assertStmt, RpcSendQueue q) {
        q.getAndSend((Object)assertStmt, J.Assert::getCondition, cond -> this.visit((Tree)cond, q));
        q.getAndSend((Object)assertStmt, J.Assert::getDetail, detail -> this.visitLeftPadded((JLeftPadded)detail, q));
        return assertStmt;
    }

    @Override
    public J visitAssignment(J.Assignment assignment, RpcSendQueue q) {
        q.getAndSend((Object)assignment, J.Assignment::getVariable, variable -> this.visit((Tree)variable, q));
        q.getAndSend((Object)assignment, a -> a.getPadding().getAssignment(), assign -> this.visitLeftPadded((JLeftPadded)assign, q));
        q.getAndSend((Object)assignment, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return assignment;
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignmentOperation, RpcSendQueue q) {
        q.getAndSend((Object)assignmentOperation, J.AssignmentOperation::getVariable, variable -> this.visit((Tree)variable, q));
        q.getAndSend((Object)assignmentOperation, a -> a.getPadding().getOperator(), op -> this.visitLeftPadded((JLeftPadded)op, q));
        q.getAndSend((Object)assignmentOperation, J.AssignmentOperation::getAssignment, assign -> this.visit((Tree)assign, q));
        q.getAndSend((Object)assignmentOperation, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return assignmentOperation;
    }

    @Override
    public J visitBinary(J.Binary binary, RpcSendQueue q) {
        q.getAndSend((Object)binary, J.Binary::getLeft, left -> this.visit((Tree)left, q));
        q.getAndSend((Object)binary, b -> b.getPadding().getOperator(), op -> this.visitLeftPadded((JLeftPadded)op, q));
        q.getAndSend((Object)binary, J.Binary::getRight, right -> this.visit((Tree)right, q));
        q.getAndSend((Object)binary, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return binary;
    }

    @Override
    public J visitBlock(J.Block block, RpcSendQueue q) {
        q.getAndSend((Object)block, b -> b.getPadding().getStatic(), s -> this.visitRightPadded((JRightPadded)s, q));
        q.getAndSendList((Object)block, b -> b.getPadding().getStatements(), r -> ((Statement)r.getElement()).getId(), stmts -> this.visitRightPadded((JRightPadded)stmts, q));
        q.getAndSend((Object)block, J.Block::getEnd, space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        return block;
    }

    @Override
    public J visitBreak(J.Break breakStmt, RpcSendQueue q) {
        q.getAndSend((Object)breakStmt, J.Break::getLabel, label -> this.visit((Tree)label, q));
        return breakStmt;
    }

    @Override
    public J visitCase(J.Case caseStmt, RpcSendQueue q) {
        q.getAndSend((Object)caseStmt, J.Case::getType);
        q.getAndSend((Object)caseStmt, c -> c.getPadding().getCaseLabels(), labels -> this.visitContainer((JContainer)labels, q));
        q.getAndSend((Object)caseStmt, c -> c.getPadding().getStatements(), stmts -> this.visitContainer((JContainer)stmts, q));
        q.getAndSend((Object)caseStmt, c -> c.getPadding().getBody(), body -> this.visitRightPadded((JRightPadded)body, q));
        q.getAndSend((Object)caseStmt, J.Case::getGuard, guard -> this.visit((Tree)guard, q));
        return caseStmt;
    }

    @Override
    public J visitClassDeclaration(J.ClassDeclaration classDecl, RpcSendQueue q) {
        q.getAndSendList((Object)classDecl, J.ClassDeclaration::getLeadingAnnotations, Tree::getId, j -> this.visit((Tree)j, q));
        q.getAndSendList((Object)classDecl, J.ClassDeclaration::getModifiers, Tree::getId, j -> this.visit((Tree)j, q));
        q.getAndSend((Object)classDecl, c -> c.getPadding().getKind(), k -> this.visitClassDeclarationKind((J.ClassDeclaration.Kind)k, q));
        q.getAndSend((Object)classDecl, J.ClassDeclaration::getName, j -> this.visit((Tree)j, q));
        q.getAndSend((Object)classDecl, c -> c.getPadding().getTypeParameters(), tp -> this.visitContainer((JContainer)tp, q));
        q.getAndSend((Object)classDecl, c -> c.getPadding().getPrimaryConstructor(), ctor -> this.visitContainer((JContainer)ctor, q));
        q.getAndSend((Object)classDecl, c -> c.getPadding().getExtends(), ext -> this.visitLeftPadded((JLeftPadded)ext, q));
        q.getAndSend((Object)classDecl, c -> c.getPadding().getImplements(), impl -> this.visitContainer((JContainer)impl, q));
        q.getAndSend((Object)classDecl, c -> c.getPadding().getPermits(), impl -> this.visitContainer((JContainer)impl, q));
        q.getAndSend((Object)classDecl, J.ClassDeclaration::getBody, j -> this.visit((Tree)j, q));
        return classDecl;
    }

    private void visitClassDeclarationKind(J.ClassDeclaration.Kind kind, RpcSendQueue q) {
        this.preVisit(kind, q);
        q.getAndSendList((Object)kind, J.ClassDeclaration.Kind::getAnnotations, Tree::getId, j -> this.visit((Tree)j, q));
        q.getAndSend((Object)kind, J.ClassDeclaration.Kind::getType);
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, RpcSendQueue q) {
        q.getAndSend((Object)cu, c -> c.getSourcePath().toString());
        q.getAndSend((Object)cu, c -> c.getCharset().name());
        q.getAndSend((Object)cu, J.CompilationUnit::isCharsetBomMarked);
        q.getAndSend((Object)cu, J.CompilationUnit::getChecksum);
        q.getAndSend((Object)cu, J.CompilationUnit::getFileAttributes);
        q.getAndSend((Object)cu, c -> c.getPadding().getPackageDeclaration(), pkg -> this.visitRightPadded((JRightPadded)pkg, q));
        q.getAndSendList((Object)cu, c -> c.getPadding().getImports(), r -> ((J.Import)r.getElement()).getId(), j -> this.visitRightPadded((JRightPadded)j, q));
        q.getAndSendList((Object)cu, J.CompilationUnit::getClasses, Tree::getId, j -> this.visit((Tree)j, q));
        q.getAndSend((Object)cu, J.CompilationUnit::getEof, space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        return cu;
    }

    @Override
    public J visitContinue(J.Continue continueStmt, RpcSendQueue q) {
        q.getAndSend((Object)continueStmt, J.Continue::getLabel, label -> this.visit((Tree)label, q));
        return continueStmt;
    }

    @Override
    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, RpcSendQueue q) {
        q.getAndSend(controlParens, c -> c.getPadding().getTree(), tree -> this.visitRightPadded((JRightPadded)tree, q));
        return controlParens;
    }

    @Override
    public J visitDeconstructionPattern(J.DeconstructionPattern deconstructionPattern, RpcSendQueue q) {
        q.getAndSend((Object)deconstructionPattern, J.DeconstructionPattern::getDeconstructor, dec -> this.visit((Tree)dec, q));
        q.getAndSend((Object)deconstructionPattern, dp -> dp.getPadding().getNested(), nested -> this.visitContainer((JContainer)nested, q));
        q.getAndSend((Object)deconstructionPattern, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return deconstructionPattern;
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, RpcSendQueue q) {
        q.getAndSend((Object)doWhileLoop, d -> d.getPadding().getBody(), body -> this.visitRightPadded((JRightPadded)body, q));
        q.getAndSend((Object)doWhileLoop, d -> d.getPadding().getWhileCondition(), cond -> this.visitLeftPadded((JLeftPadded)cond, q));
        return doWhileLoop;
    }

    @Override
    public J visitElse(J.If.Else anElse, RpcSendQueue q) {
        q.getAndSend((Object)anElse, e -> e.getPadding().getBody(), body -> this.visitRightPadded((JRightPadded)body, q));
        return anElse;
    }

    @Override
    public J visitEmpty(J.Empty empty, RpcSendQueue q) {
        return empty;
    }

    @Override
    public J visitEnumValue(J.EnumValue enumValue, RpcSendQueue q) {
        q.getAndSendList((Object)enumValue, J.EnumValue::getAnnotations, Tree::getId, a -> this.visit((Tree)a, q));
        q.getAndSend((Object)enumValue, J.EnumValue::getName, name -> this.visit((Tree)name, q));
        q.getAndSend((Object)enumValue, J.EnumValue::getInitializer, init -> this.visit((Tree)init, q));
        return enumValue;
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enumValueSet, RpcSendQueue q) {
        q.getAndSendList((Object)enumValueSet, e -> e.getPadding().getEnums(), r -> ((J.EnumValue)r.getElement()).getId(), e -> this.visitRightPadded((JRightPadded)e, q));
        q.getAndSend((Object)enumValueSet, J.EnumValueSet::isTerminatedWithSemicolon);
        return enumValueSet;
    }

    @Override
    public J visitErroneous(J.Erroneous erroneous, RpcSendQueue q) {
        q.getAndSend((Object)erroneous, J.Erroneous::getText);
        return erroneous;
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess, RpcSendQueue q) {
        q.getAndSend((Object)fieldAccess, J.FieldAccess::getTarget, t -> this.visit((Tree)t, q));
        q.getAndSend((Object)fieldAccess, f -> f.getPadding().getName(), name -> this.visitLeftPadded((JLeftPadded)name, q));
        q.getAndSend((Object)fieldAccess, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return fieldAccess;
    }

    @Override
    public J visitForEachControl(J.ForEachLoop.Control control, RpcSendQueue q) {
        q.getAndSend((Object)control, c -> c.getPadding().getVariable(), variable -> this.visitRightPadded((JRightPadded)variable, q));
        q.getAndSend((Object)control, c -> c.getPadding().getIterable(), iterable -> this.visitRightPadded((JRightPadded)iterable, q));
        return control;
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forEachLoop, RpcSendQueue q) {
        q.getAndSend((Object)forEachLoop, J.ForEachLoop::getControl, control -> this.visit((Tree)control, q));
        q.getAndSend((Object)forEachLoop, f -> f.getPadding().getBody(), body -> this.visitRightPadded((JRightPadded)body, q));
        return forEachLoop;
    }

    @Override
    public J visitForControl(J.ForLoop.Control control, RpcSendQueue q) {
        q.getAndSendList((Object)control, c -> c.getPadding().getInit(), r -> ((Statement)r.getElement()).getId(), init -> this.visitRightPadded((JRightPadded)init, q));
        q.getAndSend((Object)control, c -> c.getPadding().getCondition(), cond -> this.visitRightPadded((JRightPadded)cond, q));
        q.getAndSendList((Object)control, c -> c.getPadding().getUpdate(), r -> ((Statement)r.getElement()).getId(), update -> this.visitRightPadded((JRightPadded)update, q));
        return control;
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop, RpcSendQueue q) {
        q.getAndSend((Object)forLoop, J.ForLoop::getControl, control -> this.visit((Tree)control, q));
        q.getAndSend((Object)forLoop, f -> f.getPadding().getBody(), body -> this.visitRightPadded((JRightPadded)body, q));
        return forLoop;
    }

    @Override
    public J visitIdentifier(J.Identifier identifier, RpcSendQueue q) {
        q.getAndSendList((Object)identifier, J.Identifier::getAnnotations, Tree::getId, a -> this.visit((Tree)a, q));
        q.getAndSend((Object)identifier, J.Identifier::getSimpleName);
        q.getAndSend((Object)identifier, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        q.getAndSend((Object)identifier, a -> Reference.asRef((Object)a.getFieldType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return identifier;
    }

    @Override
    public J visitIf(J.If iff, RpcSendQueue q) {
        q.getAndSend((Object)iff, J.If::getIfCondition, cond -> this.visit((Tree)cond, q));
        q.getAndSend((Object)iff, i -> i.getPadding().getThenPart(), thenPart -> this.visitRightPadded((JRightPadded)thenPart, q));
        q.getAndSend((Object)iff, J.If::getElsePart, elsePart -> this.visit((Tree)elsePart, q));
        return iff;
    }

    @Override
    public J visitImport(J.Import importStmt, RpcSendQueue q) {
        q.getAndSend((Object)importStmt, i -> i.getPadding().getStatic(), s -> this.visitLeftPadded((JLeftPadded)s, q));
        q.getAndSend((Object)importStmt, J.Import::getQualid, id -> this.visit((Tree)id, q));
        q.getAndSend((Object)importStmt, i -> i.getPadding().getAlias(), alias -> this.visitLeftPadded((JLeftPadded)alias, q));
        return importStmt;
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, RpcSendQueue q) {
        q.getAndSend((Object)instanceOf, i -> i.getPadding().getExpression(), expr -> this.visitRightPadded((JRightPadded)expr, q));
        q.getAndSend((Object)instanceOf, J.InstanceOf::getClazz, clazz -> this.visit((Tree)clazz, q));
        q.getAndSend((Object)instanceOf, J.InstanceOf::getPattern, pattern -> this.visit((Tree)pattern, q));
        q.getAndSend((Object)instanceOf, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        q.getAndSend((Object)instanceOf, J.InstanceOf::getModifier, modifier -> this.visit((Tree)modifier, q));
        return instanceOf;
    }

    @Override
    public J visitIntersectionType(J.IntersectionType intersectionType, RpcSendQueue q) {
        q.getAndSend((Object)intersectionType, i -> i.getPadding().getBounds(), bounds -> this.visitContainer((JContainer)bounds, q));
        q.getAndSend((Object)intersectionType, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return intersectionType;
    }

    @Override
    public J visitLabel(J.Label label, RpcSendQueue q) {
        q.getAndSend((Object)label, l -> l.getPadding().getLabel(), lbl -> this.visitRightPadded((JRightPadded)lbl, q));
        q.getAndSend((Object)label, J.Label::getStatement, stmt -> this.visit((Tree)stmt, q));
        return label;
    }

    @Override
    public J visitLambda(J.Lambda lambda, RpcSendQueue q) {
        q.getAndSend((Object)lambda, J.Lambda::getParameters, params -> this.visit((Tree)params, q));
        q.getAndSend((Object)lambda, J.Lambda::getArrow, arrow -> this.visitSpace((Space)arrow, q));
        q.getAndSend((Object)lambda, J.Lambda::getBody, body -> this.visit((Tree)body, q));
        q.getAndSend((Object)lambda, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return lambda;
    }

    @Override
    public J visitLambdaParameters(J.Lambda.Parameters parameters, RpcSendQueue q) {
        q.getAndSend((Object)parameters, J.Lambda.Parameters::isParenthesized);
        q.getAndSendList((Object)parameters, p -> p.getPadding().getParameters(), r -> ((J)r.getElement()).getId(), param -> this.visitRightPadded((JRightPadded)param, q));
        return parameters;
    }

    @Override
    public J visitLiteral(J.Literal literal, RpcSendQueue q) {
        q.getAndSend((Object)literal, J.Literal::getValue);
        q.getAndSend((Object)literal, J.Literal::getValueSource);
        q.getAndSendList((Object)literal, J.Literal::getUnicodeEscapes, s -> s.getValueSourceIndex() + s.getCodePoint(), s -> {});
        q.getAndSend((Object)literal, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return literal;
    }

    @Override
    public J visitMemberReference(J.MemberReference memberReference, RpcSendQueue q) {
        q.getAndSend((Object)memberReference, m -> m.getPadding().getContaining(), containing -> this.visitRightPadded((JRightPadded)containing, q));
        q.getAndSend((Object)memberReference, m -> m.getPadding().getTypeParameters(), typeParams -> this.visitContainer((JContainer)typeParams, q));
        q.getAndSend((Object)memberReference, m -> m.getPadding().getReference(), ref -> this.visitLeftPadded((JLeftPadded)ref, q));
        q.getAndSend((Object)memberReference, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        q.getAndSend((Object)memberReference, m -> Reference.asRef((Object)m.getMethodType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        q.getAndSend((Object)memberReference, m -> Reference.asRef((Object)m.getVariableType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return memberReference;
    }

    @Override
    public J visitMethodDeclaration(J.MethodDeclaration method, RpcSendQueue q) {
        q.getAndSendList((Object)method, J.MethodDeclaration::getLeadingAnnotations, Tree::getId, a -> this.visit((Tree)a, q));
        q.getAndSendList((Object)method, J.MethodDeclaration::getModifiers, Tree::getId, m -> this.visit((Tree)m, q));
        q.getAndSend((Object)method, m -> m.getPadding().getTypeParameters(), params -> this.visit((Tree)params, q));
        q.getAndSend((Object)method, J.MethodDeclaration::getReturnTypeExpression, type -> this.visit((Tree)type, q));
        q.getAndSendList((Object)method, m -> m.getAnnotations().getName().getAnnotations(), J.Annotation::getId, name -> this.visit((Tree)name, q));
        q.getAndSend((Object)method, J.MethodDeclaration::getName, name -> this.visit((Tree)name, q));
        q.getAndSend((Object)method, m -> m.getPadding().getParameters(), params -> this.visitContainer((JContainer)params, q));
        q.getAndSend((Object)method, m -> m.getPadding().getThrows(), thr -> this.visitContainer((JContainer)thr, q));
        q.getAndSend((Object)method, J.MethodDeclaration::getBody, body -> this.visit((Tree)body, q));
        q.getAndSend((Object)method, m -> m.getPadding().getDefaultValue(), def -> this.visitLeftPadded((JLeftPadded)def, q));
        q.getAndSend((Object)method, a -> Reference.asRef((Object)a.getMethodType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return method;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation methodInvocation, RpcSendQueue q) {
        q.getAndSend((Object)methodInvocation, m -> m.getPadding().getSelect(), select -> this.visitRightPadded((JRightPadded)select, q));
        q.getAndSend((Object)methodInvocation, m -> m.getPadding().getTypeParameters(), typeParams -> this.visitContainer((JContainer)typeParams, q));
        q.getAndSend((Object)methodInvocation, J.MethodInvocation::getName, name -> this.visit((Tree)name, q));
        q.getAndSend((Object)methodInvocation, m -> m.getPadding().getArguments(), args -> this.visitContainer((JContainer)args, q));
        q.getAndSend((Object)methodInvocation, m -> Reference.asRef((Object)m.getMethodType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return methodInvocation;
    }

    @Override
    public J visitModifier(J.Modifier modifier, RpcSendQueue q) {
        q.getAndSend((Object)modifier, J.Modifier::getKeyword);
        q.getAndSend((Object)modifier, J.Modifier::getType);
        q.getAndSendList((Object)modifier, J.Modifier::getAnnotations, J.Annotation::getId, annot -> this.visit((Tree)annot, q));
        return modifier;
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch, RpcSendQueue q) {
        q.getAndSendList((Object)multiCatch, m -> m.getPadding().getAlternatives(), r -> ((NameTree)r.getElement()).getId(), alt -> this.visitRightPadded((JRightPadded)alt, q));
        return multiCatch;
    }

    @Override
    public J visitNewArray(J.NewArray newArray, RpcSendQueue q) {
        q.getAndSend((Object)newArray, J.NewArray::getTypeExpression, type -> this.visit((Tree)type, q));
        q.getAndSendList((Object)newArray, J.NewArray::getDimensions, Tree::getId, dim -> this.visit((Tree)dim, q));
        q.getAndSend((Object)newArray, n -> n.getPadding().getInitializer(), init -> this.visitContainer((JContainer)init, q));
        q.getAndSend((Object)newArray, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return newArray;
    }

    @Override
    public J visitNewClass(J.NewClass newClass, RpcSendQueue q) {
        q.getAndSend((Object)newClass, n -> n.getPadding().getEnclosing(), enclosing -> this.visitRightPadded((JRightPadded)enclosing, q));
        q.getAndSend((Object)newClass, J.NewClass::getNew, n -> this.visitSpace((Space)n, q));
        q.getAndSend((Object)newClass, J.NewClass::getClazz, clazz -> this.visit((Tree)clazz, q));
        q.getAndSend((Object)newClass, n -> n.getPadding().getArguments(), args -> this.visitContainer((JContainer)args, q));
        q.getAndSend((Object)newClass, J.NewClass::getBody, body -> this.visit((Tree)body, q));
        q.getAndSend((Object)newClass, n -> Reference.asRef((Object)n.getConstructorType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return newClass;
    }

    @Override
    public J visitNullableType(J.NullableType nullableType, RpcSendQueue q) {
        q.getAndSendList((Object)nullableType, J.NullableType::getAnnotations, J.Annotation::getId, annot -> this.visit((Tree)annot, q));
        q.getAndSend((Object)nullableType, n -> n.getPadding().getTypeTree(), type -> this.visitRightPadded((JRightPadded)type, q));
        return nullableType;
    }

    @Override
    public J visitPackage(J.Package pkg, RpcSendQueue q) {
        q.getAndSend((Object)pkg, J.Package::getExpression, expr -> this.visit((Tree)expr, q));
        q.getAndSendList((Object)pkg, J.Package::getAnnotations, Tree::getId, a -> this.visit((Tree)a, q));
        return pkg;
    }

    @Override
    public J visitParameterizedType(J.ParameterizedType type, RpcSendQueue q) {
        q.getAndSend((Object)type, J.ParameterizedType::getClazz, clazz -> this.visit((Tree)clazz, q));
        q.getAndSend((Object)type, t -> t.getPadding().getTypeParameters(), params -> this.visitContainer((JContainer)params, q));
        q.getAndSend((Object)type, t -> Reference.asRef((Object)t.getType()), t -> this.visitType((JavaType)Reference.getValueNonNull((Object)t), q));
        return type;
    }

    @Override
    public J visitParenthesizedTypeTree(J.ParenthesizedTypeTree parenthesizedType, RpcSendQueue q) {
        q.getAndSendList((Object)parenthesizedType, J.ParenthesizedTypeTree::getAnnotations, Tree::getId, a -> this.visit((Tree)a, q));
        q.getAndSend((Object)parenthesizedType, J.ParenthesizedTypeTree::getParenthesizedType, tree -> this.visit((Tree)tree, q));
        return parenthesizedType;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parentheses, RpcSendQueue q) {
        q.getAndSend(parentheses, p -> p.getPadding().getTree(), tree -> this.visitRightPadded((JRightPadded)tree, q));
        return parentheses;
    }

    @Override
    public J visitPrimitive(J.Primitive primitive, RpcSendQueue q) {
        q.getAndSend((Object)primitive, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return primitive;
    }

    @Override
    public J visitReturn(J.Return aReturn, RpcSendQueue q) {
        q.getAndSend((Object)aReturn, J.Return::getExpression, r -> this.visit((Tree)r, q));
        return aReturn;
    }

    @Override
    public J visitSwitch(J.Switch switchStmt, RpcSendQueue q) {
        q.getAndSend((Object)switchStmt, J.Switch::getSelector, selector -> this.visit((Tree)selector, q));
        q.getAndSend((Object)switchStmt, J.Switch::getCases, cases -> this.visit((Tree)cases, q));
        return switchStmt;
    }

    @Override
    public J visitSwitchExpression(J.SwitchExpression switchExpression, RpcSendQueue q) {
        q.getAndSend((Object)switchExpression, J.SwitchExpression::getSelector, selector -> this.visit((Tree)selector, q));
        q.getAndSend((Object)switchExpression, J.SwitchExpression::getCases, cases -> this.visit((Tree)cases, q));
        q.getAndSend((Object)switchExpression, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return switchExpression;
    }

    @Override
    public J visitSynchronized(J.Synchronized synch, RpcSendQueue q) {
        q.getAndSend((Object)synch, J.Synchronized::getLock, lock -> this.visit((Tree)lock, q));
        q.getAndSend((Object)synch, J.Synchronized::getBody, body -> this.visit((Tree)body, q));
        return synch;
    }

    @Override
    public J visitTernary(J.Ternary ternary, RpcSendQueue q) {
        q.getAndSend((Object)ternary, J.Ternary::getCondition, cond -> this.visit((Tree)cond, q));
        q.getAndSend((Object)ternary, t -> t.getPadding().getTruePart(), truePart -> this.visitLeftPadded((JLeftPadded)truePart, q));
        q.getAndSend((Object)ternary, t -> t.getPadding().getFalsePart(), falsePart -> this.visitLeftPadded((JLeftPadded)falsePart, q));
        q.getAndSend((Object)ternary, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return ternary;
    }

    @Override
    public J visitThrow(J.Throw throwStmt, RpcSendQueue q) {
        q.getAndSend((Object)throwStmt, J.Throw::getException, ex -> this.visit((Tree)ex, q));
        return throwStmt;
    }

    @Override
    public J visitTry(J.Try tryStmt, RpcSendQueue q) {
        q.getAndSend((Object)tryStmt, t -> t.getPadding().getResources(), resources -> this.visitContainer((JContainer)resources, q));
        q.getAndSend((Object)tryStmt, J.Try::getBody, body -> this.visit((Tree)body, q));
        q.getAndSendList((Object)tryStmt, J.Try::getCatches, Tree::getId, c -> this.visit((Tree)c, q));
        q.getAndSend((Object)tryStmt, t -> t.getPadding().getFinally(), fin -> this.visitLeftPadded((JLeftPadded)fin, q));
        return tryStmt;
    }

    @Override
    public J visitTypeCast(J.TypeCast typeCast, RpcSendQueue q) {
        q.getAndSend((Object)typeCast, J.TypeCast::getClazz, clazz -> this.visit((Tree)clazz, q));
        q.getAndSend((Object)typeCast, J.TypeCast::getExpression, expr -> this.visit((Tree)expr, q));
        return typeCast;
    }

    @Override
    public J visitTypeParameter(J.TypeParameter typeParam, RpcSendQueue q) {
        q.getAndSendList((Object)typeParam, J.TypeParameter::getAnnotations, J.Annotation::getId, annot -> this.visit((Tree)annot, q));
        q.getAndSendList((Object)typeParam, J.TypeParameter::getModifiers, Tree::getId, mod -> this.visit((Tree)mod, q));
        q.getAndSend((Object)typeParam, J.TypeParameter::getName, name -> this.visit((Tree)name, q));
        q.getAndSend((Object)typeParam, t -> t.getPadding().getBounds(), bounds -> this.visitContainer((JContainer)bounds, q));
        return typeParam;
    }

    @Override
    public J visitTypeParameters(J.TypeParameters typeParameters, RpcSendQueue q) {
        q.getAndSendList((Object)typeParameters, J.TypeParameters::getAnnotations, J.Annotation::getId, annot -> this.visit((Tree)annot, q));
        q.getAndSendList((Object)typeParameters, t -> t.getPadding().getTypeParameters(), r -> ((J.TypeParameter)r.getElement()).getId(), mod -> this.visitRightPadded((JRightPadded)mod, q));
        return typeParameters;
    }

    @Override
    public J visitCatch(J.Try.Catch tryCatch, RpcSendQueue q) {
        q.getAndSend((Object)tryCatch, J.Try.Catch::getParameter, param -> this.visit((Tree)param, q));
        q.getAndSend((Object)tryCatch, J.Try.Catch::getBody, body -> this.visit((Tree)body, q));
        return tryCatch;
    }

    @Override
    public J visitTryResource(J.Try.Resource tryResource, RpcSendQueue q) {
        q.getAndSend((Object)tryResource, J.Try.Resource::getVariableDeclarations, vars -> this.visit((Tree)vars, q));
        q.getAndSend((Object)tryResource, J.Try.Resource::isTerminatedWithSemicolon);
        return tryResource;
    }

    @Override
    public J visitUnary(J.Unary unary, RpcSendQueue q) {
        q.getAndSend((Object)unary, u -> u.getPadding().getOperator(), op -> this.visitLeftPadded((JLeftPadded)op, q));
        q.getAndSend((Object)unary, J.Unary::getExpression, expr -> this.visit((Tree)expr, q));
        q.getAndSend((Object)unary, a -> Reference.asRef((Object)a.getType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return unary;
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, RpcSendQueue q) {
        q.getAndSend((Object)variable, J.VariableDeclarations.NamedVariable::getDeclarator, decl -> this.visit((Tree)decl, q));
        q.getAndSendList((Object)variable, J.VariableDeclarations.NamedVariable::getDimensionsAfterName, l -> ((Space)l.getElement()).toString(), dim -> this.visitLeftPadded((JLeftPadded)dim, q));
        q.getAndSend((Object)variable, n -> n.getPadding().getInitializer(), init -> this.visitLeftPadded((JLeftPadded)init, q));
        q.getAndSend((Object)variable, a -> Reference.asRef((Object)a.getVariableType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return variable;
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations variableDeclarations, RpcSendQueue q) {
        q.getAndSendList((Object)variableDeclarations, J.VariableDeclarations::getLeadingAnnotations, Tree::getId, a -> this.visit((Tree)a, q));
        q.getAndSendList((Object)variableDeclarations, J.VariableDeclarations::getModifiers, Tree::getId, m -> this.visit((Tree)m, q));
        q.getAndSend((Object)variableDeclarations, J.VariableDeclarations::getTypeExpression, type -> this.visit((Tree)type, q));
        q.getAndSend((Object)variableDeclarations, J.VariableDeclarations::getVarargs, space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        q.getAndSendList((Object)variableDeclarations, v -> v.getPadding().getVariables(), r -> ((J.VariableDeclarations.NamedVariable)r.getElement()).getId(), v -> this.visitRightPadded((JRightPadded)v, q));
        return variableDeclarations;
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, RpcSendQueue q) {
        q.getAndSend((Object)whileLoop, J.WhileLoop::getCondition, cond -> this.visit((Tree)cond, q));
        q.getAndSend((Object)whileLoop, w -> w.getPadding().getBody(), body -> this.visitRightPadded((JRightPadded)body, q));
        return whileLoop;
    }

    @Override
    public J visitWildcard(J.Wildcard wildcard, RpcSendQueue q) {
        q.getAndSend((Object)wildcard, w -> w.getPadding().getBound(), bound -> this.visitLeftPadded((JLeftPadded)bound, q));
        q.getAndSend((Object)wildcard, J.Wildcard::getBoundedType, type -> this.visit((Tree)type, q));
        return wildcard;
    }

    @Override
    public J visitYield(J.Yield yieldStmt, RpcSendQueue q) {
        q.getAndSend((Object)yieldStmt, J.Yield::isImplicit);
        q.getAndSend((Object)yieldStmt, J.Yield::getValue, value -> this.visit((Tree)value, q));
        return yieldStmt;
    }

    public <T> void visitLeftPadded(JLeftPadded<T> left, RpcSendQueue q) {
        q.getAndSend(left, JLeftPadded::getBefore, space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        Object element = left.getElement();
        if (element instanceof J) {
            q.getAndSend(left, JLeftPadded::getElement, elem -> this.visit((J)elem, q));
        } else if (element instanceof Space) {
            q.getAndSend(left, r -> element, space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        } else {
            q.getAndSend(left, JLeftPadded::getElement);
        }
        q.sendMarkers(left, JLeftPadded::getMarkers);
    }

    public <T> void visitRightPadded(JRightPadded<T> right, RpcSendQueue q) {
        Object element = right.getElement();
        if (element instanceof J) {
            q.getAndSend(right, JRightPadded::getElement, elem -> this.visit((J)elem, q));
        } else if (element instanceof Space) {
            q.getAndSend(right, r -> element, space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        } else {
            q.getAndSend(right, JRightPadded::getElement);
        }
        q.getAndSend(right, JRightPadded::getAfter, space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        q.sendMarkers(right, JRightPadded::getMarkers);
    }

    public <J2 extends J> void visitContainer(JContainer<J2> container, RpcSendQueue q) {
        q.getAndSend(container, JContainer::getBefore, space -> this.visitSpace((Space)Reference.getValueNonNull((Object)space), q));
        q.getAndSendList(container, c -> c.getPadding().getElements(), e -> ((J)e.getElement()).getId(), e -> this.visitRightPadded((JRightPadded)e, q));
        q.sendMarkers(container, JContainer::getMarkers);
    }

    public void visitSpace(Space space, RpcSendQueue q) {
        q.getAndSendList((Object)space, Space::getComments, c -> {
            if (c instanceof TextComment) {
                return ((TextComment)c).getText() + c.getSuffix();
            }
            if (c instanceof Javadoc.DocComment) {
                return ((Javadoc.DocComment)c).getId();
            }
            throw new IllegalArgumentException("Unexpected comment type " + c.getClass().getName());
        }, c -> {
            if (!(c instanceof TextComment)) {
                throw new IllegalArgumentException("Unexpected comment type " + c.getClass().getName());
            }
            TextComment tc = (TextComment)c;
            q.getAndSend((Object)tc, TextComment::isMultiline);
            q.getAndSend((Object)tc, TextComment::getText);
            q.getAndSend(c, Comment::getSuffix);
            q.sendMarkers(c, Comment::getMarkers);
        });
        q.getAndSend((Object)space, Space::getWhitespace);
    }
}

