/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.naming;

import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public abstract class AbstractNameCheck
extends AbstractCheck {
    public static final String MSG_INVALID_PATTERN = "name.invalidPattern";
    private Pattern format;

    protected AbstractNameCheck(String format) {
        this.format = CommonUtil.createPattern(format);
    }

    protected abstract boolean mustCheckName(DetailAST var1);

    public final void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nameAST;
        if (this.mustCheckName(ast) && !this.format.matcher((nameAST = ast.findFirstToken(58)).getText()).find()) {
            this.log(nameAST, MSG_INVALID_PATTERN, nameAST.getText(), this.format.pattern());
        }
    }
}

