/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;

public class TypesInUse {
    private final JavaSourceFile cu;
    private final Set<JavaType> typesInUse;
    private final Set<JavaType.Method> declaredMethods;
    private final Set<JavaType.Method> usedMethods;
    private final Set<JavaType.Variable> variables;

    public static TypesInUse build(JavaSourceFile cu) {
        FindTypesInUse findTypesInUse = new FindTypesInUse();
        findTypesInUse.visit(cu, 0);
        return new TypesInUse(cu, findTypesInUse.getTypes(), findTypesInUse.getDeclaredMethods(), findTypesInUse.getUsedMethods(), findTypesInUse.getVariables());
    }

    @Generated
    private TypesInUse(JavaSourceFile cu, Set<JavaType> typesInUse, Set<JavaType.Method> declaredMethods, Set<JavaType.Method> usedMethods, Set<JavaType.Variable> variables) {
        this.cu = cu;
        this.typesInUse = typesInUse;
        this.declaredMethods = declaredMethods;
        this.usedMethods = usedMethods;
        this.variables = variables;
    }

    @Generated
    public JavaSourceFile getCu() {
        return this.cu;
    }

    @Generated
    public Set<JavaType> getTypesInUse() {
        return this.typesInUse;
    }

    @Generated
    public Set<JavaType.Method> getDeclaredMethods() {
        return this.declaredMethods;
    }

    @Generated
    public Set<JavaType.Method> getUsedMethods() {
        return this.usedMethods;
    }

    @Generated
    public Set<JavaType.Variable> getVariables() {
        return this.variables;
    }

    public static class FindTypesInUse
    extends JavaIsoVisitor<Integer> {
        private final Set<JavaType> types = Collections.newSetFromMap(new IdentityHashMap());
        private final Set<JavaType.Method> declaredMethods = Collections.newSetFromMap(new IdentityHashMap());
        private final Set<JavaType.Method> usedMethods = Collections.newSetFromMap(new IdentityHashMap());
        private final Set<JavaType.Variable> variables = Collections.newSetFromMap(new IdentityHashMap());

        @Override
        public J.Import visitImport(J.Import _import, Integer p) {
            return _import;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, Integer p) {
            Object parent = Objects.requireNonNull(this.getCursor().getParent()).getValue();
            if (parent instanceof J.ClassDeclaration) {
                return identifier;
            }
            if (parent instanceof J.MethodDeclaration && ((J.MethodDeclaration)parent).getName() == identifier) {
                return identifier;
            }
            return super.visitIdentifier(identifier, p);
        }

        @Override
        public @Nullable JavaType visitType(@Nullable JavaType javaType, Integer p) {
            if (javaType != null && !(javaType instanceof JavaType.Unknown)) {
                Cursor cursor = this.getCursor();
                if (javaType instanceof JavaType.Variable) {
                    this.variables.add((JavaType.Variable)javaType);
                } else if (javaType instanceof JavaType.Method) {
                    if (cursor.getValue() instanceof J.MethodDeclaration) {
                        this.declaredMethods.add((JavaType.Method)javaType);
                    } else {
                        this.usedMethods.add((JavaType.Method)javaType);
                    }
                } else if (!(cursor.getValue() instanceof J.ClassDeclaration) && !(cursor.getValue() instanceof J.Lambda)) {
                    this.types.add(javaType);
                }
            }
            return javaType;
        }

        @Generated
        public Set<JavaType> getTypes() {
            return this.types;
        }

        @Generated
        public Set<JavaType.Method> getDeclaredMethods() {
            return this.declaredMethods;
        }

        @Generated
        public Set<JavaType.Method> getUsedMethods() {
            return this.usedMethods;
        }

        @Generated
        public Set<JavaType.Variable> getVariables() {
            return this.variables;
        }
    }
}

