/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;

public class RemoveMethodInvocationsVisitor
extends JavaVisitor<ExecutionContext> {
    private final Map<MethodMatcher, Predicate<List<Expression>>> matchers;

    public RemoveMethodInvocationsVisitor(Map<MethodMatcher, Predicate<List<Expression>>> matchers) {
        this.matchers = matchers;
    }

    public RemoveMethodInvocationsVisitor(List<String> methodSignatures) {
        this(methodSignatures.stream().collect(Collectors.toMap(MethodMatcher::new, signature -> args -> true)));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
        J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, ctx);
        if (this.inMethodCallChain()) {
            List newArgs = ListUtils.map(m.getArguments(), arg -> (Expression)this.visit((Tree)arg, ctx));
            return m.withArguments(newArgs);
        }
        J j = this.removeMethods(m, 0, this.isLambdaBody(), new Stack<Space>());
        if (j != null) {
            j = j.withPrefix(m.getPrefix());
            if (!m.getArguments().isEmpty() && m.getArguments().stream().allMatch(ToBeRemoved::hasMarker)) {
                return ToBeRemoved.withMarker(j);
            }
        }
        return j;
    }

    private @Nullable J removeMethods(Expression expression, int depth, boolean isLambdaBody, Stack<Space> selectAfter) {
        if (!(expression instanceof J.MethodInvocation)) {
            return expression;
        }
        boolean isStatement = this.isStatement();
        J.MethodInvocation m = (J.MethodInvocation)expression;
        if (m.getMethodType() == null || m.getSelect() == null) {
            return expression;
        }
        if (this.matchers.entrySet().stream().anyMatch(entry -> this.matches(m, (MethodMatcher)entry.getKey(), (Predicate)entry.getValue()))) {
            boolean removable;
            boolean hasSameReturnType = TypeUtils.isAssignableTo(m.getMethodType().getReturnType(), m.getSelect().getType());
            boolean bl = removable = isStatement && depth == 0 || hasSameReturnType;
            if (!removable) {
                return expression;
            }
            if (m.getSelect() instanceof J.Identifier || m.getSelect() instanceof J.NewClass) {
                boolean keepSelect;
                boolean bl2 = keepSelect = depth != 0;
                if (keepSelect) {
                    selectAfter.add(this.getSelectAfter(m));
                    return m.getSelect();
                }
                if (isStatement) {
                    return null;
                }
                if (isLambdaBody) {
                    return ToBeRemoved.withMarker(J.Block.createEmptyBlock());
                }
                return m.getSelect();
            }
            if (m.getSelect() instanceof J.MethodInvocation) {
                return this.removeMethods(m.getSelect(), depth, isLambdaBody, selectAfter);
            }
        }
        J.MethodInvocation method = m.withSelect((Expression)this.removeMethods(m.getSelect(), depth + 1, isLambdaBody, selectAfter));
        if (!selectAfter.isEmpty()) {
            method = this.inheritSelectAfter(method, selectAfter);
        }
        return method;
    }

    private boolean matches(J.MethodInvocation m, MethodMatcher matcher, Predicate<List<Expression>> argsMatches) {
        return matcher.matches(m) && argsMatches.test(m.getArguments());
    }

    private boolean isStatement() {
        return this.getCursor().dropParentUntil(p -> p instanceof J.Block || p instanceof J.Assignment || p instanceof J.VariableDeclarations.NamedVariable || p instanceof J.Return || p instanceof JContainer || p == "root").getValue() instanceof J.Block;
    }

    private boolean isLambdaBody() {
        if (this.getCursor().getParent() == null) {
            return false;
        }
        Object parent = this.getCursor().getParent().getValue();
        return parent instanceof J.Lambda && ((J.Lambda)parent).getBody() == this.getCursor().getValue();
    }

    private boolean inMethodCallChain() {
        return this.getCursor().dropParentUntil(p -> !(p instanceof JRightPadded)).getValue() instanceof J.MethodInvocation;
    }

    private J.MethodInvocation inheritSelectAfter(J.MethodInvocation method, final Stack<Space> prefix) {
        return (J.MethodInvocation)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, ExecutionContext executionContext) {
                if (right == null) {
                    return null;
                }
                return prefix.isEmpty() ? right : right.withAfter((Space)prefix.pop());
            }
        }.visitNonNull(method, new InMemoryExecutionContext());
    }

    private Space getSelectAfter(J.MethodInvocation method) {
        return (Space)((List)new JavaIsoVisitor<List<Space>>(){

            @Override
            public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, List<Space> selectAfter) {
                if (selectAfter.isEmpty()) {
                    selectAfter.add(right == null ? Space.EMPTY : right.getAfter());
                }
                return right;
            }
        }.reduce(method, new ArrayList())).get(0);
    }

    public static Predicate<List<Expression>> isTrueArgument() {
        return args -> args.size() == 1 && RemoveMethodInvocationsVisitor.isTrue((Expression)args.get(0));
    }

    public static Predicate<List<Expression>> isFalseArgument() {
        return args -> args.size() == 1 && RemoveMethodInvocationsVisitor.isFalse((Expression)args.get(0));
    }

    public static boolean isTrue(Expression expression) {
        return RemoveMethodInvocationsVisitor.isBoolean(expression, Boolean.TRUE);
    }

    public static boolean isFalse(Expression expression) {
        return RemoveMethodInvocationsVisitor.isBoolean(expression, Boolean.FALSE);
    }

    private static boolean isBoolean(Expression expression, Boolean b) {
        if (expression instanceof J.Literal) {
            return expression.getType() == JavaType.Primitive.Boolean && b.equals(((J.Literal)expression).getValue());
        }
        return false;
    }

    public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext ctx) {
        J body = (lambda = (J.Lambda)super.visitLambda(lambda, ctx)).getBody();
        if (body instanceof J.MethodInvocation && ToBeRemoved.hasMarker(body)) {
            Expression select = ((J.MethodInvocation)body).getSelect();
            List<J> parameters = lambda.getParameters().getParameters();
            if (select instanceof J.Identifier && !parameters.isEmpty() && parameters.get(0) instanceof J.VariableDeclarations) {
                J.VariableDeclarations declarations = (J.VariableDeclarations)parameters.get(0);
                if (((J.Identifier)select).getSimpleName().equals(declarations.getVariables().get(0).getSimpleName())) {
                    return ToBeRemoved.withMarker(lambda);
                }
            } else if (select instanceof J.MethodInvocation) {
                return lambda.withBody((J)select.withPrefix(body.getPrefix()));
            }
        } else if (body instanceof J.Block && ToBeRemoved.hasMarker(body)) {
            return ToBeRemoved.withMarker(lambda.withBody(ToBeRemoved.removeMarker(body)));
        }
        return lambda;
    }

    public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
        int statementsCount = block.getStatements().size();
        List<Statement> statements = (block = (J.Block)super.visitBlock(block, ctx)).getStatements();
        if (!statements.isEmpty() && statements.stream().allMatch(ToBeRemoved::hasMarker)) {
            return ToBeRemoved.withMarker(block.withStatements(Collections.emptyList()));
        }
        if (statementsCount > 0 && statements.isEmpty()) {
            return ToBeRemoved.withMarker(block.withStatements(Collections.emptyList()));
        }
        if (statements.stream().anyMatch(ToBeRemoved::hasMarker)) {
            return block.withStatements(statements.stream().filter(s -> !ToBeRemoved.hasMarker(s) || s instanceof J.MethodInvocation && ((J.MethodInvocation)s).getSelect() instanceof J.MethodInvocation).map(s -> s instanceof J.MethodInvocation && ToBeRemoved.hasMarker(s) ? (Statement)((J.MethodInvocation)s).getSelect().withPrefix(s.getPrefix()) : s).collect(Collectors.toList()));
        }
        return block;
    }

    static final class ToBeRemoved
    implements Marker {
        private final UUID id;

        static <J2 extends J> J2 withMarker(J2 j) {
            return (J2)((J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new ToBeRemoved(Tree.randomId()))));
        }

        static <J2 extends J> J2 removeMarker(J2 j) {
            return (J2)((J)j.withMarkers(j.getMarkers().removeByType(ToBeRemoved.class)));
        }

        static boolean hasMarker(J j) {
            return j.getMarkers().findFirst(ToBeRemoved.class).isPresent();
        }

        @Generated
        public ToBeRemoved(UUID id) {
            this.id = id;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToBeRemoved)) {
                return false;
            }
            ToBeRemoved other = (ToBeRemoved)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RemoveMethodInvocationsVisitor.ToBeRemoved(id=" + this.getId() + ")";
        }

        @NonNull
        @Generated
        public ToBeRemoved withId(UUID id) {
            return this.id == id ? this : new ToBeRemoved(id);
        }
    }
}

