/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;

public class NormalizeFormatVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;

    @JsonCreator
    public NormalizeFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public NormalizeFormatVisitor() {
        this(null);
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J c = super.visitClassDeclaration(classDecl, (Object)p);
        if (!((J.ClassDeclaration)c).getLeadingAnnotations().isEmpty()) {
            c = (J.ClassDeclaration)this.concatenatePrefix(c, Space.firstPrefix(((J.ClassDeclaration)c).getLeadingAnnotations()));
            c = ((J.ClassDeclaration)c).withLeadingAnnotations(Space.formatFirstPrefix(((J.ClassDeclaration)c).getLeadingAnnotations(), Space.EMPTY));
            return c;
        }
        if (!((J.ClassDeclaration)c).getModifiers().isEmpty()) {
            c = (J.ClassDeclaration)this.concatenatePrefix(c, Space.firstPrefix(((J.ClassDeclaration)c).getModifiers()));
            c = ((J.ClassDeclaration)c).withModifiers(Space.formatFirstPrefix(((J.ClassDeclaration)c).getModifiers(), Space.EMPTY));
            return c;
        }
        if (!((J.ClassDeclaration)c).getPadding().getKind().getPrefix().isEmpty()) {
            c = (J.ClassDeclaration)this.concatenatePrefix(c, ((J.ClassDeclaration)c).getPadding().getKind().getPrefix());
            c = ((J.ClassDeclaration)c).getPadding().withKind(((J.ClassDeclaration)c).getPadding().getKind().withPrefix(Space.EMPTY));
            return c;
        }
        JContainer<J.TypeParameter> typeParameters = ((J.ClassDeclaration)c).getPadding().getTypeParameters();
        if (typeParameters != null && !typeParameters.getElements().isEmpty()) {
            c = (J.ClassDeclaration)this.concatenatePrefix(c, typeParameters.getBefore());
            c = ((J.ClassDeclaration)c).getPadding().withTypeParameters(typeParameters.withBefore(Space.EMPTY));
            return c;
        }
        return ((J.ClassDeclaration)c).withName(((J.ClassDeclaration)c).getName().withPrefix(((J.ClassDeclaration)c).getName().getPrefix().withWhitespace(" ")));
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J m = super.visitMethodDeclaration(method, (Object)p);
        if (!((J.MethodDeclaration)m).getLeadingAnnotations().isEmpty()) {
            m = (J.MethodDeclaration)this.concatenatePrefix(m, Space.firstPrefix(((J.MethodDeclaration)m).getLeadingAnnotations()));
            m = ((J.MethodDeclaration)m).withLeadingAnnotations(Space.formatFirstPrefix(((J.MethodDeclaration)m).getLeadingAnnotations(), Space.EMPTY));
            return m;
        }
        if (!((J.MethodDeclaration)m).getModifiers().isEmpty()) {
            m = (J.MethodDeclaration)this.concatenatePrefix(m, Space.firstPrefix(((J.MethodDeclaration)m).getModifiers()));
            m = ((J.MethodDeclaration)m).withModifiers(Space.formatFirstPrefix(((J.MethodDeclaration)m).getModifiers(), Space.EMPTY));
            return m;
        }
        if (((J.MethodDeclaration)m).getAnnotations().getTypeParameters() != null) {
            if (!((J.MethodDeclaration)m).getAnnotations().getTypeParameters().getTypeParameters().isEmpty()) {
                m = (J.MethodDeclaration)this.concatenatePrefix(m, ((J.MethodDeclaration)m).getAnnotations().getTypeParameters().getPrefix());
                m = ((J.MethodDeclaration)m).getAnnotations().withTypeParameters(((J.MethodDeclaration)m).getAnnotations().getTypeParameters().withPrefix(Space.EMPTY));
            }
            return m;
        }
        if (((J.MethodDeclaration)m).getReturnTypeExpression() != null) {
            if (!((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix().getWhitespace().isEmpty()) {
                m = (J.MethodDeclaration)this.concatenatePrefix(m, ((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix());
                m = ((J.MethodDeclaration)m).withReturnTypeExpression((TypeTree)((J.MethodDeclaration)m).getReturnTypeExpression().withPrefix(Space.EMPTY));
            }
            return m;
        }
        m = (J.MethodDeclaration)this.concatenatePrefix(m, ((J.MethodDeclaration)m).getName().getPrefix());
        m = ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withPrefix(Space.EMPTY));
        return m;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J v = super.visitVariableDeclarations(multiVariable, (Object)p);
        if (!((J.VariableDeclarations)v).getLeadingAnnotations().isEmpty()) {
            v = (J.VariableDeclarations)this.concatenatePrefix(v, Space.firstPrefix(((J.VariableDeclarations)v).getLeadingAnnotations()));
            v = ((J.VariableDeclarations)v).withLeadingAnnotations(Space.formatFirstPrefix(((J.VariableDeclarations)v).getLeadingAnnotations(), Space.EMPTY));
            return v;
        }
        if (!((J.VariableDeclarations)v).getModifiers().isEmpty()) {
            v = (J.VariableDeclarations)this.concatenatePrefix(v, Space.firstPrefix(((J.VariableDeclarations)v).getModifiers()));
            v = ((J.VariableDeclarations)v).withModifiers(Space.formatFirstPrefix(((J.VariableDeclarations)v).getModifiers(), Space.EMPTY));
            return v;
        }
        if (((J.VariableDeclarations)v).getTypeExpression() != null) {
            v = (J.VariableDeclarations)this.concatenatePrefix(v, ((J.VariableDeclarations)v).getTypeExpression().getPrefix());
            v = ((J.VariableDeclarations)v).withTypeExpression((TypeTree)((J.VariableDeclarations)v).getTypeExpression().withPrefix(Space.EMPTY));
            return v;
        }
        return v;
    }

    private <J2 extends J> J2 concatenatePrefix(J2 j, Space prefix) {
        final String shift = StringUtils.commonMargin(null, (CharSequence)j.getPrefix().getWhitespace());
        List comments = ListUtils.concatAll(j.getComments(), (List)ListUtils.map(prefix.getComments(), comment -> {
            Comment c = comment;
            if (shift.isEmpty()) {
                return c;
            }
            if (comment instanceof TextComment) {
                TextComment textComment = (TextComment)c;
                c = textComment.withText(textComment.getText().replace("\n", "\n" + shift));
            } else if (c instanceof Javadoc) {
                c = (Comment)new JavadocVisitor<Integer>(new JavaVisitor()){

                    @Override
                    public Javadoc visitLineBreak(Javadoc.LineBreak lineBreak, Integer integer) {
                        return lineBreak.withMargin(shift + lineBreak.getMargin());
                    }
                }.visitNonNull((Javadoc)((Object)c), 0);
            }
            if (c.getSuffix().contains("\n")) {
                c = c.withSuffix(c.getSuffix().replace("\n", "\n" + shift));
            }
            return c;
        }));
        return j.withPrefix(j.getPrefix().withWhitespace(j.getPrefix().getWhitespace() + prefix.getWhitespace()).withComments(comments));
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

