/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.CompactConstructor;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JavaPrinter<P>
extends JavaVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> JAVA_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit(node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    protected void visitContainer(String before, @Nullable JContainer<? extends J> container, JContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.beforeSyntax(container.getBefore(), container.getMarkers(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        this.afterSyntax(container.getMarkers(), p);
        p.append(after == null ? "" : after);
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        List<Comment> comments = space.getComments();
        for (int i = 0; i < comments.size(); ++i) {
            Comment comment = comments.get(i);
            this.visitMarkers(comment.getMarkers(), p);
            comment.printComment(this.getCursor(), p);
            p.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit(leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitRightPadded(@Nullable JRightPadded<? extends J> rightPadded, JRightPadded.Location location, @Nullable String suffix, PrintOutputCapture<P> p) {
        if (rightPadded != null) {
            this.beforeSyntax(Space.EMPTY, rightPadded.getMarkers(), null, p);
            this.visit(rightPadded.getElement(), p);
            this.afterSyntax(rightPadded.getMarkers(), p);
            this.visitSpace(rightPadded.getAfter(), location.getAfterLocation(), p);
            if (suffix != null) {
                p.append(suffix);
            }
        }
    }

    protected void visitModifier(J.Modifier mod, PrintOutputCapture<P> p) {
        this.visit(mod.getAnnotations(), p);
        String keyword = "";
        switch (mod.getType()) {
            case Default: {
                keyword = "default";
                break;
            }
            case Public: {
                keyword = "public";
                break;
            }
            case Protected: {
                keyword = "protected";
                break;
            }
            case Private: {
                keyword = "private";
                break;
            }
            case Abstract: {
                keyword = "abstract";
                break;
            }
            case Static: {
                keyword = "static";
                break;
            }
            case Final: {
                keyword = "final";
                break;
            }
            case Native: {
                keyword = "native";
                break;
            }
            case NonSealed: {
                keyword = "non-sealed";
                break;
            }
            case Sealed: {
                keyword = "sealed";
                break;
            }
            case Strictfp: {
                keyword = "strictfp";
                break;
            }
            case Synchronized: {
                keyword = "synchronized";
                break;
            }
            case Transient: {
                keyword = "transient";
                break;
            }
            case Volatile: {
                keyword = "volatile";
            }
        }
        this.beforeSyntax(mod, Space.Location.MODIFIER_PREFIX, p);
        p.append(keyword);
        this.afterSyntax(mod, p);
    }

    @Override
    public J visitAnnotation(J.Annotation annotation, PrintOutputCapture<P> p) {
        this.beforeSyntax(annotation, Space.Location.ANNOTATION_PREFIX, p);
        p.append('@');
        this.visit(annotation.getAnnotationType(), p);
        this.visitContainer("(", annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, ",", ")", p);
        this.afterSyntax(annotation, p);
        return annotation;
    }

    @Override
    public J visitAnnotatedType(J.AnnotatedType annotatedType, PrintOutputCapture<P> p) {
        this.beforeSyntax(annotatedType, Space.Location.ANNOTATED_TYPE_PREFIX, p);
        this.visit(annotatedType.getAnnotations(), p);
        this.visit(annotatedType.getTypeExpression(), p);
        this.afterSyntax(annotatedType, p);
        return annotatedType;
    }

    @Override
    public J visitArrayDimension(J.ArrayDimension arrayDimension, PrintOutputCapture<P> p) {
        this.beforeSyntax(arrayDimension, Space.Location.DIMENSION_PREFIX, p);
        p.append('[');
        this.visitRightPadded(arrayDimension.getPadding().getIndex(), JRightPadded.Location.ARRAY_INDEX, "]", p);
        this.afterSyntax(arrayDimension, p);
        return arrayDimension;
    }

    @Override
    public J visitArrayType(J.ArrayType arrayType, PrintOutputCapture<P> p) {
        this.beforeSyntax(arrayType, Space.Location.ARRAY_TYPE_PREFIX, p);
        TypeTree type = arrayType;
        while (type instanceof J.ArrayType) {
            type = type.getElementType();
        }
        this.visit(type, p);
        this.visit(arrayType.getAnnotations(), p);
        if (arrayType.getDimension() != null) {
            this.visitSpace(arrayType.getDimension().getBefore(), Space.Location.DIMENSION_PREFIX, p);
            p.append('[');
            this.visitSpace(arrayType.getDimension().getElement(), Space.Location.DIMENSION, p);
            p.append(']');
            if (arrayType.getElementType() instanceof J.ArrayType) {
                this.printDimensions((J.ArrayType)arrayType.getElementType(), p);
            }
        }
        this.afterSyntax(arrayType, p);
        return arrayType;
    }

    private void printDimensions(J.ArrayType arrayType, PrintOutputCapture<P> p) {
        this.beforeSyntax(arrayType, Space.Location.ARRAY_TYPE_PREFIX, p);
        this.visit(arrayType.getAnnotations(), p);
        this.visitSpace(arrayType.getDimension().getBefore(), Space.Location.DIMENSION_PREFIX, p);
        p.append('[');
        this.visitSpace(arrayType.getDimension().getElement(), Space.Location.DIMENSION, p);
        p.append(']');
        if (arrayType.getElementType() instanceof J.ArrayType) {
            this.printDimensions((J.ArrayType)arrayType.getElementType(), p);
        }
        this.afterSyntax(arrayType, p);
    }

    @Override
    public J visitAssert(J.Assert assert_, PrintOutputCapture<P> p) {
        this.beforeSyntax(assert_, Space.Location.ASSERT_PREFIX, p);
        p.append("assert");
        this.visit(assert_.getCondition(), p);
        this.visitLeftPadded(":", assert_.getDetail(), JLeftPadded.Location.ASSERT_DETAIL, p);
        this.afterSyntax(assert_, p);
        return assert_;
    }

    @Override
    public J visitAssignment(J.Assignment assignment, PrintOutputCapture<P> p) {
        this.beforeSyntax(assignment, Space.Location.ASSIGNMENT_PREFIX, p);
        this.visit(assignment.getVariable(), p);
        this.visitLeftPadded("=", assignment.getPadding().getAssignment(), JLeftPadded.Location.ASSIGNMENT, p);
        this.afterSyntax(assignment, p);
        return assignment;
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, PrintOutputCapture<P> p) {
        String keyword = "";
        switch (assignOp.getOperator()) {
            case Addition: {
                keyword = "+=";
                break;
            }
            case Subtraction: {
                keyword = "-=";
                break;
            }
            case Multiplication: {
                keyword = "*=";
                break;
            }
            case Division: {
                keyword = "/=";
                break;
            }
            case Modulo: {
                keyword = "%=";
                break;
            }
            case BitAnd: {
                keyword = "&=";
                break;
            }
            case BitOr: {
                keyword = "|=";
                break;
            }
            case BitXor: {
                keyword = "^=";
                break;
            }
            case LeftShift: {
                keyword = "<<=";
                break;
            }
            case RightShift: {
                keyword = ">>=";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>=";
            }
        }
        this.beforeSyntax(assignOp, Space.Location.ASSIGNMENT_OPERATION_PREFIX, p);
        this.visit(assignOp.getVariable(), p);
        this.visitSpace(assignOp.getPadding().getOperator().getBefore(), Space.Location.ASSIGNMENT_OPERATION_OPERATOR, p);
        p.append(keyword);
        this.visit(assignOp.getAssignment(), p);
        this.afterSyntax(assignOp, p);
        return assignOp;
    }

    @Override
    public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
        String keyword = "";
        switch (binary.getOperator()) {
            case Addition: {
                keyword = "+";
                break;
            }
            case Subtraction: {
                keyword = "-";
                break;
            }
            case Multiplication: {
                keyword = "*";
                break;
            }
            case Division: {
                keyword = "/";
                break;
            }
            case Modulo: {
                keyword = "%";
                break;
            }
            case LessThan: {
                keyword = "<";
                break;
            }
            case GreaterThan: {
                keyword = ">";
                break;
            }
            case LessThanOrEqual: {
                keyword = "<=";
                break;
            }
            case GreaterThanOrEqual: {
                keyword = ">=";
                break;
            }
            case Equal: {
                keyword = "==";
                break;
            }
            case NotEqual: {
                keyword = "!=";
                break;
            }
            case BitAnd: {
                keyword = "&";
                break;
            }
            case BitOr: {
                keyword = "|";
                break;
            }
            case BitXor: {
                keyword = "^";
                break;
            }
            case LeftShift: {
                keyword = "<<";
                break;
            }
            case RightShift: {
                keyword = ">>";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>";
                break;
            }
            case Or: {
                keyword = "||";
                break;
            }
            case And: {
                keyword = "&&";
            }
        }
        this.beforeSyntax(binary, Space.Location.BINARY_PREFIX, p);
        this.visit(binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
        p.append(keyword);
        this.visit(binary.getRight(), p);
        this.afterSyntax(binary, p);
        return binary;
    }

    @Override
    public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
        this.beforeSyntax(block, Space.Location.BLOCK_PREFIX, p);
        if (block.isStatic()) {
            p.append("static");
            this.visitRightPadded(block.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, p);
        }
        p.append('{');
        this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
        this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
        p.append('}');
        this.afterSyntax(block, p);
        return block;
    }

    protected void visitStatements(List<JRightPadded<Statement>> statements, JRightPadded.Location location, PrintOutputCapture<P> p) {
        for (JRightPadded<Statement> paddedStat : statements) {
            this.visitStatement(paddedStat, location, p);
        }
    }

    protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
        Object aSwitch;
        if (paddedStat == null) {
            return;
        }
        this.visit(paddedStat.getElement(), p);
        this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
        Statement s = paddedStat.getElement();
        while (true) {
            if (s instanceof J.Assert || s instanceof J.Assignment || s instanceof J.AssignmentOperation || s instanceof J.Break || s instanceof J.Continue || s instanceof J.DoWhileLoop || s instanceof J.Empty || s instanceof J.MethodInvocation || s instanceof J.NewClass || s instanceof J.Return || s instanceof J.Throw || s instanceof J.Unary || s instanceof J.VariableDeclarations || s instanceof J.Yield) {
                p.append(';');
                return;
            }
            if (s instanceof J.MethodDeclaration && ((J.MethodDeclaration)s).getBody() == null) {
                p.append(';');
                return;
            }
            if (!(s instanceof J.Label)) break;
            s = ((J.Label)s).getStatement();
        }
        if (this.getCursor().getValue() instanceof J.Case && (aSwitch = this.getCursor().dropParentUntil(c -> c instanceof J.Switch || c instanceof J.SwitchExpression || c == "root").getValue()) instanceof J.SwitchExpression) {
            J.Case aCase = (J.Case)this.getCursor().getValue();
            if (!(aCase.getBody() instanceof J.Block)) {
                p.append(';');
            }
            return;
        }
    }

    @Override
    public J visitBreak(J.Break breakStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(breakStatement, Space.Location.BREAK_PREFIX, p);
        p.append("break");
        this.visit(breakStatement.getLabel(), p);
        this.afterSyntax(breakStatement, p);
        return breakStatement;
    }

    @Override
    public J visitCase(J.Case case_, PrintOutputCapture<P> p) {
        this.beforeSyntax(case_, Space.Location.CASE_PREFIX, p);
        Expression elem = case_.getExpressions().get(0);
        if (!(elem instanceof J.Identifier) || !((J.Identifier)elem).getSimpleName().equals("default")) {
            p.append("case");
        }
        this.visitContainer("", case_.getPadding().getExpressions(), JContainer.Location.CASE_EXPRESSION, ",", "", p);
        this.visitSpace(case_.getPadding().getStatements().getBefore(), Space.Location.CASE, p);
        p.append(case_.getType() == J.Case.Type.Statement ? ":" : "->");
        this.visitStatements(case_.getPadding().getStatements().getPadding().getElements(), JRightPadded.Location.CASE, p);
        if (case_.getBody() instanceof Statement) {
            this.visitStatement(case_.getPadding().getBody(), JRightPadded.Location.CASE_BODY, p);
        } else {
            this.visitRightPadded(case_.getPadding().getBody(), JRightPadded.Location.CASE_BODY, ";", p);
        }
        this.afterSyntax(case_, p);
        return case_;
    }

    @Override
    public J visitCatch(J.Try.Catch catch_, PrintOutputCapture<P> p) {
        this.beforeSyntax(catch_, Space.Location.CATCH_PREFIX, p);
        p.append("catch");
        this.visit(catch_.getParameter(), p);
        this.visit(catch_.getBody(), p);
        this.afterSyntax(catch_, p);
        return catch_;
    }

    @Override
    public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
        String kind = "";
        switch (classDecl.getKind()) {
            case Class: {
                kind = "class";
                break;
            }
            case Enum: {
                kind = "enum";
                break;
            }
            case Interface: {
                kind = "interface";
                break;
            }
            case Annotation: {
                kind = "@interface";
                break;
            }
            case Record: {
                kind = "record";
            }
        }
        this.beforeSyntax(classDecl, Space.Location.CLASS_DECLARATION_PREFIX, p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(classDecl.getLeadingAnnotations(), p);
        for (J.Modifier m : classDecl.getModifiers()) {
            this.visitModifier(m, p);
        }
        this.visit(classDecl.getPadding().getKind().getAnnotations(), p);
        this.visitSpace(classDecl.getPadding().getKind().getPrefix(), Space.Location.CLASS_KIND, p);
        p.append(kind);
        this.visit(classDecl.getName(), p);
        this.visitContainer("<", classDecl.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
        this.visitContainer("(", classDecl.getPadding().getPrimaryConstructor(), JContainer.Location.RECORD_STATE_VECTOR, ",", ")", p);
        this.visitLeftPadded("extends", classDecl.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, p);
        this.visitContainer(classDecl.getKind().equals((Object)J.ClassDeclaration.Kind.Type.Interface) ? "extends" : "implements", classDecl.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, ",", null, p);
        this.visitContainer("permits", classDecl.getPadding().getPermits(), JContainer.Location.PERMITS, ",", null, p);
        this.visit(classDecl.getBody(), p);
        this.afterSyntax(classDecl, p);
        return classDecl;
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, PrintOutputCapture<P> p) {
        this.beforeSyntax(cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visitRightPadded(cu.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, ";", p);
        this.visitRightPadded(cu.getPadding().getImports(), JRightPadded.Location.IMPORT, ";", p);
        if (!cu.getImports().isEmpty()) {
            p.append(';');
        }
        this.visit(cu.getClasses(), p);
        this.afterSyntax(cu, p);
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        return cu;
    }

    @Override
    public J visitContinue(J.Continue continueStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(continueStatement, Space.Location.CONTINUE_PREFIX, p);
        p.append("continue");
        this.visit(continueStatement.getLabel(), p);
        this.afterSyntax(continueStatement, p);
        return continueStatement;
    }

    @Override
    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, PrintOutputCapture<P> p) {
        this.beforeSyntax(controlParens, Space.Location.CONTROL_PARENTHESES_PREFIX, p);
        p.append('(');
        this.visitRightPadded(controlParens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, ")", p);
        this.afterSyntax(controlParens, p);
        return controlParens;
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, PrintOutputCapture<P> p) {
        this.beforeSyntax(doWhileLoop, Space.Location.DO_WHILE_PREFIX, p);
        p.append("do");
        this.visitStatement(doWhileLoop.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, p);
        this.visitLeftPadded("while", doWhileLoop.getPadding().getWhileCondition(), JLeftPadded.Location.WHILE_CONDITION, p);
        this.afterSyntax(doWhileLoop, p);
        return doWhileLoop;
    }

    @Override
    public J visitElse(J.If.Else else_, PrintOutputCapture<P> p) {
        this.beforeSyntax(else_, Space.Location.ELSE_PREFIX, p);
        p.append("else");
        this.visitStatement(else_.getPadding().getBody(), JRightPadded.Location.IF_ELSE, p);
        this.afterSyntax(else_, p);
        return else_;
    }

    @Override
    public J visitEmpty(J.Empty empty, PrintOutputCapture<P> p) {
        this.beforeSyntax(empty, Space.Location.EMPTY_PREFIX, p);
        this.afterSyntax(empty, p);
        return empty;
    }

    @Override
    public J visitEnumValue(J.EnumValue enum_, PrintOutputCapture<P> p) {
        this.beforeSyntax(enum_, Space.Location.ENUM_VALUE_PREFIX, p);
        this.visit(enum_.getAnnotations(), p);
        this.visit(enum_.getName(), p);
        J.NewClass initializer = enum_.getInitializer();
        if (enum_.getInitializer() != null) {
            this.visitSpace(initializer.getPrefix(), Space.Location.NEW_CLASS_PREFIX, p);
            this.visitSpace(initializer.getNew(), Space.Location.NEW_PREFIX, p);
            if (!initializer.getPadding().getArguments().getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                this.visitContainer("(", initializer.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, ",", ")", p);
            }
            this.visit(initializer.getBody(), p);
        }
        this.afterSyntax(enum_, p);
        return enum_;
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enums, PrintOutputCapture<P> p) {
        this.beforeSyntax(enums, Space.Location.ENUM_VALUE_SET_PREFIX, p);
        this.visitRightPadded(enums.getPadding().getEnums(), JRightPadded.Location.ENUM_VALUE, ",", p);
        if (enums.isTerminatedWithSemicolon()) {
            p.append(';');
        }
        this.afterSyntax(enums, p);
        return enums;
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
        this.beforeSyntax(fieldAccess, Space.Location.FIELD_ACCESS_PREFIX, p);
        this.visit(fieldAccess.getTarget(), p);
        this.visitLeftPadded(".", fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
        this.afterSyntax(fieldAccess, p);
        return fieldAccess;
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop, PrintOutputCapture<P> p) {
        this.beforeSyntax(forLoop, Space.Location.FOR_PREFIX, p);
        p.append("for");
        J.ForLoop.Control ctrl = forLoop.getControl();
        this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_CONTROL_PREFIX, p);
        p.append('(');
        this.visitRightPadded(ctrl.getPadding().getInit(), JRightPadded.Location.FOR_INIT, ",", p);
        p.append(';');
        this.visitRightPadded(ctrl.getPadding().getCondition(), JRightPadded.Location.FOR_CONDITION, ";", p);
        this.visitRightPadded(ctrl.getPadding().getUpdate(), JRightPadded.Location.FOR_UPDATE, ",", p);
        p.append(')');
        this.visitStatement(forLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
        this.afterSyntax(forLoop, p);
        return forLoop;
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
        this.beforeSyntax(forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
        p.append("for");
        J.ForEachLoop.Control ctrl = forEachLoop.getControl();
        this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
        p.append('(');
        this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, ":", p);
        this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
        p.append(')');
        this.visitStatement(forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
        this.afterSyntax(forEachLoop, p);
        return forEachLoop;
    }

    @Override
    public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(ident.getAnnotations(), p);
        this.beforeSyntax(ident, Space.Location.IDENTIFIER_PREFIX, p);
        p.append(ident.getSimpleName());
        this.afterSyntax(ident, p);
        return ident;
    }

    @Override
    public J visitIf(J.If iff, PrintOutputCapture<P> p) {
        this.beforeSyntax(iff, Space.Location.IF_PREFIX, p);
        p.append("if");
        this.visit(iff.getIfCondition(), p);
        this.visitStatement(iff.getPadding().getThenPart(), JRightPadded.Location.IF_THEN, p);
        this.visit(iff.getElsePart(), p);
        this.afterSyntax(iff, p);
        return iff;
    }

    @Override
    public J visitImport(J.Import import_, PrintOutputCapture<P> p) {
        this.beforeSyntax(import_, Space.Location.IMPORT_PREFIX, p);
        p.append("import");
        if (import_.isStatic()) {
            this.visitSpace(import_.getPadding().getStatic().getBefore(), Space.Location.STATIC_IMPORT, p);
            p.append("static");
        }
        this.visit(import_.getQualid(), p);
        this.afterSyntax(import_, p);
        return import_;
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, PrintOutputCapture<P> p) {
        this.beforeSyntax(instanceOf, Space.Location.INSTANCEOF_PREFIX, p);
        this.visitRightPadded(instanceOf.getPadding().getExpression(), JRightPadded.Location.INSTANCEOF, "instanceof", p);
        this.visit(instanceOf.getClazz(), p);
        this.visit(instanceOf.getPattern(), p);
        this.afterSyntax(instanceOf, p);
        return instanceOf;
    }

    @Override
    public J visitIntersectionType(J.IntersectionType intersectionType, PrintOutputCapture<P> p) {
        this.beforeSyntax(intersectionType, Space.Location.INTERSECTION_TYPE_PREFIX, p);
        this.visitContainer("", intersectionType.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, "&", "", p);
        this.afterSyntax(intersectionType, p);
        return intersectionType;
    }

    @Override
    public J visitLabel(J.Label label, PrintOutputCapture<P> p) {
        this.beforeSyntax(label, Space.Location.LABEL_PREFIX, p);
        this.visitRightPadded(label.getPadding().getLabel(), JRightPadded.Location.LABEL, ":", p);
        this.visit(label.getStatement(), p);
        this.afterSyntax(label, p);
        return label;
    }

    @Override
    public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
        this.beforeSyntax(lambda, Space.Location.LAMBDA_PREFIX, p);
        this.visitSpace(lambda.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
        this.visitMarkers(lambda.getParameters().getMarkers(), p);
        if (lambda.getParameters().isParenthesized()) {
            p.append('(');
            this.visitRightPadded(lambda.getParameters().getPadding().getParameters(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
            p.append(')');
        } else {
            this.visitRightPadded(lambda.getParameters().getPadding().getParameters(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
        }
        this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
        p.append("->");
        this.visit(lambda.getBody(), p);
        this.afterSyntax(lambda, p);
        return lambda;
    }

    @Override
    public J visitLiteral(J.Literal literal, PrintOutputCapture<P> p) {
        this.beforeSyntax(literal, Space.Location.LITERAL_PREFIX, p);
        List<J.Literal.UnicodeEscape> unicodeEscapes = literal.getUnicodeEscapes();
        if (unicodeEscapes == null) {
            p.append(literal.getValueSource());
        } else if (literal.getValueSource() != null) {
            Iterator<J.Literal.UnicodeEscape> surrogateIter = unicodeEscapes.iterator();
            J.Literal.UnicodeEscape surrogate = surrogateIter.hasNext() ? surrogateIter.next() : null;
            int i = 0;
            if (surrogate != null && surrogate.getValueSourceIndex() == 0) {
                p.append("\\u").append(surrogate.getCodePoint());
                if (surrogateIter.hasNext()) {
                    surrogate = surrogateIter.next();
                }
            }
            String valueSource = literal.getValueSource();
            for (int j = 0; j < valueSource.length(); ++j) {
                char c = valueSource.charAt(j);
                p.append(c);
                if (surrogate == null || surrogate.getValueSourceIndex() != ++i) continue;
                while (surrogate != null && surrogate.getValueSourceIndex() == i) {
                    p.append("\\u").append(surrogate.getCodePoint());
                    surrogate = surrogateIter.hasNext() ? surrogateIter.next() : null;
                }
            }
        }
        this.afterSyntax(literal, p);
        return literal;
    }

    @Override
    public J visitMemberReference(J.MemberReference memberRef, PrintOutputCapture<P> p) {
        this.beforeSyntax(memberRef, Space.Location.MEMBER_REFERENCE_PREFIX, p);
        this.visitRightPadded(memberRef.getPadding().getContaining(), JRightPadded.Location.MEMBER_REFERENCE_CONTAINING, p);
        p.append("::");
        this.visitContainer("<", memberRef.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
        this.visitLeftPadded("", memberRef.getPadding().getReference(), JLeftPadded.Location.MEMBER_REFERENCE_NAME, p);
        this.afterSyntax(memberRef, p);
        return memberRef;
    }

    @Override
    public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
        this.beforeSyntax(method, Space.Location.METHOD_DECLARATION_PREFIX, p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(method.getLeadingAnnotations(), p);
        for (J.Modifier m : method.getModifiers()) {
            this.visitModifier(m, p);
        }
        J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
        if (typeParameters != null) {
            this.visit(typeParameters.getAnnotations(), p);
            this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
            this.visitMarkers(typeParameters.getMarkers(), p);
            p.append('<');
            this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
            p.append('>');
        }
        this.visit(method.getReturnTypeExpression(), p);
        this.visit(method.getAnnotations().getName().getAnnotations(), p);
        this.visit(method.getName(), p);
        if (!method.getMarkers().findFirst(CompactConstructor.class).isPresent()) {
            this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
        }
        this.visitContainer("throws", method.getPadding().getThrows(), JContainer.Location.THROWS, ",", null, p);
        this.visit(method.getBody(), p);
        this.visitLeftPadded("default", method.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, p);
        this.afterSyntax(method, p);
        return method;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
        this.beforeSyntax(method, Space.Location.METHOD_INVOCATION_PREFIX, p);
        this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, ".", p);
        this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
        this.visit(method.getName(), p);
        this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
        this.afterSyntax(method, p);
        return method;
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch, PrintOutputCapture<P> p) {
        this.beforeSyntax(multiCatch, Space.Location.MULTI_CATCH_PREFIX, p);
        this.visitRightPadded(multiCatch.getPadding().getAlternatives(), JRightPadded.Location.CATCH_ALTERNATIVE, "|", p);
        this.afterSyntax(multiCatch, p);
        return multiCatch;
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
        this.beforeSyntax(multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(multiVariable.getLeadingAnnotations(), p);
        for (J.Modifier modifier : multiVariable.getModifiers()) {
            this.visitModifier(modifier, p);
        }
        this.visit(multiVariable.getTypeExpression(), p);
        for (JLeftPadded jLeftPadded : multiVariable.getDimensionsBeforeName()) {
            this.visitSpace(jLeftPadded.getBefore(), Space.Location.DIMENSION_PREFIX, p);
            p.append('[');
            this.visitSpace((Space)jLeftPadded.getElement(), Space.Location.DIMENSION, p);
            p.append(']');
        }
        if (multiVariable.getVarargs() != null) {
            this.visitSpace(multiVariable.getVarargs(), Space.Location.VARARGS, p);
            p.append("...");
        }
        this.visitRightPadded(multiVariable.getPadding().getVariables(), JRightPadded.Location.NAMED_VARIABLE, ",", p);
        this.afterSyntax(multiVariable, p);
        return multiVariable;
    }

    @Override
    public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
        this.beforeSyntax(newArray, Space.Location.NEW_ARRAY_PREFIX, p);
        if (newArray.getTypeExpression() != null) {
            p.append("new");
        }
        this.visit(newArray.getTypeExpression(), p);
        this.visit(newArray.getDimensions(), p);
        this.visitContainer("{", newArray.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, ",", "}", p);
        this.afterSyntax(newArray, p);
        return newArray;
    }

    @Override
    public J visitNewClass(J.NewClass newClass, PrintOutputCapture<P> p) {
        this.beforeSyntax(newClass, Space.Location.NEW_CLASS_PREFIX, p);
        this.visitRightPadded(newClass.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, ".", p);
        this.visitSpace(newClass.getNew(), Space.Location.NEW_PREFIX, p);
        p.append("new");
        this.visit(newClass.getClazz(), p);
        if (!newClass.getPadding().getArguments().getMarkers().findFirst(OmitParentheses.class).isPresent()) {
            this.visitContainer("(", newClass.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, ",", ")", p);
        }
        this.visit(newClass.getBody(), p);
        this.afterSyntax(newClass, p);
        return newClass;
    }

    @Override
    public J visitNullableType(J.NullableType nt, PrintOutputCapture<P> p) {
        this.beforeSyntax(nt, Space.Location.NULLABLE_TYPE_PREFIX, p);
        this.visit(nt.getTypeTree(), p);
        this.visitSpace(nt.getPadding().getTypeTree().getAfter(), Space.Location.NULLABLE_TYPE_SUFFIX, p);
        p.append("?");
        this.afterSyntax(nt, p);
        return nt;
    }

    @Override
    public J visitPackage(J.Package pkg, PrintOutputCapture<P> p) {
        for (J.Annotation a : pkg.getAnnotations()) {
            this.visitAnnotation(a, p);
        }
        this.beforeSyntax(pkg, Space.Location.PACKAGE_PREFIX, p);
        p.append("package");
        this.visit(pkg.getExpression(), p);
        this.afterSyntax(pkg, p);
        return pkg;
    }

    @Override
    public J visitParameterizedType(J.ParameterizedType type, PrintOutputCapture<P> p) {
        this.beforeSyntax(type, Space.Location.PARAMETERIZED_TYPE_PREFIX, p);
        this.visit(type.getClazz(), p);
        this.visitContainer("<", type.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
        this.afterSyntax(type, p);
        return type;
    }

    @Override
    public J visitPrimitive(J.Primitive primitive, PrintOutputCapture<P> p) {
        String keyword;
        switch (primitive.getType()) {
            case Boolean: {
                keyword = "boolean";
                break;
            }
            case Byte: {
                keyword = "byte";
                break;
            }
            case Char: {
                keyword = "char";
                break;
            }
            case Double: {
                keyword = "double";
                break;
            }
            case Float: {
                keyword = "float";
                break;
            }
            case Int: {
                keyword = "int";
                break;
            }
            case Long: {
                keyword = "long";
                break;
            }
            case Short: {
                keyword = "short";
                break;
            }
            case Void: {
                keyword = "void";
                break;
            }
            case String: {
                keyword = "String";
                break;
            }
            case None: {
                throw new IllegalStateException("Unable to print None primitive");
            }
            case Null: {
                throw new IllegalStateException("Unable to print Null primitive");
            }
            default: {
                throw new IllegalStateException("Unable to print non-primitive type");
            }
        }
        this.beforeSyntax(primitive, Space.Location.PRIMITIVE_PREFIX, p);
        p.append(keyword);
        this.afterSyntax(primitive, p);
        return primitive;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, PrintOutputCapture<P> p) {
        this.beforeSyntax(parens, Space.Location.PARENTHESES_PREFIX, p);
        p.append('(');
        this.visitRightPadded(parens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, ")", p);
        this.afterSyntax(parens, p);
        return parens;
    }

    @Override
    public J visitReturn(J.Return return_, PrintOutputCapture<P> p) {
        this.beforeSyntax(return_, Space.Location.RETURN_PREFIX, p);
        p.append("return");
        this.visit(return_.getExpression(), p);
        this.afterSyntax(return_, p);
        return return_;
    }

    @Override
    public J visitSwitch(J.Switch switch_, PrintOutputCapture<P> p) {
        this.beforeSyntax(switch_, Space.Location.SWITCH_PREFIX, p);
        p.append("switch");
        this.visit(switch_.getSelector(), p);
        this.visit(switch_.getCases(), p);
        this.afterSyntax(switch_, p);
        return switch_;
    }

    @Override
    public J visitSwitchExpression(J.SwitchExpression switch_, PrintOutputCapture<P> p) {
        this.beforeSyntax(switch_, Space.Location.SWITCH_EXPRESSION_PREFIX, p);
        p.append("switch");
        this.visit(switch_.getSelector(), p);
        this.visit(switch_.getCases(), p);
        this.afterSyntax(switch_, p);
        return switch_;
    }

    @Override
    public J visitSynchronized(J.Synchronized synch, PrintOutputCapture<P> p) {
        this.beforeSyntax(synch, Space.Location.SYNCHRONIZED_PREFIX, p);
        p.append("synchronized");
        this.visit(synch.getLock(), p);
        this.visit(synch.getBody(), p);
        this.afterSyntax(synch, p);
        return synch;
    }

    @Override
    public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
        this.beforeSyntax(ternary, Space.Location.TERNARY_PREFIX, p);
        this.visit(ternary.getCondition(), p);
        this.visitLeftPadded("?", ternary.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, p);
        this.visitLeftPadded(":", ternary.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p);
        this.afterSyntax(ternary, p);
        return ternary;
    }

    @Override
    public J visitThrow(J.Throw thrown, PrintOutputCapture<P> p) {
        this.beforeSyntax(thrown, Space.Location.THROW_PREFIX, p);
        p.append("throw");
        this.visit(thrown.getException(), p);
        this.afterSyntax(thrown, p);
        return thrown;
    }

    @Override
    public J visitTry(J.Try tryable, PrintOutputCapture<P> p) {
        this.beforeSyntax(tryable, Space.Location.TRY_PREFIX, p);
        p.append("try");
        if (tryable.getPadding().getResources() != null) {
            this.visitSpace(tryable.getPadding().getResources().getBefore(), Space.Location.TRY_RESOURCES, p);
            p.append('(');
            List<JRightPadded<J.Try.Resource>> resources = tryable.getPadding().getResources().getPadding().getElements();
            for (JRightPadded<J.Try.Resource> resource : resources) {
                this.visitSpace(resource.getElement().getPrefix(), Space.Location.TRY_RESOURCE, p);
                this.visitMarkers(resource.getElement().getMarkers(), p);
                this.visit(resource.getElement().getVariableDeclarations(), p);
                if (resource.getElement().isTerminatedWithSemicolon()) {
                    p.append(';');
                }
                this.visitSpace(resource.getAfter(), Space.Location.TRY_RESOURCE_SUFFIX, p);
            }
            p.append(')');
        }
        this.visit(tryable.getBody(), p);
        this.visit(tryable.getCatches(), p);
        this.visitLeftPadded("finally", tryable.getPadding().getFinally(), JLeftPadded.Location.TRY_FINALLY, p);
        this.afterSyntax(tryable, p);
        return tryable;
    }

    @Override
    public J visitTypeCast(J.TypeCast typeCast, PrintOutputCapture<P> p) {
        this.beforeSyntax(typeCast, Space.Location.TYPE_CAST_PREFIX, p);
        this.visit(typeCast.getClazz(), p);
        this.visit(typeCast.getExpression(), p);
        this.afterSyntax(typeCast, p);
        return typeCast;
    }

    @Override
    public J visitTypeParameter(J.TypeParameter typeParam, PrintOutputCapture<P> p) {
        this.beforeSyntax(typeParam, Space.Location.TYPE_PARAMETERS_PREFIX, p);
        this.visit(typeParam.getAnnotations(), p);
        this.visit(typeParam.getName(), p);
        this.visitContainer("extends", typeParam.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, "&", "", p);
        this.afterSyntax(typeParam, p);
        return typeParam;
    }

    @Override
    public J visitUnary(J.Unary unary, PrintOutputCapture<P> p) {
        this.beforeSyntax(unary, Space.Location.UNARY_PREFIX, p);
        switch (unary.getOperator()) {
            case PreIncrement: {
                p.append("++");
                this.visit(unary.getExpression(), p);
                break;
            }
            case PreDecrement: {
                p.append("--");
                this.visit(unary.getExpression(), p);
                break;
            }
            case PostIncrement: {
                this.visit(unary.getExpression(), p);
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                p.append("++");
                break;
            }
            case PostDecrement: {
                this.visit(unary.getExpression(), p);
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                p.append("--");
                break;
            }
            case Positive: {
                p.append('+');
                this.visit(unary.getExpression(), p);
                break;
            }
            case Negative: {
                p.append('-');
                this.visit(unary.getExpression(), p);
                break;
            }
            case Complement: {
                p.append('~');
                this.visit(unary.getExpression(), p);
                break;
            }
            default: {
                p.append('!');
                this.visit(unary.getExpression(), p);
            }
        }
        this.afterSyntax(unary, p);
        return unary;
    }

    @Override
    public J visitUnknown(J.Unknown unknown, PrintOutputCapture<P> p) {
        this.beforeSyntax(unknown, Space.Location.UNKNOWN_PREFIX, p);
        this.visit(unknown.getSource(), p);
        this.afterSyntax(unknown, p);
        return unknown;
    }

    @Override
    public J visitUnknownSource(J.Unknown.Source source, PrintOutputCapture<P> p) {
        this.beforeSyntax(source, Space.Location.UNKNOWN_SOURCE_PREFIX, p);
        p.append(source.getText());
        this.afterSyntax(source, p);
        return source;
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
        this.beforeSyntax(variable, Space.Location.VARIABLE_PREFIX, p);
        this.visit(variable.getName(), p);
        for (JLeftPadded<Space> dimension : variable.getDimensionsAfterName()) {
            this.visitSpace(dimension.getBefore(), Space.Location.DIMENSION_PREFIX, p);
            p.append('[');
            this.visitSpace(dimension.getElement(), Space.Location.DIMENSION, p);
            p.append(']');
        }
        this.visitLeftPadded("=", variable.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p);
        this.afterSyntax(variable, p);
        return variable;
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, PrintOutputCapture<P> p) {
        this.beforeSyntax(whileLoop, Space.Location.WHILE_PREFIX, p);
        p.append("while");
        this.visit(whileLoop.getCondition(), p);
        this.visitStatement(whileLoop.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, p);
        this.afterSyntax(whileLoop, p);
        return whileLoop;
    }

    @Override
    public J visitWildcard(J.Wildcard wildcard, PrintOutputCapture<P> p) {
        this.beforeSyntax(wildcard, Space.Location.WILDCARD_PREFIX, p);
        p.append('?');
        if (wildcard.getPadding().getBound() != null) {
            switch (wildcard.getBound()) {
                case Extends: {
                    this.visitSpace(wildcard.getPadding().getBound().getBefore(), Space.Location.WILDCARD_BOUND, p);
                    p.append("extends");
                    break;
                }
                case Super: {
                    this.visitSpace(wildcard.getPadding().getBound().getBefore(), Space.Location.WILDCARD_BOUND, p);
                    p.append("super");
                }
            }
        }
        this.visit(wildcard.getBoundedType(), p);
        this.afterSyntax(wildcard, p);
        return wildcard;
    }

    @Override
    public J visitYield(J.Yield yield, PrintOutputCapture<P> p) {
        this.beforeSyntax(yield, Space.Location.YIELD_PREFIX, p);
        if (!yield.isImplicit()) {
            p.append("yield");
        }
        this.visit(yield.getValue(), p);
        this.afterSyntax(yield, p);
        return yield;
    }

    protected void beforeSyntax(J j, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        Marker marker;
        int i;
        List markersList = markers.getMarkers();
        for (i = 0; i < markersList.size(); ++i) {
            marker = (Marker)markersList.get(i);
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (i = 0; i < markersList.size(); ++i) {
            marker = (Marker)markersList.get(i);
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    protected void afterSyntax(J j, PrintOutputCapture<P> p) {
        this.afterSyntax(j.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        List markersMarkers = markers.getMarkers();
        for (int i = 0; i < markersMarkers.size(); ++i) {
            Marker marker = (Marker)markersMarkers.get(i);
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }
}

