/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.table.RewriteRecipeSource;

public class FindRecipes
extends Recipe {
    RewriteRecipeSource recipeSource = new RewriteRecipeSource((Recipe)this);

    public String getDisplayName() {
        return "Find OpenRewrite recipes";
    }

    public String getDescription() {
        return "This recipe finds all OpenRewrite recipes, primarily to produce a data table that is being used to experiment with fine-tuning a large language model to produce more recipes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher getDisplayName = new MethodMatcher("org.openrewrite.Recipe getDisplayName()", true);
        final MethodMatcher getDescription = new MethodMatcher("org.openrewrite.Recipe getDescription()", true);
        return Preconditions.check(new UsesType("org.openrewrite.Recipe", false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J cd = super.visitClassDeclaration(classDecl, ctx);
                if (TypeUtils.isAssignableTo("org.openrewrite.Recipe", (JavaType)classDecl.getType())) {
                    FindRecipes.this.recipeSource.insertRow(ctx, (Object)new RewriteRecipeSource.Row((String)this.getCursor().getMessage("displayName"), (String)this.getCursor().getMessage("description"), RewriteRecipeSource.RecipeType.Java, ((J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class)).printAllTrimmed()));
                    return classDecl.withName((J.Identifier)SearchResult.found((Tree)classDecl.getName()));
                }
                return cd;
            }

            @Override
            public J.Return visitReturn(J.Return aReturn, ExecutionContext ctx) {
                J.MethodDeclaration method = (J.MethodDeclaration)this.getCursor().firstEnclosingOrThrow(J.MethodDeclaration.class);
                if (getDisplayName.matches(method.getMethodType()) && aReturn.getExpression() instanceof J.Literal) {
                    this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "displayName", Objects.requireNonNull(((J.Literal)aReturn.getExpression()).getValue()));
                }
                if (getDescription.matches(method.getMethodType()) && aReturn.getExpression() instanceof J.Literal) {
                    this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "description", Objects.requireNonNull(((J.Literal)aReturn.getExpression()).getValue()));
                }
                return super.visitReturn(aReturn, ctx);
            }
        });
    }
}

