/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.GeneralFormatStyle;

public class EmptyNewlineAtEndOfFile
extends Recipe {
    public String getDisplayName() {
        return "End files with a single newline";
    }

    public String getDescription() {
        return "Some tools work better when files end with an empty line.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-113");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    GeneralFormatStyle generalFormatStyle = (GeneralFormatStyle)cu.getStyle(GeneralFormatStyle.class);
                    if (generalFormatStyle == null) {
                        generalFormatStyle = AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(cu);
                    }
                    String lineEnding = generalFormatStyle.isUseCRLFNewLines() ? "\r\n" : "\n";
                    Space eof = cu.getEof();
                    if (eof.getLastWhitespace().chars().filter(c -> c == 10).count() != 1L) {
                        if (eof.getComments().isEmpty()) {
                            return cu.withEof(Space.format(lineEnding));
                        }
                        List<Comment> comments = cu.getEof().getComments();
                        return cu.withEof(cu.getEof().withComments(ListUtils.map(comments, (i, comment) -> i == comments.size() - 1 ? comment.withSuffix(lineEnding) : comment)));
                    }
                    return cu;
                }
                return (J)tree;
            }
        };
    }
}

