/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.JavaType;

class TypeVisitor
extends MethodSignatureParserBaseVisitor<String> {
    private static final Set<String> COMMON_JAVA_LANG_TYPES = new HashSet<String>(Arrays.asList("Appendable", "AutoCloseable", "Boolean", "Byte", "Character", "CharSequence", "Class", "ClassLoader", "Cloneable", "Comparable", "Double", "Enum", "Error", "Exception", "Float", "FunctionalInterface", "Integer", "Iterable", "Long", "Math", "Number", "Object", "Readable", "Record", "Runnable", "Short", "String", "StringBuffer", "StringBuilder", "System", "Thread", "Throwable", "Void"));

    TypeVisitor() {
    }

    @Override
    public String visitClassNameOrInterface(MethodSignatureParser.ClassNameOrInterfaceContext ctx) {
        StringBuilder classNameBuilder = new StringBuilder();
        for (ParseTree c : ctx.children) {
            classNameBuilder.append(StringUtils.aspectjNameToPattern((String)c.getText()));
        }
        String className = classNameBuilder.toString();
        if (!className.contains(".")) {
            String beforeArr;
            int arrInit = className.lastIndexOf("\\[");
            String string = beforeArr = arrInit == -1 ? className : className.substring(0, arrInit);
            if (Character.isLowerCase(beforeArr.charAt(0)) && JavaType.Primitive.fromKeyword(beforeArr) != null) {
                return className;
            }
            if (COMMON_JAVA_LANG_TYPES.contains(beforeArr)) {
                return "java.lang." + className;
            }
        }
        return className;
    }
}

