/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.MethodSignatureLexer;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class TypeMatcher {
    private static final String ASPECTJ_DOT_PATTERN = StringUtils.aspectjNameToPattern((String)".");
    private Pattern targetTypePattern;
    @Nullable
    private String targetType;
    private final String signature;
    private final boolean matchInherited;

    public boolean matches(@Nullable TypeTree tt) {
        return tt != null && this.matches(tt.getType());
    }

    public boolean matchesPackage(String packageName) {
        return this.targetTypePattern.matcher(packageName).matches() || this.targetTypePattern.matcher(packageName.replaceAll("\\.\\*$", "." + this.signature.substring(this.signature.lastIndexOf(46) + 1))).matches();
    }

    public TypeMatcher(@Nullable String fieldType) {
        this(fieldType, false);
    }

    public TypeMatcher(@Nullable String fieldType, boolean matchInherited) {
        this.signature = fieldType == null ? ".*" : fieldType;
        this.matchInherited = matchInherited;
        if (StringUtils.isBlank((String)fieldType)) {
            this.targetTypePattern = Pattern.compile(".*");
        } else {
            MethodSignatureParser parser = new MethodSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new MethodSignatureLexer((CharStream)CharStreams.fromString((String)fieldType))));
            new MethodSignatureParserBaseVisitor<Void>(){

                @Override
                public Void visitTargetTypePattern(MethodSignatureParser.TargetTypePatternContext ctx) {
                    String pattern = (String)new TypeVisitor().visitTargetTypePattern(ctx);
                    TypeMatcher.this.targetTypePattern = Pattern.compile((String)new TypeVisitor().visitTargetTypePattern(ctx));
                    TypeMatcher.this.targetType = TypeMatcher.isPlainIdentifier(ctx) ? pattern.replace(ASPECTJ_DOT_PATTERN, ".").replace("\\", "") : null;
                    return null;
                }
            }.visitTargetTypePattern(parser.targetTypePattern());
        }
    }

    public boolean matches(@Nullable JavaType type) {
        return TypeUtils.isOfTypeWithName(TypeUtils.asFullyQualified(type), this.matchInherited, this::matchesTargetTypeName);
    }

    private boolean matchesTargetTypeName(String fullyQualifiedTypeName) {
        return this.targetType != null && TypeUtils.fullyQualifiedNamesAreEqual(this.targetType, fullyQualifiedTypeName) || this.targetType == null && this.targetTypePattern.matcher(fullyQualifiedTypeName).matches();
    }

    private static boolean isPlainIdentifier(MethodSignatureParser.TargetTypePatternContext context) {
        return context.BANG() == null && context.AND() == null && context.OR() == null && context.classNameOrInterface().DOTDOT().isEmpty() && context.classNameOrInterface().WILDCARD().isEmpty();
    }

    @Nullable
    public String getTargetType() {
        return this.targetType;
    }

    public String getSignature() {
        return this.signature;
    }

    public Pattern getTargetTypePattern() {
        return this.targetTypePattern;
    }

    public boolean isMatchInherited() {
        return this.matchInherited;
    }
}

