/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class ChangeAnnotationAttributeName
extends Recipe {
    @Option(displayName="Annotation Type", description="The fully qualified name of the annotation.", example="org.junit.Test")
    private final String annotationType;
    @Option(displayName="Old attribute name", description="The name of attribute to change.", example="timeout")
    private final String oldAttributeName;
    @Option(displayName="New attribute name", description="The new attribute name to use.", example="waitFor")
    private final String newAttributeName;

    public String getDisplayName() {
        return "Change annotation attribute name";
    }

    public String getInstanceNameSuffix() {
        String shortType = this.annotationType.substring(this.annotationType.lastIndexOf(46) + 1);
        return String.format("`@%s(%s)` to `@%s(%s)`", shortType, this.oldAttributeName, shortType, this.newAttributeName);
    }

    public String getDescription() {
        return "Some annotations accept arguments. This recipe renames an existing attribute.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType(this.annotationType, false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final AnnotationMatcher annotationMatcher;
            {
                this.annotationMatcher = new AnnotationMatcher(ChangeAnnotationAttributeName.this.annotationType);
            }

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J a = super.visitAnnotation(annotation, ctx);
                if (!this.annotationMatcher.matches((J.Annotation)a)) {
                    return a;
                }
                return ((J.Annotation)a).withArguments(ListUtils.map(((J.Annotation)a).getArguments(), arg -> {
                    if (arg instanceof J.Assignment) {
                        if (!ChangeAnnotationAttributeName.this.oldAttributeName.equals(ChangeAnnotationAttributeName.this.newAttributeName)) {
                            J.Assignment assignment = (J.Assignment)arg;
                            J.Identifier variable = (J.Identifier)assignment.getVariable();
                            if (ChangeAnnotationAttributeName.this.oldAttributeName.equals(variable.getSimpleName())) {
                                return assignment.withVariable(variable.withSimpleName(ChangeAnnotationAttributeName.this.newAttributeName));
                            }
                        }
                    } else if (ChangeAnnotationAttributeName.this.oldAttributeName.equals("value")) {
                        J.Identifier name = new J.Identifier(Tree.randomId(), arg.getPrefix(), Markers.EMPTY, Collections.emptyList(), ChangeAnnotationAttributeName.this.newAttributeName, arg.getType(), null);
                        return new J.Assignment(Tree.randomId(), Space.EMPTY, arg.getMarkers(), name, new JLeftPadded<Expression>(Space.SINGLE_SPACE, (Expression)arg.withPrefix(Space.SINGLE_SPACE), Markers.EMPTY), arg.getType());
                    }
                    return arg;
                }));
            }
        });
    }

    public ChangeAnnotationAttributeName(String annotationType, String oldAttributeName, String newAttributeName) {
        this.annotationType = annotationType;
        this.oldAttributeName = oldAttributeName;
        this.newAttributeName = newAttributeName;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public String getOldAttributeName() {
        return this.oldAttributeName;
    }

    public String getNewAttributeName() {
        return this.newAttributeName;
    }

    @NonNull
    public String toString() {
        return "ChangeAnnotationAttributeName(annotationType=" + this.getAnnotationType() + ", oldAttributeName=" + this.getOldAttributeName() + ", newAttributeName=" + this.getNewAttributeName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeAnnotationAttributeName)) {
            return false;
        }
        ChangeAnnotationAttributeName other = (ChangeAnnotationAttributeName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$annotationType = this.getAnnotationType();
        String other$annotationType = other.getAnnotationType();
        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
            return false;
        }
        String this$oldAttributeName = this.getOldAttributeName();
        String other$oldAttributeName = other.getOldAttributeName();
        if (this$oldAttributeName == null ? other$oldAttributeName != null : !this$oldAttributeName.equals(other$oldAttributeName)) {
            return false;
        }
        String this$newAttributeName = this.getNewAttributeName();
        String other$newAttributeName = other.getNewAttributeName();
        return !(this$newAttributeName == null ? other$newAttributeName != null : !this$newAttributeName.equals(other$newAttributeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeAnnotationAttributeName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $annotationType = this.getAnnotationType();
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        String $oldAttributeName = this.getOldAttributeName();
        result = result * 59 + ($oldAttributeName == null ? 43 : $oldAttributeName.hashCode());
        String $newAttributeName = this.getNewAttributeName();
        result = result * 59 + ($newAttributeName == null ? 43 : $newAttributeName.hashCode());
        return result;
    }
}

