/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.TokenCount;
import org.openrewrite.java.tree.J;

public final class ClassDefinitionLength
extends Recipe {
    private final transient TokenCount tokens = new TokenCount(this);

    public String getDisplayName() {
        return "Calculate token length of classes";
    }

    public String getDescription() {
        return "Locates class definitions and predicts the number of token in each.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration clazz, ExecutionContext ctx) {
                J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (cd == null) {
                    return cd;
                }
                int numberOfTokens = (int)((double)cd.printTrimmed(this.getCursor()).length() / 3.5);
                ClassDefinitionLength.this.tokens.insertRow(ctx, new TokenCount.Row(cd.getSimpleName(), numberOfTokens));
                return cd;
            }
        };
    }

    public TokenCount getTokens() {
        return this.tokens;
    }

    @NonNull
    public String toString() {
        return "ClassDefinitionLength(tokens=" + (Object)((Object)this.getTokens()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDefinitionLength)) {
            return false;
        }
        ClassDefinitionLength other = (ClassDefinitionLength)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClassDefinitionLength;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

