/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openrewrite.internal.lang.Nullable;

public enum Flag {
    Public("public", 1),
    Private("private", 2),
    Protected("protected", 4),
    Static("static", 8),
    Final("final", 16),
    Synchronized("synchronized", 32),
    Volatile("volatile", 64),
    Transient("transient", 128),
    Abstract("abstract", 1024);

    private final String keyword;
    private final int bitMask;
    private static final Map<Integer, Set<Flag>> flagSets;

    private Flag(String keyword, int bitMask) {
        this.keyword = keyword;
        this.bitMask = bitMask;
    }

    public String getKeyword() {
        return this.keyword;
    }

    @Nullable
    public static Flag fromKeyword(String keyword) {
        for (Flag flag : Flag.values()) {
            if (!flag.keyword.equals(keyword)) continue;
            return flag;
        }
        return null;
    }

    public static Set<Flag> bitMapToFlags(int flagsBitMap) {
        Set<Flag> flags = flagSets.get(flagsBitMap);
        if (flags == null) {
            flags = EnumSet.noneOf(Flag.class);
            if (0 != (flagsBitMap & Flag.Public.bitMask)) {
                flags.add(Public);
            }
            if (0 != (flagsBitMap & Flag.Protected.bitMask)) {
                flags.add(Protected);
            }
            if (0 != (flagsBitMap & Flag.Private.bitMask)) {
                flags.add(Private);
            }
            if (0 != (flagsBitMap & Flag.Abstract.bitMask)) {
                flags.add(Abstract);
            }
            if (0 != (flagsBitMap & Flag.Static.bitMask)) {
                flags.add(Static);
            }
            if (0 != (flagsBitMap & Flag.Final.bitMask)) {
                flags.add(Final);
            }
            if (0 != (flagsBitMap & Flag.Transient.bitMask)) {
                flags.add(Transient);
            }
            if (0 != (flagsBitMap & Flag.Volatile.bitMask)) {
                flags.add(Volatile);
            }
            if (0 != (flagsBitMap & Flag.Synchronized.bitMask)) {
                flags.add(Synchronized);
            }
            flags = Collections.unmodifiableSet(flags);
            flagSets.put(flagsBitMap, flags);
        }
        return flags;
    }

    public static int flagsToBitMap(@Nullable Set<Flag> flags) {
        int mask = 0;
        if (flags != null) {
            for (Flag flag : flags) {
                mask |= flag.bitMask;
            }
        }
        return mask;
    }

    public static boolean hasFlags(int flagsBitMap, Flag ... flags) {
        for (Flag flag : flags) {
            if ((flag.bitMask & flagsBitMap) != 0) continue;
            return false;
        }
        return true;
    }

    static {
        flagSets = new ConcurrentHashMap<Integer, Set<Flag>>(64);
    }
}

