/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

@Incubating(since="7.0.0")
public class FinalizeLocalVariablesVisitor<P>
extends JavaIsoVisitor<P> {
    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J.VariableDeclarations mv = (J.VariableDeclarations)this.visitAndCast(multiVariable, p, (x$0, x$1) -> super.visitVariableDeclarations((J.VariableDeclarations)x$0, x$1));
        if (mv.hasModifier(J.Modifier.Type.Final)) {
            return mv;
        }
        if (this.isMethodParameterVariable()) {
            return mv;
        }
        if (this.isDeclaredInLambda()) {
            return mv;
        }
        if (this.isDeclaredInCatch()) {
            return mv;
        }
        if (mv.getVariables().stream().anyMatch(v -> v.isField(this.getCursor()) || this.isField(this.getCursor()))) {
            return mv;
        }
        Predicate<J.VariableDeclarations.NamedVariable> hasReassignment = this.isDeclaredInForEachLoop() ? v -> !FindAssignmentReferencesToVariable.find((J)this.getCursor().firstEnclosingOrThrow(J.ForEachLoop.class), v).isEmpty() : v -> FindAssignmentReferencesToVariable.find((J)this.getCursor().dropParentUntil(J.class::isInstance).getValue(), v).size() + (v.getInitializer() == null ? -1 : 0) > 0;
        if (mv.getVariables().stream().noneMatch(hasReassignment)) {
            mv = this.maybeAutoFormat(mv, mv.withModifiers(ListUtils.concat(mv.getModifiers(), (Object)new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList()))), p, this.getCursor().dropParentUntil(J.class::isInstance));
        }
        return mv;
    }

    private boolean isMethodParameterVariable() {
        return this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.MethodDeclaration;
    }

    private boolean isDeclaredInForEachLoop() {
        return this.getCursor().dropParentUntil(J.class::isInstance).dropParentUntil(J.class::isInstance).getValue() instanceof J.ForEachLoop;
    }

    private boolean isDeclaredInLambda() {
        return this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.Lambda;
    }

    private boolean isDeclaredInCatch() {
        return this.getCursor().dropParentUntil(J.class::isInstance).dropParentUntil(J.class::isInstance).getValue() instanceof J.Try.Catch;
    }

    private boolean isField(Cursor cursor) {
        return cursor.getParentOrThrow().getParentOrThrow().getParentOrThrow().getValue() instanceof J.ClassDeclaration;
    }

    private static class FindAssignmentReferencesToVariable {
        private FindAssignmentReferencesToVariable() {
        }

        private static Set<NameTree> find(J j, final J.VariableDeclarations.NamedVariable variable) {
            JavaIsoVisitor<Set<NameTree>> findVisitor = new JavaIsoVisitor<Set<NameTree>>(){

                @Override
                public J.Assignment visitAssignment(J.Assignment assignment, Set<NameTree> ctx) {
                    J.Identifier i;
                    J a = super.visitAssignment(assignment, ctx);
                    if (((J.Assignment)a).getVariable() instanceof J.Identifier && (i = (J.Identifier)((J.Assignment)a).getVariable()).getSimpleName().equals(variable.getSimpleName())) {
                        ctx.add(i);
                    }
                    return a;
                }

                @Override
                public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, Set<NameTree> ctx) {
                    J.Identifier i;
                    J a = super.visitAssignmentOperation(assignOp, ctx);
                    if (((J.AssignmentOperation)a).getVariable() instanceof J.Identifier && (i = (J.Identifier)((J.AssignmentOperation)a).getVariable()).getSimpleName().equals(variable.getSimpleName())) {
                        ctx.add(i);
                    }
                    return a;
                }

                @Override
                public J.Unary visitUnary(J.Unary unary, Set<NameTree> ctx) {
                    J.Identifier i;
                    J u = super.visitUnary(unary, ctx);
                    if (((J.Unary)u).getExpression() instanceof J.Identifier && (i = (J.Identifier)((J.Unary)u).getExpression()).getSimpleName().equals(variable.getSimpleName())) {
                        ctx.add(i);
                    }
                    return u;
                }
            };
            HashSet<NameTree> refs = new HashSet<NameTree>();
            findVisitor.visit(j, refs);
            return refs;
        }
    }
}

