/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.internal.FormatFirstClassPrefix;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveImport<P>
extends JavaIsoVisitor<P> {
    private final String type;
    private final String owner;

    public RemoveImport(String type) {
        this.type = type;
        this.owner = type.substring(0, Math.max(0, type.lastIndexOf(46)));
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        ImportLayoutStyle importLayoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
        boolean typeUsed = false;
        TreeSet<String> otherTypesInPackageUsed = new TreeSet<String>();
        HashSet<String> methodsAndFieldsUsed = new HashSet<String>();
        TreeSet otherMethodsAndFieldsInTypeUsed = new TreeSet();
        HashSet<String> originalImports = new HashSet<String>();
        for (J.Import cuImport : cu.getImports()) {
            if (cuImport.getQualid().getType() == null) continue;
            originalImports.add(((JavaType.Class)cuImport.getQualid().getType()).getFullyQualifiedName());
        }
        for (JavaType javaType : cu.getTypesInUse()) {
            if (javaType instanceof JavaType.Variable) {
                JavaType.Variable variable = (JavaType.Variable)javaType;
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified(variable.getType());
                if (fq == null || !fq.getFullyQualifiedName().equals(this.type) && !fq.getFullyQualifiedName().equals(this.owner)) continue;
                methodsAndFieldsUsed.add(variable.getName());
                continue;
            }
            if (javaType instanceof JavaType.Method) {
                JavaType.Method method = (JavaType.Method)javaType;
                if (!method.hasFlags(Flag.Static) || !method.getDeclaringType().getFullyQualifiedName().equals(this.type)) continue;
                methodsAndFieldsUsed.add(method.getName());
                continue;
            }
            if (!(javaType instanceof JavaType.FullyQualified)) continue;
            JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)javaType;
            if (fullyQualified.getFullyQualifiedName().equals(this.type)) {
                typeUsed = true;
                continue;
            }
            if (!fullyQualified.getFullyQualifiedName().equals(this.owner) && !fullyQualified.getPackageName().equals(this.owner) || originalImports.contains(fullyQualified.getFullyQualifiedName())) continue;
            otherTypesInPackageUsed.add(fullyQualified.getClassName());
        }
        J.CompilationUnit c = cu;
        boolean keepImport = typeUsed;
        AtomicReference spaceForNextImport = new AtomicReference();
        if ((c = c.withImports(ListUtils.flatMap(c.getImports(), impoort -> {
            if (spaceForNextImport.get() != null) {
                impoort = impoort.withPrefix((Space)spaceForNextImport.get());
                spaceForNextImport.set(null);
            }
            String typeName = impoort.getTypeName();
            if (impoort.isStatic()) {
                String imported = impoort.getQualid().getSimpleName();
                if ((typeName + "." + imported).equals(this.type) && !methodsAndFieldsUsed.contains(imported)) {
                    spaceForNextImport.set(impoort.getPrefix());
                    return null;
                }
                if (typeName.equals(this.type) && "*".equals(imported)) {
                    if (methodsAndFieldsUsed.isEmpty() && otherMethodsAndFieldsInTypeUsed.size() < importLayoutStyle.getClassCountToUseStarImport()) {
                        if (otherMethodsAndFieldsInTypeUsed.isEmpty()) {
                            spaceForNextImport.set(impoort.getPrefix());
                            return null;
                        }
                        return this.unfoldStarImport((J.Import)impoort, otherMethodsAndFieldsInTypeUsed);
                    }
                } else if (typeName.equals(this.type) && !methodsAndFieldsUsed.contains(imported)) {
                    spaceForNextImport.set(impoort.getPrefix());
                    return null;
                }
            } else {
                if (!keepImport && typeName.equals(this.type)) {
                    if (impoort.getPrefix().isEmpty() || impoort.getPrefix().getLastWhitespace().chars().filter(s -> s == 10).count() > 1L) {
                        spaceForNextImport.set(impoort.getPrefix());
                    }
                    return null;
                }
                if (!keepImport && impoort.getPackageName().equals(this.owner) && "*".equals(impoort.getClassName()) && otherTypesInPackageUsed.size() < importLayoutStyle.getNameCountToUseStarImport()) {
                    if (otherTypesInPackageUsed.isEmpty()) {
                        spaceForNextImport.set(impoort.getPrefix());
                        return null;
                    }
                    return this.unfoldStarImport((J.Import)impoort, (Set<String>)otherTypesInPackageUsed);
                }
            }
            return impoort;
        }))) != cu) {
            this.doAfterVisit(new FormatFirstClassPrefix());
        }
        return c;
    }

    private Object unfoldStarImport(J.Import starImport, Set<String> otherImportsUsed) {
        ArrayList<J.Import> unfoldedImports = new ArrayList<J.Import>(otherImportsUsed.size());
        int i = 0;
        for (String other : otherImportsUsed) {
            J.Import unfolded = starImport.withQualid(starImport.getQualid().withName(starImport.getQualid().getName().withName(other))).withId(Tree.randomId());
            unfoldedImports.add(i++ == 0 ? unfolded : unfolded.withPrefix(Space.format("\n")));
        }
        return unfoldedImports;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveImport)) {
            return false;
        }
        RemoveImport other = (RemoveImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

