/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class PrimitiveWrapperClassConstructorToValueOf
extends Recipe {
    public String getDisplayName() {
        return "Use primitive wrapper `valueOf` method";
    }

    public String getDescription() {
        return "The constructor of all primitive types has been deprecated in favor of using the static factory method `valueOf` available for each of the primitive type wrappers.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2129");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.lang.Boolean", false), new UsesType("java.lang.Byte", false), new UsesType("java.lang.Character", false), new UsesType("java.lang.Double", false), new UsesType("java.lang.Float", false), new UsesType("java.lang.Integer", false), new UsesType("java.lang.Long", false), new UsesType("java.lang.Short", false)});
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J.NewClass nc = (J.NewClass)super.visitNewClass(newClass, executionContext);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(nc.getType());
                if (type != null && nc.getArguments().size() == 1) {
                    JavaTemplate.Builder valueOf;
                    Expression arg = nc.getArguments().get(0);
                    switch (type.getFullyQualifiedName()) {
                        case "java.lang.Boolean": {
                            valueOf = JavaTemplate.builder(() -> (this).getCursor(), "Boolean.valueOf(#{any(boolean)})");
                            break;
                        }
                        case "java.lang.Byte": {
                            valueOf = JavaTemplate.builder(() -> (this).getCursor(), "Byte.valueOf(#{any(byte)})");
                            break;
                        }
                        case "java.lang.Character": {
                            valueOf = JavaTemplate.builder(() -> (this).getCursor(), "Character.valueOf(#{any(char)})");
                            break;
                        }
                        case "java.lang.Double": {
                            valueOf = JavaTemplate.builder(() -> (this).getCursor(), "Double.valueOf(#{any(double)})");
                            break;
                        }
                        case "java.lang.Integer": {
                            valueOf = JavaTemplate.builder(() -> (this).getCursor(), "Integer.valueOf(#{any(int)})");
                            break;
                        }
                        case "java.lang.Long": {
                            valueOf = JavaTemplate.builder(() -> (this).getCursor(), "Long.valueOf(#{any(long)})");
                            break;
                        }
                        case "java.lang.Short": {
                            valueOf = JavaTemplate.builder(() -> (this).getCursor(), "Short.valueOf(#{any(short)})");
                            break;
                        }
                        case "java.lang.Float": {
                            JavaType argType;
                            if (arg instanceof J.Literal && JavaType.Primitive.Double == ((J.Literal)arg).getType()) {
                                arg = ((J.Literal)arg).withType(JavaType.Primitive.String);
                                arg = ((J.Literal)arg).withValueSource("\"" + ((J.Literal)arg).getValue() + "\"");
                            }
                            if (TypeUtils.isOfClassType(argType = arg.getType(), "java.lang.Double")) {
                                valueOf = JavaTemplate.builder(() -> (this).getCursor(), "Float.valueOf(#{any(java.lang.Double)}.floatValue())");
                                break;
                            }
                            valueOf = JavaTemplate.builder(() -> (this).getCursor(), "Float.valueOf(#{any(float)})");
                            break;
                        }
                        default: {
                            return nc;
                        }
                    }
                    return nc.withTemplate(valueOf.build(), nc.getCoordinates().replace(), arg);
                }
                return nc;
            }
        };
    }
}

