/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class UseSystemLineSeparator
extends Recipe {
    private static final MethodMatcher GET_PROPERTY = new MethodMatcher("java.lang.System getProperty(..)");
    private static final String LINE_SEPARATOR = "line.separator";

    public String getDisplayName() {
        return "Use `System.lineSeparator()`";
    }

    public String getDescription() {
        return "Replaces calls to `System.getProperty(\"line.separator\")` with `System.lineSeparator()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(GET_PROPERTY);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation invocation = (J.MethodInvocation)super.visitMethodInvocation(method, ctx);
                if (GET_PROPERTY.matches(method)) {
                    String param = "";
                    if (method.getArguments().size() == 1 && method.getArguments().get(0) instanceof J.Literal) {
                        param = ((J.Literal)method.getArguments().get(0)).getValue().toString();
                    }
                    if (!UseSystemLineSeparator.LINE_SEPARATOR.equals(param)) {
                        return invocation;
                    }
                    if (method.getSelect() != null) {
                        JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), "#{any(java.lang.System)}.lineSeparator()").build();
                        return method.withTemplate(template, method.getCoordinates().replace(), method.getSelect());
                    }
                    this.maybeRemoveImport("java.lang.System.getProperty");
                    this.maybeAddImport("java.lang.System", "lineSeparator");
                    JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), "lineSeparator()").staticImports("java.lang.System.lineSeparator").build();
                    return method.withTemplate(template, method.getCoordinates().replace(), new Object[0]);
                }
                return invocation;
            }
        };
    }
}

