/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Applicability;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.PartProvider;
import org.openrewrite.java.cleanup.ChainStringBuilderAppendCalls;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ReplaceStringBuilderWithString
extends Recipe {
    private static final MethodMatcher STRING_BUILDER_APPEND = new MethodMatcher("java.lang.StringBuilder append(..)");
    private static final MethodMatcher STRING_BUILDER_TO_STRING = new MethodMatcher("java.lang.StringBuilder toString()");
    private static J.Parentheses parenthesesTemplate;
    private static J.MethodInvocation stringValueOfTemplate;

    public String getDisplayName() {
        return "Replace StringBuilder.append() with String";
    }

    public String getDescription() {
        return "Replace `StringBuilder.append()` with String if you are only concatenating a small number of strings and the code is simple and easy to read, as the compiler can optimize simple string concatenation expressions into a single String object, which can be more efficient than using StringBuilder.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(STRING_BUILDER_APPEND), new UsesMethod(STRING_BUILDER_TO_STRING)});
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
                if (STRING_BUILDER_TO_STRING.matches(method)) {
                    ArrayList methodCallsChain = new ArrayList();
                    ArrayList<Expression> arguments = new ArrayList<Expression>();
                    boolean isFlattenable = ReplaceStringBuilderWithString.flatMethodInvocationChain(method, methodCallsChain, arguments);
                    if (!isFlattenable) {
                        return m;
                    }
                    Collections.reverse(arguments);
                    ReplaceStringBuilderWithString.this.adjustExpressions(arguments);
                    J.Parentheses additive = (J.Parentheses)ChainStringBuilderAppendCalls.additiveExpression(arguments).withPrefix(method.getPrefix());
                    if (this.isAMethodSelect(method)) {
                        additive = ReplaceStringBuilderWithString.wrapExpression(additive);
                    }
                    return additive;
                }
                return m;
            }

            private boolean isAMethodSelect(J.MethodInvocation method) {
                Cursor parent = this.getCursor().getParent(2);
                if (parent == null || !(parent.getValue() instanceof J.MethodInvocation)) {
                    return false;
                }
                return ((J.MethodInvocation)parent.getValue()).getSelect() == method;
            }
        };
    }

    private J.Literal toStringLiteral(J.Literal input) {
        if (input.getType() == JavaType.Primitive.String) {
            return input;
        }
        String value = input.getValueSource();
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, value, "\"" + value + "\"", null, JavaType.Primitive.String);
    }

    private void adjustExpressions(List<Expression> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            if (i == 0) {
                if (arguments.isEmpty() || TypeUtils.isString(arguments.get(0).getType())) continue;
                if (arguments.get(0) instanceof J.Literal) {
                    arguments.set(0, this.toStringLiteral((J.Literal)arguments.get(0)));
                    continue;
                }
                J.MethodInvocation stringValueOf = ((J.MethodInvocation)ReplaceStringBuilderWithString.getStringValueOfMethodInvocationTemplate().withArguments((List)Collections.singletonList(arguments.get(0)))).withPrefix(arguments.get(0).getPrefix());
                arguments.set(0, stringValueOf);
                continue;
            }
            Expression arg = arguments.get(i);
            if (arg instanceof J.Identifier || arg instanceof J.Literal || arg instanceof J.MethodInvocation) continue;
            arguments.set(i, ReplaceStringBuilderWithString.wrapExpression(arg));
        }
    }

    private static boolean flatMethodInvocationChain(J.MethodInvocation method, List<Expression> methodChain, List<Expression> arguments) {
        Expression select = method.getSelect();
        while (select != null) {
            methodChain.add(select);
            if (!(select instanceof J.MethodInvocation)) break;
            J.MethodInvocation selectMethod = (J.MethodInvocation)select;
            select = selectMethod.getSelect();
            if (!STRING_BUILDER_APPEND.matches(selectMethod)) {
                return false;
            }
            List<Expression> args = selectMethod.getArguments();
            if (args.size() != 1) {
                return false;
            }
            arguments.add(args.get(0));
        }
        if (select instanceof J.NewClass && TypeUtils.isOfClassType(((J.NewClass)select).getClazz().getType(), "java.lang.StringBuilder")) {
            J.NewClass nc = (J.NewClass)select;
            if (nc.getArguments().size() == 1 && TypeUtils.isString(nc.getArguments().get(0).getType())) {
                arguments.add(nc.getArguments().get(0));
            }
            return true;
        }
        return false;
    }

    public static J.Parentheses getParenthesesTemplate() {
        if (parenthesesTemplate == null) {
            parenthesesTemplate = PartProvider.buildPart("class B { void foo() { (\"A\" + \"B\").length(); } } ", J.Parentheses.class, new String[0]);
        }
        return parenthesesTemplate;
    }

    public static J.MethodInvocation getStringValueOfMethodInvocationTemplate() {
        if (stringValueOfTemplate == null) {
            stringValueOfTemplate = PartProvider.buildPart("class C {\n    void foo() {\n        Object obj = 1 + 2;\n        String.valueOf(obj);\n    }\n}", J.MethodInvocation.class, new String[0]);
        }
        return stringValueOfTemplate;
    }

    public static <T extends J> J.Parentheses<T> wrapExpression(Expression exp) {
        return ReplaceStringBuilderWithString.getParenthesesTemplate().withTree(exp).withPrefix(exp.getPrefix());
    }
}

