/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public final class FindImports
extends Recipe {
    @Option(displayName="Type pattern", description="A type pattern that is used to find matching field uses.", example="org.springframework..*", required=false)
    private final String typePattern;

    public String getDisplayName() {
        return "Find source files with imports";
    }

    public String getDescription() {
        return "Locates source files that have imports matching the given type pattern, regardless of whether that import is used in the code.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        final TypeMatcher typeMatcher = new TypeMatcher(this.typePattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Import visitImport(J.Import anImport, ExecutionContext executionContext) {
                if (typeMatcher.matchesPackage(anImport.getTypeName())) {
                    return (J.Import)SearchResult.found((Tree)anImport);
                }
                return super.visitImport(anImport, executionContext);
            }
        };
    }

    public FindImports(String typePattern) {
        this.typePattern = typePattern;
    }

    public String getTypePattern() {
        return this.typePattern;
    }

    @NonNull
    public String toString() {
        return "FindImports(typePattern=" + this.getTypePattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindImports)) {
            return false;
        }
        FindImports other = (FindImports)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$typePattern = this.getTypePattern();
        String other$typePattern = other.getTypePattern();
        return !(this$typePattern == null ? other$typePattern != null : !this$typePattern.equals(other$typePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindImports;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typePattern = this.getTypePattern();
        result = result * 59 + ($typePattern == null ? 43 : $typePattern.hashCode());
        return result;
    }
}

