/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class UnnecessaryCatch
extends Recipe {
    @Option(displayName="Include `java.lang.Exception`", description="Whether to include java.lang.Exception in the list of checked exceptions to remove. Unlike other checked exceptions, `java.lang.Exception` is also the superclass of unchecked exceptions. So removing `catch(Exception e)` may result in changed runtime behavior in the presence of unchecked exceptions. Default `false`", required=false)
    private final boolean includeJavaLangException;

    public String getDisplayName() {
        return "Remove catch for a checked exception if the try block does not throw that exception";
    }

    public String getDescription() {
        return "A refactoring operation may result in a checked exception that is no longer thrown from a `try` block. This recipe will find and remove unnecessary catch blocks.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J b = super.visitBlock(block, ctx);
                return ((J.Block)b).withStatements(ListUtils.flatMap(((J.Block)b).getStatements(), statement -> {
                    J.Try aTry;
                    if (statement instanceof J.Try && (aTry = (J.Try)statement).getCatches().isEmpty() && aTry.getResources() == null && aTry.getFinally() == null) {
                        return ListUtils.map(aTry.getBody().getStatements(), tryStat -> this.autoFormat(tryStat, ctx, this.getCursor()));
                    }
                    return statement;
                }));
            }

            @Override
            public J.Try visitTry(J.Try tryable, ExecutionContext executionContext) {
                J t = super.visitTry(tryable, executionContext);
                final ArrayList thrownExceptions = new ArrayList();
                final AtomicBoolean missingTypeInformation = new AtomicBoolean(false);
                new JavaIsoVisitor<Integer>(){

                    @Override
                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                        JavaType.Method methodType = method.getMethodType();
                        if (methodType == null) {
                            missingTypeInformation.set(true);
                        } else {
                            thrownExceptions.addAll(methodType.getThrownExceptions());
                        }
                        return super.visitMethodInvocation(method, integer);
                    }
                }.visit(((J.Try)t).getBody(), 0);
                if (missingTypeInformation.get()) {
                    return t;
                }
                return ((J.Try)t).withCatches(ListUtils.map(((J.Try)t).getCatches(), (i, aCatch) -> {
                    JavaType parameterType = aCatch.getParameter().getType();
                    if (parameterType == null || TypeUtils.isAssignableTo("java.lang.RuntimeException", parameterType)) {
                        return aCatch;
                    }
                    if (!UnnecessaryCatch.this.includeJavaLangException && TypeUtils.isOfClassType(parameterType, "java.lang.Exception")) {
                        return aCatch;
                    }
                    for (JavaType.FullyQualified e : thrownExceptions) {
                        if (!TypeUtils.isAssignableTo(e, parameterType)) continue;
                        return aCatch;
                    }
                    this.maybeRemoveImport(TypeUtils.asFullyQualified(parameterType));
                    return null;
                }));
            }
        };
    }

    public UnnecessaryCatch(boolean includeJavaLangException) {
        this.includeJavaLangException = includeJavaLangException;
    }

    public boolean isIncludeJavaLangException() {
        return this.includeJavaLangException;
    }

    @NonNull
    public String toString() {
        return "UnnecessaryCatch(includeJavaLangException=" + this.isIncludeJavaLangException() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnnecessaryCatch)) {
            return false;
        }
        UnnecessaryCatch other = (UnnecessaryCatch)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isIncludeJavaLangException() == other.isIncludeJavaLangException();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UnnecessaryCatch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeJavaLangException() ? 79 : 97);
        return result;
    }
}

