/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

public final class ChangeMethodName
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method declarations/invocations.", example="org.mockito.Matchers anyVararg()")
    private final String methodPattern;
    @Option(displayName="New method name", description="The method name that will replace the existing name.", example="any")
    private final String newMethodName;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean matchOverrides;
    @Option(displayName="Ignore type definition", description="When set to `true` the definition of the old type will be left untouched. This is useful when you're replacing usage of a class but don't want to rename it.", required=false)
    @Nullable
    private final Boolean ignoreDefinition;

    public String getDisplayName() {
        return "Change method name";
    }

    public String getDescription() {
        return "Rename a method.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                J j;
                if (Boolean.TRUE.equals(ChangeMethodName.this.ignoreDefinition) && cu != (j = (J)new DeclaresMethod(ChangeMethodName.this.methodPattern, ChangeMethodName.this.matchOverrides).visitNonNull(cu, executionContext))) {
                    return cu;
                }
                this.doAfterVisit(new UsesMethod(ChangeMethodName.this.methodPattern, ChangeMethodName.this.matchOverrides));
                this.doAfterVisit(new DeclaresMethod(ChangeMethodName.this.methodPattern, ChangeMethodName.this.matchOverrides));
                return cu;
            }
        };
    }

    public boolean causesAnotherCycle() {
        return true;
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new ChangeMethodNameVisitor(new MethodMatcher(this.methodPattern, this.matchOverrides));
    }

    public ChangeMethodName(String methodPattern, String newMethodName, @Nullable Boolean matchOverrides, @Nullable Boolean ignoreDefinition) {
        this.methodPattern = methodPattern;
        this.newMethodName = newMethodName;
        this.matchOverrides = matchOverrides;
        this.ignoreDefinition = ignoreDefinition;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getNewMethodName() {
        return this.newMethodName;
    }

    @Nullable
    public Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @Nullable
    public Boolean getIgnoreDefinition() {
        return this.ignoreDefinition;
    }

    @NonNull
    public String toString() {
        return "ChangeMethodName(methodPattern=" + this.getMethodPattern() + ", newMethodName=" + this.getNewMethodName() + ", matchOverrides=" + this.getMatchOverrides() + ", ignoreDefinition=" + this.getIgnoreDefinition() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodName)) {
            return false;
        }
        ChangeMethodName other = (ChangeMethodName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        Boolean this$ignoreDefinition = this.getIgnoreDefinition();
        Boolean other$ignoreDefinition = other.getIgnoreDefinition();
        if (this$ignoreDefinition == null ? other$ignoreDefinition != null : !((Object)this$ignoreDefinition).equals(other$ignoreDefinition)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$newMethodName = this.getNewMethodName();
        String other$newMethodName = other.getNewMethodName();
        return !(this$newMethodName == null ? other$newMethodName != null : !this$newMethodName.equals(other$newMethodName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeMethodName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        Boolean $ignoreDefinition = this.getIgnoreDefinition();
        result = result * 59 + ($ignoreDefinition == null ? 43 : ((Object)$ignoreDefinition).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $newMethodName = this.getNewMethodName();
        result = result * 59 + ($newMethodName == null ? 43 : $newMethodName.hashCode());
        return result;
    }

    private class ChangeMethodNameVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        private ChangeMethodNameVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J m = super.visitMethodDeclaration(method, ctx);
            J.ClassDeclaration classDecl = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
            if (classDecl == null) {
                return m;
            }
            if (this.methodMatcher.matches(method, classDecl)) {
                JavaType.Method type = ((J.MethodDeclaration)m).getMethodType();
                if (type != null) {
                    type = type.withName(ChangeMethodName.this.newMethodName);
                }
                m = ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withSimpleName(ChangeMethodName.this.newMethodName)).withMethodType(type);
            }
            return m;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches(method) && !method.getSimpleName().equals(ChangeMethodName.this.newMethodName)) {
                JavaType.Method type = ((J.MethodInvocation)m).getMethodType();
                if (type != null) {
                    type = type.withName(ChangeMethodName.this.newMethodName);
                }
                m = ((J.MethodInvocation)m).withName(((J.MethodInvocation)m).getName().withSimpleName(ChangeMethodName.this.newMethodName)).withMethodType(type);
            }
            return m;
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext context) {
            J m = super.visitMemberReference(memberRef, context);
            if (this.methodMatcher.matches(((J.MemberReference)m).getMethodType()) && !((J.MemberReference)m).getReference().getSimpleName().equals(ChangeMethodName.this.newMethodName)) {
                JavaType.Method type = ((J.MemberReference)m).getMethodType();
                if (type != null) {
                    type = type.withName(ChangeMethodName.this.newMethodName);
                }
                m = ((J.MemberReference)m).withReference(((J.MemberReference)m).getReference().withSimpleName(ChangeMethodName.this.newMethodName)).withMethodType(type);
            }
            return m;
        }

        @Override
        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            Expression target;
            J f = super.visitFieldAccess(fieldAccess, ctx);
            if (this.methodMatcher.isFullyQualifiedClassReference((J.FieldAccess)f) && (target = ((J.FieldAccess)f).getTarget()) instanceof J.FieldAccess) {
                String className = target.printTrimmed(this.getCursor());
                String fullyQualified = className + "." + ChangeMethodName.this.newMethodName;
                return (J.FieldAccess)TypeTree.build(fullyQualified).withPrefix(((J.FieldAccess)f).getPrefix());
            }
            return f;
        }
    }
}

