/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.openrewrite.java.style.ImportLayoutStyle;

class Deserializer
extends JsonDeserializer<ImportLayoutStyle> {
    Deserializer() {
    }

    public ImportLayoutStyle deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ImportLayoutStyle.Builder builder = ImportLayoutStyle.builder();
        String currentField = null;
        while (p.hasCurrentToken() && p.getCurrentToken() != JsonToken.END_OBJECT) {
            switch (p.currentToken()) {
                case FIELD_NAME: {
                    currentField = p.getCurrentName();
                    break;
                }
                case VALUE_STRING: {
                    if (!currentField.equals("layout")) break;
                    String block = p.getText().trim();
                    if (block.equals("<blank line>")) {
                        builder.blankLine();
                        break;
                    }
                    if (block.startsWith("import ")) {
                        block = block.substring("import ".length());
                        boolean statik = false;
                        if (block.startsWith("static")) {
                            statik = true;
                            block = block.substring("static ".length());
                        }
                        if (block.equals("all other imports")) {
                            if (statik) {
                                builder.importStaticAllOthers();
                                break;
                            }
                            builder.importAllOthers();
                            break;
                        }
                        if (statik) {
                            builder.staticImportPackage(block);
                            break;
                        }
                        builder.importPackage(block);
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error in layout block [" + block + "]");
                }
                case VALUE_NUMBER_INT: {
                    if ("classCountToUseStarImport".equals(currentField)) {
                        builder.classCountToUseStarImport(p.getValueAsInt());
                        break;
                    }
                    if (!"nameCountToUseStarImport".equals(currentField)) break;
                    builder.nameCountToUseStarImport(p.getValueAsInt());
                }
            }
            p.nextToken();
        }
        return builder.build();
    }
}

