/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.J;

public class Spaces
extends Recipe {
    public String getDisplayName() {
        return "Spaces";
    }

    public String getDescription() {
        return "Format whitespace in Java code.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SpacesFromCompilationUnitStyle();
    }

    private static class SpacesFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private SpacesFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            SpacesStyle style = (SpacesStyle)cu.getStyle(SpacesStyle.class);
            if (style == null) {
                style = IntelliJ.spaces();
            }
            this.doAfterVisit(new SpacesVisitor(style));
            return super.visitCompilationUnit(cu, executionContext);
        }
    }
}

