/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class UnnecessaryThrows
extends Recipe {
    public String getDisplayName() {
        return "Unnecessary throws";
    }

    public String getDescription() {
        return "Remove unnecessary throws";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J m = super.visitMethodDeclaration(method, ctx);
                if (((J.MethodDeclaration)m).getThrows() != null && !((J.MethodDeclaration)m).isAbstract()) {
                    final Set unusedThrows = ((J.MethodDeclaration)m).getThrows().stream().map(t -> TypeUtils.asFullyQualified(t.getType())).filter(Objects::nonNull).filter(t -> !TypeUtils.isAssignableTo(JavaType.Class.build("java.lang.RuntimeException"), t)).collect(Collectors.toCollection(HashSet::new));
                    new JavaIsoVisitor<ExecutionContext>(){

                        @Nullable
                        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                            if (unusedThrows.isEmpty()) {
                                return (J)tree;
                            }
                            return (J)super.visit(tree, (Object)ctx);
                        }

                        @Override
                        public J.Throw visitThrow(J.Throw thrown, ExecutionContext executionContext) {
                            JavaType.FullyQualified type = TypeUtils.asFullyQualified(thrown.getException().getType());
                            if (type != null) {
                                unusedThrows.removeIf(t -> TypeUtils.isAssignableTo(t, type));
                            }
                            return thrown;
                        }

                        @Override
                        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                            this.removeThrownTypes(method.getType());
                            return super.visitMethodInvocation(method, ctx);
                        }

                        @Override
                        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                            this.removeThrownTypes(newClass.getConstructorType());
                            return super.visitNewClass(newClass, ctx);
                        }

                        private void removeThrownTypes(@Nullable JavaType.Method type) {
                            if (type != null) {
                                for (JavaType.FullyQualified thrownException : type.getThrownExceptions()) {
                                    unusedThrows.removeIf(t -> TypeUtils.isAssignableTo(t, thrownException));
                                }
                            }
                        }
                    }.visit(m, ctx);
                    if (!unusedThrows.isEmpty()) {
                        m = ((J.MethodDeclaration)m).withThrows(ListUtils.map(((J.MethodDeclaration)m).getThrows(), t -> {
                            JavaType.FullyQualified type = TypeUtils.asFullyQualified(t.getType());
                            if (type != null && unusedThrows.contains(type)) {
                                this.maybeRemoveImport(type);
                                return null;
                            }
                            return t;
                        }));
                    }
                }
                return m;
            }
        };
    }
}

