/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class RenameVariable<P>
extends JavaIsoVisitor<P> {
    private final J.VariableDeclarations.NamedVariable variable;
    private final String toName;

    public RenameVariable(J.VariableDeclarations.NamedVariable variable, String toName) {
        this.variable = variable;
        this.toName = toName;
    }

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        if (variable.equals(this.variable)) {
            this.doAfterVisit(new RenameVariableByCursor(this.getCursor()));
            return variable;
        }
        return super.visitVariable(variable, (Object)p);
    }

    private class RenameVariableByCursor
    extends JavaIsoVisitor<P> {
        private final Cursor scope;
        private boolean isConstant = false;

        public RenameVariableByCursor(Cursor scope) {
            this.scope = scope;
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
            return super.visitCompilationUnit(cu, p);
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier ident, P p) {
            if (!this.isConstant && ident.getSimpleName().equals(RenameVariable.this.variable.getSimpleName()) && this.isInSameNameScope(this.scope, this.getCursor())) {
                if (!(this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.FieldAccess)) {
                    return ident.withName(RenameVariable.this.toName);
                }
            }
            return super.visitIdentifier(ident, p);
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
            if (!this.isConstant && multiVariable.getVariables().contains(RenameVariable.this.variable) && multiVariable.hasModifier(J.Modifier.Type.Static) && multiVariable.hasModifier(J.Modifier.Type.Final)) {
                this.isConstant = true;
            }
            return super.visitVariableDeclarations(multiVariable, p);
        }
    }
}

