/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class ForLoopControlVariablePostfixOperators
extends Recipe {
    public String getDisplayName() {
        return "`for` loop counters should use postfix operators";
    }

    public String getDescription() {
        return "Replace `for` loop control variables using pre-increment (`++i`) or pre-decrement (`--i`) operators with their post-increment (`i++`) or post-decrement (`i++`) notation equivalents.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ForLoop visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
                forLoop = forLoop.withControl(forLoop.getControl().withUpdate(ListUtils.map(forLoop.getControl().getUpdate(), update -> {
                    if (update instanceof J.Unary) {
                        J.Unary u = (J.Unary)update;
                        if (u.getOperator() == J.Unary.Type.PreIncrement) {
                            return ((J.Unary)update).withOperator(J.Unary.Type.PostIncrement);
                        }
                        if (u.getOperator() == J.Unary.Type.PreDecrement) {
                            return ((J.Unary)update).withOperator(J.Unary.Type.PostDecrement);
                        }
                    }
                    return update;
                })));
                return super.visitForLoop(forLoop, ctx);
            }
        };
    }
}

