/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.controlflow.ControlFlowDotFileGenerator;
import org.openrewrite.java.controlflow.ControlFlowVisualizationVisitor;

public final class ControlFlowVisualization
extends Recipe {
    @Option(displayName="Include Dotfile", description="Also output with a Dotfile which can be then later visualized by Graphviz.", example="true")
    private final boolean includeDotfile;
    private final boolean darkMode;

    public String getDisplayName() {
        return "Control Flow Visualization";
    }

    public String getDescription() {
        return "Visualize the control flow of a Java program.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ControlFlowVisualizationVisitor<ExecutionContext>(this.includeDotfile ? ControlFlowDotFileGenerator.create() : null, this.darkMode);
    }

    public ControlFlowVisualization(boolean includeDotfile, boolean darkMode) {
        this.includeDotfile = includeDotfile;
        this.darkMode = darkMode;
    }

    public boolean isIncludeDotfile() {
        return this.includeDotfile;
    }

    public boolean isDarkMode() {
        return this.darkMode;
    }

    @NonNull
    public String toString() {
        return "ControlFlowVisualization(includeDotfile=" + this.isIncludeDotfile() + ", darkMode=" + this.isDarkMode() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControlFlowVisualization)) {
            return false;
        }
        ControlFlowVisualization other = (ControlFlowVisualization)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIncludeDotfile() != other.isIncludeDotfile()) {
            return false;
        }
        return this.isDarkMode() == other.isDarkMode();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ControlFlowVisualization;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIncludeDotfile() ? 79 : 97);
        result = result * 59 + (this.isDarkMode() ? 79 : 97);
        return result;
    }
}

