/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.FindRepeatableAnnotations;
import org.openrewrite.java.tree.J;

public class UnwrapRepeatableAnnotations
extends Recipe {
    public String getDisplayName() {
        return "Unwrap `@Repeatable` annotations.";
    }

    public String getDescription() {
        return "Java 8 introduced the concept of `@Repeatable` annotations, making the wrapper annotation unnecessary.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new FindRepeatableAnnotations().getVisitor();
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J m = super.visitMethodDeclaration(method, ctx);
                List<J.Annotation> ann = this.unwrap(((J.MethodDeclaration)m).getLeadingAnnotations());
                if (ann.isEmpty()) {
                    return m;
                }
                return this.maybeAutoFormat(m, ((J.MethodDeclaration)m).withLeadingAnnotations(ann), ann.get(ann.size() - 1), ctx, this.getCursor().getParentOrThrow());
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J c = super.visitClassDeclaration(classDecl, ctx);
                List<J.Annotation> ann = this.unwrap(((J.ClassDeclaration)c).getLeadingAnnotations());
                if (ann.isEmpty()) {
                    return c;
                }
                return this.maybeAutoFormat(c, ((J.ClassDeclaration)c).withLeadingAnnotations(ann), ann.get(ann.size() - 1), ctx, this.getCursor().getParentOrThrow());
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J v = super.visitVariableDeclarations(multiVariable, ctx);
                List<J.Annotation> ann = this.unwrap(((J.VariableDeclarations)v).getLeadingAnnotations());
                if (ann.isEmpty()) {
                    return v;
                }
                return this.maybeAutoFormat(v, ((J.VariableDeclarations)v).withLeadingAnnotations(ann), ann.get(ann.size() - 1), ctx, this.getCursor().getParentOrThrow());
            }

            private List<J.Annotation> unwrap(List<J.Annotation> annotations) {
                return ListUtils.flatMap(annotations, a -> {
                    final ArrayList unwrapped = new ArrayList(1);
                    new JavaVisitor<Integer>(){

                        @Override
                        public J visitAnnotation(J.Annotation annotation, Integer p) {
                            if (annotation != a && FindRepeatableAnnotations.isRepeatable(annotation.getType())) {
                                unwrapped.add(annotation);
                            }
                            return super.visitAnnotation(annotation, p);
                        }
                    }.visit((Tree)a, 0);
                    return unwrapped.isEmpty() ? a : unwrapped;
                });
            }
        };
    }
}

