/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Calendar;
import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Markers;

public final class AddLicenseHeader
extends Recipe {
    @Option(displayName="License text", description="The license header text without the block comment. May contain ${CURRENT_YEAR} property.")
    private final String licenseText;

    public String getDisplayName() {
        return "Add license header";
    }

    public String getDescription() {
        return "Adds license headers to Java source files when missing. Does not override existing license headers";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                if (cu.getComments().isEmpty()) {
                    PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}", null);
                    String formattedLicenseText = "\n * " + propertyPlaceholderHelper.replacePlaceholders(AddLicenseHeader.this.licenseText, k -> {
                        if (k.equals("CURRENT_YEAR")) {
                            return Integer.toString(Calendar.getInstance().get(1));
                        }
                        return System.getProperty(k);
                    }).replace("\n", "\n * ") + "\n ";
                    cu = (J.CompilationUnit)cu.withComments(Collections.singletonList(new Comment(Comment.Style.BLOCK, formattedLicenseText, "\n", Markers.EMPTY)));
                }
                return cu;
            }

            @Override
            public J.Import visitImport(J.Import _import, ExecutionContext executionContext) {
                return _import;
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                return classDecl;
            }
        };
    }

    public AddLicenseHeader(String licenseText) {
        this.licenseText = licenseText;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    @NonNull
    public String toString() {
        return "AddLicenseHeader(licenseText=" + this.getLicenseText() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddLicenseHeader)) {
            return false;
        }
        AddLicenseHeader other = (AddLicenseHeader)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$licenseText = this.getLicenseText();
        String other$licenseText = other.getLicenseText();
        return !(this$licenseText == null ? other$licenseText != null : !this$licenseText.equals(other$licenseText));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddLicenseHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $licenseText = this.getLicenseText();
        result = result * 59 + ($licenseText == null ? 43 : $licenseText.hashCode());
        return result;
    }
}

